/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class ShapeManager {
    private GData gdata;
    private ModelSet ms;
    Shape[] shapes;
    public Viewer vwr;
    private static final int[] hoverable = new int[]{30, 25, 24, 22, 35};
    private static int clickableMax = hoverable.length - 1;
    private final BS bsRenderableAtoms = new BS();
    private final int[] navigationCrossHairMinMax = new int[4];

    public ShapeManager(Viewer viewer) {
        this.vwr = viewer;
        this.gdata = viewer.gdata;
    }

    public void setParallel() {
        this.resetShapes();
        this.loadDefaultShapes(this.vwr.ms);
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && atomArray[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(n, n2, atomArray, bS);
            }
        }
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public Object getShapePropertyIndex(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.vwr.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getPropertyData(string, objectArray);
        this.vwr.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 29; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.ms = modelSet;
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(modelSet);
            }
        }
        this.loadShape(0);
        this.loadShape(1);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] != null) {
            return this.shapes[n];
        }
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JC.getShapeClassName(n, false);
        Shape shape = (Shape)Interface.getInterface(string);
        if (shape == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "allocate");
        shape.initializeShape(this.vwr, this.gdata, this.ms, n);
        this.vwr.setShapeErrorState(-1, null);
        this.shapes[n] = shape;
        return this.shapes[n];
    }

    public void refreshShapeTrajectories(int n, BS bS, M4 m4) {
        Integer n2 = n;
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        for (int i = 0; i < 36; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapePropertyBs(i, "refreshTrajectories", new Object[]{n2, bS, m4}, bS2);
        }
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public void resetShapes() {
        if (!this.vwr.noGraphicsAllowed()) {
            this.shapes = new Shape[36];
        }
    }

    public void setShapeSizeBs(int n, int n2, RadiusData radiusData, BS bS) {
        if (this.shapes == null) {
            return;
        }
        if (bS == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bS = this.vwr.bsA();
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == VDW.TEMP) {
            this.ms.getBfactor100Lo();
        }
        this.vwr.setShapeErrorState(n, "set size");
        if (radiusData == null ? n2 != 0 : radiusData.value != 0.0f) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSizeRD(n2, radiusData, bS);
        }
        this.vwr.setShapeErrorState(-1, null);
    }

    public void setLabel(Object object, BS bS) {
        if (object == null) {
            if (this.shapes[5] == null) {
                return;
            }
        } else {
            this.loadShape(5);
            this.setShapeSizeBs(5, 0, null, bS);
        }
        this.setShapePropertyBs(5, "label", object, bS);
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        this.vwr.setShapeErrorState(n, "set " + string);
        this.shapes[n].setProperty(string.intern(), object, bS);
        this.vwr.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int n, int n2) {
        Shape shape = this.shapes[35];
        return shape != null && shape.wasClicked(n, n2);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Map<String, Object> map = null;
        if (n3 != 0 && this.vwr.getBondPicking() && (map = this.shapes[1].checkObjectClicked(n, n2, n3, bS, false)) != null) {
            return map;
        }
        for (int i = 0; i < clickableMax; ++i) {
            Shape shape = this.shapes[hoverable[i]];
            if (shape == null || (map = shape.checkObjectClicked(n, n2, n3, bS, bl)) == null) continue;
            return map;
        }
        return null;
    }

    boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS, int n6) {
        boolean bl = false;
        int n7 = n6 > 0 ? n6 + 1 : 36;
        for (int i = n6; !bl && i < n7; ++i) {
            if (this.shapes[i] == null) continue;
            bl = this.shapes[i].checkObjectDragged(n, n2, n3, n4, n5, bS);
        }
        return bl;
    }

    boolean checkObjectHovered(int n, int n2, BS bS, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bS)) {
            return true;
        }
        for (int i = 0; i < hoverable.length; ++i) {
            shape = this.shapes[hoverable[i]];
            if (shape == null || !shape.checkObjectHovered(n, n2, bS)) continue;
            return true;
        }
        return false;
    }

    public void deleteShapeAtoms(Object[] objectArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < 36; ++i) {
                if (this.shapes[i] == null) continue;
                this.setShapePropertyBs(i, "deleteModelAtoms", objectArray, bS);
            }
        }
    }

    void deleteVdwDependentShapes(BS bS) {
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setProperty("deleteVdw", null, bS);
        }
        if (this.shapes[25] != null) {
            this.shapes[25].setProperty("deleteVdw", null, bS);
        }
    }

    public float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JC.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].vf) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSizeG(group);
        }
        return (float)n4 / 2000.0f;
    }

    void getObjectMap(Map<String, ?> map, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        Boolean bl2 = bl;
        for (int i = 16; i < 29; ++i) {
            this.getShapePropertyData(i, "getNames", new Object[]{map, bl2});
        }
    }

    Object getProperty(Object object) {
        if (object.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    BS getRenderableBitSet() {
        return this.bsRenderableAtoms;
    }

    public Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    public void mergeShapes(Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        if (this.shapes == null) {
            this.shapes = shapeArray;
        } else {
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] == null) continue;
                if (this.shapes[i] == null) {
                    this.loadShape(i);
                }
                this.shapes[i].merge(shapeArray[i]);
            }
        }
    }

    public void resetBioshapes(BS bS) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.ms);
            this.shapes[i].setShapeSizeRD(0, null, bS);
            this.shapes[i].setProperty("color", (Object)PAL.NONE, bS);
        }
    }

    public void setAtomLabel(String string, int n) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(5);
        this.shapes[5].setProperty("label:" + string, n, null);
    }

    void setModelVisibility() {
        Object object;
        int n;
        Shape[] shapeArray = this.shapes;
        if (shapeArray == null || shapeArray[0] == null) {
            return;
        }
        BS bS = this.vwr.getVisibleFramesBitSet();
        for (n = 8; n < 32; ++n) {
            if (shapeArray[n] == null) continue;
            shapeArray[n].setVisibilityFlags(bS);
        }
        n = this.vwr.getBoolean(603979922) ? 1 : 0;
        BS bS2 = this.vwr.getDeletedAtoms();
        Atom[] atomArray = this.ms.at;
        int n2 = this.ms.ac;
        while (--n2 >= 0) {
            int n3;
            object = atomArray[n2];
            ((Atom)object).shapeVisibilityFlags &= 0xFFFFFFC0;
            if (bS2 != null && bS2.get(n2) || n == 0 && ((Atom)object).getElementNumber() == 1 || !bS.get(n3 = ((Atom)object).getModelIndex())) continue;
            int n4 = 1;
            if (this.ms.isAtomHidden(n2)) continue;
            n4 |= 8;
            if (((Atom)object).madAtom != 0) {
                n4 |= 0x10;
            }
            ((Atom)object).setShapeVisibility(n4, true);
        }
        for (n2 = 0; n2 < 36; ++n2) {
            object = shapeArray[n2];
            if (object == null) continue;
            ((Shape)object).setModelClickability();
        }
    }

    public int[] finalizeAtoms(BS bS, P3 p3) {
        int n;
        int n2;
        Vibration[] vibrationArray;
        Viewer viewer = this.vwr;
        TransformManager transformManager = viewer.tm;
        BS bS2 = this.bsRenderableAtoms;
        GData gData = this.gdata;
        if (bS != null) {
            vibrationArray = this.ms.getAtomSetCenter(bS);
            P3 p32 = new P3();
            transformManager.transformPt3f((T3)vibrationArray, p32);
            p32.add(p3);
            transformManager.unTransformPoint(p32, p32);
            p32.sub((T3)vibrationArray);
            viewer.setAtomCoordsRelative(p32, bS);
            p3.set(0.0f, 0.0f, 0.0f);
        }
        this.ms.getRenderable(bS2);
        vibrationArray = this.ms.vibrations;
        boolean bl = vibrationArray != null && transformManager.vibrationOn;
        Atom[] atomArray = this.ms.at;
        int n3 = bS2.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            P3i p3i = bl && atom.hasVibration() ? transformManager.transformPtVib(atom, vibrationArray[n3]) : transformManager.transformPt(atom);
            atom.sX = p3i.x;
            atom.sY = p3i.y;
            atom.sZ = p3i.z;
            n2 = Math.abs(atom.madAtom);
            if (n2 == Atom.MAD_GLOBAL) {
                n2 = (int)(viewer.getFloat(0x44100001) * 2000.0f);
            }
            atom.sD = (short)viewer.tm.scaleToScreen(p3i.z, n2);
            n3 = bS2.nextSetBit(n3 + 1);
        }
        if (transformManager.slabEnabled) {
            int n4;
            n3 = viewer.getBoolean(603979940) ? 1 : 0;
            boolean bl2 = viewer.getBoolean(603979939);
            int n5 = gData.getSlab();
            n2 = gData.getDepth();
            if (n3 != 0) {
                JmolMolecule[] jmolMoleculeArray = this.ms.getMolecules();
                int n6 = this.ms.getMoleculeCountInModel(-1);
                for (n4 = 0; n4 < n6; ++n4) {
                    JmolMolecule jmolMolecule = jmolMoleculeArray[n4];
                    int n7 = 0;
                    int n8 = jmolMolecule.firstAtomIndex;
                    if (!bS2.get(n8)) continue;
                    while (n7 < jmolMolecule.ac && !gData.isClippedZ(atomArray[n8].sZ - (atomArray[n8].sD >> 1))) {
                        ++n7;
                        ++n8;
                    }
                    if (n7 == jmolMolecule.ac) continue;
                    n8 = jmolMolecule.firstAtomIndex;
                    for (int i = 0; i < jmolMolecule.ac; ++i) {
                        bS2.clear(n8);
                        atomArray[n8++].sZ = 0;
                    }
                }
            }
            n = bS2.nextSetBit(0);
            while (n >= 0) {
                Atom atom = atomArray[n];
                if (gData.isClippedZ(atom.sZ - (bl2 ? atomArray[n].sD >> 1 : 0))) {
                    atom.setClickable(0);
                    n4 = (bl2 ? -1 : 1) * atom.sD / 2;
                    if (atom.sZ + n4 < n5 || atom.sZ - n4 > n2 || !gData.isInDisplayRange(atom.sX, atom.sY)) {
                        bS2.clear(n);
                    }
                }
                n = this.bsRenderableAtoms.nextSetBit(n + 1);
            }
        }
        if (this.ms.getAtomCount() == 0 || !viewer.getShowNavigationPoint()) {
            return null;
        }
        n3 = Integer.MAX_VALUE;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        n2 = Integer.MIN_VALUE;
        n = bS2.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.sX < n3) {
                n3 = atom.sX;
            }
            if (atom.sX > n9) {
                n9 = atom.sX;
            }
            if (atom.sY < n10) {
                n10 = atom.sY;
            }
            if (atom.sY > n2) {
                n2 = atom.sY;
            }
            n = bS2.nextSetBit(n + 1);
        }
        this.navigationCrossHairMinMax[0] = n3;
        this.navigationCrossHairMinMax[1] = n9;
        this.navigationCrossHairMinMax[2] = n10;
        this.navigationCrossHairMinMax[3] = n2;
        return this.navigationCrossHairMinMax;
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = this.vwr.ms = modelSet;
    }

    public void checkInheritedShapes() {
        if (this.shapes[24] == null) {
            return;
        }
        this.setShapePropertyBs(24, "remapInherited", null, null);
    }

    public void restrictSelected(boolean bl, boolean bl2) {
        BS bS = this.vwr.getSelectedAtomsNoSubset();
        if (bl2) {
            this.vwr.invertSelection();
            BS bS2 = this.vwr.getSelectionSubset();
            if (bS2 != null) {
                bS = this.vwr.getSelectedAtomsNoSubset();
                bS.and(bS2);
                this.vwr.select(bS, false, 0, true);
                BSUtil.invertInPlace(bS, this.vwr.getAtomCount());
                bS.and(bS2);
            }
        }
        BSUtil.andNot(bS, this.vwr.getDeletedAtoms());
        boolean bl3 = this.vwr.getBoolean(0x24000024);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 32768, null);
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 1023, null);
        BS bS3 = this.vwr.bsA();
        int n = 21;
        while (--n >= 0) {
            if (n == 6 || this.getShape(n) == null) continue;
            this.setShapeSizeBs(n, 0, null, bS3);
        }
        if (this.getShape(21) != null) {
            this.setShapePropertyBs(21, "delete", bS3, null);
        }
        this.setLabel(null, bS3);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", bl3);
        }
        this.vwr.select(bS, false, 0, true);
    }
}

