/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MMCifValidationParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class MMCifReader
extends CifReader {
    private boolean isBiomolecule;
    private boolean byChain;
    private boolean bySymop;
    private Map<String, P3> chainAtomMap;
    private Map<String, int[]> chainAtomCounts;
    private Lst<Map<String, Object>> vBiomolecules;
    private Map<String, Object> thisBiomolecule;
    private Map<String, M4> htBiomts;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, BS> assemblyIdAtoms;
    private int thisChain = -1;
    private P3 chainSum;
    private int[] chainAtomCount;
    private static final byte OPER_ID = 12;
    private static final byte OPER_XYZ = 13;
    private static final String[] operFields = new String[]{"_pdbx_struct_oper_list_matrix[1][1]", "_pdbx_struct_oper_list_matrix[1][2]", "_pdbx_struct_oper_list_matrix[1][3]", "_pdbx_struct_oper_list_vector[1]", "_pdbx_struct_oper_list_matrix[2][1]", "_pdbx_struct_oper_list_matrix[2][2]", "_pdbx_struct_oper_list_matrix[2][3]", "_pdbx_struct_oper_list_vector[2]", "_pdbx_struct_oper_list_matrix[3][1]", "_pdbx_struct_oper_list_matrix[3][2]", "_pdbx_struct_oper_list_matrix[3][3]", "_pdbx_struct_oper_list_vector[3]", "_pdbx_struct_oper_list_id", "_pdbx_struct_oper_list_symmetry_operation"};
    private static final byte ASSEM_ID = 0;
    private static final byte ASSEM_OPERS = 1;
    private static final byte ASSEM_LIST = 2;
    private static final String[] assemblyFields = new String[]{"_pdbx_struct_assembly_gen_assembly_id", "_pdbx_struct_assembly_gen_oper_expression", "_pdbx_struct_assembly_gen_asym_id_list"};
    private String[] assem = null;
    private static final byte STRUCT_REF_G3 = 0;
    private static final byte STRUCT_REF_G1 = 1;
    private static final String[] structRefFields = new String[]{"_struct_ref_seq_dif_mon_id", "_struct_ref_seq_dif.db_mon_id"};
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private Map<String, String> htHetero;
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_pdb_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_pdb_ins_code", "_struct_conf_id", "_struct_conf_pdbx_pdb_helix_id", "_struct_conf_pdbx_pdb_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_pdb_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_pdb_ins_code", "_struct_sheet_range_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 1;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 2;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 3;
    private static final String[] chemCompBondFields = new String[]{"_chem_comp_bond_atom_id_1", "_chem_comp_bond_atom_id_2", "_chem_comp_bond_value_order", "_chem_comp_bond_pdbx_aromatic_flag"};

    @Override
    protected void initSubclass() {
        this.setIsPDB();
        this.isMMCIF = true;
        this.byChain = this.checkFilterKey("BYCHAIN");
        this.bySymop = this.checkFilterKey("BYSYMOP");
        boolean bl = this.isCourseGrained = this.byChain || this.bySymop;
        if (this.byChain) {
            this.chainAtomMap = new Hashtable<String, P3>();
            this.chainAtomCounts = new Hashtable<String, int[]>();
        }
        if (this.checkFilterKey("BIOMOLECULE")) {
            this.filter = PT.rep(this.filter, "BIOMOLECULE", "ASSEMBLY");
        }
        this.isBiomolecule = this.checkFilterKey("ASSEMBLY");
    }

    @Override
    protected void finalizeSubclass() throws Exception {
        String string;
        Object object;
        if (this.byChain && !this.isBiomolecule) {
            object = this.chainAtomMap.keySet().iterator();
            while (object.hasNext()) {
                string = object.next();
                this.createParticle(string);
            }
        }
        if (!this.isCourseGrained && this.asc.ac == this.nAtoms) {
            this.asc.removeCurrentAtomSet();
        } else {
            if (this.validation != null && !this.isCourseGrained && (string = ((MMCifValidationParser)(object = ((MMCifValidationParser)Interface.getInterface("org.jmol.adapter.readers.cif.MMCifValidationParser")).set(this))).finalizeValidations(this.modelMap)) != null) {
                this.appendLoadNote(string);
            }
            this.applySymmetryAndSetTrajectory();
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.vBiomolecules != null && this.vBiomolecules.size() == 1 && (this.isCourseGrained || this.asc.ac > 0)) {
            this.asc.setAtomSetAuxiliaryInfo("biomolecules", this.vBiomolecules);
            object = (Map)this.vBiomolecules.get(0);
            this.appendLoadNote("Constructing " + object.get("name"));
            this.setBiomolecules((Map<String, Object>)object);
            if (this.thisBiomolecule != null) {
                this.asc.getXSymmetry().applySymmetryBio(this.thisBiomolecule, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
                this.asc.xtalSymmetry = null;
            }
        }
    }

    @Override
    protected void processSubclassEntry() throws Exception {
        if (this.key.startsWith("_pdbx_entity_nonpoly")) {
            this.processDataNonpoly();
        } else if (this.key.startsWith("_pdbx_struct_assembly_gen")) {
            this.processDataAssemblyGen();
        }
    }

    private boolean processSequence() throws Exception {
        this.parseLoopParameters(structRefFields);
        while (this.parser.getData()) {
            String string = null;
            String string2 = null;
            int n = this.parser.getFieldCount();
            block5: for (int i = 0; i < n; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        string2 = this.field;
                        continue block5;
                    }
                    case 1: {
                        if (this.field.length() != 1) continue block5;
                        string = this.field.toLowerCase();
                    }
                }
            }
            if (string == null || string2 == null) continue;
            if (this.htGroup1 == null) {
                this.htGroup1 = new Hashtable();
                this.asc.setInfo("htGroup1", this.htGroup1);
            }
            this.htGroup1.put(string2, string);
        }
        return true;
    }

    private void processDataNonpoly() throws Exception {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!this.key.equals(nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processDataAssemblyGen() throws Exception {
        if (this.assem == null) {
            this.assem = new String[3];
        }
        if (this.key.indexOf("assembly_id") >= 0) {
            this.assem[0] = this.parser.fullTrim(this.data);
        } else if (this.key.indexOf("oper_expression") >= 0) {
            this.assem[1] = this.parser.fullTrim(this.data);
        } else if (this.key.indexOf("asym_id_list") >= 0) {
            this.assem[2] = this.parser.fullTrim(this.data);
        }
        if (this.assem[0] != null && this.assem[1] != null && this.assem[2] != null) {
            this.addAssembly();
        }
    }

    private boolean processAssemblyGenBlock() throws Exception {
        this.parseLoopParameters(assemblyFields);
        while (this.parser.getData()) {
            this.assem = new String[3];
            int n = 0;
            int n2 = this.parser.getFieldCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.fieldProperty(i);
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++n;
                        this.assem[n3] = this.field;
                    }
                }
            }
            if (n != 3) continue;
            this.addAssembly();
        }
        this.assem = null;
        return true;
    }

    private void addAssembly() throws Exception {
        String string = this.assem[0];
        int n = this.parseIntStr(string);
        String string2 = this.assem[2];
        this.appendLoadNote("found biomolecule " + string + ": " + string2);
        if (!this.checkFilterKey("ASSEMBLY " + string + ";")) {
            return;
        }
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", "biomolecule " + string);
        hashtable.put("molecule", n == Integer.MIN_VALUE ? string : Integer.valueOf(n));
        hashtable.put("assemblies", "$" + string2.replace(',', '$'));
        hashtable.put("operators", this.decodeAssemblyOperators(this.assem[1]));
        hashtable.put("biomts", new Lst());
        this.thisBiomolecule = hashtable;
        Logger.info("assembly " + string + " operators " + this.assem[1] + " ASYM_IDs " + this.assem[2]);
        this.vBiomolecules.addLast((Map<String, Object>)hashtable);
        this.assem = null;
    }

    private String decodeAssemblyOperators(String string) {
        int n = string.indexOf(")(");
        if (n >= 0) {
            return this.crossBinary(this.decodeAssemblyOperators(string.substring(0, n + 1)), this.decodeAssemblyOperators(string.substring(n + 1)));
        }
        if (string.startsWith("(")) {
            if (string.indexOf("-") >= 0) {
                string = BS.unescape("({" + string.substring(1, string.length() - 1).replace('-', ':') + "})").toString();
            }
            string = PT.rep(string, " ", "");
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String crossBinary(String string, String string2) {
        SB sB = new SB();
        String[] stringArray = PT.split(string, ",");
        String[] stringArray2 = PT.split(string2, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                sB.append(",").append(stringArray[i]).append("|").append(stringArray2[j]);
            }
        }
        return sB.toString().substring(1);
    }

    private boolean processStructOperListBlock() throws Exception {
        this.parseLoopParameters(operFields);
        float[] fArray = new float[16];
        fArray[15] = 1.0f;
        while (this.parser.getData()) {
            int n = 0;
            String string = null;
            String string2 = null;
            int n2 = this.parser.getFieldCount();
            block6: for (int i = 0; i < n2; ++i) {
                int n3 = this.fieldProperty(i);
                switch (n3) {
                    case -1: {
                        continue block6;
                    }
                    case 12: {
                        string = this.field;
                        continue block6;
                    }
                    case 13: {
                        string2 = this.field;
                        continue block6;
                    }
                    default: {
                        fArray[n3] = this.parseFloatStr(this.field);
                        ++n;
                    }
                }
            }
            if (string == null || n != 12 && (string2 == null || this.symmetry == null)) continue;
            Logger.info("assembly operator " + string + " " + string2);
            M4 m4 = new M4();
            if (n != 12) {
                this.symmetry.getMatrixFromString(string2, fArray, false, 0);
                fArray[3] = fArray[3] * (this.symmetry.getUnitCellInfoType(0) / 12.0f);
                fArray[7] = fArray[7] * (this.symmetry.getUnitCellInfoType(1) / 12.0f);
                fArray[11] = fArray[11] * (this.symmetry.getUnitCellInfoType(2) / 12.0f);
            }
            m4.setA(fArray);
            if (this.htBiomts == null) {
                this.htBiomts = new Hashtable<String, M4>();
            }
            this.htBiomts.put(string, m4);
        }
        return true;
    }

    private boolean processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.parser.getData()) {
            String string = null;
            String string2 = null;
            int n = this.parser.getFieldCount();
            block6: for (int i = 0; i < n; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            this.addHetero(string, string2);
        }
        return true;
    }

    private boolean processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.parser.getData()) {
            String string = null;
            String string2 = null;
            int n = this.parser.getFieldCount();
            block6: for (int i = 0; i < n; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return false;
            }
            this.addHetero(string, string2);
        }
        return true;
    }

    private void addHetero(String string, String string2) {
        if (!JmolAdapter.isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        this.htHetero.put(string, string2);
        if (Logger.debugging) {
            Logger.debug("hetero: " + string + " = " + string2);
        }
    }

    private boolean processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing property: " + structConfFields[n]);
            return false;
        }
        while (this.parser.getData()) {
            Structure structure = new Structure(-1, STR.HELIX, STR.HELIX, null, 0, 0);
            int n2 = this.parser.getFieldCount();
            block15: for (int i = 0; i < n2; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = structure.substructureType = STR.TURN;
                            continue block15;
                        }
                        if (this.field.startsWith("HELX")) continue block15;
                        structure.structureType = structure.substructureType = STR.NONE;
                        continue block15;
                    }
                    case 1: {
                        structure.startChainStr = this.field;
                        structure.startChainID = this.vwr.getChainID(this.field);
                        continue block15;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 4: {
                        structure.endChainStr = this.field;
                        structure.endChainID = this.vwr.getChainID(this.field);
                        continue block15;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType(this.parseIntStr(this.field));
                        continue block15;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block15;
                    }
                    case 8: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.asc.addStructure(structure);
        }
        return true;
    }

    private boolean processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing property:" + structSheetRangeFields[n]);
            return false;
        }
        while (this.parser.getData()) {
            Structure structure = new Structure(-1, STR.SHEET, STR.SHEET, null, 0, 0);
            int n2 = this.parser.getFieldCount();
            block12: for (int i = 0; i < n2; ++i) {
                switch (this.fieldProperty(i)) {
                    case 1: {
                        structure.startChainID = this.vwr.getChainID(this.field);
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.vwr.getChainID(this.field);
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 0: {
                        structure.strandCount = 1;
                        structure.structureID = this.field;
                        continue block12;
                    }
                    case 7: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.asc.addStructure(structure);
        }
        return true;
    }

    protected void parseSubclassLoopParameters(String[] stringArray) throws Exception {
        this.parseLoopParameters(stringArray);
        this.propertyCount = stringArray.length;
    }

    private boolean processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing property: " + structSiteRangeFields[n]);
            return false;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Map<String, Object> map = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.parser.getData()) {
            int n2 = this.parser.getFieldCount();
            for (int i = 0; i < n2; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        if (string6 != "") {
                            String string7 = (String)map.get("groups");
                            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            map.put("groups", string7);
                        }
                        if ((map = this.htSites.get(string = this.field)) == null) {
                            map = new Hashtable<String, Object>();
                            map.put("groups", "");
                            this.htSites.put(string, map);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = this.field;
                        break;
                    }
                    case 2: {
                        string4 = this.field;
                        break;
                    }
                    case 3: {
                        string2 = this.field;
                        break;
                    }
                    case 4: {
                        string3 = this.field;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string8 = (String)map.get("groups");
            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
            string6 = "";
            map.put("groups", string8);
        }
        return true;
    }

    private void setBiomolecules(Map<String, Object> map) {
        Object object;
        if (!this.isBiomolecule || this.assemblyIdAtoms == null && this.chainAtomCounts == null) {
            return;
        }
        M4 m4 = M4.newM4(null);
        String[] stringArray = PT.split((String)map.get("operators"), ",");
        String string = (String)map.get("assemblies");
        Lst<Object> lst = new Lst<Object>();
        map.put("biomts", lst);
        lst.addLast(m4);
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.getOpMatrix(stringArray[i]);
            if (object == null || ((M4)object).equals(m4)) continue;
            lst.addLast(object);
        }
        BS bS = new BS();
        object = new P3();
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = PT.split(string, "$");
        for (int i = 1; i < stringArray2.length; ++i) {
            JSONEncodable jSONEncodable;
            String string2 = stringArray2[i];
            if (this.assemblyIdAtoms != null) {
                jSONEncodable = this.assemblyIdAtoms.get(string2);
                if (jSONEncodable == null) continue;
                bS.or((BS)jSONEncodable);
                continue;
            }
            if (!this.isCourseGrained) continue;
            jSONEncodable = this.chainAtomMap.get(string2);
            int n3 = this.chainAtomCounts.get(string2)[0];
            if (jSONEncodable == null) continue;
            if (this.bySymop) {
                ((T3)object).add((T3)jSONEncodable);
                n += n3;
                continue;
            }
            this.createParticle(string2);
            ++n2;
        }
        if (this.isCourseGrained) {
            if (this.bySymop) {
                n2 = 1;
                Atom atom = new Atom();
                atom.setT((T3)object);
                atom.scale(1.0f / (float)n);
                atom.radius = 16.0f;
            }
        } else {
            n2 = bS.cardinality();
            if (n2 < this.asc.ac) {
                this.asc.bsAtoms = bS;
            }
        }
        map.put("atomCount", n2 * stringArray.length);
    }

    private void createParticle(String string) {
        P3 p3 = this.chainAtomMap.get(string);
        int n = this.chainAtomCounts.get(string)[0];
        Atom atom = new Atom();
        atom.setT(p3);
        atom.scale(1.0f / (float)n);
        atom.elementSymbol = "Pt";
        atom.chainID = this.vwr.getChainID(string);
        atom.radius = 16.0f;
        this.asc.addAtom(atom);
    }

    private M4 getOpMatrix(String string) {
        if (this.htBiomts == null) {
            return M4.newM4(null);
        }
        int n = string.indexOf("|");
        if (n >= 0) {
            M4 m4 = M4.newM4(this.htBiomts.get(string.substring(0, n)));
            m4.mul(this.htBiomts.get(string.substring(n + 1)));
            return m4;
        }
        return this.htBiomts.get(string);
    }

    private boolean processLigandBondLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing property: " + chemCompBondFields[n]);
            return false;
        }
        n = 0;
        boolean bl = false;
        while (this.parser.getData()) {
            Atom atom = null;
            Atom atom2 = null;
            n = 0;
            bl = false;
            int n2 = this.parser.getFieldCount();
            block12: for (int i = 0; i < n2; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        atom = this.asc.getAtomFromName(this.field);
                        continue block12;
                    }
                    case 1: {
                        atom2 = this.asc.getAtomFromName(this.field);
                        continue block12;
                    }
                    case 3: {
                        bl = this.field.charAt(0) == 'Y';
                        continue block12;
                    }
                    case 2: {
                        n = this.getBondOrder(this.field);
                    }
                }
            }
            if (bl) {
                switch (n) {
                    case 1: {
                        n = 513;
                        break;
                    }
                    case 2: {
                        n = 514;
                    }
                }
            }
            this.asc.addNewBondWithOrderA(atom, atom2, n);
        }
        return true;
    }

    @Override
    public boolean processSubclassAtom(Atom atom, String string, String string2) {
        if (this.byChain && !this.isBiomolecule) {
            if (this.thisChain != atom.chainID) {
                this.thisChain = atom.chainID;
                String string3 = "" + atom.chainID;
                this.chainSum = this.chainAtomMap.get(string3);
                if (this.chainSum == null) {
                    this.chainSum = new P3();
                    this.chainAtomMap.put(string3, this.chainSum);
                    this.chainAtomCount = new int[1];
                    this.chainAtomCounts.put(string3, this.chainAtomCount);
                }
            }
            this.chainSum.add(atom);
            this.chainAtomCount[0] = this.chainAtomCount[0] + 1;
            return false;
        }
        if (this.isBiomolecule && this.isCourseGrained) {
            P3 p3 = this.chainAtomMap.get(string);
            if (p3 == null) {
                p3 = new P3();
                this.chainAtomMap.put(string, p3);
                this.chainAtomCounts.put(string, new int[1]);
            }
            int[] nArray = this.chainAtomCounts.get(string);
            nArray[0] = nArray[0] + 1;
            p3.add(atom);
            return false;
        }
        if (string != null) {
            BS bS;
            if (this.assemblyIdAtoms == null) {
                this.assemblyIdAtoms = new Hashtable<String, BS>();
            }
            if ((bS = this.assemblyIdAtoms.get(string)) == null) {
                bS = new BS();
                this.assemblyIdAtoms.put(string, bS);
            }
            bS.set(this.ac);
        }
        if (atom.isHetero && this.htHetero != null) {
            this.asc.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.asc.setInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        return true;
    }

    @Override
    protected boolean processSubclassLoopBlock() throws Exception {
        if (this.key.startsWith("_pdbx_struct_oper_list")) {
            return this.processStructOperListBlock();
        }
        if (this.key.startsWith("_pdbx_struct_assembly_gen")) {
            return this.processAssemblyGenBlock();
        }
        if (this.key.startsWith("_struct_ref_seq_dif")) {
            return this.processSequence();
        }
        if (this.isCourseGrained) {
            return false;
        }
        if (this.key.startsWith("_struct_site_gen")) {
            return this.processStructSiteBlock();
        }
        if (this.key.startsWith("_chem_comp_bond")) {
            return this.processLigandBondLoopBlock();
        }
        if (this.key.startsWith("_chem_comp")) {
            return this.processChemCompLoopBlock();
        }
        if (this.key.startsWith("_pdbx_entity_nonpoly")) {
            return this.processNonpolyLoopBlock();
        }
        if (this.key.startsWith("_struct_conf") && !this.key.startsWith("_struct_conf_type")) {
            return this.processStructConfLoopBlock();
        }
        if (this.key.startsWith("_struct_sheet_range")) {
            return this.processStructSheetRangeLoopBlock();
        }
        return false;
    }
}

