/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer.binding;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;

public abstract class Binding {
    public static final int LEFT = 16;
    public static final int MIDDLE = 8;
    public static final int RIGHT = 4;
    public static final int WHEEL = 32;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int SHIFT = 1;
    public static final int CTRL_ALT = 10;
    public static final int CTRL_SHIFT = 3;
    public static final int MAC_COMMAND = 20;
    public static final int BUTTON_MASK = 28;
    public static final int BUTTON_MODIFIER_MASK = 63;
    public static final int SINGLE = 256;
    public static final int DOUBLE = 512;
    public static final int COUNT_MASK = 768;
    public static final int DOWN = 4096;
    public static final int DRAG = 8192;
    public static final int UP = 16384;
    public static final int CLICK = 32768;
    public static final int MODE_MASK = 61440;
    public String name;
    private Map<String, Object> bindings = new Hashtable<String, Object>();

    public static int getMouseAction(int n, int n2, int n3) {
        if (n > 2) {
            n = 2;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n = 256;
                break;
            }
            default: {
                n = 512;
            }
        }
        switch (n3) {
            case 4: {
                n3 = 4096;
                break;
            }
            case 1: {
                n3 = 8192;
                break;
            }
            case 5: {
                n3 = 16384;
                break;
            }
            case 2: {
                n3 = 32768;
                break;
            }
            case 3: {
                n3 = 32;
            }
        }
        return n2 & 0x3F | n | n3;
    }

    public static int getMouseActionStr(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        n = (string = string.toUpperCase()).indexOf("MIDDLE") >= 0 ? 8 : (string.indexOf("RIGHT") >= 0 ? 4 : (string.indexOf("WHEEL") >= 0 ? 32 : 16));
        if (string.indexOf("DOWN") >= 0) {
            n |= 0x1000;
        } else if (string.indexOf("DRAG") >= 0) {
            n |= 0x2000;
        } else if (string.indexOf("UP") >= 0) {
            n |= 0x4000;
        } else if (n != 32) {
            n |= 0x8000;
        }
        if (n != 32 && string.indexOf("DOUBLE") >= 0) {
            n |= 0x200;
        } else if (n > 0) {
            n |= 0x100;
        }
        if (n != 288 && string.indexOf("ALT") >= 0) {
            n |= 8;
        }
        if (string.indexOf("CTRL") >= 0) {
            n |= 2;
        }
        if (string.indexOf("SHIFT") >= 0) {
            n |= 1;
        }
        return n;
    }

    public static int getButtonMods(int n) {
        return n & 0x3F;
    }

    public static int getClickCount(int n) {
        return (n & 0x300) >> 8;
    }

    public static String getMouseActionName(int n, boolean bl) {
        SB sB = new SB();
        if (n == 0) {
            return "";
        }
        boolean bl2 = Binding.includes(n, 8) && !Binding.includes(n, 16) && !Binding.includes(n, 4);
        char[] cArray = "      ".toCharArray();
        if (Binding.includes(n, 2)) {
            sB.append("CTRL+");
            cArray[5] = 67;
        }
        if (!bl2 && Binding.includes(n, 8)) {
            sB.append("ALT+");
            cArray[4] = 65;
        }
        if (Binding.includes(n, 1)) {
            sB.append("SHIFT+");
            cArray[3] = 83;
        }
        if (Binding.includes(n, 16)) {
            cArray[2] = 76;
            sB.append("LEFT");
        } else if (Binding.includes(n, 4)) {
            cArray[2] = 82;
            sB.append("RIGHT");
        } else if (bl2) {
            cArray[2] = 77;
            sB.append("MIDDLE");
        } else if (Binding.includes(n, 32)) {
            cArray[2] = 87;
            sB.append("WHEEL");
        }
        if (Binding.includes(n, 512)) {
            sB.append("+double");
            cArray[1] = 50;
        }
        if (Binding.includes(n, 4096)) {
            sB.append("+down");
            cArray[0] = 49;
        } else if (Binding.includes(n, 8192)) {
            sB.append("+drag");
            cArray[0] = 50;
        } else if (Binding.includes(n, 16384)) {
            sB.append("+up");
            cArray[0] = 51;
        } else if (Binding.includes(n, 32768)) {
            sB.append("+click");
            cArray[0] = 52;
        }
        return bl ? new String(cArray) + ":" + sB.toString() : sB.toString();
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public final void bindAction(int n, int n2) {
        this.addBinding(n + "\t" + n2, new int[]{n, n2});
    }

    public void bindName(int n, String string) {
        this.addBinding(n + "\t", Boolean.TRUE);
        this.addBinding(n + "\t" + string, new String[]{Binding.getMouseActionName(n, false), string});
    }

    public final void unbindAction(int n, int n2) {
        if (n == 0) {
            this.unbindJmolAction(n2);
        } else {
            this.removeBinding(null, n + "\t" + n2);
        }
    }

    public final void unbindName(int n, String string) {
        if (string == null) {
            this.unbindMouseAction(n);
        } else {
            this.removeBinding(null, n + "\t" + string);
        }
    }

    public final void unbindJmolAction(int n) {
        Iterator<String> iterator = this.bindings.keySet().iterator();
        String string = "\t" + n;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.endsWith(string)) continue;
            this.removeBinding(iterator, string2);
        }
    }

    private void addBinding(String string, Object object) {
        if (Logger.debugging) {
            Logger.debug("adding binding " + string + "\t==\t" + Escape.e(object));
        }
        this.bindings.put(string, object);
    }

    private void removeBinding(Iterator<String> iterator, String string) {
        if (Logger.debugging) {
            Logger.debug("removing binding " + string);
        }
        if (iterator == null) {
            this.bindings.remove(string);
        } else {
            iterator.remove();
        }
    }

    public final void unbindUserAction(String string) {
        Iterator<String> iterator = this.bindings.keySet().iterator();
        String string2 = "\t" + string;
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string3.endsWith(string2)) continue;
            this.removeBinding(iterator, string3);
        }
    }

    public final void unbindMouseAction(int n) {
        Iterator<String> iterator = this.bindings.keySet().iterator();
        String string = n + "\t";
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            this.removeBinding(iterator, string2);
        }
    }

    public final boolean isBound(int n, int n2) {
        return this.bindings.containsKey(n + "\t" + n2);
    }

    public final boolean isUserAction(int n) {
        return this.bindings.containsKey(n + "\t");
    }

    public String getBindingInfo(String[] stringArray, String[] stringArray2, String string) {
        int n;
        SB sB = new SB();
        String string2 = string == null || string.equalsIgnoreCase("all") ? null : string.toLowerCase();
        Lst[] lstArray = new Lst[stringArray.length];
        Lst<String[]> lst = new Lst<String[]>();
        for (Object object : this.bindings.values()) {
            Object object2;
            if (PT.isAI(object)) {
                object2 = (int[])object;
                int n2 = object2[1];
                if (lstArray[n2] == null) {
                    lstArray[n2] = new Lst();
                }
                String string3 = Binding.getMouseActionName(object2[0], true);
                if (string2 != null && (stringArray2[n2] + ";" + stringArray[n2] + ";" + string3).toLowerCase().indexOf(string2) < 0) continue;
                lstArray[n2].addLast(string3);
                continue;
            }
            if (!PT.isAS(object)) continue;
            object2 = ((String[])object)[0];
            String string4 = ((String[])object)[1];
            if (string2 != null && string2.indexOf("user") < 0 && object2.indexOf(string2) < 0 && string4.indexOf(string2) < 0) continue;
            lst.addLast((String[])object);
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n3;
            if (lstArray[n] == null || (n3 = lstArray[n].size()) == 0) continue;
            this.addInfo(sB, lstArray[n].toArray(new String[n3]), stringArray2[n], stringArray[n]);
        }
        for (n = 0; n < lst.size(); ++n) {
            String[] stringArray3 = (String[])lst.get(n);
            this.addInfo(sB, new String[]{"USER:::" + stringArray3[0]}, "user-defined", stringArray3[1]);
        }
        return sB.toString();
    }

    private void addInfo(SB sB, String[] stringArray, String string, String string2) {
        Arrays.sort(stringArray);
        Txt.leftJustify(sB, "                      ", string);
        sB.append("\t");
        String string3 = "";
        int n = sB.length();
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(string3).append(stringArray[i].substring(7));
            string3 = ", ";
        }
        n = sB.length() - n;
        if (n < 20) {
            sB.append("                 ".substring(0, 20 - n));
        }
        sB.append("\t").append(string2).appendC('\n');
    }

    private static boolean includes(int n, int n2) {
        return (n & n2) == n2;
    }

    public static Binding newBinding(String string) {
        return (Binding)Interface.getInterface("org.jmol.viewer.binding." + string + "Binding");
    }
}

