/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.M4;
import javajs.util.V3;
import org.jmol.util.C;

public class Shader {
    private static final int SHADE_INDEX_MAX = 64;
    public static final int SHADE_INDEX_LAST = 63;
    public static final byte SHADE_INDEX_NORMAL = 52;
    public static final byte SHADE_INDEX_NOISY_LIMIT = 56;
    private float xLight;
    private float yLight;
    private float zLight;
    V3 lightSource = new V3();
    public boolean specularOn = true;
    public boolean usePhongExponent = false;
    public int ambientPercent = 45;
    public int diffusePercent = 84;
    public int specularExponent = 6;
    public int specularPercent = 22;
    public int specularPower = 40;
    public int phongExponent = 64;
    public float ambientFraction = (float)this.ambientPercent / 100.0f;
    public float diffuseFactor = (float)this.diffusePercent / 100.0f;
    public float intenseFraction = (float)this.specularPower / 100.0f;
    public float specularFactor = (float)this.specularPercent / 100.0f;
    private int[][] ashades = AU.newInt2(128);
    private int[][] ashadesGreyscale;
    public boolean celOn;
    public int celPower = 10;
    private int celRGB;
    private float celZ;
    private boolean useLight;
    public byte[] sphereShadeIndexes = new byte[65536];
    private int seed = 305419897;
    private static final int SLIM = 20;
    private static final int SDIM = 40;
    public static final int maxSphereCache = 128;
    public int[][] sphereShapeCache = AU.newInt2(128);
    public byte[][][] ellipsoidShades;
    public int nOut;
    public int nIn;

    public Shader() {
        this.setLightSource(-1.0f, -1.0f, 2.5f);
    }

    private void setLightSource(float f, float f2, float f3) {
        this.lightSource.set(f, f2, f3);
        this.lightSource.normalize();
        this.xLight = this.lightSource.x;
        this.yLight = this.lightSource.y;
        this.zLight = this.lightSource.z;
    }

    public void setCel(boolean bl, int n, int n2) {
        bl = bl && n != 0;
        int n3 = (n2 = C.getArgb(C.getBgContrast(n2))) == -16777216 ? -16514044 : (n2 = n2 == -1 ? -2 : n2 + 1);
        if (this.celOn == bl && this.celRGB == n2 && this.celPower == n) {
            return;
        }
        this.celOn = bl;
        this.celPower = n;
        this.useLight = !this.celOn || n > 0;
        this.celZ = 1.0f - (float)Math.pow(2.0, (float)(-Math.abs(n)) / 10.0f);
        this.celRGB = n2;
        this.flushCaches();
    }

    public void flushCaches() {
        this.flushShades();
        this.flushSphereCache();
    }

    public void setLastColix(int n, boolean bl) {
        C.allocateColix(n);
        this.checkShades();
        if (bl) {
            C.setLastGrey(n);
        }
        this.ashades[2047] = this.getShades2(n, false);
    }

    public int[] getShades(short s) {
        this.checkShades();
        s = (short)(s & 0xFFFF87FF);
        int[] nArray = this.ashades[s];
        if (nArray == null) {
            this.ashades[s] = this.getShades2(C.argbs[s], false);
            nArray = this.ashades[s];
        }
        return nArray;
    }

    public int[] getShadesG(short s) {
        int[] nArray;
        this.checkShades();
        s = (short)(s & 0xFFFF87FF);
        if (this.ashadesGreyscale == null) {
            this.ashadesGreyscale = AU.newInt2(this.ashades.length);
        }
        if ((nArray = this.ashadesGreyscale[s]) == null) {
            this.ashadesGreyscale[s] = this.getShades2(C.argbs[s], true);
            nArray = this.ashadesGreyscale[s];
        }
        return nArray;
    }

    private void checkShades() {
        if (this.ashades != null && this.ashades.length == C.colixMax) {
            return;
        }
        this.ashades = AU.arrayCopyII(this.ashades, C.colixMax);
        if (this.ashadesGreyscale != null) {
            this.ashadesGreyscale = AU.arrayCopyII(this.ashadesGreyscale, C.colixMax);
        }
    }

    public void flushShades() {
        this.checkShades();
        int n = C.colixMax;
        while (--n >= 0) {
            this.ashades[n] = null;
        }
        this.calcSphereShading();
    }

    private int[] getShades2(int n, boolean bl) {
        int n2;
        int[] nArray = new int[64];
        if (n == 0) {
            return nArray;
        }
        float f = n >> 16 & 0xFF;
        float f2 = n >> 8 & 0xFF;
        float f3 = n & 0xFF;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = this.ambientFraction;
        while (true) {
            f4 = f * f7 + 0.5f;
            f5 = f2 * f7 + 0.5f;
            f6 = f3 * f7 + 0.5f;
            if (!(f7 > 0.0f) || !(f4 < 4.0f) || !(f5 < 4.0f) || !(f6 < 4.0f)) break;
            f += 1.0f;
            f2 += 1.0f;
            f3 += 1.0f;
            if (f7 < 0.1f) {
                f7 += 0.1f;
            }
            n = CU.rgb((int)Math.floor(f), (int)Math.floor(f2), (int)Math.floor(f3));
        }
        f7 = (1.0f - f7) / 52.0f;
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        if (this.celOn) {
            int n3 = 32;
            int n4 = CU.rgb((int)Math.floor(f4), (int)Math.floor(f5), (int)Math.floor(f6));
            if (this.celPower >= 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray[n2] = n4;
                }
            }
            n4 = CU.rgb((int)Math.floor(f4 += f8 * (float)n3), (int)Math.floor(f5 += f9 * (float)n3), (int)Math.floor(f6 += f10 * (float)n3));
            while (n2 < 64) {
                nArray[n2] = n4;
                ++n2;
            }
            nArray[0] = nArray[1] = this.celRGB;
        } else {
            while (n2 < 52) {
                nArray[n2] = CU.rgb((int)Math.floor(f4), (int)Math.floor(f5), (int)Math.floor(f6));
                f4 += f8;
                f5 += f9;
                f6 += f10;
                ++n2;
            }
            nArray[n2++] = n;
            f7 = this.intenseFraction / (float)(64 - n2);
            f8 = (255.5f - f4) * f7;
            f9 = (255.5f - f5) * f7;
            f10 = (255.5f - f6) * f7;
            while (n2 < 64) {
                nArray[n2] = CU.rgb((int)Math.floor(f4 += f8), (int)Math.floor(f5 += f9), (int)Math.floor(f6 += f10));
                ++n2;
            }
        }
        if (bl) {
            while (--n2 >= 0) {
                nArray[n2] = CU.toFFGGGfromRGB(nArray[n2]);
            }
        }
        return nArray;
    }

    public int getShadeIndex(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return Math.round(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f);
    }

    public byte getShadeB(float f, float f2, float f3) {
        return (byte)Math.round(this.getShadeF(f, f2, f3) * 63.0f);
    }

    public int getShadeFp8(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)Math.floor(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f * 256.0f);
    }

    private float getShadeF(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6 = f5 = this.useLight ? f * this.xLight + f2 * this.yLight + f3 * this.zLight : f3;
        if (f5 <= 0.0f) {
            return 0.0f;
        }
        float f7 = f5 * this.diffuseFactor;
        if (this.specularOn && (f4 = 2.0f * f5 * f3 - this.zLight) > 0.0f) {
            if (this.usePhongExponent) {
                f4 = (float)Math.pow(f4, this.phongExponent);
            } else {
                int n = this.specularExponent;
                while (--n >= 0 && f4 > 1.0E-4f) {
                    f4 *= f4;
                }
            }
            f7 += f4 * this.specularFactor;
        }
        return this.celOn && f3 < this.celZ ? 0.0f : (f7 > 1.0f ? 1.0f : f7);
    }

    public byte getShadeN(float f, float f2, float f3, float f4) {
        int n;
        int n2 = (int)Math.floor(this.getShadeF(f / f4, f2 / f4, f3 / f4) * 63.0f * 256.0f);
        int n3 = n2 >> 8;
        if (!this.useLight) {
            return (byte)n3;
        }
        if ((n2 & 0xFF) > this.nextRandom8Bit()) {
            ++n3;
        }
        if ((n = this.seed & 0xFFFF) < 21845 && n3 > 0) {
            --n3;
        } else if (n > 43690 && n3 < 63) {
            ++n3;
        }
        return (byte)n3;
    }

    private synchronized void calcSphereShading() {
        float f = -127.5f;
        float f2 = 16900.0f;
        for (int i = 0; i < 256; ++i) {
            float f3 = -127.5f;
            float f4 = f * f;
            for (int j = 0; j < 256; ++j) {
                byte by = 0;
                float f5 = f2 - f4 - f3 * f3;
                if (f5 > 0.0f) {
                    float f6 = (float)Math.sqrt(f5);
                    by = this.getShadeN(f, f3, f6, 130.0f);
                }
                this.sphereShadeIndexes[(j << 8) + i] = by;
                f3 += 1.0f;
            }
            f += 1.0f;
        }
    }

    public int nextRandom8Bit() {
        int n = this.seed;
        this.seed = n = (n << 16) + (n << 1) + n & Integer.MAX_VALUE;
        return n >> 23;
    }

    public int getEllipsoidShade(float f, float f2, float f3, int n, M4 m4) {
        boolean bl;
        float f4 = m4.m00 * f + m4.m01 * f2 + m4.m02 * f3 + m4.m03;
        float f5 = m4.m10 * f + m4.m11 * f2 + m4.m12 * f3 + m4.m13;
        float f6 = m4.m20 * f + m4.m21 * f2 + m4.m22 * f3 + m4.m23;
        float f7 = Math.min((float)n / 2.0f, 45.0f) / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        int n2 = (int)(-f4 * f7);
        int n3 = (int)(-f5 * f7);
        int n4 = (int)(f6 * f7);
        boolean bl2 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        if (bl) {
            while (n2 % 2 == 0 && n3 % 2 == 0 && n4 % 2 == 0 && n2 + n3 + n4 > 0) {
                n2 >>= 1;
                n3 >>= 1;
                n4 >>= 1;
            }
            boolean bl3 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        }
        if (bl) {
            ++this.nOut;
        } else {
            ++this.nIn;
        }
        return bl ? this.getShadeIndex(n2, n3, n4) : this.ellipsoidShades[n2 + 20][n3 + 20][n4];
    }

    public void createEllipsoidShades() {
        this.ellipsoidShades = new byte[40][40][40];
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < 40; ++k) {
                    this.ellipsoidShades[i][j][k] = (byte)this.getShadeIndex(i - 20, j - 20, k);
                }
            }
        }
    }

    public synchronized void flushSphereCache() {
        int n = 128;
        while (--n >= 0) {
            this.sphereShapeCache[n] = null;
        }
        this.ellipsoidShades = null;
    }

    public void occludePixels(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3) {
        int n4 = nArray2.length;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            int n7 = nArray2[i];
            int n8 = Math.min(n7 >> 5, 0);
            if (n8 == 0) continue;
            int n9 = n8 * n8;
            int n10 = Math.min(n, n5 + n8);
            int n11 = Math.min(n2, n6 + n8);
            for (int j = Math.max(0, n5 - n8); j < n10; ++j) {
                for (int k = Math.max(0, n6 - n8); k < n11; ++k) {
                    int n12;
                    int n13;
                    int n14 = j - n5;
                    int n15 = k - n6;
                    int n16 = n14 * n14 + n15 * n15;
                    if (n16 <= n9 && (n13 = nArray2[n12 = i + n * n15 + n14] - n7) > n7 && n13 * n13 <= n16) continue;
                }
            }
            if (++n5 != n) continue;
            n5 = 0;
            ++n6;
        }
    }
}

