/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.java.BS;
import org.jmol.util.BNode;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;

public class JmolMolecule {
    public Node[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int ac;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BS atomList;

    public static final JmolMolecule[] getMolecules(BNode[] bNodeArray, BS[] bSArray, Lst<BS> lst, BS bS) {
        BS bS2 = null;
        BS bS3 = new BS();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        JmolMolecule[] jmolMoleculeArray = new JmolMolecule[4];
        if (bS == null) {
            bS = new BS();
        }
        for (int i = 0; i < bNodeArray.length; ++i) {
            if (bS.get(i) || bS3.get(i)) continue;
            if (bNodeArray[i].isDeleted()) {
                bS.set(i);
                continue;
            }
            int n4 = bNodeArray[i].getModelIndex();
            if (n4 != n) {
                n = n4;
                n2 = 0;
                bS2 = bSArray[n4];
            }
            if ((bS3 = JmolMolecule.getBranchBitSet(bNodeArray, i, bS2, lst, -1, true, true)).nextSetBit(0) < 0) continue;
            jmolMoleculeArray = JmolMolecule.addMolecule(jmolMoleculeArray, n3++, bNodeArray, i, bS3, n4, n2++, bS);
        }
        return JmolMolecule.allocateArray(jmolMoleculeArray, n3);
    }

    public static BS getBranchBitSet(Node[] nodeArray, int n, BS bS, Lst<BS> lst, int n2, boolean bl, boolean bl2) {
        BS bS2 = BS.newN(nodeArray.length);
        if (n < 0) {
            return bS2;
        }
        if (n2 >= 0) {
            bS.clear(n2);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, nodeArray[n], bS, bl, bl2, lst, bS2) ? bS2 : new BS();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] jmolMoleculeArray, int n, Node[] nodeArray, int n2, BS bS, int n3, int n4, BS bS2) {
        bS2.or(bS);
        if (n == jmolMoleculeArray.length) {
            jmolMoleculeArray = JmolMolecule.allocateArray(jmolMoleculeArray, n * 2 + 1);
        }
        jmolMoleculeArray[n] = JmolMolecule.initialize(nodeArray, n, n2, bS, n3, n4);
        return jmolMoleculeArray;
    }

    public static String getMolecularFormula(Node[] nodeArray, BS bS, boolean bl) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.atomList = bS;
        return jmolMolecule.getMolecularFormula(bl);
    }

    public String getMolecularFormula(boolean bl) {
        int n;
        int n2;
        if (this.mf != null) {
            return this.mf;
        }
        this.getElementAndAtomCount(bl);
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n = this.elementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(n2) + " " + n;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n = this.altElementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(n2)) + " " + n;
            string2 = " ";
        }
        return string;
    }

    private static JmolMolecule initialize(Node[] nodeArray, int n, int n2, BS bS, int n3, int n4) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.firstAtomIndex = n2;
        jmolMolecule.atomList = bS;
        jmolMolecule.ac = bS.cardinality();
        jmolMolecule.moleculeIndex = n;
        jmolMolecule.modelIndex = n3;
        jmolMolecule.indexInModel = n4;
        return jmolMolecule;
    }

    private void getElementAndAtomCount(boolean bl) {
        if (this.atomList == null) {
            this.atomList = new BS();
            this.atomList.setBits(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        this.ac = this.atomList.cardinality();
        int n = this.atomList.nextSetBit(0);
        while (n >= 0) {
            int n2 = this.nodes[n].getAtomicAndIsotopeNumber();
            if (n2 < Elements.elementNumberMax) {
                int n3;
                int n4 = n2;
                this.elementCounts[n4] = this.elementCounts[n4] + 1;
                if (this.elementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n2);
                if (bl && (n3 = this.nodes[n].getImplicitHydrogenCount()) > 0) {
                    if (this.elementCounts[1] == 0) {
                        ++this.nElements;
                    }
                    this.elementCounts[1] = this.elementCounts[1] + n3;
                }
            } else {
                int n5 = n2 = Elements.altElementIndexFromNumber(n2);
                this.altElementCounts[n5] = this.altElementCounts[n5] + 1;
                if (this.altElementCounts[n2] == 1) {
                    ++this.nElements;
                }
                this.altElementMax = Math.max(this.altElementMax, n2);
            }
            n = this.atomList.nextSetBit(n + 1);
        }
    }

    private static boolean getCovalentlyConnectedBitSet(Node[] nodeArray, Node node, BS bS, boolean bl, boolean bl2, Lst<BS> lst, BS bS2) {
        int n = node.getIndex();
        if (!bS.get(n)) {
            return bl;
        }
        if (!bl2 && node instanceof BNode && ((BNode)node).getBioStructureTypeName().length() > 0) {
            return bl;
        }
        bS.clear(n);
        if (lst != null && !bS2.get(n)) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                BS bS3 = (BS)lst.get(n2);
                if (!bS3.get(n)) continue;
                bS2.or(bS3);
                bS.andNot(bS3);
                int n3 = bS3.nextSetBit(0);
                while (n3 >= 0) {
                    Node node2 = nodeArray[n3];
                    bS.set(n3);
                    JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, node2, bS, bl, bl2, lst, bS2);
                    bS.clear(n3);
                    n3 = bS3.nextSetBit(n3 + 1);
                }
                break block0;
            }
        }
        bS2.set(n);
        Edge[] edgeArray = node.getEdges();
        if (edgeArray == null) {
            return true;
        }
        int n4 = edgeArray.length;
        while (--n4 >= 0) {
            Edge edge = edgeArray[n4];
            if (!edge.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, edge.getOtherAtomNode(node), bS, bl, bl2, lst, bS2)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] jmolMoleculeArray, int n) {
        return n == jmolMoleculeArray.length ? jmolMoleculeArray : (JmolMolecule[])AU.arrayCopyObject(jmolMoleculeArray, n);
    }
}

