/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.AU;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.LineRenderer;
import org.jmol.util.Shader;

class CylinderRenderer {
    private final Graphics3D g3d;
    private final LineRenderer line3d;
    private final Shader shader;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private int[] shadesB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float xAf;
    private float yAf;
    private float zAf;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int endcapShadeIndex;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    private boolean clipped;
    private boolean drawBackside;
    private float xTip;
    private float yTip;
    private float zTip;
    private int rasterCount;
    private float[] tRaster = new float[32];
    private float[] txRaster = new float[32];
    private float[] tyRaster = new float[32];
    private float[] tzRaster = new float[32];
    private int[] xRaster = new int[32];
    private int[] yRaster = new int[32];
    private int[] zRaster = new int[32];
    private int[] fp8ShadeIndexUp = new int[32];
    private int yMin;
    private int yMax;
    private int xMin;
    private int xMax;
    private int zXMin;
    private int zXMax;

    CylinderRenderer(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.line3d = graphics3D.line3d;
        this.shader = graphics3D.shader;
    }

    void render(short s, short s2, boolean bl, boolean bl2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        if (n > this.g3d.getRenderHeight() * 3) {
            return;
        }
        int n11 = n / 2 + 1;
        int n12 = this.g3d.clipCode3(n2 - n11, n3 - n11, n4 - n11);
        boolean bl3 = this.clipped = (n12 | (n10 = this.g3d.clipCode3(n2 + n11, n3 + n11, n4 + n11)) | (n9 = this.g3d.clipCode3(n5 - n11, n6 - n11, n7 - n11)) | (n8 = this.g3d.clipCode3(n5 + n11, n6 + n11, n7 + n11))) != 0;
        if ((n12 & n8 & n10 & n9) != 0) {
            return;
        }
        this.dxB = n5 - n2;
        this.dyB = n6 - n3;
        this.dzB = n7 - n4;
        if (n <= 1) {
            this.line3d.plotLineDelta(this.g3d.getColorArgbOrGray(s), bl, this.g3d.getColorArgbOrGray(s2), bl2, n2, n3, n4, this.dxB, this.dyB, this.dzB, this.clipped);
            return;
        }
        this.drawBackside = this.clipped || by == 2 || by == 0;
        this.diameter = n;
        this.xA = n2;
        this.yA = n3;
        this.zA = n4;
        this.endcaps = by;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.calcArgbEndcap(true, false);
        this.generateBaseEllipse();
        if (by == 2 || by == 4) {
            this.renderFlatEndcap(true);
        }
        this.g3d.setZMargin(5);
        int n13 = this.rasterCount;
        while (--n13 >= 0) {
            int n14 = this.fp8ShadeIndexUp[n13] >> 8;
            int n15 = n14 >> 1;
            int n16 = this.xRaster[n13];
            int n17 = this.yRaster[n13];
            int n18 = this.zRaster[n13];
            if (this.tEndcapOpen && this.argbEndcap != 0) {
                if (this.clipped) {
                    this.g3d.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + n16, this.yEndcap + n17, this.zEndcap - n18 - 1);
                    this.g3d.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - n16, this.yEndcap - n17, this.zEndcap + n18 - 1);
                } else {
                    this.g3d.plotPixelUnclippedArgb(this.argbEndcap, this.xEndcap + n16, this.yEndcap + n17, this.zEndcap - n18 - 1);
                    this.g3d.plotPixelUnclippedArgb(this.argbEndcap, this.xEndcap - n16, this.yEndcap - n17, this.zEndcap + n18 - 1);
                }
            }
            this.line3d.plotLineDeltaA(this.shadesA, bl, this.shadesB, bl2, n14, this.xA + n16, this.yA + n17, this.zA - n18, this.dxB, this.dyB, this.dzB, this.clipped);
            if (!this.drawBackside) continue;
            this.line3d.plotLineDelta(this.shadesA[n15], bl, this.shadesB[n15], bl2, this.xA - n16, this.yA - n17, this.zA + n18, this.dxB, this.dyB, this.dzB, this.clipped);
        }
        this.g3d.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void renderBits(short s, short s2, boolean bl, boolean bl2, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        int n2;
        int n3;
        int n4;
        if (n > this.g3d.getRenderHeight() * 3) {
            return;
        }
        int n5 = n / 2 + 1;
        int n6 = Math.round(f);
        int n7 = Math.round(f2);
        int n8 = Math.round(f3);
        int n9 = Math.round(f4);
        int n10 = Math.round(f5);
        int n11 = Math.round(f6);
        int n12 = this.g3d.clipCode3(n6 - n5, n7 - n5, n8 - n5);
        boolean bl3 = this.clipped = (n12 | (n4 = this.g3d.clipCode3(n6 + n5, n7 + n5, n8 + n5)) | (n3 = this.g3d.clipCode3(n9 - n5, n10 - n5, n11 - n5)) | (n2 = this.g3d.clipCode3(n9 + n5, n10 + n5, n11 + n5))) != 0;
        if ((n12 & n2 & n4 & n3) != 0) {
            return;
        }
        this.dxBf = f4 - f;
        this.dyBf = f5 - f2;
        this.dzBf = f6 - f3;
        if (n == 0 || n == 1) {
            this.line3d.plotLineDelta(this.g3d.getColorArgbOrGray(s), bl, this.g3d.getColorArgbOrGray(s2), bl2, (int)f, (int)f2, (int)f3, (int)this.dxBf, (int)this.dyBf, (int)this.dzBf, this.clipped);
            return;
        }
        if (n > 0) {
            this.diameter = n;
            this.xAf = f;
            this.yAf = f2;
            this.zAf = f3;
        }
        this.drawBackside = !bl && !bl2 && (this.clipped || by == 2 || by == 0);
        this.xA = (int)this.xAf;
        this.yA = (int)this.yAf;
        this.zA = (int)this.zAf;
        this.dxB = (int)this.dxBf;
        this.dyB = (int)this.dyBf;
        this.dzB = (int)this.dzBf;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.endcaps = by;
        this.calcArgbEndcap(true, true);
        if (n > 0) {
            this.generateBaseEllipsePrecisely(false);
        }
        if (by == 2) {
            this.renderFlatEndcapPrecisely(true);
        }
        this.line3d.setLineBits(this.dxBf, this.dyBf);
        this.g3d.setZMargin(5);
        int n13 = this.rasterCount;
        while (--n13 >= 0) {
            int n14 = this.fp8ShadeIndexUp[n13] >> 8;
            int n15 = n14 >> 1;
            int n16 = this.xRaster[n13];
            int n17 = this.yRaster[n13];
            int n18 = this.zRaster[n13];
            if (this.tEndcapOpen && this.argbEndcap != 0) {
                if (this.clipped) {
                    this.g3d.plotPixelClippedArgb(this.argbEndcap, this.xEndcap + n16, this.yEndcap + n17, this.zEndcap - n18 - 1);
                    this.g3d.plotPixelClippedArgb(this.argbEndcap, this.xEndcap - n16, this.yEndcap - n17, this.zEndcap + n18 - 1);
                } else {
                    this.g3d.plotPixelUnclippedArgb(this.argbEndcap, this.xEndcap + n16, this.yEndcap + n17, this.zEndcap - n18 - 1);
                    this.g3d.plotPixelUnclippedArgb(this.argbEndcap, this.xEndcap - n16, this.yEndcap - n17, this.zEndcap + n18 - 1);
                }
            }
            this.line3d.plotLineDeltaBits(this.shadesA, bl, this.shadesB, bl2, n14, this.xA + n16, this.yA + n17, this.zA - n18, this.dxB, this.dyB, this.dzB, this.clipped);
            if (!this.drawBackside) continue;
            this.line3d.plotLineDelta(this.shadesA[n15], bl, this.shadesB[n15], bl2, this.xA - n16, this.yA - n17, this.zA + n18, this.dxB, this.dyB, this.dzB, this.clipped);
        }
        this.g3d.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
        this.xAf += this.dxBf;
        this.yAf += this.dyBf;
        this.zAf += this.dzBf;
    }

    void renderCone(short s, boolean bl, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6, boolean bl2, boolean bl3) {
        if (n > this.g3d.getRenderHeight() * 3) {
            return;
        }
        this.xAf = f;
        this.dxBf = f4 - this.xAf;
        this.yAf = f2;
        this.dyBf = f5 - this.yAf;
        this.zAf = f3;
        this.dzBf = f6 - this.zAf;
        this.xA = (int)Math.floor(this.xAf);
        this.yA = (int)Math.floor(this.yAf);
        this.zA = (int)Math.floor(this.zAf);
        this.dxB = (int)Math.floor(this.dxBf);
        this.dyB = (int)Math.floor(this.dyBf);
        this.dzB = (int)Math.floor(this.dzBf);
        this.xTip = f4;
        this.yTip = f5;
        this.zTip = f6;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(s);
        int n2 = this.shader.getShadeIndex(this.dxB, this.dyB, -this.dzB);
        this.g3d.plotPixelClippedScreened(this.shadesA[n2], bl, (int)f4, (int)f5, (int)f6);
        this.diameter = n;
        if (n <= 1) {
            if (n == 1) {
                this.line3d.plotLineDelta(this.colixA, bl, this.colixA, bl, this.xA, this.yA, this.zA, this.dxB, this.dyB, this.dzB, this.clipped);
            }
            return;
        }
        this.endcaps = by;
        this.calcArgbEndcap(false, true);
        this.generateBaseEllipsePrecisely(bl3);
        if (!bl3 && this.endcaps == 2) {
            this.renderFlatEndcapPrecisely(false);
        }
        this.g3d.setZMargin(5);
        int n3 = this.rasterCount;
        while (--n3 >= 0) {
            float f7 = this.txRaster[n3];
            float f8 = this.tyRaster[n3];
            float f9 = this.tzRaster[n3];
            float f10 = this.xAf + f7;
            float f11 = this.yAf + f8;
            float f12 = this.zAf - f9;
            float f13 = this.xAf - f7;
            float f14 = this.yAf - f8;
            float f15 = this.zAf + f9;
            int n4 = this.shadesA[0];
            if (this.tEndcapOpen && this.argbEndcap != 0) {
                this.g3d.plotPixelClippedScreened(this.argbEndcap, bl, (int)f10, (int)f11, (int)f12);
                this.g3d.plotPixelClippedScreened(this.argbEndcap, bl, (int)f13, (int)f14, (int)f15);
            }
            int n5 = this.fp8ShadeIndexUp[n3] >> 8;
            if (n4 == 0) continue;
            this.line3d.plotLineDeltaA(this.shadesA, bl, this.shadesA, bl, n5, (int)f10, (int)f11, (int)f12, (int)Math.ceil(this.xTip - f10), (int)Math.ceil(this.yTip - f11), (int)Math.ceil(this.zTip - f12), true);
            if (bl2) {
                this.line3d.plotLineDeltaA(this.shadesA, bl, this.shadesA, bl, n5, (int)f10, (int)f11 + 1, (int)f12, (int)Math.ceil(this.xTip - f10), (int)Math.ceil(this.yTip - f11) + 1, (int)Math.ceil(this.zTip - f12), true);
                this.line3d.plotLineDeltaA(this.shadesA, bl, this.shadesA, bl, n5, (int)f10 + 1, (int)f11, (int)f12, (int)Math.ceil(this.xTip - f10) + 1, (int)Math.ceil(this.yTip - f11), (int)Math.ceil(this.zTip - f12), true);
            }
            if (bl3 || this.endcaps != 2 && this.dzB > 0) continue;
            this.line3d.plotLineDelta(n4, bl, n4, bl, (int)f13, (int)f14, (int)f15, (int)Math.ceil(this.xTip - f13), (int)Math.ceil(this.yTip - f14), (int)Math.ceil(this.zTip - f15), true);
        }
        this.g3d.setZMargin(0);
    }

    private void generateBaseEllipse() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        int n = this.dxB * this.dxB + this.dyB * this.dyB;
        if (n == 0) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f = (float)Math.sqrt(n);
            float f2 = (float)Math.sqrt(n + this.dzB * this.dzB);
            this.cosTheta = (float)this.dzB / f2;
            this.cosPhi = (float)this.dxB / f;
            this.sinPhi = (float)this.dyB / f;
        }
        this.calcRotatedPoint(0.0f, 0, false);
        this.calcRotatedPoint(0.5f, 1, false);
        this.calcRotatedPoint(1.0f, 2, false);
        this.rasterCount = 3;
        this.interpolate(0, 1);
        this.interpolate(1, 2);
    }

    private void generateBaseEllipsePrecisely(boolean bl) {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        float f = this.dxBf * this.dxBf + this.dyBf * this.dyBf;
        if (f == 0.0f) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f2 = (float)Math.sqrt(f);
            float f3 = (float)Math.sqrt(f + this.dzBf * this.dzBf);
            this.cosTheta = this.dzBf / f3;
            this.cosPhi = this.dxBf / f2;
            this.sinPhi = this.dyBf / f2;
        }
        if (bl) {
            this.calcRotatedPoint(0.0f, 0, true);
            this.calcRotatedPoint(0.5f, 1, true);
            this.rasterCount = 2;
            this.interpolatePrecisely(0, 1);
        } else {
            this.calcRotatedPoint(0.0f, 0, true);
            this.calcRotatedPoint(0.5f, 1, true);
            this.calcRotatedPoint(1.0f, 2, true);
            this.rasterCount = 3;
            this.interpolatePrecisely(0, 1);
            this.interpolatePrecisely(1, 2);
        }
        for (int i = 0; i < this.rasterCount; ++i) {
            this.xRaster[i] = (int)Math.floor(this.txRaster[i]);
            this.yRaster[i] = (int)Math.floor(this.tyRaster[i]);
            this.zRaster[i] = (int)Math.floor(this.tzRaster[i]);
        }
    }

    private void calcRotatedPoint(float f, int n, boolean bl) {
        double d;
        double d2;
        double d3;
        this.tRaster[n] = f;
        double d4 = (double)f * Math.PI;
        double d5 = Math.sin(d4) * (double)this.cosTheta;
        double d6 = (double)this.radius * (d5 * (double)this.cosPhi - (d3 = Math.cos(d4)) * (double)this.sinPhi);
        double d7 = (double)this.radius2 - (d6 * d6 + (d2 = (double)this.radius * (d5 * (double)this.sinPhi + d3 * (double)this.cosPhi)) * d2);
        double d8 = d = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        if (bl) {
            this.txRaster[n] = (float)d6;
            this.tyRaster[n] = (float)d2;
            this.tzRaster[n] = (float)d;
        } else if (this.tEvenDiameter) {
            this.xRaster[n] = (int)(d6 - 0.5);
            this.yRaster[n] = (int)(d2 - 0.5);
            this.zRaster[n] = (int)(d + 0.5);
        } else {
            this.xRaster[n] = (int)d6;
            this.yRaster[n] = (int)d2;
            this.zRaster[n] = (int)(d + 0.5);
        }
        this.fp8ShadeIndexUp[n] = this.shader.getShadeFp8((float)d6, (float)d2, (float)d);
    }

    private void interpolate(int n, int n2) {
        int n3;
        int n4 = this.xRaster[n2] - this.xRaster[n];
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n3 = this.yRaster[n2] - this.yRaster[n]) < 0) {
            n3 = -n3;
        }
        if (n4 + n3 <= 1) {
            return;
        }
        float f = this.tRaster[n];
        float f2 = this.tRaster[n2];
        int n5 = this.allocRaster(false);
        int n6 = 4;
        while (--n6 >= 0) {
            float f3 = (f + f2) / 2.0f;
            this.calcRotatedPoint(f3, n5, false);
            if (this.xRaster[n5] == this.xRaster[n] && this.yRaster[n5] == this.yRaster[n]) {
                this.fp8ShadeIndexUp[n] = this.fp8ShadeIndexUp[n] + this.fp8ShadeIndexUp[n5] >>> 1;
                f = f3;
                continue;
            }
            if (this.xRaster[n5] == this.xRaster[n2] && this.yRaster[n5] == this.yRaster[n2]) {
                this.fp8ShadeIndexUp[n2] = this.fp8ShadeIndexUp[n2] + this.fp8ShadeIndexUp[n5] >>> 1;
                f2 = f3;
                continue;
            }
            this.interpolate(n, n5);
            this.interpolate(n5, n2);
            return;
        }
        this.xRaster[n5] = this.xRaster[n];
        this.yRaster[n5] = this.yRaster[n2];
    }

    private void interpolatePrecisely(int n, int n2) {
        float f;
        int n3 = (int)Math.floor(this.txRaster[n2]) - (int)Math.floor(this.txRaster[n]);
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((f = (float)((int)Math.floor(this.tyRaster[n2]) - (int)Math.floor(this.tyRaster[n]))) < 0.0f) {
            f = -f;
        }
        if ((float)n3 + f <= 1.0f) {
            return;
        }
        float f2 = this.tRaster[n];
        float f3 = this.tRaster[n2];
        int n4 = this.allocRaster(true);
        int n5 = 4;
        while (--n5 >= 0) {
            float f4 = (f2 + f3) / 2.0f;
            this.calcRotatedPoint(f4, n4, true);
            if ((int)Math.floor(this.txRaster[n4]) == (int)Math.floor(this.txRaster[n]) && (int)Math.floor(this.tyRaster[n4]) == (int)Math.floor(this.tyRaster[n])) {
                this.fp8ShadeIndexUp[n] = this.fp8ShadeIndexUp[n] + this.fp8ShadeIndexUp[n4] >>> 1;
                f2 = f4;
                continue;
            }
            if ((int)Math.floor(this.txRaster[n4]) == (int)Math.floor(this.txRaster[n2]) && (int)Math.floor(this.tyRaster[n4]) == (int)Math.floor(this.tyRaster[n2])) {
                this.fp8ShadeIndexUp[n2] = this.fp8ShadeIndexUp[n2] + this.fp8ShadeIndexUp[n4] >>> 1;
                f3 = f4;
                continue;
            }
            this.interpolatePrecisely(n, n4);
            this.interpolatePrecisely(n4, n2);
            return;
        }
        this.txRaster[n4] = this.txRaster[n];
        this.tyRaster[n4] = this.tyRaster[n2];
    }

    private int allocRaster(boolean bl) {
        while (this.rasterCount >= this.xRaster.length) {
            this.xRaster = AU.doubleLengthI(this.xRaster);
            this.yRaster = AU.doubleLengthI(this.yRaster);
            this.zRaster = AU.doubleLengthI(this.zRaster);
            this.tRaster = AU.doubleLengthF(this.tRaster);
        }
        while (this.rasterCount >= this.fp8ShadeIndexUp.length) {
            this.fp8ShadeIndexUp = AU.doubleLengthI(this.fp8ShadeIndexUp);
        }
        if (bl) {
            while (this.rasterCount >= this.txRaster.length) {
                this.txRaster = AU.doubleLengthF(this.txRaster);
                this.tyRaster = AU.doubleLengthF(this.tyRaster);
                this.tzRaster = AU.doubleLengthF(this.tzRaster);
            }
        }
        return this.rasterCount++;
    }

    private void findMinMaxY() {
        this.yMin = this.yMax = this.yRaster[0];
        int n = this.rasterCount;
        while (--n > 0) {
            int n2 = this.yRaster[n];
            if (n2 < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 > this.yMax) {
                this.yMax = n2;
                continue;
            }
            if ((n2 = -n2) < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 <= this.yMax) continue;
            this.yMax = n2;
        }
    }

    private void findMinMaxX(int n) {
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        int n2 = this.rasterCount;
        while (--n2 >= 0) {
            int n3;
            if (this.yRaster[n2] == n) {
                n3 = this.xRaster[n2];
                if (n3 < this.xMin) {
                    this.xMin = n3;
                    this.zXMin = this.zRaster[n2];
                }
                if (n3 > this.xMax) {
                    this.xMax = n3;
                    this.zXMax = this.zRaster[n2];
                }
            }
            if (this.yRaster[n2] != -n) continue;
            n3 = -this.xRaster[n2];
            if (n3 < this.xMin) {
                this.xMin = n3;
                this.zXMin = -this.zRaster[n2];
            }
            if (n3 <= this.xMax) continue;
            this.xMax = n3;
            this.zXMax = -this.zRaster[n2];
        }
    }

    private void renderFlatEndcap(boolean bl) {
        if (this.dzB == 0 || !this.g3d.setC(this.colixEndcap)) {
            return;
        }
        int n = this.xA;
        int n2 = this.yA;
        int n3 = this.zA;
        if (bl && this.dzB < 0) {
            if (this.endcaps == 4) {
                return;
            }
            n += this.dxB;
            n2 += this.dyB;
            n3 += this.dzB;
        }
        this.findMinMaxY();
        for (int i = this.yMin; i <= this.yMax; ++i) {
            this.findMinMaxX(i);
            int n4 = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.endcapShadeIndex);
            this.g3d.plotPixelsClippedRaster(n4, n + this.xMin, n2 + i, n3 - this.zXMin - 1, n3 - this.zXMax - 1, null, null);
        }
    }

    private void renderFlatEndcapPrecisely(boolean bl) {
        if (this.dzBf == 0.0f || !this.g3d.setC(this.colixEndcap)) {
            return;
        }
        float f = this.xAf;
        float f2 = this.yAf;
        float f3 = this.zAf;
        if (bl && this.dzBf < 0.0f) {
            f += this.dxBf;
            f2 += this.dyBf;
            f3 += this.dzBf;
        }
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        this.findMinMaxY();
        for (int i = this.yMin; i <= this.yMax; ++i) {
            this.findMinMaxX(i);
            int n4 = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.endcapShadeIndex);
            this.g3d.plotPixelsClippedRaster(n4, n + this.xMin, n2 + i, n3 - this.zXMin - 1, n3 - this.zXMax - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        if (this.colixA != 0 && this.g3d.setC(this.colixA)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA, this.yA, this.zA + 1);
        }
        if (this.colixB != 0 && this.g3d.setC(this.colixB)) {
            this.g3d.fillSphereXYZ(this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
        }
    }

    private void calcArgbEndcap(boolean bl, boolean bl2) {
        int[] nArray;
        float f;
        float f2;
        this.tEndcapOpen = false;
        float f3 = f2 = bl2 ? this.dzBf : (float)this.dzB;
        if (this.endcaps == 3 || f2 == 0.0f) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        float f4 = bl2 ? this.dxBf : (float)this.dxB;
        float f5 = f = bl2 ? this.dyBf : (float)this.dyB;
        if (f2 >= 0.0f || !bl) {
            this.endcapShadeIndex = this.shader.getShadeIndex(-f4, -f, f2);
            this.colixEndcap = this.colixA;
            nArray = this.shadesA;
        } else {
            this.endcapShadeIndex = this.shader.getShadeIndex(f4, f, -f2);
            this.colixEndcap = this.colixB;
            nArray = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.endcapShadeIndex > 56) {
            this.endcapShadeIndex = 56;
        }
        this.argbEndcap = nArray[this.endcapShadeIndex];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

