/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;

public class _MayaExporter
extends __CartesianExporter {
    private int nBalls = 0;
    private int nCyl = 0;
    private String name;
    private String id;

    public _MayaExporter() {
        this.commentChar = "// ";
    }

    @Override
    protected void outputHeader() {
        this.output("//  Maya ASCII 8.5 scene\n");
        this.output("//  Name: ball_stripped.ma\n");
        this.output("//  Last modified: Thu, Jul 5, 2007 10:25:55 PM\n");
        this.output("//  Codeset: UTF-8\n");
        this.output("requires maya \"8.5\";\n");
        this.output("currentUnit -l centimeter -a degree -t film;\n");
        this.output("fileInfo \"application\" \"maya\";\n");
        this.output("fileInfo \"product\" \"Maya Unlimited 8.5\";\n");
        this.output("fileInfo \"version\" \"8.5\";\n");
        this.output("fileInfo \"cutIdentifier\" \"200612170012-692032\";\n");
        this.output("fileInfo \"osv\" \"Mac OS X 10.4.9\";  \n");
    }

    private void addAttr() {
        this.output(" setAttr -k off \".v\";\n");
        this.output(" setAttr \".vir\" yes;\n");
        this.output(" setAttr \".vif\" yes;\n");
        this.output(" setAttr \".tw\" yes;\n");
        this.output(" setAttr \".covm[0]\"  0 1 1;\n");
        this.output(" setAttr \".cdvm[0]\"  0 1 1;\n");
    }

    private void addConnect() {
        this.output(" connectAttr \"make" + this.name + ".os\" \"" + this.id + ".cr\";\n");
        this.output("connectAttr \"" + this.id + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
    }

    private void setAttr(String string, float f) {
        this.output(" setAttr \"." + string + "\" " + f + ";\n");
    }

    private void setAttr(String string, int n) {
        this.output(" setAttr \"." + string + "\" " + n + ";\n");
    }

    private void setAttr(String string, T3 t3) {
        this.output(" setAttr \"." + string + "\" -type \"double3\" " + t3.x + " " + t3.y + " " + t3.z + ";\n");
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        if (p34 != null) {
            return false;
        }
        ++this.nCyl;
        this.name = "nurbsCylinder" + this.nCyl;
        this.id = "nurbsCylinderShape" + this.nCyl;
        this.output(" createNode transform -n \"" + this.name + "\";\n");
        float f2 = p32.distance(p33);
        this.tempV1.ave(p33, p32);
        this.setAttr("t", this.tempV1);
        this.tempV1.sub(p32);
        this.tempV2.setT(this.tempV1);
        this.tempV2.normalize();
        float f3 = this.tempV1.length();
        float f4 = (float)Math.acos(this.tempV1.y / f3) * 57.29578f;
        if (this.tempV1.x < 0.0f) {
            f4 += 180.0f;
        }
        float f5 = (float)Math.atan2(this.tempV1.x, this.tempV1.z) * 57.29578f;
        this.tempV2.set(f4, f5, 0.0f);
        this.setAttr("r", this.tempV2);
        this.output(" createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbCylinder -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", f);
        this.setAttr("s", 4);
        this.setAttr("hr", f2 / f);
        this.addConnect();
        return true;
    }

    @Override
    protected void outputSphere(P3 p3, float f, short s, boolean bl) {
        ++this.nBalls;
        this.name = "nurbsSphere" + this.nBalls;
        this.id = "nurbsSphereShape" + this.nBalls;
        this.output("createNode transform -n \"" + this.name + "\";\n");
        this.setAttr("t", p3);
        this.output("createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbSphere -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", f);
        this.setAttr("s", 4);
        this.setAttr("nsp", 3);
        this.addConnect();
    }

    @Override
    void drawTextPixel(int n, int n2, int n3, int n4) {
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
    }

    @Override
    protected void outputSurface(P3[] p3Array, V3[] v3Array, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
    }

    @Override
    protected void outputTriangle(P3 p3, P3 p32, P3 p33, short s) {
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    protected void output(T3 t3) {
    }
}

