/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import javajs.util.SB;
import org.jmol.c.VDW;

public class RadiusData {
    public String info;
    public EnumType factorType = EnumType.ABSOLUTE;
    public VDW vdwType = VDW.AUTO;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;
    public float[] values;

    public RadiusData(float[] fArray, float f, EnumType enumType, VDW vDW) {
        if (fArray != null) {
            this.values = fArray;
            this.value = 2.1474836E9f;
            return;
        }
        if (enumType == null) {
            return;
        }
        this.factorType = enumType;
        this.value = f;
        if (vDW != null) {
            this.vdwType = vDW;
        }
    }

    public String toString() {
        if (Float.isNaN(this.value)) {
            return "";
        }
        SB sB = new SB();
        switch (this.factorType) {
            case ABSOLUTE: {
                sB.appendF(this.value);
                break;
            }
            case OFFSET: {
                sB.append(this.value > 0.0f ? "+" : "").appendF(this.value);
                break;
            }
            case FACTOR: {
                sB.appendI((int)(this.value * 100.0f)).append("%");
                if (this.vdwType == VDW.AUTO) break;
                sB.append(this.vdwType.getVdwLabel());
                break;
            }
            case SCREEN: {
                sB.appendI((int)this.value);
            }
        }
        return sB.toString();
    }

    public static enum EnumType {
        ABSOLUTE,
        OFFSET,
        FACTOR,
        SCREEN;

    }
}

