/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;

public abstract class ProteinStructure {
    STR type;
    STR subtype;
    String structureID;
    int strucNo;
    int serialID;
    int strandCount;
    protected AlphaPolymer apolymer;
    protected int monomerIndexFirst;
    protected int nRes;
    protected P3 axisA;
    protected P3 axisB;
    protected V3 axisUnitVector;
    protected final V3 vectorProjection = new V3();
    private static int globalStrucNo = 1000;
    private int monomerIndexLast;
    private P3[] segments;
    private Map<Monomer, Integer> resMap;

    protected void setupPS(AlphaPolymer alphaPolymer, STR sTR, int n, int n2) {
        this.strucNo = ++globalStrucNo;
        this.apolymer = alphaPolymer;
        this.type = sTR;
        this.monomerIndexFirst = n;
        this.addMonomer(n + n2 - 1);
        if (Logger.debugging) {
            Logger.info("Creating ProteinStructure " + this.strucNo + " " + sTR.getBioStructureTypeName(false) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + alphaPolymer);
        }
    }

    void addMonomer(int n) {
        this.resMap = null;
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, n);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, n);
        this.nRes = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    void removeMonomer(int n) {
        this.resMap = null;
        if (n > this.monomerIndexLast || n < this.monomerIndexFirst) {
            return;
        }
        if (n == this.monomerIndexFirst) {
            ++this.monomerIndexFirst;
            --this.nRes;
        } else if (n == this.monomerIndexLast) {
            --this.monomerIndexLast;
            --this.nRes;
        } else {
            int n2 = this.monomerIndexLast - n;
            this.monomerIndexLast = n - 1;
            this.nRes = n - this.monomerIndexFirst;
            Monomer[] monomerArray = this.apolymer.monomers;
            STR sTR = monomerArray[++n].getProteinStructureType();
            int n3 = -1;
            int n4 = 0;
            int n5 = n;
            while (n4 < n2) {
                ((AlphaMonomer)monomerArray[n5]).setStructure(null);
                n3 = monomerArray[n5].setProteinStructureType(sTR, n3);
                ++n4;
                ++n5;
            }
        }
    }

    public void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new P3[this.nRes + 1];
        this.segments[this.nRes] = this.axisB;
        this.segments[0] = this.axisA;
        V3 v3 = V3.newV(this.axisUnitVector);
        v3.scale(this.axisB.distance(this.axisA) / (float)this.nRes);
        for (int i = 1; i < this.nRes; ++i) {
            P3 p3 = this.segments[i] = new P3();
            p3.add2(this.segments[i - 1], v3);
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndexFirst == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndexFirst - 1].isHelix() || this.apolymer.monomers[this.monomerIndexFirst - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int n = this.monomerIndexFirst + this.nRes;
        if (n == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[n].isHelix() || this.apolymer.monomers[n].isSheet();
    }

    public int getMonomerCount() {
        return this.nRes;
    }

    public boolean isWithin(int n) {
        return n > this.monomerIndexFirst && n < this.monomerIndexLast;
    }

    public int getMonomerIndex() {
        return this.monomerIndexFirst;
    }

    public int getIndex(Monomer monomer) {
        Integer n;
        if (this.resMap == null) {
            this.resMap = new Hashtable<Monomer, Integer>();
            int n2 = this.nRes;
            while (--n2 >= 0) {
                this.resMap.put(this.apolymer.monomers[this.monomerIndexFirst + n2], n2);
            }
        }
        return (n = this.resMap.get(monomer)) == null ? -1 : n;
    }

    public P3[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    public P3 getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public P3 getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    P3 getStructureMidPoint(int n) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[n];
    }

    public void getInfo(Map<String, Object> map) {
        map.put("type", this.type.getBioStructureTypeName(false));
        int[] nArray = this.apolymer.getLeadAtomIndices();
        int[] nArray2 = AU.arrayCopyRangeI(nArray, this.monomerIndexFirst, this.monomerIndexFirst + this.nRes);
        map.put("leadAtomIndices", nArray2);
        this.calcAxis();
        if (this.axisA == null) {
            return;
        }
        map.put("axisA", this.axisA);
        map.put("axisB", this.axisB);
        map.put("axisUnitVector", this.axisUnitVector);
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }
}

