/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.util.Point3fi;

public class HermiteRenderer
implements G3DRenderer {
    private static V3 vAB = new V3();
    private static V3 vAC = new V3();
    private JmolRendererInterface g3d;
    private final P3i[] pLeft = new P3i[16];
    private final P3i[] pRight = new P3i[16];
    private final float[] sLeft = new float[16];
    private final float[] sRight = new float[16];
    private final P3[] pTopLeft = new P3[16];
    private final P3[] pTopRight = new P3[16];
    private final P3[] pBotLeft = new P3[16];
    private final P3[] pBotRight = new P3[16];
    private final P3 a1;
    private final P3 a2;
    private final P3 b1;
    private final P3 b2;
    private final P3 c1;
    private final P3 c2;
    private final P3 d1;
    private final P3 d2;
    private final V3 T1;
    private final V3 T2;
    private final V3 depth1;
    private final boolean[] needToFill;

    public HermiteRenderer() {
        int n = 16;
        while (--n >= 0) {
            this.pLeft[n] = new P3i();
            this.pRight[n] = new P3i();
            this.pTopLeft[n] = new P3();
            this.pTopRight[n] = new P3();
            this.pBotLeft[n] = new P3();
            this.pBotRight[n] = new P3();
        }
        this.a1 = new P3();
        this.a2 = new P3();
        this.b1 = new P3();
        this.b2 = new P3();
        this.c1 = new P3();
        this.c2 = new P3();
        this.d1 = new P3();
        this.d2 = new P3();
        this.T1 = new V3();
        this.T2 = new V3();
        this.depth1 = new V3();
        this.needToFill = new boolean[16];
    }

    @Override
    public G3DRenderer set(JmolRendererInterface jmolRendererInterface) {
        this.g3d = jmolRendererInterface;
        return this;
    }

    public void renderHermiteRope(boolean bl, int n, int n2, int n3, int n4, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        if (p3i.z == 1 || p3i2.z == 1 || p3i3.z == 1 || p3i4.z == 1) {
            return;
        }
        if (this.g3d.isClippedZ(p3i2.z) || this.g3d.isClippedZ(p3i3.z)) {
            return;
        }
        int n5 = p3i2.x;
        int n6 = p3i2.y;
        int n7 = p3i2.z;
        int n8 = p3i3.x;
        int n9 = p3i3.y;
        int n10 = p3i3.z;
        int n11 = (n8 - p3i.x) * n / 8;
        int n12 = (n9 - p3i.y) * n / 8;
        int n13 = (n10 - p3i.z) * n / 8;
        int n14 = (p3i4.x - n5) * n / 8;
        int n15 = (p3i4.y - n6) * n / 8;
        int n16 = (p3i4.z - n7) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].setT(p3i2);
        this.sRight[0] = 1.0f;
        this.pRight[0].setT(p3i3);
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        if (bl) {
            n18 = 2 * (n3 - n2);
            n19 = 2 * (n4 - n3);
        }
        do {
            int n20;
            P3i p3i5 = this.pLeft[n17];
            P3i p3i6 = this.pRight[n17];
            int n21 = p3i6.x - p3i5.x;
            if (n21 >= -1 && n21 <= 1 && (n20 = p3i6.y - p3i5.y) >= -1 && n20 <= 1) {
                float f = this.sLeft[n17];
                if (bl) {
                    int n22 = f < 0.5f ? n2 + (int)((float)n18 * f) : n3 + (int)((float)n19 * (f - 0.5f));
                    this.g3d.fillSphereI(n22, p3i5);
                } else {
                    this.g3d.plotPixelClippedP3i(p3i5);
                }
                --n17;
                continue;
            }
            double d = (this.sLeft[n17] + this.sRight[n17]) / 2.0f;
            double d2 = d * d;
            double d3 = d2 * d;
            double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
            double d5 = -2.0 * d3 + 3.0 * d2;
            double d6 = d3 - 2.0 * d2 + d;
            double d7 = d3 - d2;
            if (n17 >= 15) break;
            P3i p3i7 = this.pRight[n17 + 1];
            p3i7.x = (int)(d4 * (double)n5 + d5 * (double)n8 + d6 * (double)n11 + d7 * (double)n14);
            p3i7.y = (int)(d4 * (double)n6 + d5 * (double)n9 + d6 * (double)n12 + d7 * (double)n15);
            p3i7.z = (int)(d4 * (double)n7 + d5 * (double)n10 + d6 * (double)n13 + d7 * (double)n16);
            this.pRight[n17 + 1] = this.pRight[n17];
            this.sRight[n17 + 1] = this.sRight[n17];
            this.pRight[n17] = p3i7;
            this.sRight[n17] = (float)d;
            this.pLeft[++n17].setT(p3i7);
            this.sLeft[n17] = (float)d;
        } while (n17 >= 0);
    }

    public void renderHermiteRibbon(boolean bl, boolean bl2, int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4, P3i p3i5, P3i p3i6, P3i p3i7, P3i p3i8, int n2, int n3) {
        boolean bl3;
        if (p3i.z == 1 || p3i2.z == 1 || p3i3.z == 1 || p3i4.z == 1 || p3i5.z == 1 || p3i6.z == 1 || p3i7.z == 1 || p3i8.z == 1) {
            return;
        }
        if (!bl) {
            n = Math.abs(n);
            this.renderParallelPair(bl, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8);
            return;
        }
        boolean bl4 = bl3 = n < 0;
        if (bl3) {
            n = -n;
        }
        float f = 1.0f / (float)n2;
        int n4 = p3i2.x;
        int n5 = p3i2.y;
        int n6 = p3i2.z;
        int n7 = p3i3.x;
        int n8 = p3i3.y;
        int n9 = p3i3.z;
        int n10 = (n7 - p3i.x) * n / 8;
        int n11 = (n8 - p3i.y) * n / 8;
        int n12 = (n9 - p3i.z) * n / 8;
        int n13 = (p3i4.x - n4) * n / 8;
        int n14 = (p3i4.y - n5) * n / 8;
        int n15 = (p3i4.z - n6) * n / 8;
        Point3fi.set2(this.pTopLeft[0], p3i2);
        Point3fi.set2(this.pTopRight[0], p3i3);
        int n16 = p3i6.x;
        int n17 = p3i6.y;
        int n18 = p3i6.z;
        int n19 = p3i7.x;
        int n20 = p3i7.y;
        int n21 = p3i7.z;
        int n22 = (n19 - p3i5.x) * n / 8;
        int n23 = (n20 - p3i5.y) * n / 8;
        int n24 = (n21 - p3i5.z) * n / 8;
        int n25 = (p3i8.x - n16) * n / 8;
        int n26 = (p3i8.y - n17) * n / 8;
        int n27 = (p3i8.z - n18) * n / 8;
        Point3fi.set2(this.pBotLeft[0], p3i6);
        Point3fi.set2(this.pBotRight[0], p3i7);
        this.sLeft[0] = 0.0f;
        this.sRight[0] = 1.0f;
        this.needToFill[0] = true;
        int n28 = 0;
        boolean bl5 = false;
        do {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            P3 p3 = this.pTopLeft[n28];
            P3 p32 = this.pTopRight[n28];
            double d7 = p32.x - p3.x;
            double d8 = d7 * d7;
            if (d8 < 10.0 && (d6 = (d5 = (double)(p32.y - p3.y)) * d5) < 10.0) {
                P3 p33 = this.pBotLeft[n28];
                P3 p34 = this.pBotRight[n28];
                d4 = p34.x - p33.x;
                d3 = d4 * d4;
                if (d3 < 8.0 && (d2 = (d = (double)(p34.y - p33.y)) * d) < 8.0) {
                    if (bl2) {
                        this.g3d.fillSphere(3, p3);
                        this.g3d.fillSphere(3, p33);
                    }
                    if (this.needToFill[n28]) {
                        if (n2 > 0) {
                            this.T1.sub2(p3, p33);
                            this.T1.scale(f);
                            this.T2.sub2(p3, p32);
                            this.depth1.cross(this.T1, this.T2);
                            this.depth1.scale(this.T1.length() / this.depth1.length());
                            this.a1.add2(p3, this.depth1);
                            this.a2.sub2(p3, this.depth1);
                            this.b1.add2(p32, this.depth1);
                            this.b2.sub2(p32, this.depth1);
                            this.c1.add2(p33, this.depth1);
                            this.c2.sub2(p33, this.depth1);
                            this.d1.add2(p34, this.depth1);
                            this.d2.sub2(p34, this.depth1);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.d1, this.c1);
                            this.g3d.fillQuadrilateral(this.a2, this.b2, this.d2, this.c2);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.b2, this.a2);
                            this.g3d.fillQuadrilateral(this.c1, this.d1, this.d2, this.c2);
                            bl5 = true;
                        } else if (n3 == 0) {
                            if (bl3) {
                                this.g3d.fillQuadrilateral(p33, p34, p32, p3);
                            } else {
                                this.g3d.fillQuadrilateral(p3, p32, p34, p33);
                            }
                        } else if (bl3) {
                            if (n3 != HermiteRenderer.isFront(p3, p32, p34)) {
                                this.g3d.fillTriangle3f(p3, p32, p34, false);
                            }
                            if (n3 != HermiteRenderer.isFront(p3, p34, p33)) {
                                this.g3d.fillTriangle3f(p3, p34, p33, false);
                            }
                        } else {
                            if (n3 == HermiteRenderer.isFront(p3, p32, p34)) {
                                this.g3d.fillTriangle3f(p3, p32, p34, false);
                            }
                            if (n3 == HermiteRenderer.isFront(p3, p34, p33)) {
                                this.g3d.fillTriangle3f(p3, p34, p33, false);
                            }
                        }
                        this.needToFill[n28] = false;
                    }
                    if (d8 + d6 < 2.0 && d3 + d2 < 2.0) {
                        --n28;
                        continue;
                    }
                }
            }
            d5 = (this.sLeft[n28] + this.sRight[n28]) / 2.0f;
            d6 = d5 * d5;
            double d9 = d6 * d5;
            d4 = 2.0 * d9 - 3.0 * d6 + 1.0;
            d3 = -2.0 * d9 + 3.0 * d6;
            d = d9 - 2.0 * d6 + d5;
            d2 = d9 - d6;
            if (n28 >= 15) break;
            int n29 = n28 + 1;
            P3 p35 = this.pTopRight[n29];
            p35.x = (float)(d4 * (double)n4 + d3 * (double)n7 + d * (double)n10 + d2 * (double)n13);
            p35.y = (float)(d4 * (double)n5 + d3 * (double)n8 + d * (double)n11 + d2 * (double)n14);
            p35.z = (float)(d4 * (double)n6 + d3 * (double)n9 + d * (double)n12 + d2 * (double)n15);
            P3 p36 = this.pBotRight[n29];
            p36.x = (float)(d4 * (double)n16 + d3 * (double)n19 + d * (double)n22 + d2 * (double)n25);
            p36.y = (float)(d4 * (double)n17 + d3 * (double)n20 + d * (double)n23 + d2 * (double)n26);
            p36.z = (float)(d4 * (double)n18 + d3 * (double)n21 + d * (double)n24 + d2 * (double)n27);
            this.pTopRight[n29] = this.pTopRight[n28];
            this.pTopRight[n28] = p35;
            this.pBotRight[n29] = this.pBotRight[n28];
            this.pBotRight[n28] = p36;
            this.sRight[n29] = this.sRight[n28];
            this.sRight[n28] = (float)d5;
            this.needToFill[n29] = this.needToFill[n28];
            this.pTopLeft[n29].setT(p35);
            this.pBotLeft[n29].setT(p36);
            this.sLeft[n29] = (float)d5;
            ++n28;
        } while (n28 >= 0);
        if (bl5) {
            this.a1.z += 1.0f;
            this.c1.z += 1.0f;
            this.c2.z += 1.0f;
            this.a2.z += 1.0f;
            this.g3d.fillQuadrilateral(this.a1, this.c1, this.c2, this.a2);
        }
    }

    private static int isFront(P3 p3, P3 p32, P3 p33) {
        vAB.sub2(p32, p3);
        vAC.sub2(p33, p3);
        vAB.cross(vAB, vAC);
        return HermiteRenderer.vAB.z < 0.0f ? -1 : 1;
    }

    private void renderParallelPair(boolean bl, int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4, P3i p3i5, P3i p3i6, P3i p3i7, P3i p3i8) {
        int n2;
        P3i[] p3iArray = new P3i[]{p3i3, p3i2, p3i7, p3i6};
        Lst<P3i> lst = new Lst<P3i>();
        int n3 = 0;
        int n4 = 2;
        float f = 5.0f;
        float f2 = 1.0f / f;
        float f3 = 0.0f;
        int n5 = p3i2.x;
        int n6 = p3i2.y;
        int n7 = p3i2.z;
        int n8 = p3i3.x;
        int n9 = p3i3.y;
        int n10 = p3i3.z;
        int n11 = (n8 - p3i.x) * n / 8;
        int n12 = (n9 - p3i.y) * n / 8;
        int n13 = (n10 - p3i.z) * n / 8;
        int n14 = (p3i4.x - n5) * n / 8;
        int n15 = (p3i4.y - n6) * n / 8;
        int n16 = (p3i4.z - n7) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].setT(p3i2);
        this.sRight[0] = 1.0f;
        this.pRight[0].setT(p3i3);
        int n17 = 0;
        for (n2 = 2; n2 > 0; --n2) {
            if (n2 == 1) {
                n5 = p3i6.x;
                n6 = p3i6.y;
                n7 = p3i6.z;
                n8 = p3i7.x;
                n9 = p3i7.y;
                n10 = p3i7.z;
                n11 = (n8 - p3i5.x) * n / 8;
                n12 = (n9 - p3i5.y) * n / 8;
                n13 = (n10 - p3i5.z) * n / 8;
                n14 = (p3i8.x - n5) * n / 8;
                n15 = (p3i8.y - n6) * n / 8;
                n16 = (p3i8.z - n7) * n / 8;
                this.sLeft[0] = 0.0f;
                this.pLeft[0].setT(p3i6);
                this.sRight[0] = 1.0f;
                this.pRight[0].setT(p3i7);
                n17 = 0;
            }
            lst.addLast(p3iArray[n3++]);
            f3 = f2;
            do {
                P3i p3i9 = this.pLeft[n17];
                P3i p3i10 = this.pRight[n17];
                int n18 = p3i10.x - p3i9.x;
                int n19 = p3i10.y - p3i9.y;
                int n20 = n18 * n18 + n19 * n19;
                if (n20 <= 2) {
                    float f4 = this.sLeft[n17];
                    this.g3d.fillSphereI(3, p3i9);
                    if (f4 < 1.0f - f3) {
                        P3i p3i11 = new P3i();
                        p3i11.setT(p3i9);
                        lst.addLast(p3i11);
                        f3 += f2;
                        if (n2 == 2) {
                            ++n4;
                        }
                    }
                    --n17;
                    continue;
                }
                double d = (this.sLeft[n17] + this.sRight[n17]) / 2.0f;
                double d2 = d * d;
                double d3 = d2 * d;
                double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
                double d5 = -2.0 * d3 + 3.0 * d2;
                double d6 = d3 - 2.0 * d2 + d;
                double d7 = d3 - d2;
                if (n17 >= 15) break;
                P3i p3i12 = this.pRight[n17 + 1];
                p3i12.x = (int)(d4 * (double)n5 + d5 * (double)n8 + d6 * (double)n11 + d7 * (double)n14);
                p3i12.y = (int)(d4 * (double)n6 + d5 * (double)n9 + d6 * (double)n12 + d7 * (double)n15);
                p3i12.z = (int)(d4 * (double)n7 + d5 * (double)n10 + d6 * (double)n13 + d7 * (double)n16);
                this.pRight[n17 + 1] = this.pRight[n17];
                this.sRight[n17 + 1] = this.sRight[n17];
                this.pRight[n17] = p3i12;
                this.sRight[n17] = (float)d;
                this.pLeft[++n17].setT(p3i12);
                this.sLeft[n17] = (float)d;
            } while (n17 >= 0);
            lst.addLast(p3iArray[n3++]);
        }
        n2 = lst.size();
        for (int i = 0; i < n4 && i + n4 < n2; ++i) {
            this.g3d.drawLineAB((P3i)lst.get(i), (P3i)lst.get(i + n4));
        }
    }
}

