/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.util.C;
import org.jmol.util.Edge;

public class SticksRenderer
extends FontLineShapeRenderer {
    private boolean showMultipleBonds;
    private float multipleBondSpacing;
    private float multipleBondRadiusFactor;
    private byte modeMultipleBond;
    private boolean isCartesianExport;
    private byte endcaps;
    private boolean ssbondsBackbone;
    private boolean hbondsBackbone;
    private boolean bondsBackbone;
    private boolean hbondsSolid;
    private Atom a;
    private Atom b;
    private Bond bond;
    private int xA;
    private int yA;
    private int zA;
    private int xB;
    private int yB;
    private int zB;
    private int dx;
    private int dy;
    private int mag2d;
    private int bondOrder;
    private boolean wireframeOnly;
    private boolean isAntialiased;
    private boolean slabbing;
    private boolean slabByAtom;
    private final V3 x = new V3();
    private final V3 y = new V3();
    private final V3 z = new V3();
    private final P3 p1 = new P3();
    private final P3 p2 = new P3();
    private final BS bsForPass2 = BS.newN(64);
    private boolean isPass2;
    private int xAxis1;
    private int yAxis1;
    private int xAxis2;
    private int yAxis2;
    private int dxStep;
    private int dyStep;

    @Override
    protected boolean render() {
        Bond[] bondArray = this.ms.bo;
        if (bondArray == null) {
            return false;
        }
        this.isPass2 = this.g3d.isPass2();
        if (!this.isPass2) {
            this.bsForPass2.clearAll();
        }
        this.slabbing = this.tm.slabEnabled;
        this.slabByAtom = this.vwr.getBoolean(603979939);
        this.endcaps = (byte)3;
        this.dashDots = this.vwr.getBoolean(603979889) ? sixdots : dashes;
        this.isCartesianExport = this.exportType == 1;
        this.getMultipleBondSettings(false);
        this.wireframeOnly = !this.vwr.checkMotionRendering(1678770178);
        this.ssbondsBackbone = this.vwr.getBoolean(603979952);
        this.hbondsBackbone = this.vwr.getBoolean(603979852);
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.vwr.getBoolean(603979854);
        this.isAntialiased = this.g3d.isAntialiased();
        boolean bl = false;
        if (!this.isExport && this.isPass2) {
            int n = this.bsForPass2.nextSetBit(0);
            while (n >= 0) {
                this.bond = bondArray[n];
                this.renderBond();
                n = this.bsForPass2.nextSetBit(n + 1);
            }
        } else {
            int n = this.ms.bondCount;
            while (--n >= 0) {
                this.bond = bondArray[n];
                if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || !this.renderBond()) continue;
                bl = true;
                this.bsForPass2.set(n);
            }
        }
        return bl;
    }

    private void getMultipleBondSettings(boolean bl) {
        this.multipleBondSpacing = bl ? 0.15f : this.vwr.getFloat(570425370);
        float f = this.multipleBondRadiusFactor = bl ? 0.4f : this.vwr.getFloat(570425369);
        if (this.multipleBondSpacing == 0.0f && this.isCartesianExport) {
            this.multipleBondSpacing = 0.2f;
        }
        this.modeMultipleBond = this.vwr.g.modeMultipleBond;
        this.showMultipleBonds = this.multipleBondSpacing != 0.0f && this.modeMultipleBond != 0 && this.vwr.getBoolean(603979928);
    }

    private boolean renderBond() {
        int n;
        Atom atom;
        Atom atom2;
        this.a = atom2 = this.bond.getAtom1();
        this.b = atom = this.bond.getAtom2();
        int n2 = this.bond.order & 0xFFFDFFFF;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (n2 & 0x100) != 0) {
                this.a = this.a.getGroup().getLeadAtomOr(this.a);
                this.b = this.b.getGroup().getLeadAtomOr(this.b);
            } else if (this.hbondsBackbone && Bond.isOrderH(n2)) {
                this.a = this.a.getGroup().getLeadAtomOr(this.a);
                this.b = this.b.getGroup().getLeadAtomOr(this.b);
            }
        }
        if (!(this.isPass2 || this.a.isVisible(9) && this.b.isVisible(9) && this.g3d.isInDisplayRange(this.a.sX, this.a.sY) && this.g3d.isInDisplayRange(this.b.sX, this.b.sY))) {
            return false;
        }
        if (this.slabbing) {
            if (this.g3d.isClippedZ(this.a.sZ) && this.g3d.isClippedZ(this.b.sZ)) {
                return false;
            }
            if (this.slabByAtom && (this.g3d.isClippedZ(this.a.sZ) || this.g3d.isClippedZ(this.b.sZ))) {
                return false;
            }
        }
        this.zA = this.a.sZ;
        this.zB = this.b.sZ;
        if (this.zA == 1 || this.zB == 1) {
            return false;
        }
        this.colixA = atom2.getColix();
        this.colixB = atom.getColix();
        this.colix = this.bond.colix;
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = C.getColixInherited((short)(this.colix | this.vwr.getColixAtomPalette(atom2, PAL.CPK.id)), this.colixA);
            this.colixB = C.getColixInherited((short)(this.colix | this.vwr.getColixAtomPalette(atom, PAL.CPK.id)), this.colixB);
        } else {
            this.colixA = C.getColixInherited(this.colix, this.colixA);
            this.colixB = C.getColixInherited(this.colix, this.colixB);
        }
        boolean bl = false;
        if (!this.isExport && !this.isPass2) {
            boolean bl2;
            n = !C.isColixTranslucent(this.colixA) ? 1 : 0;
            boolean bl3 = bl2 = !C.isColixTranslucent(this.colixB);
            if (n == 0 || !bl2) {
                if (n == 0 && !bl2 && !bl) {
                    this.g3d.setC(n == 0 ? this.colixA : this.colixB);
                    return true;
                }
                bl = true;
            }
        }
        this.bondOrder = n2 & 0xFFFDFFFF;
        if ((this.bondOrder & 0xE0) == 0) {
            if ((this.bondOrder & 0x100) != 0) {
                this.bondOrder &= 0xFFFFFEFF;
            }
            if ((this.bondOrder & 0x3FF) != 0 && (!this.showMultipleBonds || this.modeMultipleBond == 2 && this.mad > 500 || (this.bondOrder & 0x18000) == 65536)) {
                this.bondOrder = 1;
            }
        }
        n = 0;
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 17: 
            case 513: {
                this.bondOrder = 1;
                n = n2 == 513 ? 0 : 1;
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                n = n2 == 515 ? this.getAromaticDottedBondMask() : 0;
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = Edge.getPartialBondOrder(n2);
                    n = Edge.getPartialBondDotted(n2);
                    break;
                }
                if (Bond.isOrderH(this.bondOrder)) {
                    this.bondOrder = 1;
                    if (this.hbondsSolid) break;
                    n = -1;
                    break;
                }
                if (this.bondOrder == 32768) {
                    this.bondOrder = 1;
                    break;
                }
                if ((this.bondOrder & 0x18000) != 98304) break;
                this.getMultipleBondSettings(true);
                this.bondOrder &= 3;
                n = -2;
            }
        }
        this.xA = this.a.sX;
        this.yA = this.a.sY;
        this.xB = this.b.sX;
        this.yB = this.b.sY;
        this.mad = this.bond.mad;
        if (this.multipleBondRadiusFactor > 0.0f && this.bondOrder > 1) {
            this.mad = (short)((float)this.mad * this.multipleBondRadiusFactor);
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = (int)this.vwr.tm.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.wireframeOnly && this.width > 0) {
            this.width = 1;
        }
        if (!this.isCartesianExport) {
            boolean bl4 = this.asLineOnly = this.width <= 1;
            if (this.asLineOnly && this.isAntialiased) {
                this.width = 3;
                this.asLineOnly = false;
            }
        }
        switch (n) {
            case -2: {
                this.drawBond(0);
                this.getMultipleBondSettings(false);
                break;
            }
            case -1: {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, hDashes);
                break;
            }
            default: {
                this.drawBond(n);
            }
        }
        return bl;
    }

    private void drawBond(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (this.isCartesianExport && this.bondOrder == 1) {
            this.g3d.drawBond(this.a, this.b, this.colixA, this.colixB, this.endcaps, this.mad, -1);
            return;
        }
        boolean bl4 = bl3 = this.dx == 0 && this.dy == 0;
        if (bl3 && this.asLineOnly) {
            return;
        }
        boolean bl5 = this.bondOrder > 1 && this.multipleBondSpacing > 0.0f;
        boolean bl6 = bl2 = bl5 && (this.vwr.getHybridizationAndAxes(this.a.i, this.z, this.x, "pz") != null || this.vwr.getHybridizationAndAxes(this.b.i, this.z, this.x, "pz") != null) && !Float.isNaN(this.x.x);
        if (bl3 && !bl5) {
            int n2 = this.width / 8 + 3;
            int n3 = this.width + n2;
            int n4 = this.yA - (this.bondOrder - 1) * n3 / 2;
            do {
                this.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, n4, this.zA, this.xA, n4, this.zA);
                n4 += n3;
            } while (--this.bondOrder > 0);
            return;
        }
        boolean bl7 = bl = (n & 1) != 0;
        if (this.bondOrder == 1) {
            if (bl) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        if (bl5) {
            if (!bl2) {
                this.z.set((float)Math.PI, (float)Math.E, 8.539734f);
            }
            this.x.sub2(this.b, this.a);
            this.y.cross(this.x, this.z);
            this.y.normalize();
            if (Float.isNaN(this.y.x)) {
                this.z.set((float)Math.PI, (float)Math.E, 8.539734f);
                this.y.cross(this.x, this.z);
                this.y.cross(this.y, this.x);
                this.y.normalize();
            }
            this.y.scale(this.multipleBondSpacing);
            this.x.setT(this.y);
            this.x.scale((float)(this.bondOrder - 1) / 2.0f);
            this.p1.sub2(this.a, this.x);
            this.p2.sub2(this.b, this.x);
            while (true) {
                if (this.isCartesianExport && !bl) {
                    this.g3d.drawBond(this.p1, this.p2, this.colixA, this.colixB, this.endcaps, this.mad, -2);
                } else {
                    this.tm.transformPtScr(this.p1, this.s1);
                    this.tm.transformPtScr(this.p2, this.s2);
                    if (bl) {
                        this.drawDashed(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z, this.dashDots);
                    } else {
                        this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                    }
                    boolean bl8 = bl = ((n >>= 1) & 1) != 0;
                }
                if (--this.bondOrder <= 0) break;
                this.p1.add(this.y);
                this.p2.add(this.y);
                this.stepAxisCoordinates();
            }
            return;
        }
        int n5 = this.dx * this.dx;
        int n6 = this.dy * this.dy;
        this.mag2d = (int)Math.round(Math.sqrt(n5 + n6));
        this.resetAxisCoordinates();
        while (true) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            n >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    private void resetAxisCoordinates() {
        int n = this.mag2d >> 3;
        if (this.multipleBondSpacing != -1.0f && this.multipleBondSpacing < 0.0f) {
            n = (int)((float)n * -this.multipleBondSpacing);
        }
        int n2 = this.width + n;
        this.dxStep = n2 * this.dy / this.mag2d;
        this.dyStep = n2 * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        int n3 = this.bondOrder - 1;
        this.xAxis1 -= this.dxStep * n3 / 2;
        this.yAxis1 -= this.dyStep * n3 / 2;
        this.xAxis2 -= this.dxStep * n3 / 2;
        this.yAxis2 -= this.dyStep * n3 / 2;
    }

    private void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private int getAromaticDottedBondMask() {
        Atom atom = this.b.findAromaticNeighbor(this.a.i);
        if (atom == null) {
            return 1;
        }
        int n = atom.sY - this.yA;
        int n2 = atom.sX - this.xA;
        return this.dx * n - this.dy * n2 < 0 ? 2 : 1;
    }
}

