/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class Orientation {
    public String saveName;
    private M3 rotationMatrix = new M3();
    private float xTrans;
    private float yTrans;
    private float zoom;
    private float rotationRadius;
    private P3 center = new P3();
    private P3 navCenter = new P3();
    private float xNav = Float.NaN;
    private float yNav = Float.NaN;
    private float navDepth = Float.NaN;
    private float cameraDepth = Float.NaN;
    private float cameraX = Float.NaN;
    private float cameraY = Float.NaN;
    private boolean windowCenteredFlag;
    private boolean navigationMode;
    private String moveToText;
    private float[] pymolView;
    private Viewer vwr;

    public Orientation(Viewer viewer, boolean bl, float[] fArray) {
        this.vwr = viewer;
        if (fArray != null) {
            this.pymolView = fArray;
            this.moveToText = "moveTo -1.0 PyMOL " + Escape.eAF(fArray);
            return;
        }
        viewer.finalizeTransformParameters();
        if (bl) {
            M3 m3 = (M3)viewer.ms.getInfoM("defaultOrientationMatrix");
            if (m3 == null) {
                this.rotationMatrix.setScale(1.0f);
            } else {
                this.rotationMatrix.setM3(m3);
            }
        } else {
            viewer.tm.getRotation(this.rotationMatrix);
        }
        this.xTrans = viewer.tm.getTranslationXPercent();
        this.yTrans = viewer.tm.getTranslationYPercent();
        this.zoom = viewer.tm.getZoomSetting();
        this.center.setT(viewer.tm.getRotationCenter());
        this.windowCenteredFlag = viewer.tm.isWindowCentered();
        this.rotationRadius = viewer.getFloat(0x2200002C);
        this.navigationMode = viewer.getBoolean(603979887);
        this.moveToText = viewer.tm.getMoveToText(-1.0f, false);
        if (this.navigationMode) {
            this.xNav = viewer.tm.getNavigationOffsetPercent('X');
            this.yNav = viewer.tm.getNavigationOffsetPercent('Y');
            this.navDepth = viewer.tm.getNavigationDepthPercent();
            this.navCenter = P3.newP(viewer.tm.getNavigationCenter());
        }
        if (viewer.tm.camera.z != 0.0f) {
            this.cameraDepth = viewer.tm.getCameraDepth();
            this.cameraX = viewer.tm.camera.x;
            this.cameraY = viewer.tm.camera.y;
        }
    }

    public String getMoveToText(boolean bl) {
        return bl ? "   " + this.moveToText + "\n  save orientation " + PT.esc(this.saveName.substring(12)) + ";\n" : this.moveToText;
    }

    public boolean restore(float f, boolean bl) {
        if (bl) {
            this.vwr.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            this.vwr.setBooleanProperty("navigationMode", this.navigationMode);
            if (this.pymolView == null) {
                this.vwr.moveTo(this.vwr.eval, f, this.center, null, Float.NaN, this.rotationMatrix, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth, this.cameraDepth, this.cameraX, this.cameraY);
            } else {
                this.vwr.tm.moveToPyMOL(this.vwr.eval, f, this.pymolView);
            }
        } else {
            this.vwr.tm.setRotation(this.rotationMatrix);
        }
        return true;
    }
}

