/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class XtalSymmetry {
    private AtomSetCollection asc;
    public SymmetryInterface symmetry;
    private float[] notionalUnitCell = new float[6];
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private float packingError;
    private String filterSymop;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private P3 ptSupercell;
    private float[] fmatSupercell;
    private M4 matSupercell;
    private Lst<float[]> trajectoryUnitCells;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private boolean vibsFractional;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3 unitCellOffset;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstSymmetryAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;
    private int nVib;

    public XtalSymmetry set(AtomSetCollection atomSetCollection) {
        this.asc = atomSetCollection;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = Interface.getSymmetry()) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        this.symmetry = symmetryInterface;
        return this.symmetry;
    }

    private void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.asc.setInfo("symmetryRange", Float.valueOf(f));
    }

    private void setLatticeCells(AtomSetCollectionReader atomSetCollectionReader) {
        this.latticeCells = atomSetCollectionReader.latticeCells;
        boolean bl = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!bl || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = atomSetCollectionReader.applySymmetryToBonds;
        this.doPackUnitCell = atomSetCollectionReader.doPackUnitCell;
        this.doCentroidUnitCell = atomSetCollectionReader.doCentroidUnitCell;
        this.centroidPacked = atomSetCollectionReader.centroidPacked;
        this.filterSymop = atomSetCollectionReader.filterSymop;
        if (atomSetCollectionReader.strSupercell == null) {
            this.setSupercellFromPoint(atomSetCollectionReader.ptSupercell);
        } else {
            this.setSuperCellFromString(atomSetCollectionReader.strSupercell);
        }
    }

    public void setSupercellFromPoint(P3 p3) {
        this.ptSupercell = p3;
        if (p3 == null) {
            this.matSupercell = null;
            return;
        }
        this.matSupercell = new M4();
        this.matSupercell.m00 = p3.x;
        this.matSupercell.m11 = p3.y;
        this.matSupercell.m22 = p3.z;
        this.matSupercell.m33 = 1.0f;
        Logger.info("Using supercell \n" + this.matSupercell);
    }

    private void setSuperCellFromString(String string) {
        if (this.fmatSupercell != null) {
            return;
        }
        this.fmatSupercell = new float[16];
        if (this.symmetry.getMatrixFromString(string, this.fmatSupercell, true, 0) == null) {
            this.fmatSupercell = null;
            this.matSupercell = null;
            return;
        }
        this.matSupercell = M4.newA16(this.fmatSupercell);
        Logger.info("Using supercell \n" + this.matSupercell);
    }

    private void setNotionalUnitCell(float[] fArray, M3 m3, P3 p3) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = p3;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.asc.haveUnitCell = true;
        this.asc.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.notionalUnitCell);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell, false);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.asc.setAtomSetAuxiliaryInfo("unitCellOffset", p3);
        }
        if (m3 != null) {
            this.symmetry.initializeOrientation(m3);
            this.asc.setAtomSetAuxiliaryInfo("matUnitCellOrientation", m3);
        }
    }

    int addSpaceGroupOperation(AtomSetCollectionReader atomSetCollectionReader, String string) {
        if (atomSetCollectionReader != null) {
            this.setLatticeCells(atomSetCollectionReader);
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    SymmetryInterface applySymmetryFromReader(AtomSetCollectionReader atomSetCollectionReader, SymmetryInterface symmetryInterface) throws Exception {
        this.asc.setCoordinatesAreFractional(atomSetCollectionReader.iHaveFractionalCoordinates);
        this.setNotionalUnitCell(atomSetCollectionReader.notionalUnitCell, atomSetCollectionReader.matUnitCellOrientation, atomSetCollectionReader.unitCellOffset);
        this.asc.setAtomSetSpaceGroupName(atomSetCollectionReader.sgName);
        this.setSymmetryRange(atomSetCollectionReader.symmetryRange);
        if (atomSetCollectionReader.doConvertToFractional || atomSetCollectionReader.fileCoordinatesAreFractional) {
            this.setLatticeCells(atomSetCollectionReader);
            boolean bl = true;
            if (atomSetCollectionReader.ignoreFileSpaceGroupName || !atomSetCollectionReader.iHaveSymmetryOperators) {
                if (!atomSetCollectionReader.merging || symmetryInterface == null) {
                    symmetryInterface = atomSetCollectionReader.getNewSymmetry();
                }
                bl = symmetryInterface.createSpaceGroup(atomSetCollectionReader.desiredSpaceGroupIndex, atomSetCollectionReader.sgName.indexOf("!") >= 0 ? "P1" : atomSetCollectionReader.sgName, atomSetCollectionReader.notionalUnitCell);
            } else {
                atomSetCollectionReader.doPreSymmetry();
                this.vibsFractional = atomSetCollectionReader.vibsFractional;
                symmetryInterface = null;
            }
            if (bl) {
                if (symmetryInterface != null) {
                    this.symmetry.setSpaceGroupFrom(symmetryInterface);
                }
                this.packingError = atomSetCollectionReader.packingError;
                this.applySymmetryLattice(atomSetCollectionReader.ms, atomSetCollectionReader.altCell);
                if (symmetryInterface != null && this.filterSymop == null) {
                    this.asc.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                }
            }
        }
        if (atomSetCollectionReader.iHaveFractionalCoordinates && atomSetCollectionReader.merging && symmetryInterface != null) {
            this.asc.toCartesian(symmetryInterface);
            this.asc.setCoordinatesAreFractional(false);
            atomSetCollectionReader.addVibrations = false;
        }
        return this.symmetry;
    }

    private void applySymmetryLattice(MSInterface mSInterface, String string) throws Exception {
        int n;
        int n2;
        int n3;
        P3 p3;
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        int n4 = this.latticeCells[0];
        int n5 = this.latticeCells[1];
        int n6 = Math.abs(this.latticeCells[2]);
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        BS bS = null;
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        T3[] t3Array = null;
        P3 p32 = null;
        P3 p33 = null;
        this.nVib = 0;
        P3 p34 = null;
        P3 p35 = null;
        P3 p36 = null;
        if (string != null && string.indexOf(",") >= 0) {
            t3Array = this.symmetry.getV0abc(string);
            if (t3Array != null) {
                this.minXYZ = new P3i();
                this.maxXYZ = P3i.new3(n4, n5, n6);
                this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
                p33 = P3.newP(t3Array[0]);
                this.symmetry.toFractional(p33, true);
                p34 = P3.newP(t3Array[1]);
                p35 = P3.newP(t3Array[2]);
                p36 = P3.newP(t3Array[3]);
                t3Array[0].scaleAdd2(this.minXYZ.x, p34, t3Array[0]);
                t3Array[0].scaleAdd2(this.minXYZ.y, p35, t3Array[0]);
                t3Array[0].scaleAdd2(this.minXYZ.z, p36, t3Array[0]);
                p3 = P3.newP(t3Array[0]);
                this.symmetry.toFractional(p3, true);
                this.setSymmetryMinMax(p3);
                t3Array[1].scale(this.maxXYZ.x - this.minXYZ.x);
                t3Array[2].scale(this.maxXYZ.y - this.minXYZ.y);
                t3Array[3].scale(this.maxXYZ.z - this.minXYZ.z);
                for (n3 = 0; n3 < 3; ++n3) {
                    for (n2 = n3 + 1; n2 < 4; ++n2) {
                        p3.add2(t3Array[n3], t3Array[n2]);
                        if (n3 != 0) {
                            p3.add(t3Array[0]);
                        }
                        this.symmetry.toFractional(p3, false);
                        this.setSymmetryMinMax(p3);
                    }
                }
                this.symmetry.toCartesian(p3, false);
                p3.add(t3Array[1]);
                this.symmetry.toFractional(p3, false);
                this.setSymmetryMinMax(p3);
                this.minXYZ = P3i.new3((int)Math.floor(this.rminx + 0.001f), (int)Math.floor(this.rminy + 0.001f), (int)Math.floor(this.rminz + 0.001f));
                this.maxXYZ = P3i.new3((int)Math.ceil(this.rmaxx - 0.001f), (int)Math.ceil(this.rmaxy - 0.001f), (int)Math.ceil(this.rmaxz - 0.001f));
            }
        } else if (this.fmatSupercell != null) {
            p3 = new P3();
            for (n3 = 0; n3 <= 1; ++n3) {
                for (n2 = 0; n2 <= 1; ++n2) {
                    for (n = 0; n <= 1; ++n) {
                        p3.set(n3, n2, n);
                        this.setSym(p3);
                    }
                }
            }
            p32 = (P3)this.asc.getAtomSetAuxiliaryInfoValue(-1, "unitCellOffset");
            this.minXYZ = P3i.new3((int)this.rminx, (int)this.rminy, (int)this.rminz);
            this.maxXYZ = P3i.new3((int)this.rmaxx, (int)this.rmaxy, (int)this.rmaxz);
            p34 = this.setSym(P3.new3(1.0f, 0.0f, 0.0f));
            p35 = this.setSym(P3.new3(0.0f, 1.0f, 0.0f));
            p36 = this.setSym(P3.new3(0.0f, 0.0f, 1.0f));
        }
        if (this.rminx == Float.MAX_VALUE) {
            this.fmatSupercell = null;
            this.matSupercell = null;
            string = null;
            t3Array = null;
        } else {
            int n7;
            Logger.info("setting min/max for original lattice to " + this.minXYZ + " and " + this.maxXYZ);
            boolean bl = this.doPackUnitCell;
            boolean bl2 = this.doPackUnitCell = t3Array != null;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.setAll(this.asc.ac);
            }
            bS = this.asc.bsAtoms;
            this.applyAllSymmetry(mSInterface, null, false);
            this.doPackUnitCell = bl;
            this.setVibVectors();
            Atom[] atomArray = this.asc.atoms;
            n2 = this.asc.ac;
            for (n7 = n = this.asc.getLastAtomSetAtomIndex(); n7 < n2; ++n7) {
                this.symmetry.toCartesian(atomArray[n7], true);
            }
            this.symmetry = null;
            this.symmetry = this.getSymmetry();
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p34.x, p34.y, p34.z, p35.x, p35.y, p35.z, p36.x, p36.y, p36.z}, null, p32);
            this.asc.setAtomSetSpaceGroupName(t3Array == null ? "P1" : "cell=" + string);
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            for (n7 = n; n7 < n2; ++n7) {
                this.symmetry.toFractional(atomArray[n7], true);
                if (p33 == null) continue;
                atomArray[n7].sub(p33);
            }
            this.asc.haveAnisou = false;
            this.asc.setAtomSetAuxiliaryInfo("matUnitCellOrientation", null);
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n4, n5, n6);
        if (t3Array == null) {
            this.applyAllSymmetry(mSInterface, bS, this.fmatSupercell != null);
            this.fmatSupercell = null;
        } else {
            this.trimAtomSet();
        }
    }

    private P3 setSym(P3 p3) {
        this.matSupercell.rotate(p3);
        this.setSymmetryMinMax(p3);
        this.symmetry.toCartesian(p3, false);
        return p3;
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    private boolean isInSymmetryRange(P3 p3) {
        return p3.x >= this.rminx && p3.y >= this.rminy && p3.z >= this.rminz && p3.x <= this.rmaxx && p3.y <= this.rmaxy && p3.z <= this.rmaxz;
    }

    public boolean isWithinCell(int n, P3 p3, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return p3.x > f - f7 && p3.x < f2 + f7 && (n < 2 || p3.y > f3 - f7 && p3.y < f4 + f7) && (n < 3 || p3.z > f5 - f7 && p3.z < f6 + f7);
    }

    private void applyAllSymmetry(MSInterface mSInterface, BS bS, boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        SymmetryInterface symmetryInterface;
        boolean bl2;
        int n4;
        if (this.asc.ac == 0) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount == 0 ? this.asc.getLastAtomSetAtomCount() : this.asc.baseSymmetryAtomCount;
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        int n5 = this.symmetry.getSpaceGroupOperationCount();
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.asc.setAtomSetAuxiliaryInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (mSInterface != null) {
                mSInterface.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n6 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n7 = this.asc.checkSpecial ? this.noSymmetryCount * n5 * n6 : (this.symmetryRange > 0.0f ? this.noSymmetryCount * n5 : (this.symmetryRange < 0.0f ? 1 : 1));
        P3[] p3Array = new P3[n7];
        for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
            this.asc.atoms[n4 + this.firstSymmetryAtom].bsSymmetry = BS.newN(n5 * (n6 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n6];
        this.unitCellTranslations = new V3[n6];
        int n8 = 0;
        int n9 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl3 = this.symmetryRange != 0.0f;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = bl2 = this.symmetryRange > 0.0f;
        if (bl3) {
            this.rminz = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminx = Float.MAX_VALUE;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        SymmetryInterface symmetryInterface2 = symmetryInterface = this.symmetry;
        this.latticeOp = symmetryInterface.getLatticeOp();
        this.checkAll = bl || this.asc.atomSetCount == 1 && this.asc.checkSpecial && this.latticeOp >= 0;
        this.latticeOnly = this.asc.checkLatticeOnly && this.latticeOp >= 0;
        P3 p3 = null;
        M4 m4 = symmetryInterface.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            p3 = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n8] = V3.new3(n3, n2, n);
                    nArray[n8++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || p3Array.length == 0) continue;
                    for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
                        Atom atom = this.asc.atoms[this.firstSymmetryAtom + n4];
                        if (mSInterface != null && (symmetryInterface = mSInterface.getAtomSymmetry(atom, this.symmetry)) != symmetryInterface2) {
                            if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                                symmetryInterface2 = symmetryInterface;
                                this.finalizeSymmetry(symmetryInterface2);
                            }
                            m4 = symmetryInterface.getSpaceGroupOperation(0);
                        }
                        P3 p32 = P3.newP(atom);
                        m4.rotTrans(p32);
                        symmetryInterface.toCartesian(p32, false);
                        if (this.doPackUnitCell) {
                            symmetryInterface.toUnitCell(p32, this.ptOffset);
                            p3.setT(p32);
                            symmetryInterface.toFractional(p3, false);
                            if (bS == null) {
                                atom.setT(p3);
                            } else if (atom.distance(p3) < 1.0E-4f) {
                                bS.set(atom.index);
                            } else {
                                bS.clear(atom.index);
                                continue;
                            }
                        }
                        if (bS != null) {
                            atom.bsSymmetry.clearAll();
                        }
                        atom.bsSymmetry.set(n8 * n5);
                        atom.bsSymmetry.set(0);
                        if (bl3) {
                            this.setSymmetryMinMax(p32);
                        }
                        if (n4 >= n7) continue;
                        p3Array[n4] = p32;
                    }
                    if (bl4) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n9 = n4 = this.symmetryAddAtoms(0, 0, 0, 0, n4, n8 * n5, p3Array, mSInterface, false);
                }
            }
        }
        if (bl2) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n8 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n8;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n3, n2, n, n9, n4, n8 * n5, p3Array, mSInterface, bl);
                }
            }
        }
        if (n8 * this.noSymmetryCount == this.asc.ac - this.firstSymmetryAtom) {
            this.duplicateAtomProperties(n8);
        }
        this.setSymmetryOps();
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setAtomSetAuxiliaryInfo("latticeDesignation", symmetryInterface.getLatticeDesignation());
        this.asc.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.asc.setAtomSetAuxiliaryInfo("unitCellTranslations", this.unitCellTranslations);
        this.notionalUnitCell = new float[6];
        this.reset();
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, P3[] p3Array, MSInterface mSInterface, boolean bl) throws Exception {
        int[] nArray;
        boolean bl2 = n4 == 0;
        boolean bl3 = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl3 ? new int[this.noSymmetryCount] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n, n2, n3);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        boolean bl7 = n7 == 1 && !this.doPackUnitCell ? false : this.asc.checkSpecial;
        boolean bl8 = bl4 || (bl5 &= !bl2);
        boolean bl9 = bl7 || bl8;
        boolean bl10 = bl7 || bl6;
        SymmetryInterface symmetryInterface = this.symmetry;
        if (bl4) {
            n4 = this.noSymmetryCount;
        }
        int n8 = this.firstSymmetryAtom + this.noSymmetryCount;
        P3 p3 = new P3();
        String string = null;
        char c = '\u0000';
        for (int i = 0; i < n7; ++i) {
            int n9;
            Object object;
            Atom[] atomArray;
            if (bl2 && i == 0 || this.latticeOnly && i > 0 && i != this.latticeOp) continue;
            int n10 = bl ? 0 : (bl7 ? n5 : (bl5 ? n4 : 0));
            float f2 = this.asc.vibScale == 0 ? symmetryInterface.getSpinOp(i) : (float)this.asc.vibScale;
            for (int j = this.firstSymmetryAtom; j < n8; ++j) {
                Object object2;
                atomArray = this.asc.atoms[j];
                if (atomArray.ignoreSymmetry || this.asc.bsAtoms != null && !this.asc.bsAtoms.get(j)) continue;
                if (mSInterface == null) {
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                } else {
                    symmetryInterface = mSInterface.getAtomSymmetry((Atom)atomArray, this.symmetry);
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                    string = symmetryInterface.getSpaceGroupOperationCode(i);
                    if (string != null) {
                        c = string.charAt(0);
                        symmetryInterface = mSInterface.getSymmetryFromCode(string);
                        if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(symmetryInterface);
                        }
                    }
                }
                P3 p32 = P3.newP(p3);
                symmetryInterface.toCartesian(p32, false);
                if (this.doPackUnitCell) {
                    symmetryInterface.toUnitCell(p32, this.ptOffset);
                    p3.setT(p32);
                    symmetryInterface.toFractional(p3, false);
                    if (!this.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingError)) continue;
                }
                if (bl6) {
                    this.setSymmetryMinMax(p32);
                }
                object = null;
                if (bl9) {
                    float f3 = Float.MAX_VALUE;
                    if (bl8 && !this.isInSymmetryRange(p32)) continue;
                    int n11 = this.checkAll ? this.asc.ac : n10;
                    object2 = atomArray.atomName;
                    n9 = string == null ? atomArray.altLoc : c;
                    int n12 = n11;
                    while (--n12 >= 0) {
                        P3 p33 = p3Array[n12];
                        if (p33 == null) continue;
                        float f4 = p32.distanceSquared(p33);
                        if (bl7 && (double)f4 < 1.0E-4) {
                            object = this.asc.atoms[this.firstSymmetryAtom + n12];
                            if ((((Atom)object).atomName == null || ((Atom)object).atomName.equals(object2)) && ((Atom)object).altLoc == n9) break;
                            object = null;
                        }
                        if (!bl5 || n12 >= n4 || !(f4 < f3)) continue;
                        f3 = f4;
                    }
                    if (bl5 && f3 > f) continue;
                }
                int n13 = atomArray.atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n13] = ((Atom)object).index;
                    }
                    ((Atom)object).bsSymmetry.set(n6 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n13] = this.asc.ac;
                }
                Atom atom = this.asc.newCloneAtom((Atom)atomArray);
                if (this.asc.bsAtoms != null) {
                    this.asc.bsAtoms.set(atom.index);
                }
                atom.setT(p3);
                if (f2 != 0.0f && atom.vib != null) {
                    symmetryInterface.getSpaceGroupOperation(i).rotate(atom.vib);
                    atom.vib.scale(f2);
                    System.out.println("vib for iSym " + i + " " + atom + " " + atom.vib);
                }
                atom.atomSite = n13;
                if (string != null) {
                    atom.altLoc = c;
                }
                atom.bsSymmetry = BSUtil.newAndSetBit(n6 + i);
                atom.bsSymmetry.set(i);
                if (bl10) {
                    p3Array[n5++] = p32;
                }
                if ((object2 = atomArray.tensors) == null) continue;
                atom.tensors = null;
                n9 = ((ArrayList)object2).size();
                while (--n9 >= 0) {
                    Tensor tensor = (Tensor)((ArrayList)object2).get(n9);
                    if (tensor == null) continue;
                    if (n7 == 1) {
                        atom.addTensor(tensor.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom, tensor, i, false, symmetryInterface);
                }
            }
            if (!bl3) continue;
            Bond[] bondArray = this.asc.bonds;
            atomArray = this.asc.atoms;
            for (int j = this.asc.bondIndex0; j < this.bondCount0; ++j) {
                object = bondArray[j];
                Atom atom = atomArray[((Bond)object).atomIndex1];
                Atom atom2 = atomArray[((Bond)object).atomIndex2];
                if (atom == null || atom2 == null) continue;
                int n14 = nArray[atom.atomSite];
                n9 = nArray[atom2.atomSite];
                if (n14 < n8 && n9 < n8) continue;
                this.asc.addNewBondWithOrder(n14, n9, ((Bond)object).order);
            }
        }
        return n5;
    }

    private void duplicateAtomProperties(int n) {
        Map map = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                int n2;
                Object object;
                Object object2;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    object2 = (String)v;
                    object = new SB();
                    n2 = n;
                    while (--n2 >= 0) {
                        ((SB)object).append((String)object2);
                    }
                    map.put(string, ((SB)object).toString());
                    continue;
                }
                object2 = (float[])v;
                object = new float[((Object)object2).length * n];
                n2 = n;
                while (--n2 >= 0) {
                    System.arraycopy(object2, 0, object, n2 * ((Object)object2).length, ((Object)object2).length);
                }
            }
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetryInterface) {
        String string = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetryInterface.setFinalOperations(string, this.asc.atoms, this.firstSymmetryAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || string == null || string.equals("unspecified!")) {
            this.asc.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
            this.asc.setAtomSetAuxiliaryInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setAtomSetAuxiliaryInfo("symmetryCount", n);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> map, float[] fArray, boolean bl, String string) {
        int n;
        Cloneable cloneable;
        Object object;
        int n2;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        int n3 = string.indexOf("BYCHAIN") >= 0 ? 1 : (string.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst lst = (Lst)map.get("biomts");
        if (lst.size() < 2) {
            return;
        }
        this.symmetry = null;
        if (!Float.isNaN(fArray[0])) {
            this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        }
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation(null, "x,y,z");
        String string2 = (String)map.get("name");
        this.asc.setAtomSetSpaceGroupName(string2);
        int n4 = lst.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.asc.bondCount;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.asc.ac] : null;
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        int n5 = this.asc.ac;
        Hashtable<Serializable, BS> hashtable = new Hashtable<Serializable, BS>();
        int n6 = 0;
        Atom[] atomArray = this.asc.atoms;
        switch (n3) {
            case 1: {
                n2 = n5;
                while (--n2 >= this.firstSymmetryAtom) {
                    void object2;
                    object = atomArray[n2].chainID;
                    BS n7 = (BS)hashtable.get(object);
                    if (n7 == null) {
                        ++n6;
                        BS bS = new BS();
                        hashtable.put((Serializable)object, bS);
                    }
                    object2.set(n2);
                }
                this.asc.bsAtoms = new BS();
                for (n2 = 0; n2 < n6; ++n2) {
                    this.asc.bsAtoms.set(n5 + n2);
                    object = new Atom();
                    ((T3)object).set(0.0f, 0.0f, 0.0f);
                    ((Atom)object).radius = 16.0f;
                    this.asc.addAtom((Atom)object);
                }
                n2 = 0;
                for (Map.Entry entry : hashtable.entrySet()) {
                    Atom atom = atomArray[n5 + n2++];
                    cloneable = (BS)entry.getValue();
                    n = ((BS)cloneable).nextSetBit(0);
                    while (n >= 0) {
                        atom.add(atomArray[n]);
                        n = ((BS)cloneable).nextSetBit(n + 1);
                    }
                    atom.scale(1.0f / (float)((BS)cloneable).cardinality());
                    atom.atomName = "Pt" + n2;
                    atom.chainID = (Integer)entry.getKey();
                }
                this.firstSymmetryAtom = n5;
                n5 += n6;
                break;
            }
            case 2: {
                void var17_23;
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(n5);
                atomArray[n5] = new Atom();
                object = atomArray[n5];
                ((T3)object).set(0.0f, 0.0f, 0.0f);
                int n7 = n5;
                while (--var17_23 >= this.firstSymmetryAtom) {
                    ((T3)object).add(atomArray[var17_23]);
                }
                ((T3)object).scale(1.0f / (float)(n5 - this.firstSymmetryAtom));
                ((Atom)object).atomName = "Pt";
                ((Atom)object).radius = 16.0f;
                this.firstSymmetryAtom = n5++;
            }
        }
        if (string.indexOf("#<") >= 0) {
            n4 = Math.min(n4, PT.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = PT.rep(string, "#<", "_<");
        }
        for (n2 = this.firstSymmetryAtom; n2 < n5; ++n2) {
            atomArray[n2].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        for (n2 = 1; n2 < n4; ++n2) {
            if (string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n2 + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n2 + 1) + ";") < 0) continue;
            object = (M4)lst.get(n2);
            for (int i = this.firstSymmetryAtom; i < n5; ++i) {
                if (this.asc.bsAtoms != null && !this.asc.bsAtoms.get(i)) continue;
                try {
                    int n8 = atomArray[i].atomSite;
                    if (bl2) {
                        nArray[n8] = this.asc.ac;
                    }
                    cloneable = this.asc.newCloneAtom(atomArray[i]);
                    if (this.asc.bsAtoms != null) {
                        this.asc.bsAtoms.set(((Atom)cloneable).index);
                    }
                    ((Atom)cloneable).atomSite = n8;
                    ((M4)object).rotTrans((T3)((Object)cloneable));
                    ((Atom)cloneable).bsSymmetry = BSUtil.newAndSetBit(n2);
                    if (!bl2) continue;
                    for (n = this.asc.bondIndex0; n < this.bondCount0; ++n) {
                        Bond bond = this.asc.bonds[n];
                        int n9 = nArray[atomArray[bond.atomIndex1].atomSite];
                        int n10 = nArray[atomArray[bond.atomIndex2].atomSite];
                        if (n9 < n5 && n10 < n5) continue;
                        this.asc.addNewBondWithOrder(n9, n10, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.asc.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            if (n2 <= 0) continue;
            this.symmetry.addBioMoleculeOperation((M4)object, false);
        }
        this.noSymmetryCount = n5 - this.firstSymmetryAtom;
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setAtomSetAuxiliaryInfo("biosymmetryCount", n4);
        this.asc.setAtomSetAuxiliaryInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl, SymmetryInterface symmetryInterface) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return atom.addTensor(((Tensor)Interface.getUtil("Tensor")).setFromEigenVectors(symmetryInterface.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id, tensor), null, bl);
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom atom = this.asc.atoms[i];
            if (atom.anisoBorU == null) continue;
            atom.addTensor(this.symmetry.getTensor(atom.anisoBorU), null, false);
            if (Float.isNaN(atom.bfactor)) {
                atom.bfactor = atom.anisoBorU[7] * 100.0f;
            }
            atom.anisoBorU = null;
        }
    }

    public void setTimeReversal(int n, int n2) {
        this.symmetry.setTimeReversal(n, n2);
    }

    public void rotateToSuperCell(V3 v3) {
        if (this.matSupercell != null) {
            this.matSupercell.rotate(v3);
        }
    }

    public int setVibVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.vibsFractional) {
            return this.nVib;
        }
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            if (this.asc.atoms[n2].vib == null) continue;
            Vibration vibration = new Vibration();
            vibration.setT(this.asc.atoms[n2].vib);
            vibration.modDim = -2;
            this.symmetry.toCartesian(vibration, true);
            this.asc.atoms[n2].vib = vibration;
            ++this.nVib;
        }
        return this.nVib;
    }

    private void trimAtomSet() {
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        BS bS = this.asc.bsAtoms;
        Atom[] atomArray = this.asc.atoms;
        if (bS == null) {
            bS = this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (!this.isWithinCell(this.dtype, atomArray[n], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingError)) {
                bS.clear(n);
            }
            n = bS.nextSetBit(n + 1);
        }
    }
}

