/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.img.ImageEncoder;
import javajs.util.Lst;

public class GifEncoder
extends ImageEncoder {
    private Map<Integer, AdaptiveColorCollection> colorMap;
    protected int[] red;
    protected int[] green;
    protected int[] blue;
    private boolean interlaced;
    private boolean addHeader = true;
    private boolean addImage = true;
    private boolean addTrailer = true;
    private int delayTime100ths = -1;
    private boolean looping;
    private Map<String, Object> params;
    private int byteCount;
    private int bitsPerPixel = 1;
    protected int transparentIndex = -1;
    private int initCodeSize;
    private int curpt;
    private static final int EOF = -1;
    private static final int[] INTERLACE_PARAMS = new int[]{8, 8, 4, 2, 4, 2, 1, 0};
    private static final int BITS = 12;
    private static final int HSIZE = 5003;
    private int nBits;
    private int maxbits = 12;
    private int maxcode;
    private int maxmaxcode = 4096;
    private int[] htab = new int[5003];
    private int[] codetab = new int[5003];
    private int hsize = 5003;
    private int freeEnt = 0;
    private boolean clearFlag = false;
    private int clearCode;
    private int EOFCode;
    private int countDown;
    private int pass = 0;
    private int curx;
    private int cury;
    private int curAccum = 0;
    private int curBits = 0;
    private int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private int bufPt;
    private final byte[] buf = new byte[256];

    @Override
    protected void setParams(Map<String, Object> map) {
        this.params = map;
        boolean bl = this.interlaced = Boolean.TRUE == map.get("interlaced");
        if (this.interlaced || !map.containsKey("captureMode")) {
            return;
        }
        try {
            this.byteCount = (Integer)map.get("captureByteCount");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = "maec".indexOf(((String)map.get("captureMode")).substring(0, 1));
        if (this.logging) {
            System.out.println("GIF capture mode " + n);
        }
        switch (n) {
            case 0: {
                map.put("captureMode", "add");
                this.addImage = false;
                this.addTrailer = false;
                break;
            }
            case 1: {
                this.addHeader = false;
                this.addTrailer = false;
                int n2 = Math.abs((Integer)map.get("captureFps"));
                this.delayTime100ths = n2 == 0 ? 0 : 100 / n2;
                this.looping = Boolean.FALSE != map.get("captureLooping");
                break;
            }
            case 2: {
                this.addHeader = false;
                this.addImage = false;
                break;
            }
            case 3: {
                this.addHeader = false;
                this.addImage = false;
                this.out.cancel();
            }
        }
    }

    @Override
    protected void generate() throws IOException {
        if (this.addHeader) {
            this.writeHeader();
        }
        this.addHeader = false;
        if (this.addImage) {
            this.createColorTable();
            this.writeGraphicControlExtension();
            if (this.delayTime100ths >= 0 && this.looping) {
                this.writeNetscapeLoopExtension();
            }
            this.writeImage();
        }
    }

    @Override
    protected void close() {
        if (this.addTrailer) {
            this.writeTrailer();
        } else {
            this.doClose = false;
        }
        this.params.put("captureByteCount", this.byteCount);
    }

    private void writeHeader() throws IOException {
        this.putString("GIF89a");
        this.putWord(this.width);
        this.putWord(this.height);
        this.putByte(0);
        this.putByte(0);
        this.putByte(0);
    }

    private void createColorTable() {
        ColorVector colorVector = this.getColors();
        Map<Integer, AdaptiveColorCollection> map = this.getBest256(colorVector);
        int n = map.size();
        this.bitsPerPixel = n <= 2 ? 1 : (n <= 4 ? 2 : (n <= 16 ? 4 : 8));
        this.colorMap = this.finalizeColorMap(colorVector, map);
    }

    private ColorVector getColors() {
        ColorVector colorVector = new ColorVector();
        Hashtable<Integer, ColorItem> hashtable = new Hashtable<Integer, ColorItem>();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < this.height; ++i) {
            int n5 = 0;
            while (n5 < this.width) {
                Integer n6;
                ColorItem colorItem;
                boolean bl;
                int n7 = this.pixels[n3];
                boolean bl2 = bl = n7 >= 0;
                if (bl) {
                    if (n2 < 0) {
                        n2 = n;
                        n4 = n7;
                    } else if (n7 != n4) {
                        this.pixels[n3] = n7 = n4;
                    }
                }
                if ((colorItem = (ColorItem)hashtable.get(n6 = Integer.valueOf(n7))) == null) {
                    colorItem = new ColorItem(n7, 1);
                    hashtable.put(n6, colorItem);
                    colorVector.addLast(colorItem);
                    ++n;
                } else {
                    ++colorItem.count;
                }
                ++n5;
                ++n3;
            }
        }
        hashtable = null;
        if (this.logging) {
            System.out.println("# total image colors = " + n);
        }
        colorVector.sort();
        return colorVector;
    }

    private Map<Integer, AdaptiveColorCollection> getBest256(ColorVector colorVector) {
        int n = 65793;
        int n2 = colorVector.size();
        int n3 = Math.max(n2 - 1, 0);
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        Hashtable<Integer, AdaptiveColorCollection> hashtable = null;
        while (n4 > 255) {
            n4 = n2;
            n5 = 0;
            hashtable = new Hashtable<Integer, AdaptiveColorCollection>();
            for (int i = 0; i < n3; ++i) {
                ColorItem colorItem = (ColorItem)colorVector.get(i);
                int n6 = n4 < 256 ? colorItem.rgb : colorItem.rgb & ~n;
                Integer n7 = n6;
                colorItem.acc = (AdaptiveColorCollection)hashtable.get(n7);
                if (colorItem.acc == null) {
                    colorItem.acc = new AdaptiveColorCollection(n6, n5++);
                    hashtable.put(n7, colorItem.acc);
                    continue;
                }
                --n4;
            }
            int n8 = n;
            n <<= 1;
            n = n8 | n;
        }
        ColorItem colorItem = (ColorItem)colorVector.get(n3);
        colorItem.acc = new AdaptiveColorCollection(colorItem.rgb, n5++);
        hashtable.put(colorItem.rgb, colorItem.acc);
        if (this.logging) {
            System.out.println("# GIF colors = " + hashtable.size());
        }
        return hashtable;
    }

    private Map<Integer, AdaptiveColorCollection> finalizeColorMap(Lst<ColorItem> lst, Map<Integer, AdaptiveColorCollection> map) {
        int n = 1 << this.bitsPerPixel;
        this.red = new int[n];
        this.green = new int[n];
        this.blue = new int[n];
        int n2 = lst.size();
        Hashtable<Integer, AdaptiveColorCollection> hashtable = new Hashtable<Integer, AdaptiveColorCollection>();
        for (int i = 0; i < n2; ++i) {
            ColorItem object = (ColorItem)lst.get(i);
            int n3 = object.rgb;
            object.acc.addRgb(n3, object.count);
            hashtable.put(n3, object.acc);
        }
        for (AdaptiveColorCollection adaptiveColorCollection : map.values()) {
            adaptiveColorCollection.setRgb();
        }
        return hashtable;
    }

    private void writeGraphicControlExtension() {
        if (this.transparentIndex != -1 || this.delayTime100ths >= 0) {
            this.putByte(33);
            this.putByte(249);
            this.putByte(4);
            int n = (this.transparentIndex == -1 ? 0 : 1) | (this.delayTime100ths > 0 ? 2 : 0);
            this.putByte(n);
            this.putWord(this.delayTime100ths > 0 ? this.delayTime100ths : 0);
            this.putByte(this.transparentIndex == -1 ? 0 : this.transparentIndex);
            this.putByte(0);
        }
    }

    private void writeNetscapeLoopExtension() {
        this.putByte(33);
        this.putByte(255);
        this.putByte(11);
        this.putString("NETSCAPE2.0");
        this.putByte(3);
        this.putByte(1);
        this.putWord(0);
        this.putByte(0);
    }

    private void writeImage() {
        this.putByte(44);
        this.putWord(0);
        this.putWord(0);
        this.putWord(this.width);
        this.putWord(this.height);
        int n = 0x80 | (this.interlaced ? 64 : 0) | this.bitsPerPixel - 1;
        this.putByte(n);
        int n2 = 1 << this.bitsPerPixel;
        for (int i = 0; i < n2; ++i) {
            this.putByte(this.red[i]);
            this.putByte(this.green[i]);
            this.putByte(this.blue[i]);
        }
        this.initCodeSize = this.bitsPerPixel <= 1 ? 2 : this.bitsPerPixel;
        this.putByte(this.initCodeSize);
        this.compress();
        this.putByte(0);
    }

    private void writeTrailer() {
        this.putByte(59);
    }

    private int nextPixel() {
        if (this.countDown-- == 0) {
            return -1;
        }
        int n = this.colorMap.get((Object)Integer.valueOf((int)this.pixels[this.curpt])).index;
        ++this.curx;
        if (this.curx == this.width) {
            this.curx = 0;
            if (this.interlaced) {
                this.updateY(INTERLACE_PARAMS[this.pass], INTERLACE_PARAMS[this.pass + 4]);
            } else {
                ++this.cury;
            }
        }
        this.curpt = this.cury * this.width + this.curx;
        return n & 0xFF;
    }

    private void updateY(int n, int n2) {
        this.cury += n;
        if (n2 >= 0 && this.cury >= this.height) {
            this.cury = n2;
            ++this.pass;
        }
    }

    private void putWord(int n) {
        this.putByte(n);
        this.putByte(n >> 8);
    }

    private static final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    private void compress() {
        int n;
        int n2;
        this.countDown = this.width * this.height;
        this.pass = 0;
        this.curx = 0;
        this.cury = 0;
        this.clearFlag = false;
        this.nBits = this.initCodeSize + 1;
        this.maxcode = GifEncoder.MAXCODE(this.nBits);
        this.clearCode = 1 << this.initCodeSize;
        this.EOFCode = this.clearCode + 1;
        this.freeEnt = this.clearCode + 2;
        this.bufPt = 0;
        int n3 = this.nextPixel();
        int n4 = 0;
        for (n2 = this.hsize; n2 < 65536; n2 *= 2) {
            ++n4;
        }
        n4 = 8 - n4;
        int n5 = this.hsize;
        this.clearHash(n5);
        this.output(this.clearCode);
        block1: while ((n = this.nextPixel()) != -1) {
            int n6 = n << n4 ^ n3;
            n2 = (n << this.maxbits) + n3;
            if (this.htab[n6] == n2) {
                n3 = this.codetab[n6];
                continue;
            }
            if (this.htab[n6] >= 0) {
                int n7 = n5 - n6;
                if (n6 == 0) {
                    n7 = 1;
                }
                do {
                    if ((n6 -= n7) < 0) {
                        n6 += n5;
                    }
                    if (this.htab[n6] != n2) continue;
                    n3 = this.codetab[n6];
                    continue block1;
                } while (this.htab[n6] >= 0);
            }
            this.output(n3);
            n3 = n;
            if (this.freeEnt < this.maxmaxcode) {
                ++this.freeEnt;
                this.htab[n6] = n2;
                continue;
            }
            this.clearBlock();
        }
        this.output(n3);
        this.output(this.EOFCode);
    }

    private void output(int n) {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= n << this.curBits) : n;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.byteOut((byte)(this.curAccum & 0xFF));
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEnt > this.maxcode || this.clearFlag) {
            if (this.clearFlag) {
                this.nBits = this.initCodeSize + 1;
                this.maxcode = GifEncoder.MAXCODE(this.nBits);
                this.clearFlag = false;
            } else {
                ++this.nBits;
                this.maxcode = this.nBits == this.maxbits ? this.maxmaxcode : GifEncoder.MAXCODE(this.nBits);
            }
        }
        if (n == this.EOFCode) {
            while (this.curBits > 0) {
                this.byteOut((byte)(this.curAccum & 0xFF));
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.flushBytes();
        }
    }

    private void clearBlock() {
        this.clearHash(this.hsize);
        this.freeEnt = this.clearCode + 2;
        this.clearFlag = true;
        this.output(this.clearCode);
    }

    private void clearHash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    private void byteOut(byte by) {
        this.buf[this.bufPt++] = by;
        if (this.bufPt >= 254) {
            this.flushBytes();
        }
    }

    protected void flushBytes() {
        if (this.bufPt > 0) {
            this.putByte(this.bufPt);
            this.out.write(this.buf, 0, this.bufPt);
            this.byteCount += this.bufPt;
            this.bufPt = 0;
        }
    }

    private class AdaptiveColorCollection {
        protected int index;
        private int r;
        private int g;
        private int b;
        private int count;

        AdaptiveColorCollection(int n, int n2) {
            this.index = n2;
            if (n >= 0) {
                GifEncoder.this.transparentIndex = n2;
            }
        }

        void addRgb(int n, int n2) {
            this.count += n2;
            this.b += (n & 0xFF) * n2;
            this.g += (n >> 8 & 0xFF) * n2;
            this.r += (n >> 16 & 0xFF) * n2;
        }

        void setRgb() {
            GifEncoder.this.red[this.index] = this.r / this.count & 0xFF;
            GifEncoder.this.green[this.index] = this.g / this.count & 0xFF;
            GifEncoder.this.blue[this.index] = this.b / this.count & 0xFF;
        }
    }

    protected class ColorVector
    extends Lst<ColorItem> {
        protected ColorVector() {
        }

        void sort() {
            CountComparator countComparator = new CountComparator();
            Collections.sort(this, countComparator);
        }

        protected class CountComparator
        implements Comparator<ColorItem> {
            protected CountComparator() {
            }

            @Override
            public int compare(ColorItem colorItem, ColorItem colorItem2) {
                return colorItem == null ? 1 : (colorItem2 == null ? -1 : (colorItem.count < colorItem2.count ? -1 : (colorItem.count > colorItem2.count ? 1 : 0)));
            }
        }
    }

    private class ColorItem {
        AdaptiveColorCollection acc;
        int rgb;
        int count;

        ColorItem(int n, int n2) {
            this.rgb = n;
            this.count = n2;
        }
    }
}

