/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.HB;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.modelset.Atom;
import org.jmol.script.T;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ContactPair;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TempArray;

public class Contact
extends Isosurface {
    protected Atom[] atoms;
    private int ac;
    private float minData;
    private float maxData;
    private static final RadiusData rdVDW = new RadiusData(null, 1.0f, RadiusData.EnumType.FACTOR, VDW.AUTO);
    private V3 vZ = new V3();
    private V3 vY = new V3();
    private V3 vX = new V3();
    private P3 pt1 = new P3();
    private P3 pt2 = new P3();

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "contact";
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("set" == string) {
            this.setContacts((Object[])object, !this.vwr.getTestFlag(4));
            return;
        }
        if ("init" == string) {
            this.translucentLevel = 0.0f;
        }
        this.setPropI(string, object, bS);
    }

    private void setContacts(Object[] objectArray, boolean bl) {
        ColorEncoder colorEncoder;
        Object object;
        float f;
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        boolean bl2 = (Boolean)objectArray[2];
        boolean bl3 = (Boolean)objectArray[3];
        BS bS = (BS)objectArray[4];
        BS bS2 = (BS)objectArray[5];
        RadiusData radiusData = (RadiusData)objectArray[6];
        float f2 = ((Float)objectArray[7]).floatValue();
        float[] fArray = (float[])objectArray[8];
        String string = (String)objectArray[9];
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (radiusData == null) {
            radiusData = new RadiusData(null, f2, RadiusData.EnumType.OFFSET, VDW.AUTO);
        }
        if (bl2) {
            switch (n2) {
                case 135266319: 
                case 1073741961: 
                case 1276117512: {
                    n2 = 1276117512;
                    break;
                }
                case 4106: 
                case 3145756: 
                case 0x400000D4: 
                case 1073742135: {
                    break;
                }
                case 1074790451: {
                    bl2 = false;
                }
            }
        }
        this.ac = this.vwr.getAtomCount();
        this.atoms = this.vwr.ms.at;
        int n3 = (int)(fArray == null || fArray.length < 2 ? 0.0f : fArray[1]);
        float f3 = f = bl2 && fArray != null && fArray[0] < 0.0f ? Math.abs(fArray[0]) : 0.15f;
        if (Logger.debugging) {
            Logger.debug((String)("Contact intramolecularMode " + n3));
            Logger.debug((String)("Contacts for " + bS.cardinality() + ": " + Escape.eBS((BS)bS)));
            Logger.debug((String)("Contacts to " + bS2.cardinality() + ": " + Escape.eBS((BS)bS2)));
        }
        this.setPropI("newObject", null, null);
        this.thisMesh.setMerged(true);
        this.thisMesh.nSets = 0;
        this.thisMesh.info = null;
        Parameters parameters = this.sg.getParams();
        String string2 = null;
        switch (n2) {
            case 1073741961: {
                string2 = "(a>b?a:b)";
                break;
            }
            case 135266319: 
            case 1074790451: {
                string2 = "a-b";
                break;
            }
            case 4106: {
                string2 = "a+b";
            }
        }
        switch (n2) {
            case 0x400000D4: {
                bl3 = false;
                BS bS3 = BSUtil.copy((BS)bS);
                bS3.or(bS2);
                if (fArray[0] < 0.0f) {
                    fArray[0] = 0.0f;
                }
                parameters.colorDensity = bl2;
                parameters.bsSelected = bS3;
                parameters.bsSolvent = bS2;
                this.sg.setParameter("parameters", fArray);
                this.setPropI("nci", Boolean.TRUE, null);
                break;
            }
            case 3145756: 
            case 1073742135: {
                bl3 = false;
                this.thisMesh.nSets = 1;
                this.newSurface(3145756, null, bS, bS2, radiusData, null, null, bl2, null, f2);
                break;
            }
            case 1074790451: {
                bl3 = false;
                this.thisMesh.nSets = 1;
                this.newSurface(554176565, null, bS, bS2, radiusData, null, null, false, null, 0.0f);
                VolumeData volumeData = this.sg.getVolumeData();
                this.sg.initState();
                this.newSurface(135266319, null, bS, bS2, radiusData, fArray, string2, bl2, volumeData, 0.0f);
                this.mergeMesh(null);
                break;
            }
            case 1073741961: 
            case 1276117512: {
                bl3 = false;
                this.newSurface(1276117512, null, bS, bS2, radiusData, null, null, bl2, null, 0.0f);
                if (n2 == 1073741961) {
                    this.sg.initState();
                    this.newSurface(1276117512, null, bS2, bS, radiusData, fArray, string2, bl2, null, 0.0f);
                    this.mergeMesh(null);
                    break;
                }
                object = new MeshData();
                this.fillMeshData((MeshData)((Object)object), 1, null);
                object.getSurfaceSet();
                this.fillMeshData((MeshData)((Object)object), 3, null);
                break;
            }
            case 4106: 
            case 135266319: {
                float f4 = 0.0f;
                this.thisMesh.info = colorEncoder = this.getPairs(bS, bS2, radiusData, n3, bl);
                this.thisMesh.calculatedVolume = Float.valueOf(f4 += this.combineSurfaces((Lst<ContactPair>)colorEncoder, n, n2, fArray, string2, bl2, bl3));
                this.mergeMesh(null);
            }
        }
        this.thisMesh.setMerged(false);
        this.thisMesh.jvxlData.vertexDataOnly = true;
        this.thisMesh.reinitializeLightingAndColor(this.vwr);
        if (n != 0x400000D4) {
            this.thisMesh.bsVdw = new BS();
            this.thisMesh.bsVdw.or(bS);
            this.thisMesh.bsVdw.or(bS2);
        }
        this.setPropI("finalize", string, null);
        if (bl2) {
            this.setPropI("pointSize", Float.valueOf(f), null);
        } else {
            this.setPropI("token", 1073741964, null);
        }
        if (this.thisMesh.slabOptions != null) {
            this.thisMesh.slabOptions = null;
            this.thisMesh.polygonCount0 = -1;
        }
        this.discardTempData(true);
        object = null;
        switch (n) {
            case 1612189718: {
                object = "lightgreen";
                break;
            }
            case 1073741881: {
                object = "yellow";
                break;
            }
            case 3145756: {
                object = "skyblue";
            }
        }
        colorEncoder = null;
        if (bl3) {
            colorEncoder = this.vwr.cm.getColorEncoder("rwb");
            colorEncoder.setRange(-0.5f, 0.5f, false);
        } else if (object != null) {
            this.setPropI("color", CU.getArgbFromString((String)object), null);
        } else if (n2 == 0x400000D4) {
            colorEncoder = this.vwr.cm.getColorEncoder("bgr");
            colorEncoder.setRange(-0.03f, 0.03f, false);
        } else {
            colorEncoder = this.vwr.cm.getColorEncoder("rgb");
            if (bl2) {
                colorEncoder.setRange(-0.3f, 0.3f, false);
            } else {
                colorEncoder.setRange(-0.5f, 1.0f, false);
            }
        }
        if (colorEncoder != null) {
            this.thisMesh.remapColors(this.vwr, colorEncoder, this.translucentLevel);
        }
    }

    private float combineSurfaces(Lst<ContactPair> lst, int n, int n2, float[] fArray, Object object, boolean bl, boolean bl2) {
        VolumeData volumeData = new VolumeData();
        int n3 = Logger.getLogLevel();
        Logger.setLogLevel((int)0);
        float f = this.sg.getParams().resolution;
        int n4 = lst.size();
        double d = 0.0;
        if (n2 == 1073741961 && f == Float.MAX_VALUE) {
            f = n4 > 1000 ? 3 : 10;
        }
        int n5 = n4;
        while (--n5 >= 0) {
            boolean bl3;
            ContactPair contactPair = (ContactPair)lst.get(n5);
            float f2 = contactPair.score;
            boolean bl4 = bl3 = n2 == 135266319 && (n == 1649412120 || n == 0) && contactPair.setForVdwClash(true);
            if (bl3) {
                contactPair.score = 0.0f;
            }
            if (n != 0 && contactPair.contactType != n) continue;
            int n6 = this.thisMesh.vc;
            ++this.thisMesh.nSets;
            if (n != 0 || contactPair.contactType != 1649412120) {
                d += contactPair.volume;
            }
            this.setVolumeData(n2, volumeData, contactPair, f, n4);
            switch (n2) {
                case 1073741961: {
                    this.newSurface(n2, contactPair, null, null, null, null, object, bl, volumeData, 0.0f);
                    contactPair.switchAtoms();
                    this.newSurface(n2, contactPair, null, null, null, null, null, bl, volumeData, 0.0f);
                    break;
                }
                case 4106: 
                case 135266319: 
                case 1276117512: {
                    this.newSurface(n2, contactPair, null, null, null, fArray, object, bl, volumeData, 0.0f);
                    if (!bl3 || !contactPair.setForVdwClash(false)) break;
                    if (bl2) {
                        n6 = this.setColorByScore(contactPair.score, n6);
                    }
                    contactPair.score = f2;
                    d += contactPair.volume;
                    this.newSurface(n2, contactPair, null, null, null, fArray, object, bl, volumeData, 0.0f);
                }
            }
            if (n5 > 0 && n5 % 1000 == 0 && n3 == 4) {
                Logger.setLogLevel((int)4);
                Logger.info((String)("contact..." + n5));
                Logger.setLogLevel((int)0);
            }
            if (!bl2) continue;
            this.setColorByScore(contactPair.contactType == 1612189718 ? 4.0f : contactPair.score, n6);
        }
        Logger.setLogLevel((int)n3);
        return (float)d;
    }

    private int setColorByScore(float f, int n) {
        int n2 = this.thisMesh.vc;
        while (--n2 >= n) {
            this.thisMesh.vvs[n2] = f;
        }
        return this.thisMesh.vc;
    }

    private Lst<ContactPair> getPairs(BS bS, BS bS2, RadiusData radiusData, int n, boolean bl) {
        int n2;
        Atom atom;
        Lst lst = new Lst();
        AtomData atomData = new AtomData();
        atomData.radiusData = radiusData;
        BS bS3 = BSUtil.copy((BS)bS);
        bS3.or(bS2);
        if (bS3.isEmpty()) {
            return lst;
        }
        atomData.bsSelected = bS3;
        boolean bl2 = this.atoms[bS3.nextSetBit((int)0)].mi != this.atoms[bS3.length() - 1].mi;
        boolean bl3 = bS.equals((Object)bS2);
        this.vwr.fillAtomData(atomData, 2 | (bl2 ? 16 : 0) | 4);
        float f = 0.0f;
        int n3 = bS2.nextSetBit(0);
        while (n3 >= 0) {
            if (atomData.atomRadius[n3] > f) {
                f = atomData.atomRadius[n3];
            }
            n3 = bS2.nextSetBit(n3 + 1);
        }
        AtomIndexIterator atomIndexIterator = this.vwr.getSelectedAtomIterator(bS2, bl3, false, bl2);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            atom = this.atoms[n4];
            float f2 = atom.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
            if (bl2) {
                this.vwr.setIteratorForPoint(atomIndexIterator, -1, (T3)atomData.atomXyz[n4], atomData.atomRadius[n4] + f);
            } else {
                this.vwr.setIteratorForAtom(atomIndexIterator, n4, atomData.atomRadius[n4] + f);
            }
            block10: while (atomIndexIterator.hasNext()) {
                float f3;
                HB hB;
                boolean bl4;
                int n5 = atomIndexIterator.next();
                if (bl2 && !bS2.get(n5)) continue;
                Atom atom2 = this.atoms[n5];
                boolean bl5 = bl4 = atomData.atomMolecule[n4] == atomData.atomMolecule[n5];
                if (n4 == n5 || bl4 && atom.isWithinFourBonds(atom2)) continue;
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (bl4 == (n == 1)) break;
                        continue block10;
                    }
                }
                float f4 = atom2.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
                float f5 = atomData.atomRadius[n4];
                float f6 = atomData.atomRadius[n5];
                float f7 = atom.distance((T3)atom2);
                if (f7 > f5 + f6) continue;
                ContactPair contactPair = new ContactPair(this.atoms, n4, n5, f5, f6, f2, f4);
                if (contactPair.score < 0.0f) {
                    Contact.getVdwClashRadius(contactPair, f5 - f2, f2, f4, f7);
                }
                HB hB2 = (hB = HB.getType((Atom)atom)) == HB.NOT ? HB.NOT : HB.getType((Atom)atom2);
                boolean bl6 = HB.isPossibleHBond((HB)hB, (HB)hB2);
                float f8 = f3 = atom.getElementNumber() == 1 || atom2.getElementNumber() == 1 ? -1.2f : -1.0f;
                if (bl6 && contactPair.score < f3) {
                    bl6 = false;
                }
                if (bl6 && contactPair.score < 0.0f) {
                    contactPair.contactType = 1612189718;
                }
                lst.addLast((Object)contactPair);
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        atomIndexIterator = null;
        if (!bl) {
            return lst;
        }
        n4 = lst.size() - 1;
        atom = new BS();
        for (n2 = 0; n2 < n4; ++n2) {
            ContactPair contactPair = (ContactPair)lst.get(n2);
            for (int i = n2 + 1; i <= n4; ++i) {
                ContactPair contactPair2 = (ContactPair)lst.get(i);
                for (int j = 0; j < 2; ++j) {
                    block14: for (int k = 0; k < 2; ++k) {
                        switch (Contact.checkCp(contactPair, contactPair2, j, k)) {
                            case 1: {
                                atom.set(n2);
                                continue block14;
                            }
                            case 2: {
                                atom.set(i);
                                continue block14;
                            }
                        }
                    }
                }
            }
        }
        n2 = atom.length();
        while (--n2 >= 0) {
            if (!atom.get(n2)) continue;
            lst.remove(n2);
        }
        if (Logger.debugging) {
            for (n2 = 0; n2 < lst.size(); ++n2) {
                Logger.debug((String)((ContactPair)lst.get(n2)).toString());
            }
        }
        Logger.info((String)("Contact pairs: " + lst.size()));
        return lst;
    }

    private static int checkCp(ContactPair contactPair, ContactPair contactPair2, int n, int n2) {
        boolean bl;
        if (contactPair.myAtoms[n] != contactPair2.myAtoms[n2]) {
            return 0;
        }
        boolean bl2 = contactPair.pt.distance((T3)contactPair2.myAtoms[1 - n2]) < contactPair2.radii[1 - n2];
        boolean bl3 = bl = contactPair2.pt.distance((T3)contactPair.myAtoms[1 - n]) < contactPair.radii[1 - n];
        return !bl2 && !bl ? 0 : (contactPair.score > contactPair2.score ? 1 : 2);
    }

    private void newSurface(int n, ContactPair contactPair, BS bS, BS bS2, RadiusData radiusData, float[] fArray, Object object, boolean bl, VolumeData volumeData, float f) {
        Parameters parameters = this.sg.getParams();
        parameters.isSilent = true;
        if (contactPair == null) {
            bS2.andNot(bS);
            if (bS.isEmpty() || bS2.isEmpty()) {
                return;
            }
        } else {
            parameters.contactPair = contactPair;
        }
        int n2 = 0;
        int n3 = 0;
        this.sg.initState();
        switch (n) {
            case 3145756: 
            case 554176565: 
            case 1073741961: 
            case 1073742135: 
            case 1276117512: {
                RadiusData radiusData2;
                RadiusData radiusData3;
                if (n == 3145756) {
                    radiusData3 = rdVDW;
                    radiusData2 = new RadiusData(null, radiusData.factorType == RadiusData.EnumType.OFFSET ? radiusData.value * 2.0f : (radiusData.value - 1.0f) * 2.0f + 1.0f, radiusData.factorType, radiusData.vdwType);
                } else {
                    radiusData3 = radiusData2 = radiusData;
                }
                parameters.colorDensity = bl;
                if (bl) {
                    this.setPropI("cutoffRange", new float[]{-100.0f, 0.0f}, null);
                }
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData3;
                    parameters.bsIgnore = BSUtil.copyInvert((BS)bS, (int)this.ac);
                    parameters.bsSelected = bS;
                    parameters.bsSolvent = null;
                }
                parameters.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(f), null);
                this.setPropI("map", Boolean.TRUE, null);
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData2;
                    parameters.bsIgnore = BSUtil.copyInvert((BS)bS2, (int)this.ac);
                    parameters.bsSelected = bS2;
                }
                parameters.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(f), null);
                switch (n) {
                    case 1073741961: 
                    case 1276117512: {
                        n2 = -100;
                        break;
                    }
                    case 3145756: 
                    case 1073742135: {
                        if (!bl) break;
                        n2 = -100;
                        break;
                    }
                    case 554176565: {
                        n3 = -100;
                    }
                }
                break;
            }
            case 4106: 
            case 135266319: {
                if (n == 4106) {
                    this.sg.setParameter("parameters", fArray);
                }
                if (contactPair == null) {
                    parameters.atomRadiusData = radiusData;
                    parameters.bsIgnore = BSUtil.copyInvert((BS)bS2, (int)this.ac);
                    parameters.bsIgnore.andNot(bS);
                }
                parameters.func = object;
                parameters.intersection = new BS[]{bS, bS2};
                parameters.volumeData = volumeData;
                parameters.colorDensity = bl;
                if (bl) {
                    this.setPropI("cutoffRange", new float[]{-5.0f, 0.0f}, null);
                }
                this.setPropI("sasurface", Float.valueOf(0.0f), null);
                this.setPropI("map", Boolean.TRUE, null);
                parameters.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(0.0f), null);
                if (n == 4106) break;
                n2 = -100;
            }
        }
        if (n2 != n3) {
            this.thisMesh.slabPolygons(TempArray.getSlabWithinRange((float)n2, (float)n3), false);
        }
        if (n != 3145756) {
            this.thisMesh.setMerged(true);
        }
    }

    private void setVolumeData(int n, VolumeData volumeData, ContactPair contactPair, float f, int n2) {
        int n3;
        int n4;
        this.pt1.setT((T3)contactPair.myAtoms[0]);
        this.pt2.setT((T3)contactPair.myAtoms[1]);
        this.vX.sub2((T3)this.pt2, (T3)this.pt1);
        float f2 = this.vX.length();
        float f3 = (contactPair.radii[0] * contactPair.radii[0] + f2 * f2 - contactPair.radii[1] * contactPair.radii[1]) / (2.0f * f2 * contactPair.radii[0]);
        f3 = 2.1f * (float)((double)contactPair.radii[0] * Math.sin(Math.acos(f3)));
        Measure.getNormalToLine((P3)this.pt1, (P3)this.pt2, (V3)this.vZ);
        this.vZ.scale(f3);
        this.vY.cross((T3)this.vZ, (T3)this.vX);
        this.vY.normalize();
        this.vY.scale(f3);
        if (n != 4106) {
            this.vX.normalize();
            this.pt1.scaleAdd2((f2 - contactPair.radii[1]) * 0.95f, (T3)this.vX, (T3)this.pt1);
            this.pt2.scaleAdd2((contactPair.radii[0] - f2) * 0.95f, (T3)this.vX, (T3)this.pt2);
            this.vX.sub2((T3)this.pt2, (T3)this.pt1);
        }
        if (f == Float.MAX_VALUE) {
            f = n2 > 100 ? 3 : 10;
        }
        if ((n4 = Math.max(5, (int)Math.floor(this.pt1.distance((T3)this.pt2) * f + 1.0f))) % 2 == 0) {
            ++n4;
        }
        if ((n3 = Math.max(7, (int)Math.floor(f3 * f + 1.0f))) % 2 == 0) {
            ++n3;
        }
        volumeData.setVoxelCounts(n4, n3, n3);
        this.pt1.scaleAdd2(-0.5f, (T3)this.vY, (T3)this.pt1);
        this.pt1.scaleAdd2(-0.5f, (T3)this.vZ, (T3)this.pt1);
        volumeData.setVolumetricOrigin(this.pt1.x, this.pt1.y, this.pt1.z);
        this.vX.scale(1.0f / (float)(n4 - 1));
        this.vY.scale(1.0f / (float)(n3 - 1));
        this.vZ.scale(1.0f / (float)(n3 - 1));
        volumeData.setVolumetricVector(0, this.vX.x, this.vX.y, this.vX.z);
        volumeData.setVolumetricVector(1, this.vY.x, this.vY.y, this.vY.z);
        volumeData.setVolumetricVector(2, this.vZ.x, this.vZ.y, this.vZ.z);
    }

    private void mergeMesh(MeshData meshData) {
        this.thisMesh.merge(meshData);
        if (this.minData != Float.MAX_VALUE) {
            if (this.jvxlData.mappedDataMin == Float.MAX_VALUE) {
                this.jvxlData.mappedDataMin = this.minData;
                this.jvxlData.mappedDataMax = this.maxData;
            } else {
                this.jvxlData.mappedDataMin = Math.min(this.minData, this.jvxlData.mappedDataMin);
                this.jvxlData.mappedDataMax = Math.max(this.maxData, this.jvxlData.mappedDataMax);
            }
        }
        this.minData = this.jvxlData.mappedDataMin;
        this.maxData = this.jvxlData.mappedDataMax;
        this.jvxlData.valueMappedToBlue = this.minData;
        this.jvxlData.valueMappedToRed = this.maxData;
    }

    @Override
    protected void addMeshInfo(IsosurfaceMesh isosurfaceMesh, Map<String, Object> map) {
        if (isosurfaceMesh.info == null) {
            return;
        }
        Lst lst = new Lst();
        map.put("pairInfo", lst);
        Lst lst2 = (Lst)isosurfaceMesh.info;
        for (int i = 0; i < lst2.size(); ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            lst.addLast(hashtable);
            ContactPair contactPair = (ContactPair)lst2.get(i);
            hashtable.put("type", T.nameOf((int)contactPair.contactType));
            hashtable.put("volume", contactPair.volume);
            hashtable.put("vdwVolume", contactPair.vdwVolume);
            if (!Float.isNaN(contactPair.xVdwClash)) {
                hashtable.put("xVdwClash", Double.valueOf(contactPair.xVdwClash));
            }
            hashtable.put("score", Double.valueOf(contactPair.score));
            hashtable.put("atoms", contactPair.myAtoms);
            hashtable.put("radii", contactPair.radii);
            hashtable.put("vdws", contactPair.vdws);
        }
    }

    private static void getVdwClashRadius(ContactPair contactPair, double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d2 + d3;
        double d7 = d2 - d3;
        d7 *= d7;
        double d8 = d * d * (d6 + 1.3333333333333333 * d - d7 / d6);
        contactPair.vdwVolume = contactPair.volume - d8 * Math.PI;
        double d9 = d6 - d4;
        double d10 = d4 + 2.0 * d6 - 3.0 * d7 / d4;
        double d11 = d8 * 12.0;
        double d12 = d9 * d9;
        double d13 = d9 * d12;
        double d14 = d10 * d10;
        double d15 = d10 * d14;
        double d16 = -d9 * 2.0 / 3.0 - d10 / 6.0;
        double d17 = (4.0 * d12 - 4.0 * d9 * d10 + d14) / 36.0;
        double d18 = d13 / 27.0 - d12 * d10 / 18.0 + d9 * d14 / 36.0 - d15 / 216.0 + d11 / 4.0;
        double d19 = -d11 / 432.0 * (8.0 * d13 - 12.0 * d12 * d10 + 6.0 * d9 * d14 - d15 + 27.0 * d11);
        double d20 = Math.atan2(Math.sqrt(d19), d18);
        double d21 = Math.pow(d18 * d18 + d19, 0.16666666666666666);
        double d22 = d16 + (d17 / d21 + d21) * (d5 = Math.cos(d20 / 3.0));
        if (d22 > 0.0) {
            contactPair.xVdwClash = (float)(d22 / 2.0);
        }
    }
}

