/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.java.BS;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.util.TempArray;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private P3[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private AtomIndexIterator iter;
    private BS bsSurfacePoints;
    private BS bsSurfaceDone;
    private BS[] bsLocale;
    private Map<String, Edge> htEdges;
    protected Lst<Edge> vEdges;
    private Lst<Face> vFaces;
    private final P3 ptS1 = new P3();
    private final P3 ptS2 = new P3();
    private final V3 vTemp3 = new V3();
    protected final V3 vTemp = new V3();
    protected final P4 plane = new P4();
    protected final P3 ptTemp2 = new P3();
    protected final V3 vTemp2 = new V3();
    protected final P3 p = new P3();
    private static boolean testLinear = false;
    private BS[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    int nTest = 0;
    private float rAS;
    private float rBS;
    private float rAS2;
    private float rBS2;
    private float dAB;
    private float dAB2;
    private float ecosASB2;

    IsoSolventReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        this.initializeVolumetricData();
        this.volumeData.setUnitVectors();
        this.vl0 = this.volumeData.volumetricVectorLengths[0];
        this.vl1 = this.volumeData.volumetricVectorLengths[1];
        this.vl2 = this.volumeData.volumetricVectorLengths[2];
        if (this.isProgressive) {
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BS[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    @Override
    protected void setup(boolean bl) {
        this.setup2();
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.sr = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !bl && this.atomDataServer != null && !this.isCavity && this.sr > 0.0f && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !bl) {
                float f = 0.0f;
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, f);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0f;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!bl) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (bl) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
        }
    }

    @Override
    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        if (this.isCavity && this.dataType != 1205 && this.dataType != 1206) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, Float.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        Lst<Object[]> lst = this.params.slabInfo;
        if (lst != null) {
            for (int i = 0; i < lst.size(); ++i) {
                if (!((Boolean)((Object[])lst.get(i))[2]).booleanValue() || !(((Object[])lst.get(i))[0] instanceof P4)) continue;
                this.volumeData.capData((P4)((Object[])lst.get(i))[0], this.params.cutoff);
                lst.remove(i--);
            }
        }
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        int n6 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        int n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        boolean bl2 = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(n6) || this.bsSurfaceVoxels.get(n7));
        if (testLinear || this.voxelSource == null || this.voxelSource[n6] == 0 || this.voxelSource[n6] != this.voxelSource[n7]) {
            return this.getSPF(f, bl, f2, f3, t3, v3, n, n2, n3, n6, n7, fArray, t32);
        }
        int n8 = Math.abs(f2 < f3 ? this.voxelSource[n6] : this.voxelSource[n7]);
        this.iAtomSurface = this.atomIndex[n8 - 1];
        float f4 = fArray[0] = MeshSurface.getSphericalInterpolationFraction((double)(this.voxelSource[n6] < 0 ? this.sr : this.atomRadius[this.voxelSource[n6] - 1]), (double)f2, (double)f3, (double)v3.length());
        t32.scaleAdd2(f4, (T3)v3, t3);
        float f5 = f3 - f2;
        return f2 + f4 * f5;
    }

    @Override
    public int addVertexCopy(T3 t3, float f, int n, boolean bl) {
        int n2 = this.addVC(t3, f, n, bl);
        if (n2 < 0) {
            return n2;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(n2);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[n2] = this.iAtomSurface;
        }
        return n2;
    }

    @Override
    public void selectPocket(boolean bl) {
        int n;
        int n2;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        T3[] t3Array = this.meshData.vs;
        int n3 = this.meshData.vc;
        float[] fArray = this.meshData.vvs;
        int n4 = this.dots.length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                if (!(this.dots[i].distance(t3Array[n2]) < this.envelopeRadius)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        n2 = this.meshData.nSets;
        BS bS = BS.newN((int)n2);
        block2: for (n = 0; n < n2; ++n) {
            BS bS2 = this.meshData.surfaceSet[n];
            if (bS2 == null) continue;
            int n5 = bS2.nextSetBit(0);
            while (n5 >= 0) {
                if (Float.isNaN(this.meshData.vvs[n5])) {
                    bS.set(n);
                    continue block2;
                }
                n5 = bS2.nextSetBit(n5 + 1);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.meshData.surfaceSet[n] == null || bS.get(n) != bl) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (!bl) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    @Override
    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BS bS = new BS();
            BS[] bSArray = this.meshData.getSurfaceSet();
            BS[] bSArray2 = null;
            double[] dArray = (double[])(this.isPocket ? null : this.meshData.calculateVolumeOrArea(Integer.MIN_VALUE, false, false));
            float f = (float)(4.71238898038469 * Math.pow(this.sr, 3.0));
            double d = 0.0;
            boolean bl = false;
            if (dArray != null && !this.isCavity) {
                for (int i = 0; i < this.meshData.nSets; ++i) {
                    double d2 = dArray[i];
                    if (!(Math.abs(d2) > d)) continue;
                    d = Math.abs(d2);
                    bl = d2 < 0.0;
                }
            }
            double d3 = bl ? -1 : 1;
            for (int i = 0; i < this.meshData.nSets; ++i) {
                BS bS2 = bSArray[i];
                if (bS2.intersects(this.bsSurfacePoints) && (dArray == null || dArray[i] * d3 > (double)f) && this.params.vertexSource != null) {
                    BS bS3 = new BS();
                    if (bSArray2 == null) {
                        bSArray2 = new BS[bSArray.length];
                    }
                    int n = bS2.nextSetBit(0);
                    while (n >= 0) {
                        int n2 = this.params.vertexSource[n];
                        if (n2 >= 0) {
                            if (bS.get(n2)) {
                                this.meshData.invalidateSurfaceSet(i);
                                break;
                            }
                            bS3.set(n2);
                        }
                        n = bS2.nextSetBit(n + 1);
                    }
                    bS.or(bS3);
                    continue;
                }
                this.meshData.invalidateSurfaceSet(i);
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(TempArray.getSlabWithinRange((float)-100.0f, (float)0.0f));
        }
    }

    private void generateSolventCavity() {
        int n;
        int n2;
        int n3;
        int n4;
        BS bS = BS.newN((int)(this.nPointsX * this.nPointsY * this.nPointsZ));
        int n5 = 0;
        int n6 = this.dots.length;
        int n7 = 0;
        float f = this.envelopeRadius;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                n2 = 0;
                while (n2 < this.nPointsZ) {
                    block9: {
                        float f2;
                        float f3 = this.voxelData[n4][n3][n2];
                        if (f2 < Float.MAX_VALUE && f3 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(n4, n3, n2, (T3)this.ptV);
                            for (n = 0; n < n6; ++n) {
                                if (!(this.dots[n].distance((T3)this.ptV) < f)) {
                                    continue;
                                }
                                break block9;
                            }
                            bS.set(n5);
                            ++n7;
                        }
                    }
                    ++n2;
                    ++n5;
                }
            }
        }
        Logger.info((String)("cavities include " + n7 + " voxel points"));
        this.atomRadius = new float[n7];
        this.atomXyz = new P3[n7];
        n3 = 0;
        n2 = 0;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n = 0; n < this.nPointsY; ++n) {
                for (int i = 0; i < this.nPointsZ; ++i) {
                    if (!bS.get(n3++)) continue;
                    this.atomXyz[n2] = new P3();
                    this.volumeData.voxelPtToXYZ(n4, n, i, (T3)this.atomXyz[n2]);
                    this.atomRadius[n2++] = this.voxelData[n4][n][i];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n7;
        this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
        this.rs = null;
        this.setRadii();
    }

    private void generateSolventCube() {
        if (this.dataType == 1205) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BS();
        this.bsSurfaceVoxels = new BS();
        this.bsSurfacePoints = new BS();
        if (this.doCalculateTroughs) {
            this.iter = this.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new Lst();
            this.bsLocale = new BS[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info((String)(this.vEdges.size() + " edges"));
            this.vFaces = new Lst();
            this.getFaces();
            Logger.info((String)(this.vFaces.size() + " faces"));
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.validSpheres.or(this.noFaceSpheres);
            this.vEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
        }
        this.markSphereVoxels(0.0f, this.doCalculateTroughs ? Float.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        int n;
        for (n = 0; n < this.myAtomCount; ++n) {
            this.bsLocale[n] = new BS();
        }
        for (n = 0; n < this.myAtomCount; ++n) {
            P3 p3 = this.atomXyz[n];
            float f = this.rs[n];
            this.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[n], f + this.maxRS);
            while (this.iter.hasNext()) {
                int n2 = this.iter.next();
                int n3 = this.myIndex[n2];
                if (n >= this.firstNearbyAtom && n3 >= this.firstNearbyAtom) continue;
                P3 p32 = this.atomXyz[n3];
                float f2 = this.rs[n3];
                float f3 = p3.distance((T3)p32);
                if (f3 >= f + f2) continue;
                Edge edge = new Edge(this, n, n3, f3);
                this.vEdges.addLast((Object)edge);
                this.bsLocale[n].set(n3);
                this.bsLocale[n3].set(n);
                this.htEdges.put(edge.toString(), edge);
            }
        }
    }

    protected Edge findEdge(int n, int n2) {
        return this.htEdges.get(n < n2 ? n + "_" + n2 : n2 + "_" + n);
    }

    private void getFaces() {
        BS bS = new BS();
        this.validSpheres = new BS();
        this.noFaceSpheres = BSUtil.setAll((int)this.myAtomCount);
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)((Object)this.vEdges.get(n));
            int n2 = edge.ia;
            int n3 = edge.ib;
            bS.clearAll();
            bS.or(this.bsLocale[n2]);
            bS.and(this.bsLocale[n3]);
            int n4 = bS.nextSetBit(n3 + 1);
            while (n4 >= 0) {
                if (this.getSolventPoints(edge, n2, n3, n4)) {
                    boolean bl = false;
                    Face face = this.validateFace(n2, n3, n4, edge, this.ptS1);
                    if (face != null) {
                        this.vFaces.addLast((Object)face);
                        bl = true;
                    }
                    if ((face = this.validateFace(n2, n3, n4, edge, this.ptS2)) != null) {
                        this.vFaces.addLast((Object)face);
                        bl = true;
                    }
                    if (bl) {
                        this.noFaceSpheres.clear(n2);
                        this.noFaceSpheres.clear(n3);
                        this.noFaceSpheres.clear(n4);
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
    }

    private Face validateFace(int n, int n2, int n3, Edge edge, P3 p3) {
        this.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, (T3)p3, this.maxRS);
        boolean bl = true;
        while (this.iter.hasNext()) {
            float f;
            int n4 = this.iter.next();
            int n5 = this.myIndex[n4];
            if (n5 == n || n5 == n2 || n5 == n3 || !((f = this.atomData.atomXyz[n4].distance((T3)p3)) < this.atomData.atomRadius[n4] + this.sr)) continue;
            bl = false;
            break;
        }
        Edge edge2 = this.findEdge(n2, n3);
        Edge edge3 = this.findEdge(n, n3);
        Face face = bl ? new Face(n, n2, n3, p3) : null;
        edge.addFace(face);
        edge2.addFace(face);
        edge3.addFace(face);
        if (!bl) {
            return null;
        }
        this.validSpheres.set(n);
        this.validSpheres.set(n2);
        this.validSpheres.set(n3);
        return face;
    }

    private void markFaceVoxels(boolean bl) {
        BS bS = new BS();
        V3 v3 = this.volumetricVectors[0];
        V3 v32 = this.volumetricVectors[1];
        V3 v33 = this.volumetricVectors[2];
        int n = this.vFaces.size();
        while (--n >= 0) {
            Face face = (Face)this.vFaces.get(n);
            P3 p3 = this.atomXyz[face.ia];
            P3 p32 = this.atomXyz[face.ib];
            P3 p33 = this.atomXyz[face.ic];
            P3 p34 = face.pS;
            this.setGridLimitsForAtom(p34, this.sr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, (T3)this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float f = this.sr - this.ptV.distance((T3)p34);
                        float f2 = this.voxelData[i][j][k];
                        int n2 = this.volumeData.getPointIndex(i, j, k);
                        if (bl && f > 0.0f) {
                            this.bsSurfaceDone.set(n2);
                        }
                        if (Measure.isInTetrahedron((P3)this.ptV, (P3)p3, (P3)p32, (P3)p33, (P3)p34, (P4)this.plane, (V3)this.vTemp, (V3)this.vTemp2, (V3)this.vTemp3, (boolean)false) && (!bl ? !this.bsSurfaceDone.get(n2) && f < 0.0f && f > -this.volumeData.maxGrid * 1.8f && f > f2 == bS.get(n2) : f > 0.0f && (f2 < 0.0f || f2 == Float.MAX_VALUE || f > f2 == bS.get(n2)))) {
                            bS.set(n2);
                            this.setVoxel(i, j, k, n2, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n2] = -1 - face.ia;
                            }
                            if (f > 0.0f) {
                                this.bsSurfaceVoxels.set(n2);
                            }
                        }
                        this.ptV.add((T3)v33);
                    }
                    this.ptV.add2((T3)v32, (T3)this.ptZ0);
                }
                this.ptV.add2((T3)v3, (T3)this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        V3 v3 = this.volumetricVectors[0];
        V3 v32 = this.volumetricVectors[1];
        V3 v33 = this.volumetricVectors[2];
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)((Object)this.vEdges.get(n));
            if (!edge.isValid()) continue;
            int n2 = edge.ia;
            int n3 = edge.ib;
            P3 p3 = this.atomXyz[n2];
            P3 p32 = this.atomXyz[n3];
            this.rAS = this.rs[n2];
            this.rBS = this.rs[n3];
            this.rAS2 = this.rs2[n2];
            this.rBS2 = this.rs2[n3];
            this.dAB = edge.d;
            this.dAB2 = edge.d2;
            this.ecosASB2 = edge.cosASB2;
            this.setGridLimitsForAtom(edge, edge.maxr, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, (T3)this.ptV);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptV);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptV);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float f;
                        float f2 = this.checkSpecialVoxel(p3, p32, this.ptV);
                        if (!Float.isNaN(f2) && (f = this.sr - f2) < this.voxelData[i][j][k]) {
                            int n4 = this.volumeData.getPointIndex(i, j, k);
                            this.setVoxel(i, j, k, n4, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n4] = -1 - n2;
                            }
                        }
                        this.ptV.add((T3)v33);
                    }
                    this.ptV.add2((T3)v32, (T3)this.ptZ0);
                }
                this.ptV.add2((T3)v3, (T3)this.ptY0);
            }
        }
    }

    @Override
    protected void unsetVoxelData() {
        if (!this.havePlane) {
            this.unsetVoxelData2();
            return;
        }
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] < 0.001f) continue;
                this.thisPlane[i] = 0.001f;
            }
        } else {
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        if (this.voxelData[i][j][k] < 0.001f) continue;
                        this.voxelData[i][j][k] = 0.001f;
                    }
                }
            }
        }
    }

    private boolean getSolventPoints(Edge edge, int n, int n2, int n3) {
        float f = this.rs[n];
        V3 v3 = edge.v;
        float f2 = (edge.d2 + this.rs2[n] - this.rs2[n2]) / (2.0f * edge.d * f);
        float f3 = (float)Math.acos(f2);
        this.p.scaleAdd2(f2 * f, (T3)v3, (T3)this.atomXyz[n]);
        Measure.getPlaneThroughPoint((T3)this.p, (V3)v3, (P4)this.plane);
        float f4 = (float)(Math.sin(f3) * (double)f);
        P3 p3 = this.atomXyz[n3];
        float f5 = this.rs[n3];
        float f6 = Measure.distanceToPlane((P4)this.plane, (T3)p3);
        if (Math.abs(f6) >= f5 * 0.9f) {
            return false;
        }
        this.ptTemp.scaleAdd2(-f6, (T3)v3, (T3)p3);
        float f7 = this.p.distance((T3)this.ptTemp);
        float f8 = f4 * f4;
        float f9 = this.rs2[n3] - f6 * f6;
        float f10 = (f8 + f7 * f7 - f9) / (2.0f * f4 * f7);
        if ((double)Math.abs(f10) >= 0.99) {
            return false;
        }
        V3 v32 = this.vTemp2;
        v32.sub2((T3)this.ptTemp, (T3)this.p);
        v32.normalize();
        this.ptTemp.scaleAdd2(f4 * f10, (T3)v32, (T3)this.p);
        v32.cross((T3)v3, (T3)v32);
        v32.normalize();
        v32.scale((float)(Math.sqrt(1.0f - f10 * f10) * (double)f4));
        this.ptS1.add2((T3)this.ptTemp, (T3)v32);
        this.ptS2.sub2((T3)this.ptTemp, (T3)v32);
        return true;
    }

    private float checkSpecialVoxel(P3 p3, P3 p32, P3 p33) {
        float f;
        float f2 = p3.distance((T3)p33);
        float f3 = p3.distanceSquared((T3)p33);
        float f4 = this.rAS / f2;
        if (f4 > 1.0f) {
            this.p.set(p3.x + (p33.x - p3.x) * f4, p3.y + (p33.y - p3.y) * f4, p3.z + (p33.z - p3.z) * f4);
            return p32.distanceSquared((T3)this.p) >= this.rBS2 ? Float.NaN : this.solventDistance(this.rAS, this.rAS2, this.rBS2, f2, f3, p32.distanceSquared((T3)p33));
        }
        float f5 = p32.distance((T3)p33);
        f4 = this.rBS / f5;
        if (f > 1.0f) {
            this.p.set(p32.x + (p33.x - p32.x) * f4, p32.y + (p33.y - p32.y) * f4, p32.z + (p33.z - p32.z) * f4);
            return p3.distanceSquared((T3)this.p) >= this.rAS2 ? Float.NaN : this.solventDistance(this.rBS, this.rBS2, this.rAS2, f5, f5 * f5, f3);
        }
        return Float.NaN;
    }

    private float solventDistance(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8 = (float)Math.acos((f5 + this.dAB2 - f6) / (2.0f * f4 * this.dAB));
        float f9 = (float)Math.acos((f2 + this.dAB2 - f3) / (2.0f * f * this.dAB));
        float f10 = (float)((double)(f2 + f5) - (double)(2.0f * f * f4) * Math.cos(f9 - f8));
        return this.ecosASB2 < (f2 + f10 - f4 * f4) / ((f7 = (float)Math.sqrt(f10)) * f) ? f7 : Float.NaN;
    }

    void dumpLine(P3 p3, T3 t3, String string, String string2) {
        this.sg.log("draw ID \"x" + string + this.nTest++ + "\" " + P3.newP((T3)p3) + " " + P3.newP((T3)t3) + " color " + string2);
    }

    void dumpLine2(P3 p3, P3 p32, String string, float f, String string2, String string3) {
        V3 v3 = new V3();
        v3.setT((T3)p32);
        v3.sub((T3)p3);
        v3.normalize();
        v3.scale(f);
        v3.add((T3)p3);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" " + P3.newP((T3)p3) + " " + P3.newP((T3)v3) + " color " + string2);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\"" + P3.newP((T3)v3) + " " + P3.newP((T3)p32) + " color " + string3 + "\"" + string + "\"");
    }

    void dumpPoint(P3 p3, String string, String string2) {
        this.sg.log("draw ID \"" + string + this.nTest++ + "\"" + P3.newP((T3)p3) + " color " + string2);
    }

    @Override
    public float getValueAtPoint(T3 t3, boolean bl) {
        if (this.contactPair != null) {
            return t3.distance((T3)this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.firstNearbyAtom; ++i) {
            float f2;
            if (this.rs == null || this.atomXyz == null || this.atomXyz[i] == null || t3 == null) {
                System.out.println("HOH");
            }
            if (!((f2 = t3.distance((T3)this.atomXyz[i]) - this.rs[i]) < f)) continue;
            f = f2;
        }
        return f == Float.MAX_VALUE ? Float.NaN : f;
    }

    @Override
    void discardTempData(boolean bl) {
        this.rs = null;
        this.rs2 = null;
        this.discardTempDataSR(bl);
    }

    @Override
    public float[] getPlane(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = n;
        this.thisPlane = this.yzPlanes[n % 2];
        if (this.contactPair == null) {
            this.resetPlane(Float.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[n];
            this.markSphereVoxels(0.0f, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels((P3)this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        P3 pS;

        Face(int n, int n2, int n3, P3 p3) {
            this.ia = n;
            this.ib = n2;
            this.ic = n3;
            this.pS = P3.newP((T3)p3);
        }

        public String toString() {
            return this.ia + "_" + this.ib + "_" + this.ic + "_" + this.pS;
        }
    }

    private class Edge
    extends P3 {
        int ia;
        int ib;
        int nFaces;
        int nInvalid;
        float d;
        float d2;
        float maxr;
        float cosASB2;
        V3 v;

        Edge(IsoSolventReader isoSolventReader2, int n, int n2, float f) {
            this.ia = Math.min(n, n2);
            this.ib = Math.max(n, n2);
            this.d = f;
            this.d2 = f * f;
            this.maxr = (float)Math.sqrt(this.d2 / 4.0f + Math.max(isoSolventReader2.rs2[n], isoSolventReader2.rs2[n2]));
            this.ave((T3)isoSolventReader2.atomXyz[n], (T3)isoSolventReader2.atomXyz[n2]);
            this.cosASB2 = (isoSolventReader2.rs2[n] + isoSolventReader2.rs2[n2] - this.d2) / (isoSolventReader2.rs[n2] * isoSolventReader2.rs[n]);
            this.v = V3.newVsub((T3)isoSolventReader2.atomXyz[n2], (T3)isoSolventReader2.atomXyz[n]);
            this.v.normalize();
        }

        void addFace(Face face) {
            ++this.nFaces;
            if (face == null) {
                ++this.nInvalid;
                return;
            }
        }

        boolean isValid() {
            return this.nFaces == 0 || this.nInvalid != this.nFaces;
        }

        public String toString() {
            return this.ia + "_" + this.ib;
        }
    }
}

