/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javajs.api.EventManager;
import javajs.api.GenericMouseInterface;
import javajs.api.PlatformViewer;
import javajs.util.PT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class Mouse
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener,
GenericMouseInterface {
    private Viewer vwr;
    private EventManager manager;
    private String keyBuffer = "";
    private boolean isMouseDown;
    private boolean wheeling;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    Mouse(double d, PlatformViewer platformViewer, Object object) {
        this.vwr = (Viewer)platformViewer;
        this.manager = this.vwr.acm;
        Component component = (Component)object;
        component.addKeyListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    @Override
    public void clear() {
    }

    @Override
    public void dispose() {
        Component component = (Component)this.vwr.display;
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeMouseWheelListener(this);
        component.removeKeyListener(this);
    }

    @Override
    public boolean processEvent(int n, int n2, int n3, int n4, long l) {
        n4 = Mouse.applyLeftMouse(n4);
        switch (n) {
            case 501: {
                this.xWhenPressed = n2;
                this.yWhenPressed = n3;
                this.modifiersWhenPressed10 = n4;
                this.mousePressed(l, n2, n3, n4, false);
                break;
            }
            case 506: {
                this.mouseDragged(l, n2, n3, n4);
                break;
            }
            case 504: {
                this.mouseEntered(l, n2, n3);
                break;
            }
            case 505: {
                this.mouseExited(l, n2, n3);
                break;
            }
            case 503: {
                this.mouseMoved(l, n2, n3, n4);
                break;
            }
            case 502: {
                this.mouseReleased(l, n2, n3, n4);
                if (n2 != this.xWhenPressed || n3 != this.yWhenPressed || n4 != this.modifiersWhenPressed10) break;
                this.mouseClicked(l, n2, n3, n4, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExited(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x1C) == 0) {
            n |= 0x10;
        }
        this.mouseDragged(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), n);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        this.mouseWheel(mouseWheelEvent.getWhen(), mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getModifiers());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
        if (!this.vwr.menuEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (Logger.debuggingHigh) {
            Logger.debug("MouseManager keyTyped: " + c + " " + ('\u0000' + c) + " " + n);
        }
        if (n != 0 && n != 1) {
            switch (c) {
                case '\u000b': 
                case 'k': {
                    boolean bl = !this.vwr.getBooleanProperty("allowKeyStrokes");
                    switch (n) {
                        case 2: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", bl);
                            this.vwr.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 8: 
                        case 10: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", bl);
                            this.vwr.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.vwr.refresh(3, "showkey");
                    break;
                }
                case '\u0016': 
                case 'v': {
                    switch (n) {
                        case 2: {
                            String string = this.vwr.getClipboardText();
                            if (string == null) break;
                            if (string.startsWith("http://") && string.indexOf("\n") < 0) {
                                string = "LoAd " + PT.esc(string);
                            }
                            if (string.startsWith("LoAd ")) {
                                this.vwr.evalStringQuietSync(string, false, true);
                                break;
                            }
                            if ((string = this.vwr.loadInlineAppend(string, false)) != null) {
                                Logger.error(string);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case '\u001a': 
                case 'z': {
                    switch (n) {
                        case 2: {
                            this.vwr.undoMoveAction(4165, 1);
                            break;
                        }
                        case 3: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                    break;
                }
                case '\u0019': 
                case 'y': {
                    switch (n) {
                        case 2: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                }
            }
            return;
        }
        if (!this.vwr.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(keyEvent.getModifiers() == 1 ? Character.toUpperCase(c) : c);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.vwr.isApplet) {
            keyEvent.consume();
        }
        this.manager.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
        this.manager.keyReleased(keyEvent.getKeyCode());
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo \"\"", true, true);
        }
    }

    private void addKeyBuffer(char c) {
        if (c == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (c == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + c;
        }
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc("\u0001" + this.keyBuffer), true, true);
        }
    }

    private void sendKeyBuffer() {
        String string = this.keyBuffer;
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc(this.keyBuffer), true, true);
        }
        this.clearKeyBuffer();
        this.vwr.evalStringQuietSync(string, false, true);
    }

    private void mouseEntered(long l, int n, int n2) {
        this.wheeling = false;
        this.manager.mouseEnterExit(l, n, n2, false);
    }

    private void mouseExited(long l, int n, int n2) {
        this.wheeling = false;
        this.manager.mouseEnterExit(l, n, n2, true);
    }

    private void mouseClicked(long l, int n, int n2, int n3, int n4) {
        this.clearKeyBuffer();
        this.manager.mouseAction(2, l, n, n2, 1, n3);
    }

    private void mouseMoved(long l, int n, int n2, int n3) {
        this.clearKeyBuffer();
        if (this.isMouseDown) {
            this.manager.mouseAction(1, l, n, n2, 0, Mouse.applyLeftMouse(n3));
        } else {
            this.manager.mouseAction(0, l, n, n2, 0, n3);
        }
    }

    private void mouseWheel(long l, int n, int n2) {
        this.clearKeyBuffer();
        this.wheeling = true;
        this.manager.mouseAction(3, l, 0, n, 0, n2 & 0xFFFFFFF7 | 0x20);
    }

    private void mousePressed(long l, int n, int n2, int n3, boolean bl) {
        this.clearKeyBuffer();
        this.isMouseDown = true;
        this.wheeling = false;
        this.manager.mouseAction(4, l, n, n2, 0, n3);
    }

    private void mouseReleased(long l, int n, int n2, int n3) {
        this.isMouseDown = false;
        this.wheeling = false;
        this.manager.mouseAction(5, l, n, n2, 0, n3);
    }

    private void mouseDragged(long l, int n, int n2, int n3) {
        if (this.wheeling) {
            return;
        }
        if ((n3 & 0x14) == 20) {
            n3 = n3 & 0xFFFFFFFB | 2;
        }
        this.manager.mouseAction(1, l, n, n2, 0, n3);
    }

    private static int applyLeftMouse(int n) {
        return (n & 0x1C) == 0 ? n | 0x10 : n;
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
    }
}

