/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.STR;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class PdbReader
extends AtomSetCollectionReader {
    private static final int MODE_PDB = 0;
    private static final int MODE_HEX = 1;
    private static final int MODE_HYBRID36 = 2;
    private int serMode = 0;
    private int seqMode = 0;
    private int serial;
    private int lineLength;
    private SB pdbHeader;
    private boolean applySymmetry;
    private boolean getTlsGroups;
    private boolean isMultiModel;
    private boolean haveMappedSerials;
    private boolean isConnectStateBug;
    private boolean isLegacyModelType;
    private boolean gromacsWideFormat;
    protected boolean isPQR;
    private final Map<String, Map<String, Boolean>> htFormul = new Hashtable<String, Map<String, Boolean>>();
    private Map<String, String> htHetero;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, Boolean> htElementsInCurrentGroup;
    private Map<String, Map<String, String>> htMolIds;
    private Lst<Map<String, String>> vCompnds;
    private Map<String, Object> thisBiomolecule;
    private Lst<Map<String, Object>> vBiomolecules;
    private Lst<Map<String, Object>> vTlsModels;
    private SB sbTlsErrors;
    protected int[] biomtChainAtomCounts;
    private SB sbIgnored;
    private SB sbSelected;
    private SB sbConect;
    private SB sb;
    private int ac;
    private int maxSerial;
    private int nUNK;
    private int nRes;
    private Map<String, String> currentCompnd;
    private String currentGroup3;
    private String currentKey;
    private int currentResno = Integer.MIN_VALUE;
    private int configurationPtr = Integer.MIN_VALUE;
    private boolean resetKey = true;
    private String compnd = null;
    private int conformationIndex;
    protected int fileAtomIndex;
    private char lastAltLoc = '\u0000';
    private int lastGroup = Integer.MIN_VALUE;
    private char lastInsertion = '\u0000';
    private int lastSourceSerial = Integer.MIN_VALUE;
    private int lastTargetSerial = Integer.MIN_VALUE;
    private int tlsGroupID;
    private int atomTypePt0;
    private int atomTypeLen;
    private boolean isCourseGrained;
    private boolean isbiomol;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  SOURCE  TITLE   SEQADV  ";
    Map<String, String> htGroup1;
    private boolean haveDoubleBonds;
    private float cryst1;
    private final float[] dataT = new float[8];
    private static final float RAD_PER_DEG = (float)Math.PI / 180;
    private static final float _8PI2_ = 78.95683f;
    private Map<Atom, float[]> tlsU;
    private Lst<int[]> vConnect;
    private int connectNextAtomIndex = 0;
    private int connectNextAtomSet = 0;
    private int[] connectLast;

    @Override
    protected void initializeReader() throws Exception {
        String[] stringArray;
        String string;
        this.allowPDBFilter = true;
        this.pdbHeader = this.getHeader ? new SB() : null;
        this.applySymmetry = !this.checkFilterKey("NOSYMMETRY");
        this.getTlsGroups = this.checkFilterKey("TLS");
        if (this.checkFilterKey("ASSEMBLY")) {
            this.filter = PT.rep(this.filter, "ASSEMBLY", "BIOMOLECULE");
        }
        this.isbiomol = this.checkFilterKey("BIOMOLECULE");
        boolean bl = this.isbiomol && this.checkFilterKey("BYCHAIN");
        boolean bl2 = this.isbiomol && this.checkFilterKey("BYSYMOP");
        boolean bl3 = this.isCourseGrained = bl || bl2;
        if (!this.isCourseGrained) {
            this.setIsPDB();
        }
        this.isConcatenated |= this.filePath.endsWith(".dssr");
        if (this.htParams.containsKey("vTlsModels")) {
            this.vTlsModels = (Lst)this.htParams.remove("vTlsModels");
        }
        if ((string = this.getFilter("TYPE ")) != null) {
            stringArray = PT.getTokens(string.replace(',', ' '));
            this.atomTypePt0 = Integer.parseInt(stringArray[0]) - 1;
            int n = stringArray[1].indexOf("=");
            if (n >= 0) {
                this.setFilterAtomTypeStr(stringArray[1].substring(n + 1).toUpperCase());
            } else {
                n = stringArray[1].length();
            }
            this.atomTypeLen = Integer.parseInt(stringArray[1].substring(0, n));
        }
        if ((stringArray = this.getFilter("CONF ")) != null) {
            this.configurationPtr = this.parseIntStr((String)stringArray);
            this.sbIgnored = new SB();
            this.sbSelected = new SB();
        }
        this.isLegacyModelType = this.stateScriptVersionInt < 120000;
        this.isConnectStateBug = this.stateScriptVersionInt >= 120151 && this.stateScriptVersionInt <= 120220 || this.stateScriptVersionInt >= 120300 && this.stateScriptVersionInt <= 120320;
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean bl;
        this.lineLength = this.line.length();
        int n = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
        boolean bl2 = n == 0 || n == 1;
        boolean bl3 = n == 2;
        this.serial = bl2 ? this.getSerial(6, 11) : 0;
        boolean bl4 = bl = (this.isTrajectory || this.isSequential) && !this.isMultiModel && bl2 && this.serial == 1;
        if (this.getHeader) {
            if (bl2 || bl3) {
                this.getHeader = false;
            } else {
                this.readHeader(false);
            }
        }
        if (bl3 || bl) {
            this.isMultiModel = bl3;
            this.getHeader = false;
            int n2 = bl ? this.modelNumber + 1 : this.getModelNumber();
            int n3 = this.modelNumber = this.bsModels == null ? n2 : this.modelNumber + 1;
            if (!this.doGetModel(this.modelNumber, null)) {
                this.handleTlsMissingModels();
                boolean bl5 = this.checkLastModel();
                if (!bl5 && this.isConcatenated) {
                    this.continuing = true;
                    bl5 = true;
                }
                return bl5;
            }
            if (!this.isCourseGrained) {
                this.connectAll(this.maxSerial, this.isConnectStateBug);
            }
            if (this.ac > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.model(n2);
            if (this.isLegacyModelType || !bl2) {
                return true;
            }
        }
        if (this.isMultiModel && !this.doProcessLines) {
            if (this.isConcatenated) {
                this.checkDSSR();
            }
            return true;
        }
        if (bl2) {
            this.getHeader = false;
            this.atom();
            return true;
        }
        switch (n) {
            case 3: {
                this.conect();
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                this.structure();
                return true;
            }
            case 7: {
                this.het();
                return true;
            }
            case 8: {
                this.hetnam();
                return true;
            }
            case 9: {
                this.anisou();
                return true;
            }
            case 10: {
                this.site();
                return true;
            }
            case 11: {
                this.cryst1();
                return true;
            }
            case 12: 
            case 13: 
            case 14: {
                this.scale(n - 11);
                return true;
            }
            case 15: {
                this.expdta();
                return true;
            }
            case 16: {
                this.formul();
                return true;
            }
            case 17: {
                if (this.line.contains("The B-factors in this file hold atomic radii")) {
                    this.isPQR = true;
                    return true;
                }
                if (this.line.contains("This file does not adhere to the PDB standard")) {
                    this.gromacsWideFormat = true;
                    return true;
                }
                if (this.line.startsWith("REMARK 350")) {
                    this.remark350();
                    return false;
                }
                if (this.line.startsWith("REMARK 290")) {
                    this.remark290();
                    return false;
                }
                if (this.getTlsGroups && this.line.indexOf("TLS DETAILS") > 0) {
                    return this.remarkTls();
                }
                this.checkCurrentLineForScript();
                return true;
            }
            case 18: {
                this.header();
                return true;
            }
            case 19: 
            case 20: {
                this.compnd(n == 20);
                return true;
            }
            case 21: {
                this.title();
                return true;
            }
            case 22: {
                this.seqAdv();
                return true;
            }
        }
        this.checkDSSR();
        return true;
    }

    private void checkDSSR() throws Exception {
        if (this.line.trim().startsWith("DSSR:") && this.asc.ac > 0) {
            this.processDSSR(this, this.htGroup1);
        }
    }

    private void seqAdv() {
        String string = this.line.substring(39, 42).trim().toLowerCase();
        if (string.length() != 1) {
            return;
        }
        if (this.htGroup1 == null) {
            this.htGroup1 = new Hashtable<String, String>();
            this.asc.setInfo("htGroup1", this.htGroup1);
        }
        String string2 = this.line.substring(12, 15).trim();
        this.htGroup1.put(string2, string);
    }

    private String readHeader(boolean bl) throws Exception {
        if (bl) {
            this.rd();
            if (!this.getHeader) {
                return this.line;
            }
        }
        this.pdbHeader.append(this.line).appendC('\n');
        return this.line;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderPDB();
    }

    protected void finalizeReaderPDB() throws Exception {
        int n;
        this.checkNotPDB();
        if (!this.isCourseGrained) {
            this.connectAll(this.maxSerial, this.isConnectStateBug);
        }
        if (this.vBiomolecules != null && this.vBiomolecules.size() > 0 && this.asc.ac > 0) {
            this.asc.setCurrentModelInfo("biomolecules", this.vBiomolecules);
            this.setBiomoleculeAtomCounts();
            if (this.thisBiomolecule != null && this.applySymmetry) {
                this.asc.getXSymmetry().applySymmetryBio(this.thisBiomolecule, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
                this.vTlsModels = null;
                this.asc.xtalSymmetry = null;
            }
        }
        if (this.vTlsModels != null) {
            int n2;
            Symmetry symmetry = (Symmetry)this.getInterface("org.jmol.symmetry.Symmetry");
            n = this.asc.atomSetCount;
            if (n == this.vTlsModels.size()) {
                n2 = n;
                while (--n2 >= 0) {
                    this.setTlsGroups(n2, n2, symmetry);
                }
            } else {
                Logger.info(n + " models but " + this.vTlsModels.size() + " TLS descriptions");
                if (this.vTlsModels.size() == 1) {
                    Logger.info(" -- assuming all models have the same TLS description -- check REMARK 3 for details.");
                    n2 = n;
                    while (--n2 >= 0) {
                        this.setTlsGroups(0, n2, symmetry);
                    }
                }
            }
            this.checkForResidualBFactors(symmetry);
        }
        if (this.sbTlsErrors != null) {
            this.asc.setInfo("tlsErrors", this.sbTlsErrors.toString());
            this.appendLoadNote(this.sbTlsErrors.toString());
        }
        this.doCheckUnitCell &= this.iHaveUnitCell && (this.doApplySymmetry || this.isbiomol);
        this.finalizeReaderASCR();
        if (this.vCompnds != null) {
            this.asc.setInfo("compoundSource", this.vCompnds);
            n = this.asc.iSet + 1;
            while (--n >= 0) {
                this.asc.setModelInfoForSet("compoundSource", this.vCompnds, n);
            }
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.pdbHeader != null) {
            this.asc.setInfo("fileHeader", this.pdbHeader.toString());
        }
        if (this.configurationPtr > 0) {
            Logger.info(this.sbSelected.toString());
            Logger.info(this.sbIgnored.toString());
        }
    }

    private void checkForResidualBFactors(SymmetryInterface symmetryInterface) {
        Atom[] atomArray = this.asc.atoms;
        boolean bl = false;
        int n = this.asc.ac;
        while (--n >= 0) {
            float f;
            float[] object = this.tlsU.get(atomArray[n]);
            if (object == null || !((f = object[7] - (object[0] + object[1] + object[2]) / 3.0f) < 0.0f) && !Float.isNaN(f)) continue;
            bl = true;
            break;
        }
        Logger.info("TLS analysis suggests Bfactors are " + (bl ? "" : "NOT") + " residuals");
        for (Map.Entry<Atom, float[]> entry : this.tlsU.entrySet()) {
            float[] fArray = entry.getValue();
            float f = fArray[7];
            if (f == 0.0f) continue;
            if (!bl) {
                f -= (fArray[0] + fArray[1] + fArray[2]) / 3.0f;
            }
            fArray[0] = fArray[0] + f;
            fArray[1] = fArray[1] + f;
            fArray[2] = fArray[2] + f;
            entry.getKey().addTensor(symmetryInterface.getTensor(this.vwr, fArray).setType(null), "TLS-R", false);
            Logger.info("TLS-U:  " + Escape.eAF(fArray));
            fArray = entry.getKey().anisoBorU;
            if (fArray == null) continue;
            Logger.info("ANISOU: " + Escape.eAF(fArray));
        }
        this.tlsU = null;
    }

    private void header() {
        String string;
        if (this.lineLength < 8) {
            return;
        }
        this.appendLoadNote(this.line.substring(7).trim());
        String string2 = string = this.lineLength >= 66 ? this.line.substring(62, 66).trim() : "";
        if (string.length() == 4) {
            this.asc.setCollectionName(string);
            this.asc.setInfo("havePDBHeaderName", Boolean.TRUE);
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.asc.setInfo("CLASSIFICATION", this.line.substring(7).trim());
    }

    private void title() {
        if (this.lineLength < 10) {
            return;
        }
        this.appendLoadNote(this.line.substring(10).trim());
    }

    private void compnd(boolean bl) {
        String string;
        if (!bl) {
            this.compnd = this.compnd == null ? "" : this.compnd + " ";
            String string2 = this.line;
            if (this.lineLength > 62) {
                string2 = string2.substring(0, 62);
            }
            this.compnd = this.compnd + string2.substring(10).trim();
            this.asc.setInfo("COMPND", this.compnd);
        }
        if (this.vCompnds == null) {
            if (bl) {
                return;
            }
            this.vCompnds = new Lst();
            this.htMolIds = new Hashtable<String, Map<String, String>>();
            this.currentCompnd = new Hashtable<String, String>();
            this.currentCompnd.put("select", "(*)");
            this.currentKey = "MOLECULE";
            this.htMolIds.put("", this.currentCompnd);
        }
        if (bl && this.resetKey) {
            this.resetKey = false;
            this.currentKey = "SOURCE";
            this.currentCompnd = this.htMolIds.get("");
        }
        this.line = this.line.substring(10, Math.min(this.lineLength, 72)).trim();
        int n = this.line.indexOf(":");
        if (n < 0 || n > 0 && this.line.charAt(n - 1) == '\\') {
            n = this.line.length();
        }
        String string3 = this.line.substring(0, n).trim();
        String string4 = string = n < this.line.length() ? this.line.substring(n + 1).trim() : null;
        if (string3.equals("MOL_ID")) {
            if (string == null) {
                return;
            }
            if (bl) {
                this.currentCompnd = this.htMolIds.remove(string);
                return;
            }
            this.currentCompnd = new Hashtable<String, String>();
            this.vCompnds.addLast(this.currentCompnd);
            this.htMolIds.put(string, this.currentCompnd);
        }
        if (this.currentCompnd == null) {
            return;
        }
        if (string == null) {
            string = this.currentCompnd.get(this.currentKey);
            if (string == null) {
                string = "";
            }
            string = string + string3;
            if (this.vCompnds.size() == 0) {
                this.vCompnds.addLast(this.currentCompnd);
            }
        } else {
            this.currentKey = string3;
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        this.currentCompnd.put(this.currentKey, string);
        if (this.currentKey.equals("CHAIN")) {
            this.currentCompnd.put("select", "(:" + PT.rep(PT.rep(string, ", ", ",:"), " ", "") + ")");
        }
    }

    private void setBiomoleculeAtomCounts() {
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            Map map = (Map)this.vBiomolecules.get(n);
            String string = (String)map.get("chains");
            int n2 = ((Lst)map.get("biomts")).size();
            int n3 = 0;
            int n4 = string.length() - 1;
            while (--n4 >= 0) {
                if (string.charAt(n4) != ':') continue;
                n3 += this.biomtChainAtomCounts['\u0000' + string.charAt(n4 + 1)];
            }
            map.put("atomCount", n3 * n2);
        }
    }

    private void remark350() throws Exception {
        Lst<M4> lst = null;
        this.vBiomolecules = new Lst();
        this.biomtChainAtomCounts = new int[255];
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = true;
        Hashtable<String, Object> hashtable = null;
        int n = 0;
        M4 m4 = M4.newM4(null);
        while (true) {
            if (bl) {
                this.readHeader(true);
            } else {
                bl = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                Object object;
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (n > 0) {
                        Logger.info("biomolecule " + string3 + ": number of transforms: " + n);
                    }
                    hashtable = new Hashtable<String, Object>();
                    lst = new Lst<M4>();
                    string3 = this.line.substring(this.line.indexOf(":") + 1).trim();
                    string = this.line.trim();
                    hashtable.put("name", "biomolecule " + string3);
                    hashtable.put("molecule", string3.length() == 3 ? string3 : Integer.valueOf(this.parseIntStr(string3)));
                    hashtable.put("title", string);
                    hashtable.put("chains", "");
                    hashtable.put("biomts", lst);
                    this.vBiomolecules.addLast((Map<String, Object>)hashtable);
                    n = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (hashtable == null) {
                        bl = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    object = this.line.substring(41).trim();
                    this.appendLoadNote("found biomolecule " + string3 + ": " + (String)object);
                    string2 = ":" + ((String)object).replace(' ', ':');
                    bl = false;
                    while (this.readHeader(true) != null && this.line.indexOf("BIOMT") < 0 && this.line.indexOf("350") == 7) {
                        string2 = string2 + ":" + this.line.substring(11).trim().replace(' ', ':');
                    }
                    if (this.checkFilterKey("BIOMOLECULE " + string3 + ";") || this.checkFilterKey("BIOMOLECULE=" + string3 + ";")) {
                        this.setFilter(this.filter.replace(':', '_') + string2);
                        Logger.info("filter set to \"" + this.filter + "\"");
                        this.thisBiomolecule = hashtable;
                    }
                    hashtable.put("chains", string2);
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++n;
                object = new float[16];
                int n2 = 0;
                while (n2 < 12) {
                    String[] stringArray = this.getTokens();
                    object[n2++] = this.parseFloatStr(stringArray[4]);
                    object[n2++] = this.parseFloatStr(stringArray[5]);
                    object[n2++] = this.parseFloatStr(stringArray[6]);
                    object[n2++] = this.parseFloatStr(stringArray[7]);
                    if (n2 != 4 && n2 != 8) continue;
                    this.readHeader(true);
                }
                object[15] = 1.0f;
                M4 m42 = new M4();
                m42.setA((float[])object);
                if (m42.equals(m4)) {
                    lst.add(0, m42);
                    continue;
                }
                lst.addLast(m42);
            }
            catch (Exception exception) {
                this.thisBiomolecule = null;
                this.vBiomolecules = null;
                return;
            }
        }
        if (n > 0) {
            Logger.info("biomolecule " + string3 + ": number of transforms: " + n);
        }
    }

    private void remark290() throws Exception {
        while (this.readHeader(true) != null && this.line.startsWith("REMARK 290")) {
            String[] stringArray;
            if (this.line.indexOf("NNNMMM   OPERATOR") < 0) continue;
            while (this.readHeader(true) != null && (stringArray = this.getTokens()).length >= 4) {
                if (!this.doApplySymmetry && !this.isbiomol) continue;
                this.setSymmetryOperator(stringArray[3]);
            }
        }
    }

    private int getSerial(int n, int n2) {
        char c = this.line.charAt(n);
        boolean bl = c == ' ' || this.line.charAt(n2 - 1) == ' ';
        switch (this.serMode) {
            default: {
                if (bl) {
                    return this.parseIntRange(this.line, n, n2);
                }
                try {
                    this.serial = Integer.parseInt(this.line.substring(n, n2));
                    return this.serial;
                }
                catch (Exception exception) {
                    this.serMode = PT.isDigit(c) ? 1 : 2;
                    return this.getSerial(n, n2);
                }
            }
            case 2: {
                return bl || PT.isDigit(c) ? this.parseIntRange(this.line, n, n2) : PT.parseIntRadix(this.line.substring(n, n2), 36) + (PT.isUpperCase(c) ? -16696160 : 26973856);
            }
            case 1: 
        }
        if (!bl) {
            this.serial = PT.parseIntRadix(this.line.substring(n, n2), 16);
            return this.serial;
        }
        this.serMode = 0;
        return this.getSerial(n, n2);
    }

    private int getSeqNo(int n, int n2) {
        char c = this.line.charAt(n);
        boolean bl = c == ' ' || this.line.charAt(n2 - 1) == ' ';
        switch (this.seqMode) {
            default: {
                if (bl) {
                    return this.parseIntRange(this.line, n, n2);
                }
                try {
                    return Integer.parseInt(this.line.substring(n, n2));
                }
                catch (Exception exception) {
                    this.seqMode = PT.isDigit(c) ? 1 : 2;
                    return this.getSeqNo(n, n2);
                }
            }
            case 2: {
                return bl || PT.isDigit(c) ? this.parseIntRange(this.line, n, n2) : PT.parseIntRadix(this.line.substring(n, n2), 36) + (PT.isUpperCase(c) ? -456560 : 756496);
            }
            case 1: 
        }
        if (!bl) {
            return PT.parseIntRadix(this.line.substring(n, n2), 16);
        }
        this.seqMode = 0;
        return this.getSeqNo(n, n2);
    }

    protected Atom processAtom(Atom atom, String string, char c, String string2, int n, int n2, char c2, boolean bl, String string3) {
        atom.atomName = string;
        if (c != ' ') {
            atom.altLoc = c;
        }
        atom.group3 = string2;
        atom.chainID = n;
        if (this.biomtChainAtomCounts != null) {
            int n3 = n % 256;
            this.biomtChainAtomCounts[n3] = this.biomtChainAtomCounts[n3] + 1;
        }
        atom.sequenceNumber = n2;
        atom.insertionCode = JmolAdapter.canonizeInsertionCode(c2);
        atom.isHetero = bl;
        atom.elementSymbol = string3;
        return atom;
    }

    protected void processAtom2(Atom atom, int n, float f, float f2, float f3, int n2) {
        atom.atomSerial = n;
        if (n > this.maxSerial) {
            this.maxSerial = n;
        }
        if (atom.group3 == null) {
            if (this.currentGroup3 != null) {
                this.currentGroup3 = null;
                this.currentResno = Integer.MIN_VALUE;
                this.htElementsInCurrentGroup = null;
            }
        } else if (!atom.group3.equals(this.currentGroup3) || atom.sequenceNumber != this.currentResno) {
            this.currentGroup3 = atom.group3;
            this.currentResno = atom.sequenceNumber;
            this.htElementsInCurrentGroup = this.htFormul.get(atom.group3);
            ++this.nRes;
            if (atom.group3.equals("UNK")) {
                ++this.nUNK;
            }
        }
        this.setAtomCoordXYZ(atom, f, f2, f3);
        atom.formalCharge = n2;
        this.setAdditionalAtomParameters(atom);
        if (this.haveMappedSerials) {
            this.asc.addAtomWithMappedSerialNumber(atom);
        } else {
            this.asc.addAtom(atom);
        }
        if (this.ac++ == 0 && !this.isCourseGrained) {
            this.setModelPDB(true);
        }
        if (atom.isHetero && this.htHetero != null) {
            this.asc.setCurrentModelInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    private void atom() {
        float f;
        float f2;
        float f3;
        String string;
        boolean bl = this.line.startsWith("HETATM");
        Atom atom = this.processAtom(new Atom(), this.line.substring(12, 16).trim(), this.line.charAt(16), this.parseTokenRange(this.line, 17, 20), this.vwr.getChainID(this.line.substring(21, 22), true), this.getSeqNo(22, 26), this.line.charAt(26), bl, this.deduceElementSymbol(bl));
        if (this.atomTypeLen > 0 && (string = this.line.substring(this.atomTypePt0, this.atomTypePt0 + this.atomTypeLen).trim()).length() > 0) {
            atom.atomName = atom.atomName + "\u0000" + string;
        }
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return;
        }
        int n = 0;
        if (this.gromacsWideFormat) {
            f3 = this.parseFloatRange(this.line, 30, 40);
            f2 = this.parseFloatRange(this.line, 40, 50);
            f = this.parseFloatRange(this.line, 50, 60);
        } else {
            if (this.lineLength >= 80) {
                char c = this.line.charAt(78);
                char c2 = this.line.charAt(79);
                if (c2 >= '0' && c2 <= '7') {
                    char c3 = c2;
                    c2 = c;
                    c = c3;
                }
                if ((c2 == '+' || c2 == '-' || c2 == ' ') && c >= '0' && c <= '7') {
                    n = c - 48;
                    if (c2 == '-') {
                        n = -n;
                    }
                }
            }
            f3 = this.parseFloatRange(this.line, 30, 38);
            f2 = this.parseFloatRange(this.line, 38, 46);
            f = this.parseFloatRange(this.line, 46, 54);
        }
        this.processAtom2(atom, this.serial, f3, f2, f, n);
    }

    protected boolean filterPDBAtom(Atom atom, int n) {
        if (!this.filterAtom(atom, n)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (atom.sequenceNumber != this.lastGroup || atom.insertionCode != this.lastInsertion) {
                this.conformationIndex = this.configurationPtr - 1;
                this.lastGroup = atom.sequenceNumber;
                this.lastInsertion = atom.insertionCode;
                this.lastAltLoc = '\u0000';
            }
            if (atom.altLoc != '\u0000') {
                String string = " atom [" + atom.group3 + "]" + atom.sequenceNumber + (atom.insertionCode == '\u0000' ? "" : "^" + atom.insertionCode) + (atom.chainID == 0 ? "" : ":" + this.vwr.getChainIDStr(atom.chainID)) + "." + atom.atomName + "%" + atom.altLoc + "\n";
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex < 0 && atom.altLoc != this.lastAltLoc) {
                    this.sbIgnored.append("ignoring").append(string);
                    return false;
                }
                this.sbSelected.append("loading").append(string);
            }
        }
        return true;
    }

    protected void setAdditionalAtomParameters(Atom atom) {
        float f;
        if (this.isPQR) {
            if (this.gromacsWideFormat) {
                atom.partialCharge = this.parseFloatRange(this.line, 60, 68);
                atom.radius = PdbReader.fixRadius(this.parseFloatRange(this.line, 68, 76));
            } else {
                String[] stringArray = this.getTokens();
                int n = stringArray.length - 2 - (this.line.length() > 75 ? 1 : 0);
                atom.partialCharge = this.parseFloatStr(stringArray[n++]);
                atom.radius = PdbReader.fixRadius(this.parseFloatStr(stringArray[n]));
            }
            return;
        }
        if (this.gromacsWideFormat) {
            f = this.parseFloatRange(this.line, 60, 68);
            atom.bfactor = PdbReader.fixRadius(this.parseFloatRange(this.line, 68, 76));
        } else {
            f = this.parseFloatRange(this.line, 54, 60);
            atom.bfactor = this.parseFloatRange(this.line, 60, 66);
        }
        atom.foccupancy = Float.isNaN(f) ? 1.0f : f;
    }

    protected String deduceElementSymbol(boolean bl) {
        char c;
        char c2;
        if (this.lineLength >= 78) {
            c2 = this.line.charAt(76);
            c = this.line.charAt(77);
            if (c2 == ' ' && Atom.isValidSym1(c)) {
                return "" + c;
            }
            if (Atom.isValidSymNoCase(c2, c)) {
                return "" + c2 + c;
            }
        }
        c2 = this.line.charAt(12);
        c = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidSymNoCase(c2, c)) {
            return bl || c2 != 'H' ? "" + c2 + c : "H";
        }
        if (c2 == 'H') {
            return "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c) != null) && Atom.isValidSym1(c)) {
            return "" + c;
        }
        if (c2 != ' ' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c2) != null) && Atom.isValidSym1(c2)) {
            return "" + c2;
        }
        char c3 = this.line.charAt(14);
        if (c2 == ' ' && c != 'X' && (this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(13, 15)) != null) && Atom.isValidSymNoCase(c, c3)) {
            return "" + c + c3;
        }
        return "Xx";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void conect() {
        if (this.sbConect == null) {
            this.sbConect = new SB();
            this.sb = new SB();
        } else {
            this.sb.setLength(0);
        }
        int n = this.getSerial(6, 11);
        if (n < 0) {
            return;
        }
        int n2 = 1;
        int n3 = this.line.trim().length();
        if (n3 > 56) {
            n3 = this.line.substring(0, 56).trim().length();
        }
        int n4 = 11;
        while (true) {
            block16: {
                String string;
                int n5;
                int n6;
                block17: {
                    boolean bl;
                    boolean bl2;
                    if (n4 >= n3) {
                        this.sbConect.appendSB(this.sb);
                        return;
                    }
                    switch (n4) {
                        case 31: {
                            n2 = 2048;
                            break;
                        }
                        case 41: {
                            break block16;
                        }
                    }
                    n6 = this.getSerial(n4, n4 + 5);
                    if (n6 < 0) break block16;
                    boolean bl3 = bl2 = n == this.lastSourceSerial && n6 == this.lastTargetSerial;
                    if (bl2) {
                        this.haveDoubleBonds = true;
                    }
                    this.lastSourceSerial = n;
                    this.lastTargetSerial = n6;
                    boolean bl4 = bl = n6 < n;
                    if (bl) {
                        n5 = n6;
                        n6 = n;
                    } else {
                        n5 = n;
                    }
                    string = ";" + n5 + " " + n6 + ";";
                    if (this.sbConect.indexOf(string) >= 0 && !bl2) break block16;
                    if (!this.haveDoubleBonds) break block17;
                    String string2 = "--" + string;
                    if (this.sbConect.indexOf(string2) >= 0) break block16;
                    this.sb.append(string2);
                }
                this.sbConect.append(string);
                this.addConnection(new int[]{n5, n6, n2});
            }
            n4 += 5;
        }
    }

    private void structure() {
        int n;
        int n2;
        int n3;
        int n4;
        STR sTR = STR.NONE;
        STR sTR2 = STR.NONE;
        int n5 = 0;
        if (this.line.startsWith("HELIX ")) {
            sTR = STR.HELIX;
            n4 = 19;
            n3 = 21;
            n2 = 31;
            n = 33;
            if (this.line.length() >= 40) {
                sTR2 = Structure.getHelixType(this.parseIntRange(this.line, 38, 40));
            }
        } else if (this.line.startsWith("SHEET ")) {
            sTR = STR.SHEET;
            n4 = 21;
            n3 = 22;
            n2 = 32;
            n = 33;
            n5 = this.parseIntRange(this.line, 14, 16);
        } else if (this.line.startsWith("TURN  ")) {
            sTR = STR.TURN;
            n4 = 19;
            n3 = 20;
            n2 = 30;
            n = 31;
        } else {
            return;
        }
        if (this.lineLength < n + 4) {
            return;
        }
        String string = this.line.substring(11, 15).trim();
        int n6 = this.parseIntRange(this.line, 7, 10);
        int n7 = this.vwr.getChainID(this.line.substring(n4, n4 + 1), true);
        int n8 = this.parseIntRange(this.line, n3, n3 + 4);
        char c = this.line.charAt(n3 + 4);
        int n9 = this.vwr.getChainID(this.line.substring(n2, n2 + 1), true);
        int n10 = this.parseIntRange(this.line, n, n + 4);
        char c2 = ' ';
        if (this.lineLength > n + 4) {
            c2 = this.line.charAt(n + 4);
        }
        if (sTR2 == STR.NONE) {
            sTR2 = sTR;
        }
        Structure structure = new Structure(-1, sTR, sTR2, string, n6, n5);
        structure.set(n7, n8, c, n9, n10, c2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.asc.addStructure(structure);
    }

    private int getModelNumber() {
        int n;
        int n2 = 6;
        int n3 = 14;
        if (n3 > this.lineLength) {
            n3 = this.lineLength;
        }
        return (n = this.parseIntRange(this.line, n2, n3)) == Integer.MIN_VALUE ? 0 : n;
    }

    protected void model(int n) {
        this.checkNotPDB();
        this.haveMappedSerials = false;
        this.sbConect = null;
        this.asc.newAtomSet();
        if (!this.isCourseGrained) {
            this.setModelPDB(true);
        }
        this.asc.setCurrentAtomSetNumber(n);
        if (this.isCourseGrained) {
            this.asc.setCurrentModelInfo("courseGrained", Boolean.TRUE);
        }
    }

    private void checkNotPDB() {
        boolean bl = !this.isCourseGrained && (this.nRes == 0 || this.nUNK != this.nRes);
        this.asc.checkSpecial = !bl;
        this.setModelPDB(bl);
        this.nRes = 0;
        this.nUNK = 0;
        this.currentGroup3 = null;
    }

    private void cryst1() throws Exception {
        this.cryst1 = this.getFloat(6, 9);
        float f = this.cryst1;
        if (f == 1.0f) {
            f = Float.NaN;
        }
        this.setUnitCell(f, this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        if (this.sgName == null) {
            this.setSpaceGroupName(PT.parseTrimmedRange(this.line, 55, 66));
        }
    }

    private float getFloat(int n, int n2) throws Exception {
        return this.parseFloatRange(this.line, n, n + n2);
    }

    private void scale(int n) throws Exception {
        if (this.notionalUnitCell == null) {
            return;
        }
        int n2 = n * 4 + 2;
        this.notionalUnitCell[0] = this.cryst1;
        this.setUnitCellItem(n2++, this.getFloat(10, 10));
        this.setUnitCellItem(n2++, this.getFloat(20, 10));
        this.setUnitCellItem(n2++, this.getFloat(30, 10));
        this.setUnitCellItem(n2++, this.getFloat(45, 10));
    }

    private void expdta() {
        if (this.line.toUpperCase().indexOf("NMR") >= 0) {
            this.asc.setInfo("isNMRdata", "true");
        }
    }

    private void formul() {
        String string;
        Map<String, Boolean> map;
        String string2 = this.parseTokenRange(this.line, 12, 15);
        String string3 = PT.parseTrimmedRange(this.line, 19, 70);
        int n = string3.indexOf(40);
        if (n >= 0) {
            int n2 = string3.indexOf(41);
            if (n2 < 0 || n >= n2 || n + 1 == n2) {
                return;
            }
            string3 = PT.parseTrimmedRange(string3, n + 1, n2);
        }
        if ((map = this.htFormul.get(string2)) == null) {
            map = new Hashtable<String, Boolean>();
            this.htFormul.put(string2, map);
        }
        this.next[0] = 0;
        while ((string = this.parseTokenNext(string3)) != null) {
            char c;
            if (string.length() < 2) continue;
            char c2 = string.charAt(0);
            if (Atom.isValidSymNoCase(c2, c = string.charAt(1))) {
                map.put("" + c2 + c, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidSym1(c2)) continue;
            map.put("" + c2, Boolean.TRUE);
        }
    }

    private void het() {
        String string;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (this.htHetero.containsKey(string = this.parseTokenRange(this.line, 7, 10))) {
            return;
        }
        String string2 = PT.parseTrimmedRange(this.line, 30, 70);
        this.htHetero.put(string, string2);
    }

    private void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        String string = this.parseTokenRange(this.line, 11, 14);
        String string2 = PT.parseTrimmedRange(this.line, 15, 70);
        if (string == null) {
            Logger.error("ERROR: HETNAM record does not contain a group name: " + this.line);
            return;
        }
        String string3 = this.htHetero.get(string);
        if (string3 != null) {
            string2 = string3 + string2;
        }
        this.htHetero.put(string, string2);
    }

    private void anisou() {
        Atom atom;
        int n;
        float[] fArray = new float[8];
        fArray[6] = 1.0f;
        String string = this.line.substring(6, 11).trim();
        if (!this.haveMappedSerials && this.asc.ac > 0) {
            for (int i = this.asc.getAtomSetAtomIndex(this.asc.iSet); i < this.asc.ac; ++i) {
                n = this.asc.atoms[i].atomSerial;
                if (n == Integer.MIN_VALUE) continue;
                this.asc.atomSymbolicMap.put("" + n, this.asc.atoms[i]);
            }
            this.haveMappedSerials = true;
        }
        if ((atom = this.asc.getAtomFromName(string)) == null) {
            return;
        }
        n = 28;
        int n2 = 0;
        while (n < 70) {
            fArray[n2] = this.parseFloatRange(this.line, n, n + 7);
            n += 7;
            ++n2;
        }
        n = 0;
        while (n < 6) {
            if (Float.isNaN(fArray[n])) {
                Logger.error("Bad ANISOU record: " + this.line);
                return;
            }
            int n3 = n++;
            fArray[n3] = fArray[n3] / 10000.0f;
        }
        this.asc.setAnisoBorU(atom, fArray, 12);
    }

    private void site() {
        int n;
        String string;
        if (this.htSites == null) {
            this.htSites = new Hashtable<String, Map<String, Object>>();
        }
        int n2 = this.parseIntRange(this.line, 15, 17);
        String string2 = PT.parseTrimmedRange(this.line, 11, 14);
        Map<String, Object> map = this.htSites.get(string2);
        if (map == null) {
            map = new Hashtable<String, Object>();
            map.put("nResidues", n2);
            map.put("groups", "");
            this.htSites.put(string2, map);
        }
        String string3 = (String)map.get("groups");
        for (int i = 0; i < 4 && (string = PT.parseTrimmedRange(this.line, n = 18 + i * 11, n + 3)).length() != 0; ++i) {
            String string4 = PT.parseTrimmedRange(this.line, n + 4, n + 5);
            String string5 = PT.parseTrimmedRange(this.line, n + 5, n + 9);
            String string6 = PT.parseTrimmedRange(this.line, n + 9, n + 10);
            string3 = string3 + (string3.length() == 0 ? "" : ",") + "[" + string + "]" + string5;
            if (string6.length() > 0) {
                string3 = string3 + "^" + string6;
            }
            if (string4.length() > 0) {
                string3 = string3 + ":" + string4;
            }
            map.put("groups", string3);
        }
    }

    private boolean remarkTls() throws Exception {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        String string = null;
        Lst<Hashtable<String, Object>> lst = null;
        Hashtable<String, Object> hashtable = null;
        Lst lst2 = null;
        Hashtable<String, Object> hashtable2 = null;
        String string2 = this.line.substring(0, 11);
        while (this.readHeader(true) != null && this.line.startsWith(string2)) {
            try {
                int n3;
                int n4;
                int n5;
                stringArray = PT.getTokens(this.line.substring(10).replace(':', ' '));
                if (stringArray.length < 2) continue;
                Logger.info(this.line);
                if (stringArray[1].equalsIgnoreCase("GROUP")) {
                    hashtable = new Hashtable<String, Object>();
                    lst2 = new Lst();
                    hashtable.put("ranges", lst2);
                    lst.addLast(hashtable);
                    this.tlsGroupID = this.parseIntStr(stringArray[stringArray.length - 1]);
                    hashtable.put("id", this.tlsGroupID);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("NUMBER")) {
                    if (stringArray[2].equalsIgnoreCase("COMPONENTS")) continue;
                    n = this.parseIntStr(stringArray[stringArray.length - 1]);
                    if (n < 1) break;
                    if (this.vTlsModels == null) {
                        this.vTlsModels = new Lst();
                    }
                    lst = new Lst<Hashtable<String, Object>>();
                    this.appendLoadNote(this.line.substring(11).trim());
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("COMPONENTS")) {
                    string = this.line;
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("RESIDUE")) {
                    int n6;
                    char c;
                    char c2;
                    hashtable2 = new Hashtable<String, Object>();
                    if (stringArray.length == 6) {
                        c2 = stringArray[2].charAt(0);
                        c = stringArray[4].charAt(0);
                        n6 = this.parseIntStr(stringArray[3]);
                        n5 = this.parseIntStr(stringArray[5]);
                    } else {
                        n4 = string.indexOf(" C ");
                        n3 = string.indexOf(" C ", n4 + 4);
                        c2 = this.line.charAt(n3);
                        c = this.line.charAt(n4);
                        n6 = this.parseIntRange(this.line, n3 + 1, n4);
                        n5 = this.parseIntStr(this.line.substring(n4 + 1));
                    }
                    if (c2 == c) {
                        hashtable2.put("chains", "" + c2 + c);
                        if (n6 <= n5) {
                            hashtable2.put("residues", new int[]{n6, n5});
                            lst2.addLast(hashtable2);
                            continue;
                        }
                        this.tlsAddError(" TLS group residues are not in order (range ignored)");
                        continue;
                    }
                    this.tlsAddError(" TLS group chains are different (range ignored)");
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("SELECTION")) {
                    char c = '\u0000';
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (stringArray[i].toUpperCase().indexOf("CHAIN") >= 0) {
                            c = stringArray[++i].charAt(0);
                            continue;
                        }
                        int n7 = this.parseIntStr(stringArray[i]);
                        if (n7 == Integer.MIN_VALUE) continue;
                        hashtable2 = new Hashtable();
                        hashtable2.put("residues", new int[]{n7, this.parseIntStr(stringArray[++i])});
                        if (c != '\u0000') {
                            hashtable2.put("chains", "" + c + c);
                        }
                        lst2.addLast(hashtable2);
                    }
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("ORIGIN")) {
                    P3 p3 = new P3();
                    hashtable.put("origin", p3);
                    if (stringArray.length == 8) {
                        p3.set(this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[7]));
                    } else {
                        int n8 = this.line.length();
                        p3.set(this.parseFloatRange(this.line, n8 - 27, n8 - 18), this.parseFloatRange(this.line, n8 - 18, n8 - 9), this.parseFloatRange(this.line, n8 - 9, n8));
                    }
                    if (!Float.isNaN(p3.x) && !Float.isNaN(p3.y) && !Float.isNaN(p3.z)) continue;
                    p3.set(Float.NaN, Float.NaN, Float.NaN);
                    this.tlsAddError("invalid origin: " + this.line);
                    continue;
                }
                if (!stringArray[1].equalsIgnoreCase("TENSOR")) continue;
                char c = stringArray[0].charAt(0);
                String string3 = (this.readHeader(true).substring(10) + this.readHeader(true).substring(10) + this.readHeader(true).substring(10)).replace(c, ' ').replace(':', ' ');
                stringArray = PT.getTokens(string3);
                float[][] fArray = new float[3][3];
                hashtable.put("t" + c, fArray);
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    n4 = stringArray[n5].charAt(0) - 49;
                    n3 = stringArray[n5].charAt(1) - 49;
                    fArray[n4][n3] = this.parseFloatStr(stringArray[++n5]);
                    if (n4 >= n3) continue;
                    fArray[n3][n4] = fArray[n4][n3];
                }
                for (n5 = 0; n5 < 3; ++n5) {
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (!Float.isNaN(fArray[n5][n4])) continue;
                        this.tlsAddError("invalid tensor: " + Escape.escapeFloatAA(fArray, false));
                    }
                }
                if (c != 'S' || ++n2 != n) continue;
                Logger.info(n + " TLS groups read");
                this.readHeader(true);
                break;
            }
            catch (Exception exception) {
                Logger.error(this.line + "\nError in TLS parser: ");
                System.out.println(exception.getMessage());
                lst = null;
                break;
            }
        }
        if (lst != null) {
            stringArray = new Hashtable();
            stringArray.put("groupCount", n);
            stringArray.put("groups", lst);
            this.vTlsModels.addLast((Map<String, Object>)stringArray);
        }
        return n < 1;
    }

    private void handleTlsMissingModels() {
        this.vTlsModels = null;
    }

    private void setTlsGroups(int n, int n2, SymmetryInterface symmetryInterface) {
        Logger.info("TLS model " + (n2 + 1) + " set " + (n + 1));
        Map map = (Map)this.vTlsModels.get(n);
        Lst lst = (Lst)map.get("groups");
        int n3 = this.asc.getAtomSetAtomIndex(n2);
        float[] fArray = new float[this.asc.getAtomSetAtomCount(n2)];
        int n4 = n3 + fArray.length;
        Atom[] atomArray = this.asc.atoms;
        int n5 = lst.size();
        for (int i = 0; i < n5; ++i) {
            Map map2 = (Map)lst.get(i);
            Lst lst2 = (Lst)map2.get("ranges");
            this.tlsGroupID = (Integer)map2.get("id");
            int n6 = lst2.size();
            while (--n6 >= 0) {
                int n7;
                String string = (String)((Map)lst2.get(n6)).get("chains");
                int[] nArray = (int[])((Map)lst2.get(n6)).get("residues");
                int n8 = '\u0000' + string.charAt(0);
                int n9 = '\u0000' + string.charAt(1);
                int n10 = nArray[0];
                int n11 = nArray[1];
                int n12 = this.findAtomForRange(n3, n4, n8, n10, false);
                int n13 = n7 = n12 >= 0 ? this.findAtomForRange(n12, n4, n9, n11, false) : -1;
                if (n7 < 0) {
                    Logger.info("TLS processing terminated");
                    return;
                }
                Logger.info("TLS ID=" + this.tlsGroupID + " model atom index range " + n12 + "-" + n7);
                boolean bl = n8 == n9;
                for (int j = n3; j < n4; ++j) {
                    Atom atom = atomArray[j];
                    if (!(bl ? atom.sequenceNumber >= n10 && atom.sequenceNumber <= n11 : atom.chainID > n8 && atom.chainID < n9 || atom.chainID == n8 && atom.sequenceNumber >= n10 || atom.chainID == n9 && atom.sequenceNumber <= n11)) continue;
                    fArray[j - n3] = this.tlsGroupID;
                    this.setTlsTensor(atom, map2, symmetryInterface);
                }
            }
        }
        this.asc.setAtomProperties("tlsGroup", fArray, n2, true);
        this.asc.setModelInfoForSet("TLS", map, n2);
        this.asc.setTensors();
    }

    private int findAtomForRange(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.findAtom(n, n2, n3, n4, true);
        return bl && n5 >= 0 ? this.findAtom(n5, n2, n3, n4, false) : n5;
    }

    private int findAtom(int n, int n2, int n3, int n4, boolean bl) {
        Atom[] atomArray = this.asc.atoms;
        for (int i = n; i < n2; ++i) {
            Atom atom = atomArray[i];
            if ((atom.chainID == n3 && atom.sequenceNumber == n4) != bl) continue;
            return i;
        }
        if (bl) {
            Logger.warn("PdbReader findAtom chain=" + n3 + " resno=" + n4 + " not found");
            this.tlsAddError("atom not found: chain=" + n3 + " resno=" + n4);
        }
        return bl ? -1 : n2;
    }

    private void setTlsTensor(Atom atom, Map<String, Object> map, SymmetryInterface symmetryInterface) {
        P3 p3 = (P3)map.get("origin");
        if (Float.isNaN(p3.x)) {
            return;
        }
        float[][] fArray = (float[][])map.get("tT");
        float[][] fArray2 = (float[][])map.get("tL");
        float[][] fArray3 = (float[][])map.get("tS");
        if (fArray == null || fArray2 == null || fArray3 == null) {
            return;
        }
        float f = (atom.x - p3.x) * ((float)Math.PI / 180);
        float f2 = (atom.y - p3.y) * ((float)Math.PI / 180);
        float f3 = (atom.z - p3.z) * ((float)Math.PI / 180);
        float f4 = f * f;
        float f5 = f2 * f2;
        float f6 = f3 * f3;
        float f7 = f * f2;
        float f8 = f * f3;
        float f9 = f2 * f3;
        this.dataT[0] = fArray[0][0];
        this.dataT[1] = fArray[1][1];
        this.dataT[2] = fArray[2][2];
        this.dataT[3] = fArray[0][1];
        this.dataT[4] = fArray[0][2];
        this.dataT[5] = fArray[1][2];
        this.dataT[6] = 12.0f;
        float[] fArray4 = new float[8];
        float f10 = Float.isNaN(atom.bfactor) ? 0.0f : atom.bfactor / 78.95683f;
        fArray4[0] = this.dataT[0] + fArray2[1][1] * f6 + fArray2[2][2] * f5 - 2.0f * fArray2[1][2] * f9 + 2.0f * fArray3[1][0] * f3 - 2.0f * fArray3[2][0] * f2;
        fArray4[1] = this.dataT[1] + fArray2[0][0] * f6 + fArray2[2][2] * f4 - 2.0f * fArray2[2][0] * f8 - 2.0f * fArray3[0][1] * f3 + 2.0f * fArray3[2][1] * f;
        fArray4[2] = this.dataT[2] + fArray2[0][0] * f5 + fArray2[1][1] * f4 - 2.0f * fArray2[0][1] * f7 - 2.0f * fArray3[1][2] * f + 2.0f * fArray3[0][2] * f2;
        fArray4[3] = this.dataT[3] - fArray2[2][2] * f7 + fArray2[1][2] * f8 + fArray2[2][0] * f9 - fArray2[0][1] * f6 - fArray3[0][0] * f3 + fArray3[1][1] * f3 + fArray3[2][0] * f - fArray3[2][1] * f2;
        fArray4[4] = this.dataT[4] - fArray2[1][1] * f8 + fArray2[1][2] * f7 - fArray2[2][0] * f5 + fArray2[0][1] * f9 + fArray3[0][0] * f2 - fArray3[2][2] * f2 + fArray3[1][2] * f3 - fArray3[1][0] * f;
        fArray4[5] = this.dataT[5] - fArray2[0][0] * f9 - fArray2[1][2] * f4 + fArray2[2][0] * f7 + fArray2[0][1] * f8 - fArray3[1][1] * f + fArray3[2][2] * f + fArray3[0][1] * f2 - fArray3[0][2] * f3;
        fArray4[6] = 12.0f;
        fArray4[7] = f10;
        if (this.tlsU == null) {
            this.tlsU = new Hashtable<Atom, float[]>();
        }
        this.tlsU.put(atom, fArray4);
        atom.addTensor(symmetryInterface.getTensor(this.vwr, this.dataT).setType(null), "TLS-U", false);
    }

    private void tlsAddError(String string) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new SB();
        }
        this.sbTlsErrors.append(this.fileName).appendC('\t').append("TLS group ").appendI(this.tlsGroupID).appendC('\t').append(string).appendC('\n');
    }

    protected static float fixRadius(float f) {
        return f < 0.9f ? 1.0f : f;
    }

    private void addConnection(int[] nArray) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new Lst();
        }
        if (this.connectLast != null && nArray[0] == this.connectLast[0] && nArray[1] == this.connectLast[1] && nArray[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = nArray;
        this.vConnect.addLast(nArray);
    }

    private void connectAllBad(int n) {
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.asc.atomSetCount; ++i) {
            int n3 = this.asc.getAtomSetAtomCount(i);
            this.asc.setModelInfoForSet("PDB_CONECT_firstAtom_count_max", new int[]{n2, n3, n}, i);
            if (this.vConnect != null) {
                this.asc.setModelInfoForSet("PDB_CONECT_bonds", this.vConnect, i);
                this.asc.setGlobalBoolean(3);
            }
            n2 += n3;
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.asc.iSet + 1;
        this.connectNextAtomIndex = n2;
    }

    private void connectAll(int n, boolean bl) {
        AtomSetCollection atomSetCollection = this.asc;
        int n2 = atomSetCollection.iSet;
        if (n2 < 0) {
            return;
        }
        if (bl) {
            this.connectAllBad(n);
            return;
        }
        atomSetCollection.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{atomSetCollection.getAtomSetAtomIndex(n2), atomSetCollection.getAtomSetAtomCount(n2), n});
        if (this.vConnect == null) {
            return;
        }
        int n3 = this.connectNextAtomIndex;
        int n4 = atomSetCollection.atomSetCount;
        while (--n4 >= this.connectNextAtomSet) {
            atomSetCollection.setModelInfoForSet("PDB_CONECT_bonds", this.vConnect, n4);
            atomSetCollection.setGlobalBoolean(3);
            n3 += atomSetCollection.getAtomSetAtomCount(n4);
        }
        this.vConnect = null;
        this.connectNextAtomSet = n2 + 1;
        this.connectNextAtomIndex = n3;
    }
}

