/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.PT;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MSRdr;

public class MSCifRdr
extends MSRdr {
    private String field;
    private static final int FWV_ID = 0;
    private static final int WV_ID = 1;
    private static final int WV_X = 2;
    private static final int WV_Y = 3;
    private static final int WV_Z = 4;
    private static final int FWV_X = 5;
    private static final int FWV_Y = 6;
    private static final int FWV_Z = 7;
    private static final int JANA_FWV_Q1_COEF = 8;
    private static final int JANA_FWV_Q2_COEF = 9;
    private static final int JANA_FWV_Q3_COEF = 10;
    private static final int FWV_DISP_LABEL = 11;
    private static final int FWV_DISP_AXIS = 12;
    private static final int FWV_DISP_SEQ_ID = 13;
    private static final int FWV_DISP_COS = 14;
    private static final int FWV_DISP_SIN = 15;
    private static final int FWV_DISP_MODULUS = 16;
    private static final int FWV_DISP_PHASE = 17;
    private static final int DISP_SPEC_LABEL = 18;
    private static final int DISP_SAW_AX = 19;
    private static final int DISP_SAW_AY = 20;
    private static final int DISP_SAW_AZ = 21;
    private static final int DISP_SAW_C = 22;
    private static final int DISP_SAW_W = 23;
    private static final int FWV_OCC_LABEL = 24;
    private static final int FWV_OCC_SEQ_ID = 25;
    private static final int FWV_OCC_COS = 26;
    private static final int FWV_OCC_SIN = 27;
    private static final int FWV_OCC_MODULUS = 28;
    private static final int FWV_OCC_PHASE = 29;
    private static final int OCC_SPECIAL_LABEL = 30;
    private static final int OCC_CRENEL_C = 31;
    private static final int OCC_CRENEL_W = 32;
    private static final int FWV_U_LABEL = 33;
    private static final int FWV_U_TENS = 34;
    private static final int FWV_U_SEQ_ID = 35;
    private static final int FWV_U_COS = 36;
    private static final int FWV_U_SIN = 37;
    private static final int FWV_U_MODULUS = 38;
    private static final int FWV_U_PHASE = 39;
    private static final int FD_ID = 40;
    private static final int FO_ID = 41;
    private static final int FU_ID = 42;
    private static final int FDP_ID = 43;
    private static final int FOP_ID = 44;
    private static final int FUP_ID = 45;
    private static final int JANA_OCC_ABS_LABEL = 46;
    private static final int JANA_OCC_ABS_O_0 = 47;
    private static final int FWV_SPIN_LABEL = 48;
    private static final int FWV_SPIN_AXIS = 49;
    private static final int FWV_SPIN_SEQ_ID = 50;
    private static final int FWV_SPIN_COS = 51;
    private static final int FWV_SPIN_SIN = 52;
    private static final int FWV_SPIN_MODULUS = 53;
    private static final int FWV_SPIN_PHASE = 54;
    private static final int SPIN_SPEC_LABEL = 55;
    private static final int SPIN_SAW_AX = 56;
    private static final int SPIN_SAW_AY = 57;
    private static final int SPIN_SAW_AZ = 58;
    private static final int SPIN_SAW_C = 59;
    private static final int SPIN_SAW_W = 60;
    private static final int LEG_DISP_LABEL = 61;
    private static final int LEG_DISP_AXIS = 62;
    private static final int LEG_DISP_ORDER = 63;
    private static final int LEG_DISP_COEF = 64;
    private static final int LEG_U_LABEL = 65;
    private static final int LEG_U_TENS = 66;
    private static final int LEG_U_ORDER = 67;
    private static final int LEG_U_COEF = 68;
    private static final int LEG_OCC_LABEL = 69;
    private static final int LEG_OCC_ORDER = 70;
    private static final int LEG_OCC_COEF = 71;
    private static final int DEPR_FD_COS = 72;
    private static final int DEPR_FD_SIN = 73;
    private static final int DEPR_FO_COS = 74;
    private static final int DEPR_FO_SIN = 75;
    private static final int DEPR_FU_COS = 76;
    private static final int DEPR_FU_SIN = 77;
    private static final String[] modulationFields = new String[]{"*_fourier_wave_vector_seq_id", "_cell_wave_vector_seq_id", "_cell_wave_vector_x", "_cell_wave_vector_y", "_cell_wave_vector_z", "*_fourier_wave_vector_x", "*_fourier_wave_vector_y", "*_fourier_wave_vector_z", "*_fourier_wave_vector_q1_coeff", "*_fourier_wave_vector_q2_coeff", "*_fourier_wave_vector_q3_coeff", "*_displace_fourier_atom_site_label", "*_displace_fourier_axis", "*_displace_fourier_wave_vector_seq_id", "*_displace_fourier_param_cos", "*_displace_fourier_param_sin", "*_displace_fourier_param_modulus", "*_displace_fourier_param_phase", "*_displace_special_func_atom_site_label", "*_displace_special_func_sawtooth_ax", "*_displace_special_func_sawtooth_ay", "*_displace_special_func_sawtooth_az", "*_displace_special_func_sawtooth_c", "*_displace_special_func_sawtooth_w", "*_occ_fourier_atom_site_label", "*_occ_fourier_wave_vector_seq_id", "*_occ_fourier_param_cos", "*_occ_fourier_param_sin", "*_occ_fourier_param_modulus", "*_occ_fourier_param_phase", "*_occ_special_func_atom_site_label", "*_occ_special_func_crenel_c", "*_occ_special_func_crenel_w", "*_u_fourier_atom_site_label", "*_u_fourier_tens_elem", "*_u_fourier_wave_vector_seq_id", "*_u_fourier_param_cos", "*_u_fourier_param_sin", "*_u_fourier_param_modulus", "*_u_fourier_param_phase", "*_displace_fourier_id", "*_occ_fourier_id", "*_u_fourier_id", "*_displace_fourier_param_id", "*_occ_fourier_param_id", "*_u_fourier_param_id", "*_occ_fourier_absolute_site_label", "*_occ_fourier_absolute", "*_moment_fourier_atom_site_label", "*_moment_fourier_axis", "*_moment_fourier_wave_vector_seq_id", "*_moment_fourier_param_cos", "*_moment_fourier_param_sin", "*_moment_fourier_param_modulus", "*_moment_fourier_param_phase", "*_moment_special_func_atom_site_label", "*_moment_special_func_sawtooth_ax", "*_moment_special_func_sawtooth_ay", "*_moment_special_func_sawtooth_az", "*_moment_special_func_sawtooth_c", "*_moment_special_func_sawtooth_w", "*_displace_legendre_atom_site_label", "*_displace_legendre_axis", "*_displace_legendre_param_order", "*_displace_legendre_param_coeff", "*_u_legendre_atom_site_label", "*_u_legendre_tens_elem", "*_u_legendre_param_order", "*_u_legendre_param_coeff", "*_occ_legendre_atom_site_label", "*_occ_legendre_param_order", "*_occ_legendre_param_coeff", "*_displace_fourier_cos", "*_displace_fourier_sin", "*_occ_fourier_cos", "*_occ_fourier_sin", "*_u_fourier_cos", "*_u_fourier_sin"};
    private static final int NONE = -1;
    private M3 comSSMat;

    public void processEntry() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        if (cifReader.key.equals("_cell_commen_t_section_1")) {
            this.isCommensurate = true;
            this.commensurateSection1 = cifReader.parseIntStr(cifReader.data);
        }
        if (cifReader.key.startsWith("_cell_commen_supercell_matrix")) {
            this.isCommensurate = true;
            if (this.comSSMat == null) {
                this.comSSMat = M3.newM3(null);
            }
            String[] stringArray = PT.split((String)cifReader.key, (String)"_");
            int n = cifReader.parseIntStr(stringArray[stringArray.length - 2]);
            int n2 = cifReader.parseIntStr(stringArray[stringArray.length - 1]);
            if (n > 0 && n2 > 0) {
                this.comSSMat.setElement(n - 1, n2 - 1, cifReader.parseFloatStr(cifReader.data));
            }
        }
    }

    public int processLoopBlock() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        if (cifReader.key.equals("_cell_subsystem_code")) {
            return this.processSubsystemLoopBlock();
        }
        if (!(cifReader.key.startsWith("_cell_wave") || cifReader.key.contains("fourier") || cifReader.key.contains("legendre") || cifReader.key.contains("_special_func"))) {
            return 0;
        }
        if (cifReader.asc.iSet < 0) {
            cifReader.asc.newAtomSet();
        }
        cifReader.parseLoopParametersFor("_atom_site", modulationFields);
        if (cifReader.fieldOf[8] != -1) {
            cifReader.fieldOf[7] = -1;
            cifReader.fieldOf[6] = -1;
            cifReader.fieldOf[5] = -1;
        }
        block37: while (cifReader.parser.getData()) {
            int n;
            boolean bl = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
            double d = Double.NaN;
            double d2 = Double.NaN;
            String string4 = null;
            int n2 = cifReader.parser.getFieldCount();
            block38: for (n = 0; n < n2; ++n) {
                int n3 = this.fieldProperty(cifReader, n);
                switch (n3) {
                    case 1: {
                        cifReader.haveCellWaveVector = true;
                    }
                    case 0: 
                    case 40: 
                    case 41: 
                    case 42: {
                        dArray[2] = 0.0;
                        dArray[1] = 0.0;
                        dArray[0] = 0.0;
                    }
                    case 13: 
                    case 25: 
                    case 35: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 50: {
                        switch (n3) {
                            case 1: {
                                string = "W_";
                                break;
                            }
                            case 0: {
                                string = "F_";
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 42: {
                                string4 = "?" + this.field;
                                dArray[2] = 1.0;
                                continue block38;
                            }
                            case 43: 
                            case 44: 
                            case 45: {
                                string3 = "*";
                                string2 = "*";
                            }
                            case 13: 
                            case 25: 
                            case 35: 
                            case 50: {
                                string = Character.toUpperCase(modulationFields[n3].charAt(11)) + "_";
                            }
                        }
                        string = string + this.field;
                        continue block38;
                    }
                    case 46: {
                        if (string == null) {
                            string = "J_O";
                        }
                        dArray[2] = 1.0;
                        dArray[0] = 1.0;
                    }
                    case 30: {
                        if (string == null) {
                            string = "O_0";
                        }
                        string3 = "0";
                    }
                    case 18: {
                        if (string == null) {
                            string = "D_S";
                        }
                    }
                    case 61: {
                        if (string == null) {
                            string = "D_L";
                        }
                    }
                    case 65: {
                        if (string == null) {
                            string = "U_L";
                        }
                    }
                    case 69: {
                        if (string == null) {
                            string = "O_L";
                        }
                    }
                    case 55: {
                        if (string == null) {
                            string = "M_T";
                        }
                    }
                    case 11: 
                    case 24: 
                    case 33: 
                    case 48: {
                        string2 = this.field;
                        continue block38;
                    }
                    case 12: 
                    case 49: 
                    case 62: {
                        string3 = this.field;
                        if (this.modAxes == null || this.modAxes.indexOf(string3.toUpperCase()) >= 0) continue block38;
                        bl = true;
                        continue block38;
                    }
                    case 34: 
                    case 66: {
                        string3 = this.field.toUpperCase();
                        continue block38;
                    }
                    default: {
                        float f = cifReader.parseFloatStr(this.field);
                        switch (n3) {
                            case 64: 
                            case 68: 
                            case 71: {
                                dArray[0] = f;
                                if (f == 0.0f) continue block38;
                                dArray[2] = 0.0;
                                continue block38;
                            }
                            case 15: 
                            case 27: 
                            case 31: 
                            case 37: 
                            case 52: 
                            case 73: 
                            case 75: 
                            case 77: {
                                dArray[2] = 0.0;
                            }
                            case 2: 
                            case 5: 
                            case 19: 
                            case 56: {
                                dArray[0] = f;
                                continue block38;
                            }
                            case 8: {
                                string = string + "_coefs_";
                                dArray = new double[this.modDim];
                                dArray[0] = f;
                                continue block38;
                            }
                            case 16: 
                            case 28: 
                            case 38: 
                            case 53: {
                                dArray[0] = f;
                                dArray[2] = 1.0;
                                continue block38;
                            }
                            case 26: 
                            case 70: 
                            case 74: {
                                string3 = "0";
                            }
                            case 3: 
                            case 6: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 20: 
                            case 29: 
                            case 32: 
                            case 36: 
                            case 39: 
                            case 47: 
                            case 51: 
                            case 54: 
                            case 57: 
                            case 63: 
                            case 67: 
                            case 72: 
                            case 76: {
                                dArray[1] = f;
                                continue block38;
                            }
                            case 4: 
                            case 7: 
                            case 10: 
                            case 21: 
                            case 58: {
                                dArray[2] = f;
                                continue block38;
                            }
                            case 22: 
                            case 59: {
                                d = f;
                                continue block38;
                            }
                            case 23: 
                            case 60: {
                                d2 = f;
                            }
                        }
                    }
                }
            }
            if (bl || string == null || string2 != null && !string2.equals("*") && cifReader.rejectAtomName(string2)) continue;
            n = 1;
            int n4 = dArray.length;
            for (int i = 0; i < dArray.length; ++i) {
                if (!Double.isNaN(dArray[i]) && !(dArray[i] > 1.0E100) && (dArray[i] != 0.0 || --n4 != 0)) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            switch (string.charAt(0)) {
                case 'D': 
                case 'J': 
                case 'M': 
                case 'O': 
                case 'U': {
                    if (string2 == null || string3 == null) continue block37;
                    if (string.equals("D_S") || string.equals("M_T")) {
                        if (Double.isNaN(d) || Double.isNaN(d2)) continue block37;
                        if (dArray[0] != 0.0) {
                            this.addMod(string + "#x;" + string2, string4, new double[]{d, d2, dArray[0]});
                        }
                        if (dArray[1] != 0.0) {
                            this.addMod(string + "#y;" + string2, string4, new double[]{d, d2, dArray[1]});
                        }
                        if (dArray[2] == 0.0) continue block37;
                        this.addMod(string + "#z;" + string2, string4, new double[]{d, d2, dArray[2]});
                        continue block37;
                    }
                    if (string.indexOf("_L") == 1) {
                        if (string.startsWith("U")) {
                            string = string + (int)dArray[1];
                        } else {
                            string3 = string3 + (int)dArray[1];
                        }
                    }
                    string = string + "#" + string3 + ";" + string2;
                }
            }
            this.addMod(string, string4, dArray);
        }
        return 1;
    }

    private void addMod(String string, String string2, double[] dArray) {
        if (string2 != null) {
            string = string + string2;
        }
        this.addModulation(null, string, dArray, -1);
    }

    private int processSubsystemLoopBlock() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        cifReader.parseLoopParameters(null);
        while (cifReader.parser.getData()) {
            this.fieldProperty(cifReader, 0);
            String string = this.field;
            this.addSubsystem(string, this.getSparseMatrix(cifReader, "_w_", 1, 3 + this.modDim));
        }
        return 1;
    }

    private Matrix getSparseMatrix(CifReader cifReader, String string, int n, int n2) {
        Matrix matrix = new Matrix((double[][])null, n2, n2);
        double[][] dArray = matrix.getArray();
        int n3 = cifReader.parser.getFieldCount();
        while (n < n3) {
            String string2;
            int n4 = this.fieldProperty(cifReader, n);
            if (n4 >= 0 && (string2 = cifReader.parser.getField(n4)).contains(string)) {
                String[] stringArray = PT.split((String)string2, (String)"_");
                int n5 = cifReader.parseIntStr(stringArray[stringArray.length - 2]);
                int n6 = cifReader.parseIntStr(stringArray[stringArray.length - 1]);
                if (n5 > 0 && n6 > 0) {
                    dArray[n5 - 1][n6 - 1] = cifReader.parseFloatStr(this.field);
                }
            }
            ++n;
        }
        return matrix;
    }

    private int fieldProperty(CifReader cifReader, int n) {
        this.field = cifReader.parser.getLoopData(n);
        return this.field.length() > 0 && this.field.charAt(0) != '\u0000' ? cifReader.propertyOf[n] : -1;
    }
}

