/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;
    private SymmetryDesc desc;

    public boolean isBio() {
        return this.isBio;
    }

    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, Atom[] atomArray, BS bS, boolean bl, float f, float f2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, atomArray, bS, bl, f, f2);
        return this;
    }

    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2, f)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true).set(bl);
        }
    }

    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n, false);
    }

    public int addBioMoleculeOperation(M4 m4, boolean bl) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((bl ? "!" : "") + "[[bio" + m4, 0, false);
    }

    public void setLattice(int n) {
        this.spaceGroup.setLatticeParam(n);
    }

    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroupFrom(SymmetryInterface symmetryInterface) {
        this.spaceGroup = (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    public boolean createSpaceGroup(int n, String string, Object object) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, object);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug((String)("using generated space group " + this.spaceGroup.dumpInfo(null)));
        }
        return this.spaceGroup != null;
    }

    public String getSpaceGroupInfoStr(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    public void setFinalOperations(String string, P3[] p3Array, int n, int n2, boolean bl, String string2) {
        if (string != null && (string.startsWith("bio") || string.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = string;
        }
        if (string2 != null) {
            Lst lst = new Lst();
            lst.addLast((Object)this.spaceGroup.operations[0]);
            for (int i = 1; i < this.spaceGroup.operationCount; ++i) {
                if (!string2.contains(" " + (i + 1) + " ")) continue;
                lst.addLast((Object)this.spaceGroup.operations[i]);
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, string + " *(" + string2.trim() + ")", lst);
        }
        this.spaceGroup.setFinalOperations(p3Array, n, n2, bl);
    }

    public M4 getSpaceGroupOperation(int n) {
        return n >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[n] : this.spaceGroup.finalOperations[n]);
    }

    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.getXyz(n, bl);
    }

    public void newSpaceGroupPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(p3, p32, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(p3, p32, n2, n3, n4);
    }

    public V3[] rotateAxes(int n, V3[] v3Array, P3 p3, M3 m3) {
        return n == 0 ? v3Array : this.spaceGroup.finalOperations[n].rotateAxes(v3Array, this.unitCell, p3, m3);
    }

    public String getSpaceGroupOperationCode(int n) {
        return this.spaceGroup.operations[n].subsystemCode;
    }

    public void setTimeReversal(int n, int n2) {
        this.spaceGroup.operations[n].setTimeReversal(n2);
    }

    public float getSpinOp(int n) {
        return this.spaceGroup.operations[n].getSpinOp();
    }

    public boolean addLatticeVectors(Lst<float[]> lst) {
        return this.spaceGroup.addLatticeVectors(lst);
    }

    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    public Matrix getOperationRsVs(int n) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[n].rsvs;
    }

    public int getSiteMultiplicity(P3 p3) {
        return this.spaceGroup.getSiteMultiplicity(p3, this.unitCell);
    }

    public String addOp(String string, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.spaceGroup.isSSG = true;
        String string2 = SymmetryOperation.getXYZFromRsVs(matrix, matrix2, false);
        int n = this.spaceGroup.addSymmetry(string2, -1, true);
        this.spaceGroup.operations[n].setSigma(string, matrix3);
        return string2;
    }

    public String getMatrixFromString(String string, float[] fArray, boolean bl, int n) {
        return SymmetryOperation.getMatrixFromString(null, string, fArray, bl);
    }

    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    public String getSymmetryInfoStr() {
        return this.symmetryInfo.infoStr;
    }

    public M4[] getSymmetryOperations() {
        return this.symmetryInfo == null ? this.spaceGroup.finalOperations : this.symmetryInfo.symmetryOperations;
    }

    public boolean isPeriodic() {
        return this.symmetryInfo == null ? false : this.symmetryInfo.isPeriodic();
    }

    public void setSymmetryInfo(int n, Map<String, Object> map, float[] fArray) {
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray2 = this.symmetryInfo.setSymmetryInfo(map, fArray);
        if (fArray2 == null) {
            return;
        }
        this.setUnitCell(fArray2, map.containsKey("jmolData"));
        this.unitCell.moreInfo = (Lst)map.get("moreUnitCellInfo");
        map.put("infoUnitCell", this.getUnitCellAsArray(false));
        this.setOffsetPt((T3)((P3)map.get("unitCellOffset")));
        M3 m3 = (M3)map.get("matUnitCellOrientation");
        if (m3 != null) {
            this.initializeOrientation(m3);
        }
        if (Logger.debugging) {
            Logger.debug((String)("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true)));
        }
    }

    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public boolean checkUnitCell(SymmetryInterface symmetryInterface, P3 p3, P3 p32, boolean bl) {
        symmetryInterface.toFractional((T3)p32, bl);
        float f = 0.02f;
        return p32.x >= p3.x - 1.0f - f && p32.x <= p3.x + f && p32.y >= p3.y - 1.0f - f && p32.y <= p3.y + f && p32.z >= p3.z - 1.0f - f && p32.z <= p3.z + f;
    }

    public void setUnitCell(float[] fArray, boolean bl) {
        this.unitCell = UnitCell.newA(fArray, bl);
    }

    public boolean unitCellEquals(SymmetryInterface symmetryInterface) {
        return ((Symmetry)symmetryInterface).unitCell.isSameAs(this.unitCell);
    }

    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    public void initializeOrientation(M3 m3) {
        this.unitCell.initOrientation(m3);
    }

    public void unitize(P3 p3) {
        this.unitCell.unitize(p3);
    }

    public void toUnitCell(P3 p3, P3 p32) {
        this.unitCell.toUnitCell(p3, p32);
    }

    public void toCartesian(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toCartesian(t3, bl);
        }
    }

    public P3 toSupercell(P3 p3) {
        return this.unitCell.toSupercell(p3);
    }

    public void toFractional(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toFractional(t3, bl);
        }
    }

    public float[] getNotionalUnitCell() {
        return this.unitCell.getNotionalUnitCell();
    }

    public float[] getUnitCellAsArray(boolean bl) {
        return this.unitCell.getUnitCellAsArray(bl);
    }

    public Tensor getTensor(Viewer viewer, float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.newA(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true);
        }
        return this.unitCell.getTensor(viewer, fArray);
    }

    public P3[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    public void setOffsetPt(T3 t3) {
        this.unitCell.setOffset(t3);
    }

    public void setOffset(int n) {
        P3 p3 = new P3();
        SimpleUnitCell.ijkToPoint3f((int)n, (P3)p3, (int)0);
        this.unitCell.setOffset((T3)p3);
    }

    public P3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    public P3[] getCanonicalCopy(float f, boolean bl) {
        return this.unitCell.getCanonicalCopy(f, bl);
    }

    public float getUnitCellInfoType(int n) {
        return this.unitCell.getInfo(n);
    }

    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    public void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        this.unitCell.setMinMaxLatticeParameters(p3i, p3i2);
    }

    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        return this.unitCell.checkDistance(p3, p32, f, f2, n, n2, n3, p33);
    }

    public V3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    public SymmetryInterface getUnitCell(T3[] t3Array, boolean bl, String string) {
        this.unitCell = UnitCell.newP(t3Array, bl);
        if (string != null) {
            this.unitCell.name = string;
        }
        return this;
    }

    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    public BS notInCentroid(ModelSet modelSet, BS bS, int[] nArray) {
        try {
            BS bS2 = new BS();
            int n = bS.nextSetBit(0);
            JmolMolecule[] jmolMoleculeArray = modelSet.getMolecules();
            int n2 = jmolMoleculeArray.length;
            Atom[] atomArray = modelSet.at;
            boolean bl = jmolMoleculeArray[n2 - 1].firstAtomIndex == modelSet.am[atomArray[n].mi].firstAtomIndex;
            P3 p3 = new P3();
            boolean bl2 = nArray[6] == 1;
            int n3 = n2;
            block2: while (--n3 >= 0 && bS.get(jmolMoleculeArray[n3].firstAtomIndex)) {
                BS bS3 = jmolMoleculeArray[n3].atomList;
                p3.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                int n5 = bS3.nextSetBit(0);
                while (n5 >= 0) {
                    if (bl || bl2) {
                        p3.setT((T3)atomArray[n5]);
                        if (this.isNotCentroid(p3, 1, nArray, bl2)) {
                            if (bl) {
                                bS2.set(n5);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        p3.add((T3)atomArray[n5]);
                        ++n4;
                    }
                    n5 = bS3.nextSetBit(n5 + 1);
                }
                if (!bl2 && (n4 <= 0 || !this.isNotCentroid(p3, n4, nArray, false))) continue;
                bS2.or(bS3);
            }
            return bS2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 p3, int n, int[] nArray, boolean bl) {
        p3.scale(1.0f / (float)n);
        this.toFractional((T3)p3, false);
        if (bl) {
            return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x - 5.0E-6f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y - 5.0E-6f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z - 5.0E-6f > (float)nArray[5];
        }
        return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x + 5.0E-5f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y + 5.0E-5f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z + 5.0E-5f > (float)nArray[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        return this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface((String)"org.jmol.symmetry.SymmetryDesc", (Viewer)modelSet.vwr, (String)"eval")) : this.desc;
    }

    public Object getSymmetryInfoAtom(ModelSet modelSet, BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        return this.getDesc(modelSet).getSymmetryInfoAtom(bS, string, n, p3, p32, string2, n2, modelSet);
    }

    public String getSymmetryInfoString(ModelSet modelSet, int n, int n2, P3 p3, P3 p32, String string, String string2) {
        return this.getDesc(modelSet).getSymmetryInfoString(this, n, n2, p3, p32, string, string2, modelSet);
    }

    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String string) {
        return this.getDesc(modelSet).getSpaceGroupInfo(this, -1, string, 0, null, null, null, modelSet);
    }

    public Object getSymmetryInfo(ModelSet modelSet, int n, int n2, SymmetryInterface symmetryInterface, String string, int n3, P3 p3, P3 p32, String string2, int n4) {
        return this.getDesc(modelSet).getSymmetryInfo(this, n, n2, (Symmetry)symmetryInterface, string, n3, p3, p32, string2, n4, modelSet);
    }

    public String fcoord(T3 t3) {
        return SymmetryOperation.fcoord(t3);
    }

    public T3[] getV0abc(Object object) {
        M4 m4;
        Object object2;
        Object object3;
        if (this.unitCell == null) {
            return null;
        }
        boolean bl = false;
        if (object instanceof String) {
            object3 = (V3[])object;
            if (object3.indexOf(";") < 0) {
                object3 = (String)object3 + ";0,0,0";
            }
            if (bl = object3.startsWith("!")) {
                object3 = object3.substring(1);
            }
            object2 = new Symmetry();
            ((Symmetry)object2).setSpaceGroup(false);
            int n = ((Symmetry)object2).addSpaceGroupOperation("=" + (String)object3, 0);
            if (n < 0) {
                return null;
            }
            m4 = ((Symmetry)object2).getSpaceGroupOperation(n);
            ((SymmetryOperation)m4).doFinalize();
        } else {
            m4 = object instanceof M3 ? M4.newMV((M3)((M3)object), (T3)new P3()) : (M4)object;
        }
        object3 = new V3[4];
        object2 = new P3();
        M3 m3 = new M3();
        m4.getRotationScale(m3);
        m4.getTranslation((T3)object2);
        if (bl) {
            m3.invert();
            m3.transpose();
            m3.rotate((T3)object2);
            object2.scale(-1.0f);
        } else {
            m3.transpose();
        }
        this.unitCell.toCartesian((T3)object2, false);
        object3[0] = V3.newV((T3)object2);
        object3[1] = V3.new3((float)1.0f, (float)0.0f, (float)0.0f);
        object3[2] = V3.new3((float)0.0f, (float)1.0f, (float)0.0f);
        object3[3] = V3.new3((float)0.0f, (float)0.0f, (float)1.0f);
        for (int i = 1; i < 4; ++i) {
            m3.rotate((T3)object3[i]);
            this.unitCell.toCartesian((T3)object3[i], true);
        }
        return object3;
    }

    public Quat getQuaternionRotation(String string) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(string);
    }

    public T3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }
}

