/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.T3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.java.BS;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.util.C;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class NucleicRenderer {
    private boolean renderEdges;
    private boolean ladderOnly;
    private boolean renderRibose;
    private P3[] rPt;
    private P3[] rPt5;
    private P3i[] rScr;
    private P3i[] rScr5;
    private P3 basePt;
    private P3 backbonePt;
    private P3i baseScreen;
    private P3i backboneScreen;
    private Viewer vwr;
    private TransformManager tm;
    private JmolRendererInterface g3d;
    private BioShapeRenderer bsr;
    private short colix;

    void renderNucleic(BioShapeRenderer bioShapeRenderer) {
        if (this.vwr == null) {
            this.rPt = new P3[10];
            this.rScr = new P3i[10];
            this.rPt5 = new P3[5];
            this.rScr5 = new P3i[5];
            this.backboneScreen = new P3i();
            this.backbonePt = new P3();
            this.bsr = bioShapeRenderer;
            this.tm = bioShapeRenderer.vwr.tm;
            this.vwr = bioShapeRenderer.vwr;
        }
        this.g3d = bioShapeRenderer.g3d;
        P3i[] p3iArray = bioShapeRenderer.controlPointScreens;
        P3[] p3Array = bioShapeRenderer.controlPoints;
        this.renderEdges = this.vwr.getBoolean(603979816);
        this.ladderOnly = this.vwr.getBoolean(603979818);
        this.renderRibose = this.vwr.getBoolean(603979819);
        boolean bl = this.vwr.getBoolean(603979966);
        BS bS = this.bsr.bsVisible;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                this.backboneScreen.set((p3iArray[n].x + p3iArray[n + 1].x) / 2, (p3iArray[n].y + p3iArray[n + 1].y) / 2, (p3iArray[n].z + p3iArray[n + 1].z) / 2);
                this.backbonePt.ave((T3)p3Array[n], (T3)p3Array[n + 1]);
            } else {
                this.backboneScreen.setT((T3i)p3iArray[n + 1]);
                this.backbonePt.setT((T3)p3Array[n + 1]);
            }
            this.bsr.renderHermiteConic(n, false, 4);
            this.colix = this.bsr.getLeadColix(n);
            if (this.bsr.setBioColix(this.colix)) {
                this.renderNucleicBaseStep(n);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private void renderNucleicBaseStep(int n) {
        P3 p3;
        P3i p3i;
        boolean bl;
        NucleicMonomer nucleicMonomer = (NucleicMonomer)this.bsr.monomers[n];
        int n2 = this.bsr.mads[n];
        if (this.rScr[0] == null) {
            int n3 = 10;
            while (--n3 >= 0) {
                this.rScr[n3] = new P3i();
            }
            n3 = 5;
            while (--n3 >= 0) {
                this.rScr5[n3] = new P3i();
            }
            this.baseScreen = new P3i();
            this.basePt = new P3();
            this.rPt[9] = new P3();
        }
        if (this.renderEdges) {
            this.renderLeontisWesthofEdges(nucleicMonomer);
            return;
        }
        nucleicMonomer.getBaseRing6Points(this.rPt);
        this.vwr.tm.transformPoints(6, (T3[])this.rPt, this.rScr);
        if (!this.ladderOnly) {
            this.renderRing6();
        }
        if (bl = nucleicMonomer.maybeGetBaseRing5Points(this.rPt5)) {
            if (this.ladderOnly) {
                p3i = this.rScr[2];
                p3 = this.rPt[2];
            } else {
                this.tm.transformPoints(5, (T3[])this.rPt5, this.rScr5);
                this.renderRing5();
                p3i = this.rScr5[3];
                p3 = this.rPt5[3];
            }
        } else {
            int n4 = this.ladderOnly ? 4 : 2;
            p3i = this.rScr[n4];
            p3 = this.rPt[n4];
        }
        short s = (short)(n2 > 1 ? n2 / 2 : n2);
        float f = (float)s / 2000.0f;
        int n5 = (int)this.vwr.tm.scaleToScreen(this.backboneScreen.z, (int)s);
        if (this.ladderOnly || !this.renderRibose) {
            this.g3d.fillCylinderScreen3I((byte)3, n5, this.backboneScreen, p3i, this.backbonePt, p3, f);
        }
        if (this.ladderOnly) {
            return;
        }
        this.drawEdges(this.rScr, this.rPt, 6);
        if (bl) {
            this.drawEdges(this.rScr5, this.rPt5, 5);
        } else {
            this.renderEdge(this.rScr, this.rPt, 0, 5);
        }
        if (this.renderRibose) {
            this.baseScreen.setT((T3i)p3i);
            this.basePt.setT((T3)p3);
            nucleicMonomer.getRiboseRing5Points(this.rPt);
            P3 p32 = this.rPt[9];
            p32.set(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < 5; ++i) {
                p32.add((T3)this.rPt[i]);
            }
            p32.scale(0.2f);
            this.tm.transformPoints(10, (T3[])this.rPt, this.rScr);
            this.renderRibose();
            this.renderEdge(this.rScr, this.rPt, 2, 5);
            this.renderEdge(this.rScr, this.rPt, 3, 6);
            this.renderEdge(this.rScr, this.rPt, 6, 7);
            this.renderEdge(this.rScr, this.rPt, 7, 8);
            this.renderCyl(this.rScr[0], this.baseScreen, this.rPt[0], this.basePt);
            this.drawEdges(this.rScr, this.rPt, 5);
        }
    }

    private void drawEdges(P3i[] p3iArray, P3[] p3Array, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            --p3iArray[n2].z;
        }
        n2 = n;
        while (--n2 > 0) {
            this.renderEdge(p3iArray, p3Array, n2, n2 - 1);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleicMonomer) {
        if (!nucleicMonomer.getEdgePoints(this.rPt)) {
            return;
        }
        this.tm.transformPoints(6, (T3[])this.rPt, this.rScr);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, true);
        this.renderEdge(this.rScr, this.rPt, 0, 1);
        this.renderEdge(this.rScr, this.rPt, 1, 2);
        boolean bl = C.isColixTranslucent((short)this.colix);
        float f = C.getColixTranslucencyLevel((short)this.colix);
        short s = C.getColixTranslucent3((short)10, (boolean)bl, (float)f);
        short s2 = C.getColixTranslucent3((short)11, (boolean)bl, (float)f);
        short s3 = C.getColixTranslucent3((short)7, (boolean)bl, (float)f);
        this.g3d.setC(s);
        this.renderEdge(this.rScr, this.rPt, 2, 3);
        this.g3d.setC(s2);
        this.renderEdge(this.rScr, this.rPt, 3, 4);
        this.g3d.setC(s3);
        this.renderEdge(this.rScr, this.rPt, 4, 5);
    }

    private void renderEdge(P3i[] p3iArray, P3[] p3Array, int n, int n2) {
        this.renderCyl(p3iArray[n], p3iArray[n2], p3Array[n], p3Array[n2]);
    }

    private void renderCyl(P3i p3i, P3i p3i2, P3 p3, P3 p32) {
        this.g3d.fillCylinderScreen3I((byte)3, 3, p3i, p3i2, p3, p32, 0.005f);
    }

    private void renderTriangle(P3i[] p3iArray, P3[] p3Array, int n, int n2, int n3, boolean bl) {
        this.g3d.fillTriangle3i(p3iArray[n], p3iArray[n2], p3iArray[n3], (T3)p3Array[n], (T3)p3Array[n2], (T3)p3Array[n3], bl);
    }

    private void renderRing6() {
        this.renderTriangle(this.rScr, this.rPt, 0, 2, 4, true);
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 2, false);
        this.renderTriangle(this.rScr, this.rPt, 0, 4, 5, false);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, false);
    }

    private void renderRing5() {
        this.renderTriangle(this.rScr5, this.rPt5, 0, 1, 2, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 2, 3, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 3, 4, false);
    }

    private void renderRibose() {
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 1, 2, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 3, 4, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 4, 0, 9, true);
    }
}

