/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.BytePoster;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericFileInterface;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.DataReader;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolDomReaderInterface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.FileReader;
import org.jmol.io.JmolBinary;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class FileManager
implements BytePoster {
    public static String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public Viewer vwr;
    public JmolBinary jmb;
    private String pathForAllFiles = "";
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String lastFullPathName;
    private String lastNameAsGiven = "zapped";
    private String fileName;
    private URL appletDocumentBaseURL = null;
    private String appletProxy;
    public static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};
    private Map<String, Object> cache = new Hashtable<String, Object>();

    FileManager(Viewer viewer) {
        this.vwr = viewer;
        this.jmb = new JmolBinary(this);
        this.clear();
    }

    void clear() {
        this.setFileInfo(new String[]{this.vwr.getZapName()});
        this.jmb.spardirCache = null;
    }

    public void clearPngjCache(String string) {
        this.jmb.clearPngjCache(string == null ? null : this.getCanonicalName(Rdr.getZipRoot(string)));
    }

    private void setLoadState(Map<String, Object> map) {
        if (this.vwr.getPreserveState()) {
            map.put("loadState", this.vwr.g.getLoadState(map));
        }
    }

    public String getPathForAllFiles() {
        return this.pathForAllFiles;
    }

    String setPathForAllFiles(String string) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("|")) {
            string = string + "/";
        }
        this.pathForAllFiles = string;
        return this.pathForAllFiles;
    }

    public void setFileInfo(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[Math.min(1, stringArray.length - 1)];
        this.nameAsGiven = stringArray[Math.min(2, stringArray.length - 1)];
        if (!this.nameAsGiven.equals("zapped")) {
            this.lastNameAsGiven = this.nameAsGiven;
            this.lastFullPathName = this.fullPathName;
        }
    }

    public String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    public String getFullPathName(boolean bl) {
        String string;
        String string2 = string = this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
        return !bl || !string.equals("zapped") ? string : (this.lastFullPathName != null ? this.lastFullPathName : this.lastNameAsGiven);
    }

    public String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBaseURL == null ? "" : this.appletDocumentBaseURL.toString();
    }

    void setAppletContext(String string) {
        try {
            System.out.println("setting document base to \"" + string + "\"");
            this.appletDocumentBaseURL = string.length() == 0 ? null : new URL((URL)null, string, null);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("error setting document base to " + string);
        }
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    Object createAtomSetCollectionFromFile(String string, Map<String, Object> map, boolean bl) {
        int n;
        if (map.get("atomDataOnly") == null) {
            this.setLoadState(map);
        }
        String string2 = (n = (string = this.vwr.resolveDatabaseFormat(string)).indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string3 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + string2 + ")" + (string.equals(string2) ? "" : " //" + string));
        String[] stringArray = this.getClassifiedName(string2, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        map.put("fullPathName", (string3 == null ? "" : string3 + "::") + string4.replace('\\', '/'));
        if (this.vwr.getBoolean(603979880) && this.vwr.getBoolean(603979825)) {
            this.vwr.scriptStatus("Requesting " + string4);
        }
        FileReader fileReader = new FileReader(this, this.vwr, string5, string4, string2, string3, null, map, bl);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            String string = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            String string2 = n >= 0 ? stringArray[i].substring(0, n) : null;
            String[] stringArray5 = this.getClassifiedName(string, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[i] = stringArray5[0];
            stringArray[i] = stringArray5[0].replace('\\', '/');
            stringArray4[i] = string2;
            stringArray3[i] = string;
        }
        map.put("fullPathNames", stringArray2);
        map.put("fileTypes", stringArray4);
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray3, stringArray4, null, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromString(String string, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        boolean bl2 = string.indexOf("Viewer.AddHydrogens") >= 0;
        String[] stringArray = bl2 ? this.getFileInfo() : null;
        FileReader fileReader = new FileReader(this, this.vwr, "string", "string", "string", null, Rdr.getBR(string), map, bl);
        fileReader.run();
        if (stringArray != null) {
            this.setFileInfo(stringArray);
        }
        if (!bl && !(fileReader.getAtomSetCollection() instanceof String)) {
            this.vwr.zap(false, true, false);
            this.setFileInfo(new String[]{string == "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" ? "Jmol Model Kit" : "string"});
        }
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, SB sB, Map<String, Object> map, boolean bl) {
        Object object;
        String[] stringArray2;
        if (!map.containsKey("isData")) {
            stringArray2 = "\"" + this.vwr.getDataSeparator() + "\"";
            object = "\"" + (bl ? "append" : "model") + " inline\"";
            SB sB2 = new SB();
            sB2.append("set dataSeparator \"~~~next file~~~\";\ndata ").append((String)object);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    sB2.append("~~~next file~~~");
                }
                sB2.append(stringArray[i]);
            }
            sB2.append("end ").append((String)object).append(";set dataSeparator ").append((String)stringArray2);
            sB.appendSB(sB2);
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        stringArray2 = new String[stringArray.length];
        object = new DataReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            object[i] = FileManager.newDataReader(this.vwr, stringArray[i]);
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray2, null, (DataReader[])object, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromArrayData(Lst<Object> lst, Map<String, Object> map, boolean bl) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        int n = lst.size();
        String[] stringArray = new String[n];
        DataReader[] dataReaderArray = new DataReader[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "String[" + i + "]";
            dataReaderArray[i] = FileManager.newDataReader(this.vwr, lst.get(i));
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray, stringArray, null, dataReaderArray, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    static DataReader newDataReader(Viewer viewer, Object object) {
        String string;
        String string2 = object instanceof String ? "String" : (PT.isAS(object) ? "Array" : (string = object instanceof Lst ? "List" : null));
        if (string == null) {
            return null;
        }
        DataReader dataReader = (DataReader)Interface.getInterface("javajs.util." + string + "DataReader", viewer, "file");
        return dataReader.setData(object);
    }

    private JmolFilesReaderInterface newFilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        JmolFilesReaderInterface jmolFilesReaderInterface = (JmolFilesReaderInterface)Interface.getOption("io.FilesReader", this.vwr, "file");
        jmolFilesReaderInterface.set(this, this.vwr, stringArray, stringArray2, stringArray3, dataReaderArray, map, bl);
        return jmolFilesReaderInterface;
    }

    Object createAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        JmolDomReaderInterface jmolDomReaderInterface = (JmolDomReaderInterface)Interface.getOption("io.DOMReadaer", this.vwr, "file");
        jmolDomReaderInterface.set(this, this.vwr, object, map);
        jmolDomReaderInterface.run();
        return jmolDomReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Object object, Map<String, Object> map) {
        FileReader fileReader = new FileReader(this, this.vwr, string2, string, string2, null, object, map, false);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    public Object getBufferedInputStreamOrErrorMessageFromName(String string, String string2, boolean bl, boolean bl2, byte[] byArray, boolean bl3, boolean bl4) {
        byte[] byArray2 = null;
        if (bl4 && byArray == null) {
            byte[] byArray3 = byArray2 = string2 == null || this.jmb.pngjCache == null ? null : this.jmb.getCachedPngjBytes(string2);
            if (byArray2 == null) {
                byArray2 = (byte[])this.cacheGet(string, true);
            }
        }
        BufferedInputStream bufferedInputStream = null;
        Object object = null;
        String string3 = null;
        try {
            if (byArray2 == null) {
                boolean bl5;
                int n;
                boolean bl6;
                boolean bl7 = string.indexOf("?POST?_PNGJBIN_") >= 0;
                boolean bl8 = bl6 = bl7 || string.indexOf("?POST?_PNGJ_") >= 0;
                if (string.indexOf("?POST?_PNG_") > 0 || bl6) {
                    String[] stringArray = new String[1];
                    byte[] byArray4 = this.vwr.getImageAsBytes(bl6 ? "PNGJ" : "PNG", 0, 0, -1, stringArray);
                    if (stringArray[0] != null) {
                        return stringArray[0];
                    }
                    if (bl7) {
                        byArray = byArray4;
                        string = PT.rep(string, "?_", "=_");
                    } else {
                        string = new SB().append(string).append("=").appendSB(Base64.getBase64(byArray4)).toString();
                    }
                }
                boolean bl9 = (n = OC.urlTypeIndex(string)) >= 0;
                String string4 = null;
                if (bl9 && (n = string.indexOf("?POST?")) >= 0) {
                    string4 = string.substring(n + 6);
                    string = string.substring(0, n);
                }
                boolean bl10 = bl5 = this.appletDocumentBaseURL != null;
                if (bl4 && string.indexOf(".png") >= 0 && this.jmb.pngjCache == null && this.vwr.cachePngFiles()) {
                    this.jmb.clearAndCachePngjFile(null);
                }
                if (bl5 || bl9) {
                    URL uRL;
                    if (bl5 && bl9 && this.appletProxy != null) {
                        string = this.appletProxy + "?url=" + this.urlEncode(string);
                    }
                    URL uRL2 = uRL = bl5 ? new URL(this.appletDocumentBaseURL, string, null) : new URL((URL)null, string, null);
                    if (bl2) {
                        return null;
                    }
                    string = uRL.toString();
                    if (bl && string.toLowerCase().indexOf("password") < 0) {
                        Logger.info("FileManager opening 1 " + string);
                    }
                    object = this.vwr.apiPlatform.getURLContents(uRL, byArray, string4, false);
                    byte[] byArray5 = null;
                    if (object instanceof SB) {
                        SB sB = (SB)object;
                        if (bl3 && !Rdr.isBase64(sB)) {
                            return Rdr.getBR(sB.toString());
                        }
                        byArray5 = Rdr.getBytesFromSB(sB);
                    } else if (PT.isAB(object)) {
                        byArray5 = (byte[])object;
                    }
                    if (byArray5 != null) {
                        object = Rdr.getBIS(byArray5);
                    }
                } else if (!bl4 || (byArray2 = (byte[])this.cacheGet(string, true)) == null) {
                    if (bl) {
                        Logger.info("FileManager opening 2 " + string);
                    }
                    object = this.vwr.apiPlatform.getBufferedFileInputStream(string);
                }
                if (object instanceof String) {
                    return object;
                }
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = byArray2 == null ? (BufferedInputStream)object : Rdr.getBIS(byArray2);
            if (bl2) {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            return bufferedInputStream;
        }
        catch (Exception exception) {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string3 = "" + exception;
            return string3;
        }
    }

    private String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public String getEmbeddedFileState(String string, boolean bl) {
        String[] stringArray = null;
        stringArray = this.getZipDirectory(string, false, bl);
        if (stringArray.length == 0) {
            String string2 = this.vwr.getFileAsString4(string, -1, false, true, false, "file");
            return string2.indexOf("**** Jmol Embedded Script ****") < 0 ? "" : JmolBinary.getEmbeddedScript(string2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".spt") < 0) continue;
            String[] stringArray2 = new String[]{string + "|" + stringArray[i], null};
            this.getFileDataAsString(stringArray2, -1, false, false, false);
            return stringArray2[1];
        }
        return "";
    }

    Object getFullPathNameOrError(String string, boolean bl, String[] stringArray) {
        String[] stringArray2 = this.getClassifiedName(string, true);
        if (stringArray2 == null || stringArray2[0] == null || stringArray2.length < 2) {
            return new String[]{null, "cannot read file name: " + string};
        }
        String string2 = stringArray2[0];
        String string3 = stringArray2[0].replace('\\', '/');
        string2 = Rdr.getZipRoot(string2);
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string2, string3, false, !bl, null, false, !bl);
        stringArray[0] = string3;
        if (object instanceof String) {
            stringArray[1] = (String)object;
        }
        return object;
    }

    public Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        byte[] byArray;
        Object object = this.cacheGet(string, false);
        boolean bl3 = PT.isAB(object);
        byte[] byArray2 = byArray = bl3 ? (byte[])object : null;
        if (string.startsWith("cache://")) {
            if (object == null) {
                return "cannot read " + string;
            }
            if (bl3) {
                byArray = (byte[])object;
            } else {
                return Rdr.getBR((String)object);
            }
        }
        if ((stringArray2 = this.getClassifiedName(string, true)) == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedReaderOrStreamFromName(stringArray2[0], byArray, false, bl, false, bl2, null);
    }

    public Object getUnzippedReaderOrStreamFromName(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) {
        String[] stringArray = null;
        String[] stringArray2 = byArray == null && bl4 ? this.getSpartanFileList(string) : null;
        String string2 = string;
        if (stringArray2 != null) {
            if (bl3) {
                return stringArray2;
            }
            if (stringArray2[2] != null) {
                String string3;
                Object object;
                String string4 = stringArray2[1];
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (stringArray2.length == 3) {
                    object = this.getObjectAsSections(stringArray2[2], string4, hashtable);
                    hashtable.put("OUTPUT", (String)object);
                    stringArray2 = this.jmb.spartanFileList(string, (String)hashtable.get(object));
                    if (stringArray2.length == 3) {
                        object = this.getObjectAsSections(stringArray2[2], string4, hashtable);
                        hashtable.put("OUTPUT", (String)object);
                        stringArray2 = this.jmb.spartanFileList(stringArray2[1], (String)hashtable.get(object));
                    }
                }
                object = new SB();
                if (hashtable.get("OUTPUT") != null) {
                    ((SB)object).append((String)hashtable.get(hashtable.get("OUTPUT")));
                }
                for (int i = 2; i < stringArray2.length; ++i) {
                    string = stringArray2[i];
                    string = this.getObjectAsSections(string, string4, hashtable);
                    Logger.info("reading " + string);
                    string3 = (String)hashtable.get(string);
                    ((SB)object).append(string3);
                }
                string3 = ((SB)object).toString();
                this.jmb.spardirPut(string2.replace('\\', '/'), string3.getBytes());
                return Rdr.getBR(string3);
            }
        }
        if (byArray == null && this.jmb.pngjCache != null && (byArray = this.jmb.getCachedPngjBytes(string)) != null && map != null) {
            map.put("sourcePNGJ", Boolean.TRUE);
        }
        String string5 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string.replace('\\', '/'), "|");
            if (byArray == null) {
                Logger.info("FileManager opening 3 " + string);
            }
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = byArray == null ? this.getBufferedInputStreamOrErrorMessageFromName(string, string5, true, false, null, !bl2, true) : Rdr.getBIS(byArray);
        try {
            if (bufferedInputStream instanceof String) {
                return bufferedInputStream;
            }
            if (bufferedInputStream instanceof BufferedReader) {
                return bufferedInputStream;
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (Rdr.isGzipS(bufferedInputStream2)) {
                bufferedInputStream2 = Rdr.getUnzippedInputStream(this.vwr.getJzt(), bufferedInputStream2);
            }
            if (Rdr.isCompoundDocumentS(bufferedInputStream2)) {
                GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)Interface.getInterface("javajs.util.CompoundDocument", this.vwr, "file");
                genericBinaryDocument.setStream(this.vwr.getJzt(), bufferedInputStream2, true);
                return Rdr.getBR(genericBinaryDocument.getAllDataFiles("Molecule", "Input").toString());
            }
            if (Rdr.isPickleS(bufferedInputStream2)) {
                return bufferedInputStream2;
            }
            if (Rdr.isZipS(bufferedInputStream2 = Rdr.getPngZipStream(bufferedInputStream2, true))) {
                if (bl) {
                    return Rdr.newZipInputStream(this.vwr.getJzt(), bufferedInputStream2);
                }
                Object object = Rdr.getZipFileDirectory(this.vwr.getJzt(), bufferedInputStream2, stringArray, 1, bl2);
                return object instanceof String ? Rdr.getBR((String)object) : object;
            }
            return bl2 ? bufferedInputStream2 : Rdr.getBufferedReader(bufferedInputStream2, null);
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private String[] getSpartanFileList(String string) {
        if (string.endsWith(".spt")) {
            return new String[]{null, null, null};
        }
        if (string.endsWith(".spardir.zip")) {
            return new String[]{"SpartanSmol", "Directory Entry ", string + "|output"};
        }
        if (!(string = string.replace('\\', '/')).endsWith(".spardir") && string.indexOf(".spardir/") < 0) {
            return null;
        }
        int n = string.lastIndexOf(".spardir");
        if (n < 0) {
            return null;
        }
        if (string.lastIndexOf("/") > n) {
            return new String[]{"SpartanSmol", "Directory Entry ", string + "/input", string + "/archive", string + "/Molecule:asBinaryString", string + "/proparc"};
        }
        return new String[]{"SpartanSmol", "Directory Entry ", string + "/output"};
    }

    private String getObjectAsSections(String string, String string2, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        SB sB = null;
        if (map.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            map.put(string3, string3 + "\n");
            return string3;
        }
        String string4 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string4, false, false, null, false, true);
            if (object instanceof String) {
                map.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = (BufferedInputStream)object;
            if (Rdr.isCompoundDocumentS(bufferedInputStream)) {
                GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)Interface.getInterface("javajs.util.CompoundDocument", this.vwr, "file");
                genericBinaryDocument.setStream(this.vwr.getJzt(), bufferedInputStream, true);
                genericBinaryDocument.getAllDataMapped(string.replace('\\', '/'), "Molecule", map);
            } else if (Rdr.isZipS(bufferedInputStream)) {
                Rdr.getAllZipData(this.vwr.getJzt(), bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", map);
            } else if (bl) {
                GenericBinaryDocument genericBinaryDocument = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file");
                genericBinaryDocument.setStream(this.vwr.getJzt(), bufferedInputStream, false);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        sB.append(Integer.toHexString(genericBinaryDocument.readByte() & 0xFF)).appendC(' ');
                    }
                }
                catch (Exception exception) {
                    sB.appendC('\n');
                    if (string2 != null) {
                        sB.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    map.put(string3, sB.toString());
                }
            } else {
                String string5;
                BufferedReader bufferedReader = Rdr.getBufferedReader(Rdr.isGzipS(bufferedInputStream) ? new BufferedInputStream(Rdr.newGZIPInputStream(this.vwr.getJzt(), bufferedInputStream)) : bufferedInputStream, null);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string5 = bufferedReader.readLine()) != null) {
                    sB.append(string5);
                    sB.appendC('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    sB.append("\nEND Directory Entry " + string3 + "\n");
                }
                map.put(string3, sB.toString());
            }
        }
        catch (Exception exception) {
            map.put(string3, exception.toString());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!map.containsKey(string3)) {
            map.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    public String[] getZipDirectory(String string, boolean bl, boolean bl2) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null, false, bl2);
        return Rdr.getZipDirectoryAndClose(this.vwr.getJzt(), (BufferedInputStream)object, bl ? "JmolManifest" : null);
    }

    public Object getFileAsBytes(String string, OC oC) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = string;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getBufferedInputStreamOrErrorMessageFromName(string, string2, false, false, null, false, true)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
            Object object2 = oC != null || stringArray == null || stringArray.length <= 1 || !Rdr.isZipS(bufferedInputStream) && !Rdr.isPngZipStream(bufferedInputStream) ? Rdr.getStreamAsBytes(bufferedInputStream, oC) : Rdr.getZipFileContentsAsBytes(this.vwr.getJzt(), bufferedInputStream, stringArray, 1);
            bufferedInputStream.close();
            return object2;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public Map<String, Object> getFileAsMap(String string) {
        Object object;
        String[] stringArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string == null) {
            stringArray = new String[1];
            byte[] byArray = this.vwr.getImageAsBytes("PNGJ", -1, -1, -1, stringArray);
            if (stringArray[0] != null) {
                hashtable.put("_ERROR_", stringArray[0]);
                return hashtable;
            }
            object = Rdr.getBIS(byArray);
        } else {
            stringArray = new String[2];
            object = this.getFullPathNameOrError(string, true, stringArray);
            if (object instanceof String) {
                hashtable.put("_ERROR_", object);
                return hashtable;
            }
            if (!this.checkSecurity(stringArray[0])) {
                hashtable.put("_ERROR_", "java.io. Security exception: cannot read file " + stringArray[0]);
                return hashtable;
            }
        }
        try {
            Rdr.readFileAsMap(this.vwr.getJzt(), (BufferedInputStream)object, hashtable, string);
        }
        catch (Exception exception) {
            hashtable.clear();
            hashtable.put("_ERROR_", "" + exception);
        }
        return hashtable;
    }

    public boolean getFileDataAsString(String[] stringArray, int n, boolean bl, boolean bl2, boolean bl3) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        if (bl3 && !this.checkSecurity(stringArray[0])) {
            stringArray[1] = "java.io. Security exception: cannot read file " + stringArray[0];
            return false;
        }
        try {
            return Rdr.readAllAsString((BufferedReader)object, n, bl2, stringArray, 1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkSecurity(String string) {
        if (!string.startsWith("file:")) {
            return true;
        }
        int n = string.lastIndexOf(47);
        return string.lastIndexOf(":/") != n - 1 && string.indexOf("/.") < 0 && string.lastIndexOf(46) >= string.lastIndexOf(47);
    }

    public void loadImage(Object object, String string) {
        String string2;
        Object object2 = null;
        String string3 = null;
        byte[] byArray = null;
        if (object instanceof Map) {
            object = ((Map)object).containsKey("_DATA_") ? ((Map)object).get("_DATA_") : ((Map)object).get("_IMAGE_");
        }
        if (object instanceof SV) {
            object = ((SV)object).value;
        }
        String string4 = string2 = object instanceof String ? (String)object : null;
        if (string2 != null && string2.startsWith(";base64,")) {
            byArray = Base64.decodeBase64(string2);
        } else if (object instanceof BArray) {
            byArray = ((BArray)object).data;
        } else {
            String[] stringArray = this.getClassifiedName((String)object, true);
            String string5 = string3 = stringArray == null ? "cannot read file name: " + object : stringArray[0].replace('\\', '/');
            if (stringArray != null) {
                object2 = this.jmb.getImage(this.vwr, string3, string);
            }
        }
        if (byArray != null) {
            object2 = this.jmb.getImage(this.vwr, byArray, string);
        }
        if (object2 instanceof String) {
            string3 = (String)object2;
            object2 = null;
        }
        if (!this.vwr.isJS) {
            if (object2 != null && byArray != null) {
                string3 = ";base64," + Base64.getBase64(byArray).toString();
            }
            this.vwr.loadImageData(object2, string3, string, null);
        }
    }

    private String[] getClassifiedName(String string, boolean bl) {
        int n;
        String string2;
        boolean bl2;
        if (string == null) {
            return new String[]{null};
        }
        boolean bl3 = bl2 = this.pathForAllFiles.length() > 0;
        if (string.startsWith("?") || string.startsWith("http://?")) {
            if ((string = this.vwr.dialogAsk("Load", string)) == null) {
                return new String[]{bl ? "#CANCELED#" : null};
            }
            bl2 = false;
        }
        GenericFileInterface genericFileInterface = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.startsWith("cache://")) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = string;
            stringArray[1] = FileManager.stripPath(stringArray[0]);
            return stringArray;
        }
        if ((string = this.vwr.resolveDatabaseFormat(string)).indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.vwr.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBaseURL == null) {
            if (OC.urlTypeIndex(string) >= 0 || this.vwr.haveAccess(Viewer.ACCESS.NONE) || this.vwr.haveAccess(Viewer.ACCESS.READSPT) && !string.endsWith(".spt") && !string.endsWith("/")) {
                try {
                    uRL = new URL((URL)null, string, null);
                }
                catch (MalformedURLException malformedURLException) {
                    return new String[]{bl ? malformedURLException.toString() : null};
                }
            } else {
                genericFileInterface = this.vwr.apiPlatform.newFile(string);
                string2 = genericFileInterface.getFullPath();
                String string3 = genericFileInterface.getName();
                stringArray = new String[]{string2 == null ? string3 : string2, string3, string2 == null ? string3 : "file:/" + string2.replace('\\', '/')};
            }
        } else {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBaseURL, string, null);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.toString() : null};
            }
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = FileManager.stripPath(stringArray[0]);
        }
        if (bl2) {
            string2 = stringArray[0];
            stringArray[0] = this.pathForAllFiles + stringArray[1];
            Logger.info("FileManager substituting " + string2 + " --> " + stringArray[0]);
        }
        if (bl && (genericFileInterface != null || OC.urlTypeIndex(stringArray[0]) == 4) && (n = (string2 = genericFileInterface == null ? PT.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.vwr, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuilder.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuilder.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.getClassifiedName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return string == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = PT.rep(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return PT.rep(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFilePath(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.getClassifiedName(string, false);
        return stringArray == null || stringArray.length == 1 ? "" : (bl2 ? stringArray[1] : (bl ? stringArray[2] : (stringArray[0] == null ? "" : stringArray[0].replace('\\', '/'))));
    }

    public static GenericFileInterface getLocalDirectory(Viewer viewer, boolean bl) {
        String string = (String)viewer.getP(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (bl && string.length() == 0) {
            string = (String)viewer.getP("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return viewer.isApplet ? null : viewer.apiPlatform.newFile(System.getProperty("user.dir", "."));
        }
        if (viewer.isApplet && string.indexOf("file:/") == 0) {
            string = string.substring(6);
        }
        GenericFileInterface genericFileInterface = viewer.apiPlatform.newFile(string);
        try {
            return genericFileInterface.isDirectory() ? genericFileInterface : genericFileInterface.getParentAsFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setLocalPath(Viewer viewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        viewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            viewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(Viewer viewer, String string) {
        if (string.startsWith("http://")) {
            return string;
        }
        if ((string = PT.rep(string, "?", "")).indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        GenericFileInterface genericFileInterface = null;
        try {
            genericFileInterface = FileManager.getLocalDirectory(viewer, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return genericFileInterface == null ? string : FileManager.fixPath(genericFileInterface.toString() + "/" + string);
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileRefs(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileRefs(string, string3, false);
        }
        string = PT.rep(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            for (int i = 0; i < scriptFilePrefixes.length; ++i) {
                String string5 = scriptFilePrefixes[i];
                string = PT.rep(string, string5 + ".", string5 + string4);
            }
        }
        return string;
    }

    private static String setScriptFileRefs(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        Lst<String> lst = new Lst<String>();
        JmolBinary.getFileReferences(string, lst);
        Lst<String> lst2 = new Lst<String>();
        Lst<String> lst3 = new Lst<String>();
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)lst.get(i);
            String string4 = string3;
            if (bl == OC.isLocal(string4)) {
                int n2;
                int n3 = n2 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n2 >= 0) {
                    string4 = string4.substring(n2 + 1);
                } else {
                    n2 = string4.lastIndexOf("/");
                    if (n2 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n2 < 0 || bl2) {
                        ++n2;
                    }
                    string4 = string2 + string4.substring(n2);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            lst2.addLast("\"" + string3 + "\"");
            lst3.addLast("\u0001\"" + string4 + "\"");
        }
        return PT.replaceStrings(string, lst2, lst3);
    }

    public static String stripPath(String string) {
        int n = Math.max(string.lastIndexOf("|"), string.lastIndexOf("/"));
        return string.substring(n + 1);
    }

    public static String fixFileNameVariables(String string, String string2) {
        String string3 = PT.rep(string, "%FILE", string2);
        if (string3.indexOf("%LC") < 0) {
            return string3;
        }
        string2 = string2.toLowerCase();
        string3 = PT.rep(string3, "%LCFILE", string2);
        if (string2.length() == 4) {
            string3 = PT.rep(string3, "%LC13", string2.substring(1, 3));
        }
        return string3;
    }

    void cachePut(String string, Object object) {
        string = string.replace('\\', '/');
        if (Logger.debugging) {
            Logger.debug("cachePut " + string);
        }
        if (object == null || "".equals(object)) {
            this.cache.remove(string);
            return;
        }
        this.cache.put(string, object);
        this.jmb.getCachedPngjBytes(string);
    }

    public Object cacheGet(String string, boolean bl) {
        int n = (string = string.replace('\\', '/')).indexOf("|");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = this.getFilePath(string, true, false);
        Object object = null;
        Logger.info("cacheGet " + string + " " + this.cache.containsKey(string));
        object = this.cache.get(string);
        return bl && object instanceof String ? null : object;
    }

    void cacheClear() {
        Logger.info("cache cleared");
        this.cache.clear();
        this.clearPngjCache(null);
    }

    public int cacheFileByNameAdd(String string, boolean bl) {
        Object object;
        if (string == null || !bl && string.equalsIgnoreCase("")) {
            this.cacheClear();
            return -1;
        }
        if (bl) {
            object = this.getFileAsBytes(string = this.vwr.resolveDatabaseFormat(string), null);
            if (object instanceof String) {
                return 0;
            }
            this.cachePut(string, object);
        } else {
            if (string.endsWith("*")) {
                return AU.removeMapKeys(this.cache, string.substring(0, string.length() - 1));
            }
            object = this.cache.remove(string.replace('\\', '/'));
        }
        return object == null ? 0 : (object instanceof String ? ((String)object).length() : ((byte[])object).length);
    }

    public Map<String, Integer> cacheList() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (Map.Entry<String, Object> entry : this.cache.entrySet()) {
            hashtable.put(entry.getKey(), PT.isAB(entry.getValue()) ? ((byte[])entry.getValue()).length : entry.getValue().toString().length());
        }
        return hashtable;
    }

    public String getCanonicalName(String string) {
        String[] stringArray = this.getClassifiedName(string, true);
        return stringArray == null ? string : stringArray[2];
    }

    @Override
    public String postByteArray(String string, byte[] byArray) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, null, false, false, byArray, false, true);
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = Rdr.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (IOException iOException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return object == null ? "" : Rdr.fixUTF((byte[])object);
    }
}

