/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class RocketRenderer {
    private boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private V3 vtemp;
    private P3 screenA = new P3();
    private P3 screenB = new P3();
    private P3 screenC = new P3();
    private short colix;
    private short mad;
    private RocketsRenderer rr;
    private Viewer vwr;
    private JmolRendererInterface g3d;
    private TransformManager tm;
    private boolean renderArrowHeads;
    private boolean isRockets;
    private static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    private static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    private P3 ptC;
    private P3 ptTip;
    private P3[] corners;
    private P3[] screenCorners;
    private V3 vW;
    private V3 vH;

    public RocketRenderer(RocketsRenderer rocketsRenderer, boolean bl) {
        this.vtemp = new V3();
        this.rr = rocketsRenderer;
        this.vwr = rocketsRenderer.vwr;
        this.tm = rocketsRenderer.vwr.tm;
        this.isRockets = bl;
    }

    protected void renderRockets() {
        this.g3d = this.rr.g3d;
        this.tPending = false;
        this.renderArrowHeads = this.rr.renderArrowHeads;
        BS bS = this.rr.bsVisible;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.rr.structureTypes[n] == STR.HELIX || this.isRockets && this.rr.structureTypes[n] == STR.SHEET) {
                this.renderSpecialSegment((AlphaMonomer)this.rr.monomers[n], this.rr.getLeadColix(n), this.rr.mads[n]);
            } else if (this.isRockets) {
                this.renderPending();
                this.rr.renderHermiteConic(n, true, 7);
            }
            n = bS.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    private void renderSpecialSegment(AlphaMonomer alphaMonomer, short s, short s2) {
        ProteinStructure proteinStructure = alphaMonomer.proteinStructure;
        if (this.tPending) {
            if (proteinStructure == this.proteinstructurePending && s2 == this.mad && s == this.colix && proteinStructure.getIndex(alphaMonomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinStructure;
        this.startIndexPending = this.endIndexPending = proteinStructure.getIndex(alphaMonomer);
        this.colix = s;
        this.mad = s2;
        this.tPending = true;
    }

    private void renderPending() {
        boolean bl;
        if (!this.tPending) {
            return;
        }
        P3[] p3Array = this.proteinstructurePending.getSegments();
        boolean bl2 = bl = this.renderArrowHeads && this.endIndexPending == this.proteinstructurePending.nRes - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        } else if (this.proteinstructurePending instanceof Sheet) {
            this.renderPendingSheetPlank(p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int n, P3 p3, P3 p32, P3 p33, boolean bl) {
        if (this.g3d.setC(this.colix)) {
            this.tm.transformPt3f(p3, this.screenA);
            this.tm.transformPt3f(bl ? p32 : p33, this.screenB);
            int n2 = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
            int n3 = (int)this.vwr.tm.scaleToScreen(n2, this.mad);
            if (p3 != p32) {
                this.g3d.fillCylinderBits((byte)2, n3, this.screenA, this.screenB);
            }
            if (bl) {
                this.screenA.sub2(p33, p32);
                this.tm.transformPt3f(p33, this.screenC);
                int n4 = (this.mad << 1) - (this.mad >> 1);
                n4 = (int)this.vwr.tm.scaleToScreen((int)Math.floor(this.screenB.z), n4);
                this.g3d.fillConeSceen3f((byte)2, n4, this.screenB, this.screenC);
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            P3 p34 = this.screenB;
            this.screenB = this.screenC;
            this.screenC = p34;
        }
    }

    private void renderPendingSheetPlank(P3 p3, P3 p32, P3 p33, boolean bl) {
        byte by;
        byte by2;
        byte by3;
        int n;
        if (!this.g3d.setC(this.colix)) {
            return;
        }
        if (this.corners == null) {
            this.ptC = new P3();
            this.ptTip = new P3();
            this.vW = new V3();
            this.vH = new V3();
            this.screenCorners = new P3[8];
            this.corners = new P3[8];
        }
        if (this.corners[0] == null) {
            n = 8;
            while (--n >= 0) {
                this.corners[n] = new P3();
                this.screenCorners[n] = new P3();
            }
        }
        if (bl) {
            this.setBox(1.25f, 0.333f, p32);
            this.ptTip.scaleAdd2(-0.5f, this.vH, p33);
            n = 4;
            while (--n >= 0) {
                P3 p34 = this.corners[n];
                p34.setT(this.ptC);
                if ((n & 1) != 0) {
                    p34.add(this.vW);
                }
                if ((n & 2) != 0) {
                    p34.add(this.vH);
                }
                this.tm.transformPt3f(p34, this.screenCorners[n]);
            }
            this.corners[4].setT(this.ptTip);
            this.tm.transformPt3f(this.ptTip, this.screenCorners[4]);
            this.corners[5].add2(this.ptTip, this.vH);
            this.tm.transformPt3f(this.corners[5], this.screenCorners[5]);
            this.g3d.fillTriangle3f(this.screenCorners[0], this.screenCorners[1], this.screenCorners[4], true);
            this.g3d.fillTriangle3f(this.screenCorners[2], this.screenCorners[3], this.screenCorners[5], true);
            for (n = 0; n < 12; n += 4) {
                byte by4 = arrowHeadFaces[n];
                by3 = arrowHeadFaces[n + 1];
                by2 = arrowHeadFaces[n + 2];
                by = arrowHeadFaces[n + 3];
                this.g3d.fillQuadrilateral(this.screenCorners[by4], this.screenCorners[by3], this.screenCorners[by2], this.screenCorners[by]);
            }
            p33 = p32;
        }
        this.setBox(1.0f, 0.25f, p3);
        this.vtemp.sub2(p33, p3);
        if (this.vtemp.lengthSquared() == 0.0f) {
            return;
        }
        this.buildBox(this.ptC, this.vW, this.vH, this.vtemp);
        for (n = 0; n < 6; ++n) {
            byte by5 = boxFaces[n * 4];
            by3 = boxFaces[n * 4 + 1];
            by2 = boxFaces[n * 4 + 2];
            by = boxFaces[n * 4 + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[by5], this.screenCorners[by3], this.screenCorners[by2], this.screenCorners[by]);
        }
    }

    private void setBox(float f, float f2, P3 p3) {
        ((Sheet)this.proteinstructurePending).setBox(f, f2, p3, this.vW, this.vH, this.ptC, (float)this.mad / 1000.0f);
    }

    private void buildBox(P3 p3, V3 v3, V3 v32, V3 v33) {
        int n = 8;
        while (--n >= 0) {
            P3 p32 = this.corners[n];
            p32.setT(p3);
            if ((n & 1) != 0) {
                p32.add(v3);
            }
            if ((n & 2) != 0) {
                p32.add(v32);
            }
            if ((n & 4) != 0) {
                p32.add(v33);
            }
            this.tm.transformPt3f(p32, this.screenCorners[n]);
        }
    }
}

