/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class Model {
    public ModelSet ms;
    public int modelIndex;
    int fileIndex;
    public int hydrogenCount;
    public boolean isBioModel;
    public boolean isPdbWithMultipleBonds;
    protected boolean hasRasmolHBonds;
    public String loadState = "";
    public SB loadScript = new SB();
    public boolean isModelKit;
    Map<String, Integer> dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    public int firstAtomIndex;
    public int ac = 0;
    public final BS bsAtoms = new BS();
    public final BS bsAtomsDeleted = new BS();
    public int trajectoryBaseIndex;
    public boolean isTrajectory;
    public int selectedTrajectory = -1;
    private int bondCount = -1;
    int firstMoleculeIndex;
    public int moleculeCount;
    public int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    protected int chainCount = 0;
    public Chain[] chains = new Chain[8];
    int biosymmetryCount;
    protected Map<String, Object> auxiliaryInfo;
    public Properties properties;
    float defaultRotationRadius;
    String defaultStructure;
    public SymmetryInterface biosymmetry;
    public Orientation orientation;
    public boolean structureTainted;
    public boolean isJmolDataFrame;
    public long frameDelay;
    public SymmetryInterface simpleCage;
    public Map<String, Object> dssrCache;

    public ModelSet getModelSet() {
        return this.ms;
    }

    public boolean isModelkit() {
        return this.isModelKit;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    public int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bondArray = this.ms.bo;
        this.bondCount = 0;
        int n = this.ms.bondCount;
        while (--n >= 0) {
            if (bondArray[n].atom1.mi != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    public Model set(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.ms = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = map;
        if (map.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)map.get("biosymmetryCount");
            this.biosymmetry = (SymmetryInterface)map.get("biosymmetry");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = string;
            this.isJmolDataFrame = true;
            map.put("jmolData", string);
            map.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
        return this;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != 0) continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCountHetero(boolean bl) {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            int n3 = this.chains[n2].groupCount;
            while (--n3 >= 0) {
                if (this.chains[n2].groups[n3].isHetero() != bl) continue;
                ++n;
            }
        }
        return n;
    }

    void calcSelectedGroupsCount(BS bS) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bS);
        }
    }

    public int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].groupCount;
            }
        }
        return this.groupCount;
    }

    public Chain getChainAt(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    Chain getChain(int n) {
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            Chain chain = this.chains[n2];
            if (chain.chainID != n) continue;
            return chain;
        }
        return null;
    }

    public void fixIndices(int n, int n2, BS bS) {
        this.fixIndicesM(n, n2, bS);
    }

    protected void fixIndicesM(int n, int n2, BS bS) {
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(n2, bS);
        }
        BSUtil.deleteBits(this.bsAtoms, bS);
        BSUtil.deleteBits(this.bsAtomsDeleted, bS);
    }

    public void freeze() {
        this.freezeM();
    }

    protected void freezeM() {
        this.chains = (Chain[])AU.arrayCopyObject(this.chains, this.chainCount);
        this.groupCount = -1;
        this.getGroupCount();
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].groups = (Group[])AU.arrayCopyObject(this.chains[i].groups, this.chains[i].groupCount);
        }
    }

    public void getPdbData(Viewer viewer, String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
    }

    public Lst<BS> getBioBranches(Lst<BS> lst) {
        return lst;
    }

    public void clearBioPolymers() {
    }

    public void getAllPolymerInfo(BS bS, Map<String, Lst<Map<String, Object>>> map, Lst<Map<String, Object>> lst) {
    }

    public int getBioPolymerCount() {
        return 0;
    }

    public String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return "";
    }

    public void setStructureList(Map<STR, float[]> map) {
    }

    public void getChimeInfo(SB sB, int n) {
        this.getChimeInfoM(sB, n);
    }

    protected void getChimeInfoM(SB sB, int n) {
        sB.append("\nNumber of Atoms ..... " + (this.ms.ac - n));
        if (n > 0) {
            sB.append(" (" + n + ")");
        }
        sB.append("\nNumber of Bonds ..... " + this.ms.bondCount);
        sB.append("\nNumber of Models ...... " + this.ms.mc);
    }

    public void setConformation(BS bS) {
    }

    public boolean getPdbConformation(BS bS, int n) {
        return false;
    }

    public String getFullPDBHeader() {
        return null;
    }

    public BS getSequenceBits(ModelSet modelSet, String string, BS bS) {
        return null;
    }

    public BS getBasePairBits(ModelSet modelSet, String string) {
        return null;
    }

    public void resetRasmolBonds(Model model, BS bS) {
    }

    public void calcRasmolHydrogenBonds(ModelSet modelSet, BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3) {
    }

    public String getFullProteinStructureState(ModelSet modelSet, BS bS, boolean bl, boolean bl2, int n) {
        return null;
    }

    public void calculateAllPolymers(ModelSet modelSet, Group[] groupArray, int n, int n2, BS bS) {
    }

    public BS getGroupsWithinAll(ModelSet modelSet, int n, BS bS) {
        return null;
    }

    public BS getSelectCodeRange(ModelSet modelSet, int[] nArray) {
        return null;
    }

    public int calculateStruts(ModelSet modelSet, BS bS, BS bS2) {
        return 0;
    }

    public void getPolymerPointsAndVectors(BS bS, Lst<P3[]> lst, boolean bl, float f) {
    }

    public void recalculatePoints(ModelSet modelSet, int n) {
    }

    public void getDefaultLargePDBRendering(SB sB, int n) {
    }

    public void calcSelectedMonomersCount(BS bS) {
    }

    public int getBioPolymerCountInModel(ModelSet modelSet, int n) {
        return 0;
    }

    public void calculateStraightnessAll(ModelSet modelSet) {
    }
}

