/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class XtalSymmetry {
    private AtomSetCollection asc;
    private AtomSetCollectionReader acr;
    public SymmetryInterface symmetry;
    private float[] notionalUnitCell = new float[6];
    private float[] baseUnitCell;
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private float packingError;
    private String filterSymop;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private P3 ptSupercell;
    private M4 matSupercell;
    private Lst<float[]> trajectoryUnitCells;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private SymmetryInterface baseSymmetry;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3 unitCellOffset;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstSymmetryAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;
    private int nVib;

    public XtalSymmetry set(AtomSetCollectionReader atomSetCollectionReader) {
        this.acr = atomSetCollectionReader;
        this.asc = atomSetCollectionReader.asc;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = (Symmetry)this.acr.getInterface("org.jmol.symmetry.Symmetry")) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        this.symmetry = symmetryInterface;
        return this.symmetry;
    }

    private void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.asc.setInfo("symmetryRange", Float.valueOf(f));
    }

    private void setLatticeCells() {
        this.latticeCells = this.acr.latticeCells;
        boolean bl = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!bl || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell;
        this.doCentroidUnitCell = this.acr.doCentroidUnitCell;
        this.centroidPacked = this.acr.centroidPacked;
        this.filterSymop = this.acr.filterSymop;
        if (this.acr.strSupercell == null) {
            this.setSupercellFromPoint(this.acr.ptSupercell);
        }
    }

    public void setSupercellFromPoint(P3 p3) {
        this.ptSupercell = p3;
        if (p3 == null) {
            this.matSupercell = null;
            return;
        }
        this.matSupercell = new M4();
        this.matSupercell.m00 = p3.x;
        this.matSupercell.m11 = p3.y;
        this.matSupercell.m22 = p3.z;
        this.matSupercell.m33 = 1.0f;
        Logger.info("Using supercell \n" + this.matSupercell);
    }

    private void setNotionalUnitCell(float[] fArray, M3 m3, P3 p3) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = p3;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.asc.haveUnitCell = true;
        this.asc.setCurrentModelInfo("notionalUnitcell", this.notionalUnitCell);
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.notionalUnitCell);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell, false);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.asc.setCurrentModelInfo("unitCellOffset", p3);
        }
        if (m3 != null) {
            this.symmetry.initializeOrientation(m3);
            this.asc.setCurrentModelInfo("matUnitCellOrientation", m3);
        }
    }

    int addSpaceGroupOperation(String string, boolean bl) {
        if (bl) {
            this.setLatticeCells();
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    SymmetryInterface applySymmetryFromReader(SymmetryInterface symmetryInterface) throws Exception {
        this.asc.setCoordinatesAreFractional(this.acr.iHaveFractionalCoordinates);
        this.setNotionalUnitCell(this.acr.notionalUnitCell, this.acr.matUnitCellOrientation, this.acr.unitCellOffset);
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.setSymmetryRange(this.acr.symmetryRange);
        if (this.acr.doConvertToFractional || this.acr.fileCoordinatesAreFractional) {
            this.setLatticeCells();
            boolean bl = true;
            if (this.acr.ignoreFileSpaceGroupName || !this.acr.iHaveSymmetryOperators) {
                if (!this.acr.merging || symmetryInterface == null) {
                    symmetryInterface = this.acr.getNewSymmetry();
                }
                bl = symmetryInterface.createSpaceGroup(this.acr.desiredSpaceGroupIndex, this.acr.sgName.indexOf("!") >= 0 ? "P1" : this.acr.sgName, this.acr.notionalUnitCell);
            } else {
                this.acr.doPreSymmetry();
                symmetryInterface = null;
            }
            this.packingError = this.acr.packingError;
            if (bl) {
                if (symmetryInterface != null) {
                    this.symmetry.setSpaceGroupFrom(symmetryInterface);
                }
                this.applySymmetryLattice(this.acr.ms, this.acr.strSupercell);
                if (symmetryInterface != null && this.filterSymop == null) {
                    this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                }
            }
        }
        if (this.acr.iHaveFractionalCoordinates && this.acr.merging && symmetryInterface != null) {
            Atom[] atomArray = this.asc.atoms;
            int n = this.asc.ac;
            for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                symmetryInterface.toCartesian(atomArray[i], true);
            }
            this.asc.setCoordinatesAreFractional(false);
            this.acr.addVibrations = false;
        }
        return this.symmetry;
    }

    private void setAtomSetSpaceGroupName(String string) {
        this.asc.setCurrentModelInfo("spaceGroup", string + "");
    }

    private void applySymmetryLattice(MSInterface mSInterface, String string) throws Exception {
        int n;
        Object object;
        JSONEncodable jSONEncodable;
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        int n2 = this.latticeCells[0];
        int n3 = this.latticeCells[1];
        int n4 = Math.abs(this.latticeCells[2]);
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        BS bS = null;
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        T3[] t3Array = null;
        P3 p3 = null;
        P3 p32 = null;
        this.nVib = 0;
        P3 p33 = null;
        P3 p34 = null;
        P3 p35 = null;
        this.baseSymmetry = this.symmetry;
        if (string != null && string.indexOf(",") >= 0 && (t3Array = this.symmetry.getV0abc(string)) != null) {
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(n2, n3, n4);
            this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
            p32 = P3.newP(t3Array[0]);
            p33 = P3.newP(t3Array[1]);
            p34 = P3.newP(t3Array[2]);
            p35 = P3.newP(t3Array[3]);
            jSONEncodable = new P3();
            object = new P3();
            P3 p36 = new P3();
            if (this.acr.forcePacked) {
                ((T3)jSONEncodable).setT(p33);
                ((T3)object).setT(p34);
                p36.setT(p35);
                ((T3)jSONEncodable).scale(this.packingError);
                ((T3)object).scale(this.packingError);
                p36.scale(this.packingError);
            }
            t3Array[0].scaleAdd2(this.minXYZ.x, p33, t3Array[0]);
            t3Array[0].scaleAdd2(this.minXYZ.y, p34, t3Array[0]);
            t3Array[0].scaleAdd2(this.minXYZ.z, p35, t3Array[0]);
            t3Array[0].sub((T3)jSONEncodable);
            t3Array[0].sub((T3)object);
            t3Array[0].sub(p36);
            P3 p37 = P3.newP(t3Array[0]);
            this.symmetry.toFractional(p37, true);
            this.setSymmetryMinMax(p37);
            t3Array[1].scale(this.maxXYZ.x - this.minXYZ.x);
            t3Array[2].scale(this.maxXYZ.y - this.minXYZ.y);
            t3Array[3].scale(this.maxXYZ.z - this.minXYZ.z);
            t3Array[1].scaleAdd2(2.0f, (T3)jSONEncodable, t3Array[1]);
            t3Array[2].scaleAdd2(2.0f, (T3)object, t3Array[2]);
            t3Array[3].scaleAdd2(2.0f, p36, t3Array[3]);
            for (n = 0; n < 3; ++n) {
                for (int i = n + 1; i < 4; ++i) {
                    p37.add2(t3Array[n], t3Array[i]);
                    if (n != 0) {
                        p37.add(t3Array[0]);
                    }
                    this.symmetry.toFractional(p37, false);
                    this.setSymmetryMinMax(p37);
                }
            }
            this.symmetry.toCartesian(p37, false);
            p37.add(t3Array[1]);
            this.symmetry.toFractional(p37, false);
            this.setSymmetryMinMax(p37);
            this.minXYZ = P3i.new3((int)Math.floor(this.rminx + 0.001f), (int)Math.floor(this.rminy + 0.001f), (int)Math.floor(this.rminz + 0.001f));
            this.maxXYZ = P3i.new3((int)Math.ceil(this.rmaxx - 0.001f), (int)Math.ceil(this.rmaxy - 0.001f), (int)Math.ceil(this.rmaxz - 0.001f));
        }
        if (this.rminx == Float.MAX_VALUE) {
            this.matSupercell = null;
            string = null;
            t3Array = null;
        } else {
            int n5;
            boolean bl;
            Logger.info("setting min/max for original lattice to " + this.minXYZ + " and " + this.maxXYZ);
            this.doPackUnitCell = bl = this.doPackUnitCell;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.setAll(this.asc.ac);
            }
            bS = this.asc.bsAtoms;
            this.applyAllSymmetry(mSInterface, null);
            this.doPackUnitCell = bl;
            object = this.asc.atoms;
            int n6 = this.asc.ac;
            for (n = n5 = this.asc.getLastAtomSetAtomIndex(); n < n6; ++n) {
                this.symmetry.toCartesian(object[n], true);
            }
            this.symmetry = null;
            this.symmetry = this.getSymmetry();
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p33.x, p33.y, p33.z, p34.x, p34.y, p34.z, p35.x, p35.y, p35.z}, null, p3);
            this.setAtomSetSpaceGroupName(t3Array == null ? "P1" : "cell=" + string);
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            if (p32 != null) {
                this.symmetry.toFractional(p32, true);
            }
            for (n = n5; n < n6; ++n) {
                this.symmetry.toFractional((T3)object[n], true);
                if (p32 == null) continue;
                ((T3)object[n]).sub(p32);
            }
            this.asc.haveAnisou = false;
            this.asc.setCurrentModelInfo("matUnitCellOrientation", null);
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n2, n3, n4);
        if (t3Array == null) {
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(n2, n3, n4);
            this.applyAllSymmetry(mSInterface, bS);
        } else if (this.acr.forcePacked || this.doPackUnitCell) {
            this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
            jSONEncodable = this.asc.bsAtoms;
            object = this.asc.atoms;
            if (jSONEncodable == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
                jSONEncodable = this.asc.bsAtoms;
            }
            int n7 = ((BS)jSONEncodable).nextSetBit(0);
            while (n7 >= 0) {
                if (!this.isWithinCell(this.dtype, object[n7], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingError)) {
                    ((BS)jSONEncodable).clear(n7);
                }
                n7 = ((BS)jSONEncodable).nextSetBit(n7 + 1);
            }
        }
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    private boolean isInSymmetryRange(P3 p3) {
        return p3.x >= this.rminx && p3.y >= this.rminy && p3.z >= this.rminz && p3.x <= this.rmaxx && p3.y <= this.rmaxy && p3.z <= this.rmaxz;
    }

    public boolean isWithinCell(int n, P3 p3, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return p3.x > f - f7 && p3.x < f2 + f7 && (n < 2 || p3.y > f3 - f7 && p3.y < f4 + f7) && (n < 3 || p3.z > f5 - f7 && p3.z < f6 + f7);
    }

    private void applyAllSymmetry(MSInterface mSInterface, BS bS) throws Exception {
        int n;
        int n2;
        int n3;
        SymmetryInterface symmetryInterface;
        boolean bl;
        int n4;
        if (this.asc.ac == 0) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount == 0 ? this.asc.getLastAtomSetAtomCount() : this.asc.baseSymmetryAtomCount;
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        int n5 = this.symmetry.getSpaceGroupOperationCount();
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.asc.setCurrentModelInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (mSInterface != null) {
                mSInterface.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n6 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n7 = this.asc.checkSpecial ? this.noSymmetryCount * n5 * n6 : (this.symmetryRange > 0.0f ? this.noSymmetryCount * n5 : (this.symmetryRange < 0.0f ? 1 : 1));
        P3[] p3Array = new P3[n7];
        for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
            this.asc.atoms[n4 + this.firstSymmetryAtom].bsSymmetry = BS.newN(n5 * (n6 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n6];
        this.unitCellTranslations = new V3[n6];
        int n8 = 0;
        int n9 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminz = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminx = Float.MAX_VALUE;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        SymmetryInterface symmetryInterface2 = symmetryInterface = this.symmetry;
        this.latticeOp = symmetryInterface.getLatticeOp();
        this.checkAll = this.asc.atomSetCount == 1 && this.asc.checkSpecial && this.latticeOp >= 0;
        this.latticeOnly = this.asc.checkLatticeOnly && this.latticeOp >= 0;
        P3 p3 = null;
        M4 m4 = symmetryInterface.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            p3 = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n8] = V3.new3(n3, n2, n);
                    nArray[n8++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || p3Array.length == 0) continue;
                    for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
                        Atom atom = this.asc.atoms[this.firstSymmetryAtom + n4];
                        if (mSInterface != null && (symmetryInterface = mSInterface.getAtomSymmetry(atom, this.symmetry)) != symmetryInterface2) {
                            if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                                symmetryInterface2 = symmetryInterface;
                                this.finalizeSymmetry(symmetryInterface2);
                            }
                            m4 = symmetryInterface.getSpaceGroupOperation(0);
                        }
                        P3 p32 = P3.newP(atom);
                        m4.rotTrans(p32);
                        symmetryInterface.toCartesian(p32, false);
                        if (this.doPackUnitCell) {
                            symmetryInterface.toUnitCell(p32, this.ptOffset);
                            p3.setT(p32);
                            symmetryInterface.toFractional(p3, false);
                            if (this.acr.fixJavaFloat) {
                                PT.fixPtFloats(p3, 100000.0f);
                            }
                            if (bS == null) {
                                atom.setT(p3);
                            } else if (atom.distance(p3) < 1.0E-4f) {
                                bS.set(atom.index);
                            } else {
                                bS.clear(atom.index);
                                continue;
                            }
                        }
                        if (bS != null) {
                            atom.bsSymmetry.clearAll();
                        }
                        atom.bsSymmetry.set(n8 * n5);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(p32);
                        }
                        if (n4 >= n7) continue;
                        p3Array[n4] = p32;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n9 = n4 = this.symmetryAddAtoms(0, 0, 0, 0, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n8 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n8;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n3, n2, n, n9, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (n8 * this.noSymmetryCount == this.asc.ac - this.firstSymmetryAtom) {
            this.duplicateAtomProperties(n8);
        }
        this.setSymmetryOps();
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("latticeDesignation", symmetryInterface.getLatticeDesignation());
        this.asc.setCurrentModelInfo("unitCellRange", nArray);
        this.asc.setCurrentModelInfo("unitCellTranslations", this.unitCellTranslations);
        this.baseUnitCell = this.notionalUnitCell;
        this.notionalUnitCell = new float[6];
        this.reset();
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, P3[] p3Array, MSInterface mSInterface) throws Exception {
        int[] nArray;
        boolean bl = n4 == 0;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl2 ? new int[this.noSymmetryCount] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n, n2, n3);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = this.symmetryRange > 0.0f;
        boolean bl5 = bl && bl4;
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        boolean bl6 = n7 == 1 && !this.doPackUnitCell ? false : this.asc.checkSpecial;
        boolean bl7 = bl3 || (bl4 &= !bl);
        boolean bl8 = bl6 || bl7;
        boolean bl9 = bl6 || bl5;
        SymmetryInterface symmetryInterface = this.symmetry;
        if (bl3) {
            n4 = this.noSymmetryCount;
        }
        int n8 = this.firstSymmetryAtom + this.noSymmetryCount;
        P3 p3 = new P3();
        String string = null;
        char c = '\u0000';
        for (int i = 0; i < n7; ++i) {
            int n9;
            Object object;
            Atom[] atomArray;
            if (bl && i == 0 || this.latticeOnly && i > 0 && i != this.latticeOp) continue;
            int n10 = bl6 ? n5 : (bl4 ? n4 : 0);
            float f2 = this.asc.vibScale == 0 ? symmetryInterface.getSpinOp(i) : (float)this.asc.vibScale;
            for (int j = this.firstSymmetryAtom; j < n8; ++j) {
                Object object2;
                atomArray = this.asc.atoms[j];
                if (atomArray.ignoreSymmetry || this.asc.bsAtoms != null && !this.asc.bsAtoms.get(j)) continue;
                if (mSInterface == null) {
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                } else {
                    symmetryInterface = mSInterface.getAtomSymmetry((Atom)atomArray, this.symmetry);
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                    string = symmetryInterface.getSpaceGroupOperationCode(i);
                    if (string != null) {
                        c = string.charAt(0);
                        symmetryInterface = mSInterface.getSymmetryFromCode(string);
                        if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(symmetryInterface);
                        }
                    }
                }
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(p3, 100000.0f);
                }
                P3 p32 = P3.newP(p3);
                symmetryInterface.toCartesian(p32, false);
                if (this.doPackUnitCell) {
                    symmetryInterface.toUnitCell(p32, this.ptOffset);
                    p3.setT(p32);
                    symmetryInterface.toFractional(p3, false);
                    if (this.acr.fixJavaFloat) {
                        PT.fixPtFloats(p3, 100000.0f);
                    }
                    if (!this.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingError)) continue;
                }
                if (bl5) {
                    this.setSymmetryMinMax(p32);
                }
                object = null;
                if (bl8) {
                    float f3 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(p32)) continue;
                    int n11 = this.checkAll ? this.asc.ac : n10;
                    object2 = atomArray.atomName;
                    n9 = string == null ? atomArray.altLoc : c;
                    int n12 = n11;
                    while (--n12 >= 0) {
                        P3 p33 = p3Array[n12];
                        if (p33 == null) continue;
                        float f4 = p32.distanceSquared(p33);
                        if (bl6 && (double)f4 < 1.0E-4) {
                            object = this.asc.atoms[this.firstSymmetryAtom + n12];
                            if ((((Atom)object).atomName == null || ((Atom)object).atomName.equals(object2)) && ((Atom)object).altLoc == n9) break;
                            object = null;
                        }
                        if (!bl4 || n12 >= n4 || !(f4 < f3)) continue;
                        f3 = f4;
                    }
                    if (bl4 && f3 > f) continue;
                }
                int n13 = atomArray.atomSite;
                if (object != null) {
                    if (bl2) {
                        nArray[n13] = ((Atom)object).index;
                    }
                    ((Atom)object).bsSymmetry.set(n6 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl2) {
                    nArray[n13] = this.asc.ac;
                }
                Atom atom = this.asc.newCloneAtom((Atom)atomArray);
                if (this.asc.bsAtoms != null) {
                    this.asc.bsAtoms.set(atom.index);
                }
                atom.setT(p3);
                if (f2 != 0.0f && atom.vib != null) {
                    symmetryInterface.getSpaceGroupOperation(i).rotate(atom.vib);
                    atom.vib.scale(f2);
                }
                atom.atomSite = n13;
                if (string != null) {
                    atom.altLoc = c;
                }
                atom.bsSymmetry = BSUtil.newAndSetBit(n6 + i);
                atom.bsSymmetry.set(i);
                if (bl9) {
                    p3Array[n5++] = p32;
                }
                if ((object2 = atomArray.tensors) == null) continue;
                atom.tensors = null;
                n9 = ((ArrayList)object2).size();
                while (--n9 >= 0) {
                    Tensor tensor = (Tensor)((ArrayList)object2).get(n9);
                    if (tensor == null) continue;
                    if (n7 == 1) {
                        atom.addTensor(tensor.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom, tensor, i, false, symmetryInterface);
                }
            }
            if (!bl2) continue;
            Bond[] bondArray = this.asc.bonds;
            atomArray = this.asc.atoms;
            for (int j = this.asc.bondIndex0; j < this.bondCount0; ++j) {
                object = bondArray[j];
                Atom atom = atomArray[((Bond)object).atomIndex1];
                Atom atom2 = atomArray[((Bond)object).atomIndex2];
                if (atom == null || atom2 == null) continue;
                int n14 = nArray[atom.atomSite];
                n9 = nArray[atom2.atomSite];
                if (n14 < n8 && n9 < n8) continue;
                this.asc.addNewBondWithOrder(n14, n9, ((Bond)object).order);
            }
        }
        return n5;
    }

    private void duplicateAtomProperties(int n) {
        Map map = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                int n2;
                Object object;
                Object object2;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    object2 = (String)v;
                    object = new SB();
                    n2 = n;
                    while (--n2 >= 0) {
                        ((SB)object).append((String)object2);
                    }
                    map.put(string, ((SB)object).toString());
                    continue;
                }
                object2 = (float[])v;
                object = new float[((Object)object2).length * n];
                n2 = n;
                while (--n2 >= 0) {
                    System.arraycopy(object2, 0, object, n2 * ((Object)object2).length, ((Object)object2).length);
                }
            }
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetryInterface) {
        String string = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetryInterface.setFinalOperations(string, this.asc.atoms, this.firstSymmetryAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || string == null || string.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setCurrentModelInfo("symmetryOperations", stringArray);
            this.asc.setCurrentModelInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setCurrentModelInfo("symmetryCount", n);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> map, float[] fArray, boolean bl, String string) {
        int n;
        Cloneable cloneable;
        Object object;
        int n2;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        int n3 = string.indexOf("BYCHAIN") >= 0 ? 1 : (string.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst lst = (Lst)map.get("biomts");
        if (lst.size() < 2) {
            return;
        }
        this.symmetry = null;
        if (!Float.isNaN(fArray[0])) {
            this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        }
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z", false);
        String string2 = (String)map.get("name");
        this.setAtomSetSpaceGroupName(string2);
        int n4 = lst.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.asc.bondCount;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.asc.ac] : null;
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        int n5 = this.asc.ac;
        Hashtable<Serializable, BS> hashtable = new Hashtable<Serializable, BS>();
        int n6 = 0;
        Atom[] atomArray = this.asc.atoms;
        switch (n3) {
            case 1: {
                n2 = n5;
                while (--n2 >= this.firstSymmetryAtom) {
                    void object2;
                    object = atomArray[n2].chainID;
                    BS n7 = (BS)hashtable.get(object);
                    if (n7 == null) {
                        ++n6;
                        BS bS = new BS();
                        hashtable.put((Serializable)object, bS);
                    }
                    object2.set(n2);
                }
                this.asc.bsAtoms = new BS();
                for (n2 = 0; n2 < n6; ++n2) {
                    this.asc.bsAtoms.set(n5 + n2);
                    object = new Atom();
                    ((T3)object).set(0.0f, 0.0f, 0.0f);
                    ((Atom)object).radius = 16.0f;
                    this.asc.addAtom((Atom)object);
                }
                n2 = 0;
                for (Map.Entry entry : hashtable.entrySet()) {
                    Atom atom = atomArray[n5 + n2++];
                    cloneable = (BS)entry.getValue();
                    n = ((BS)cloneable).nextSetBit(0);
                    while (n >= 0) {
                        atom.add(atomArray[n]);
                        n = ((BS)cloneable).nextSetBit(n + 1);
                    }
                    atom.scale(1.0f / (float)((BS)cloneable).cardinality());
                    atom.atomName = "Pt" + n2;
                    atom.chainID = (Integer)entry.getKey();
                }
                this.firstSymmetryAtom = n5;
                n5 += n6;
                break;
            }
            case 2: {
                void var17_23;
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(n5);
                atomArray[n5] = new Atom();
                object = atomArray[n5];
                ((T3)object).set(0.0f, 0.0f, 0.0f);
                int n7 = n5;
                while (--var17_23 >= this.firstSymmetryAtom) {
                    ((T3)object).add(atomArray[var17_23]);
                }
                ((T3)object).scale(1.0f / (float)(n5 - this.firstSymmetryAtom));
                ((Atom)object).atomName = "Pt";
                ((Atom)object).radius = 16.0f;
                this.asc.addAtom((Atom)object);
                this.firstSymmetryAtom = n5++;
            }
        }
        if (string.indexOf("#<") >= 0) {
            n4 = Math.min(n4, PT.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = PT.rep(string, "#<", "_<");
        }
        for (n2 = this.firstSymmetryAtom; n2 < n5; ++n2) {
            atomArray[n2].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        for (n2 = 1; n2 < n4; ++n2) {
            if (string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n2 + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n2 + 1) + ";") < 0) continue;
            object = (M4)lst.get(n2);
            for (int i = this.firstSymmetryAtom; i < n5; ++i) {
                if (this.asc.bsAtoms != null && !this.asc.bsAtoms.get(i)) continue;
                try {
                    int n8 = atomArray[i].atomSite;
                    if (bl2) {
                        nArray[n8] = this.asc.ac;
                    }
                    cloneable = this.asc.newCloneAtom(atomArray[i]);
                    if (this.asc.bsAtoms != null) {
                        this.asc.bsAtoms.set(((Atom)cloneable).index);
                    }
                    ((Atom)cloneable).atomSite = n8;
                    ((M4)object).rotTrans((T3)((Object)cloneable));
                    ((Atom)cloneable).bsSymmetry = BSUtil.newAndSetBit(n2);
                    if (!bl2) continue;
                    for (n = this.asc.bondIndex0; n < this.bondCount0; ++n) {
                        Bond bond = this.asc.bonds[n];
                        int n9 = nArray[atomArray[bond.atomIndex1].atomSite];
                        int n10 = nArray[atomArray[bond.atomIndex2].atomSite];
                        if (n9 < n5 && n10 < n5) continue;
                        this.asc.addNewBondWithOrder(n9, n10, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.asc.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            if (n2 <= 0) continue;
            this.symmetry.addBioMoleculeOperation((M4)object, false);
        }
        this.noSymmetryCount = n5 - this.firstSymmetryAtom;
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("biosymmetryCount", n4);
        this.asc.setCurrentModelInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setCurrentModelInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl, SymmetryInterface symmetryInterface) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return atom.addTensor(((Tensor)this.acr.getInterface("org.jmol.util.Tensor")).setFromEigenVectors(symmetryInterface.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id, tensor), null, bl);
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom atom = this.asc.atoms[i];
            if (atom.anisoBorU == null) continue;
            atom.addTensor(this.symmetry.getTensor(this.acr.vwr, atom.anisoBorU), null, false);
            if (Float.isNaN(atom.bfactor)) {
                atom.bfactor = atom.anisoBorU[7] * 100.0f;
            }
            atom.anisoBorU = null;
        }
    }

    public void setTimeReversal(int n, int n2) {
        this.symmetry.setTimeReversal(n, n2);
    }

    public void rotateToSuperCell(V3 v3) {
        if (this.matSupercell != null) {
            this.matSupercell.rotTrans(v3);
        }
    }

    public int setSpinVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.acr.vibsFractional) {
            return this.nVib;
        }
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        SymmetryInterface symmetryInterface = this.getBaseSymmetry();
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            if (vibration.modDim > 0) {
                ((JmolModulationSet)((Object)vibration)).setMoment();
            } else {
                vibration = (Vibration)vibration.clone();
                symmetryInterface.toCartesian(vibration, true);
                this.asc.atoms[n2].vib = vibration;
            }
            ++this.nVib;
        }
        return this.nVib;
    }

    public void scaleFractionalVibs() {
        float[] fArray = this.getBaseSymmetry().getNotionalUnitCell();
        P3 p3 = P3.new3(1.0f / fArray[0], 1.0f / fArray[1], 1.0f / fArray[2]);
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            vibration.scaleT(p3);
        }
    }

    public SymmetryInterface getBaseSymmetry() {
        return this.baseSymmetry == null ? this.symmetry : this.baseSymmetry;
    }

    public void finalizeUnitCell(P3 p3) {
        if (p3 != null && this.baseUnitCell != null) {
            this.baseUnitCell[22] = Math.max(1, (int)p3.x);
            this.baseUnitCell[23] = Math.max(1, (int)p3.y);
            this.baseUnitCell[24] = Math.max(1, (int)p3.z);
        }
    }
}

