/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Subsystem;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.ModulationSet;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class MSRdr
implements MSInterface {
    protected AtomSetCollectionReader cr;
    protected int modDim;
    protected String modAxes;
    protected boolean modAverage;
    protected boolean isCommensurate;
    protected int commensurateSection1;
    private boolean modPack;
    private boolean modVib;
    private String modType;
    private String modCell;
    private boolean modDebug;
    private int modSelected = -1;
    private boolean modLast;
    private Matrix sigma;
    private Map<String, double[]> htModulation;
    private Map<String, Lst<Modulation>> htAtomMods;
    private int iopLast = -1;
    private M3 gammaE;
    private int nOps;
    private boolean haveOccupancy;
    private Atom[] atoms;
    private int ac;
    private boolean haveAtomMods;
    private boolean modCoord;
    private boolean finalized;
    private SymmetryInterface symmetry;
    private SymmetryInterface supercellSymmetry;
    private Lst<String> legendres;
    private String atModel = "@0";
    private Matrix[] modMatrices;
    private double[] qlist100;
    private P3[] qs;
    private int modCount;
    private T3 modTUV;
    private static final String U_LIST = "U11U22U33U12U13U23UISO";
    Map<String, Subsystem> htSubsystems;
    private P3 minXYZ0;
    private P3 maxXYZ0;

    Matrix getSigma() {
        return this.sigma;
    }

    @Override
    public int initialize(AtomSetCollectionReader atomSetCollectionReader, int n) throws Exception {
        this.cr = atomSetCollectionReader;
        this.modCoord = atomSetCollectionReader.checkFilterKey("MODCOORD");
        this.modDebug = atomSetCollectionReader.checkFilterKey("MODDEBUG");
        this.modPack = !atomSetCollectionReader.checkFilterKey("MODNOPACK");
        this.modLast = atomSetCollectionReader.checkFilterKey("MODLAST");
        this.modAxes = atomSetCollectionReader.getFilter("MODAXES=");
        this.modType = atomSetCollectionReader.getFilter("MODTYPE=");
        this.modCell = atomSetCollectionReader.getFilter("MODCELL=");
        this.modSelected = atomSetCollectionReader.parseIntStr("" + atomSetCollectionReader.getFilter("MOD="));
        this.modVib = atomSetCollectionReader.checkFilterKey("MODVIB");
        this.modAverage = atomSetCollectionReader.checkFilterKey("MODAVE");
        String string = atomSetCollectionReader.getFilter("MODT=");
        if (string != null || (string = atomSetCollectionReader.getFilter("MODTUV=")) != null) {
            this.modTUV = new P3();
            String[] stringArray = (PT.replaceAllCharacters(string, "{}()", "") + ",0,0,0").split(",");
            this.modTUV.x = PT.parseFloatFraction(stringArray[0]);
            this.modTUV.y = PT.parseFloatFraction(stringArray[1]);
            this.modTUV.z = PT.parseFloatFraction(stringArray[2]);
            if (Float.isNaN(this.modTUV.lengthSquared())) {
                Logger.error("MSRdr cannot read modTUV=" + string);
                this.modTUV = null;
            }
        }
        this.setModDim(n);
        return n;
    }

    private void setSubsystemOptions() {
        this.cr.forceSymmetry(this.modPack);
        if (this.modCell != null) {
            this.cr.addJmolScript("unitcell {%" + this.modCell + "}");
        }
    }

    protected void setModDim(int n) {
        this.htModulation = new Hashtable<String, double[]>();
        this.modDim = n;
        this.cr.appendLoadNote("Modulation dimension = " + this.modDim);
    }

    @Override
    public void addModulation(Map<String, double[]> map, String string, double[] dArray, int n) {
        char c = string.charAt(0);
        switch (c) {
            case 'D': 
            case 'M': 
            case 'O': 
            case 'U': {
                if ((this.modType == null || this.modType.indexOf(c) >= 0) && (this.modSelected <= 0 || this.modSelected == 1)) break;
                return;
            }
        }
        boolean bl = false;
        int n2 = dArray.length;
        while (--n2 >= 0) {
            if (this.modSelected > 0 && n2 + 1 != this.modSelected && string.contains("_coefs_")) {
                dArray[n2] = 0.0;
                continue;
            }
            if (dArray[n2] == 0.0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        if (map == null) {
            map = this.htModulation;
        }
        if (string.indexOf("@") < 0) {
            string = string + "@" + (n >= 0 ? n : this.cr.asc.iSet);
        }
        if (string.startsWith("D_L#") || string.startsWith("U_L")) {
            if (this.legendres == null) {
                this.legendres = new Lst();
            }
            this.legendres.addLast(string);
        }
        Logger.info("Adding " + string + " " + Escape.e(dArray));
        map.put(string, dArray);
    }

    @Override
    public void setModulation(boolean bl, SymmetryInterface symmetryInterface) throws Exception {
        if (this.modDim == 0 || this.htModulation == null) {
            return;
        }
        if (this.modDebug) {
            Logger.debuggingHigh = true;
            Logger.debugging = true;
        }
        this.cr.asc.setInfo("someModelsAreModulated", Boolean.TRUE);
        this.symmetry = symmetryInterface;
        this.setModulationForStructure(this.cr.asc.iSet, bl);
        if (this.modDebug) {
            Logger.debuggingHigh = false;
            Logger.debugging = false;
        }
    }

    @Override
    public void finalizeModulation() {
        if (!this.finalized && this.modDim > 0 && !this.modVib) {
            if (this.modTUV != null) {
                this.cr.appendLoadNote("modTUV=" + this.modTUV);
            }
            this.cr.asc.setInfo("modulationOn", this.modTUV == null ? Boolean.TRUE : this.modTUV);
            this.cr.addJmolScript(this.haveOccupancy && !this.isCommensurate ? ";display occupancy >= 0.5" : "");
        }
        this.finalized = true;
    }

    private String checkKey(String string, boolean bl) {
        int n = string.indexOf(this.atModel);
        return n < 0 || string.indexOf("_pos#") >= 0 || string.indexOf("*;*") >= 0 || bl && string.indexOf("?") >= 0 ? null : string.substring(0, n);
    }

    @Override
    public double[] getMod(String string) {
        return this.htModulation.get(string + this.atModel);
    }

    @Override
    public Map<String, double[]> getModulationMap() {
        return this.htModulation;
    }

    private void setModulationForStructure(int n, boolean bl) throws Exception {
        int n2;
        this.atModel = "@" + n;
        if (this.htModulation.containsKey("X_" + this.atModel)) {
            return;
        }
        if (!bl) {
            this.initModForStructure(n);
            return;
        }
        this.htModulation.put("X_" + this.atModel, new double[0]);
        this.cr.appendLoadNote(this.modCount + " modulations for " + this.ac + " modulated atoms");
        if (!this.haveAtomMods) {
            return;
        }
        int n3 = this.cr.asc.ac;
        this.atoms = this.cr.asc.atoms;
        if (this.symmetry != null) {
            this.nOps = this.symmetry.getSpaceGroupOperationCount();
        }
        this.supercellSymmetry = this.cr.asc.getXSymmetry().symmetry;
        if (this.supercellSymmetry == this.symmetry) {
            this.supercellSymmetry = null;
        }
        this.iopLast = -1;
        for (int i = n2 = this.cr.asc.getLastAtomSetAtomIndex(); i < n3; ++i) {
            this.modulateAtom(this.atoms[i]);
        }
        this.htAtomMods = null;
        if (this.minXYZ0 != null) {
            this.trimAtomSet();
        }
        this.htSubsystems = null;
    }

    private void initModForStructure(int n) throws Exception {
        String string;
        String string2;
        double[] dArray;
        if (this.legendres != null) {
            this.fixLegendre();
        }
        this.sigma = new Matrix(null, this.modDim, 3);
        this.qs = null;
        this.modMatrices = new Matrix[]{this.sigma, null};
        for (int i = 0; i < this.modDim; ++i) {
            dArray = this.getMod("W_" + (i + 1));
            if (dArray == null) {
                Logger.info("Not enough cell wave vectors for d=" + this.modDim);
                return;
            }
            this.fixDouble(dArray);
            this.cr.appendLoadNote("W_" + (i + 1) + " = " + Escape.e(dArray));
            this.cr.appendUunitCellInfo("q" + (i + 1) + "=" + dArray[0] + " " + dArray[1] + " " + dArray[2]);
            this.sigma.getArray()[i] = new double[]{dArray[0], dArray[1], dArray[2]};
        }
        Hashtable<String, double[]> hashtable = new Hashtable<String, double[]>();
        for (Map.Entry<String, double[]> entry : this.htModulation.entrySet()) {
            string2 = this.checkKey(entry.getKey(), false);
            if (string2 == null) continue;
            dArray = entry.getValue();
            switch (string2.charAt(0)) {
                case 'O': {
                    this.haveOccupancy = true;
                }
                case 'D': 
                case 'M': 
                case 'U': {
                    if (dArray[2] != 1.0 || string2.charAt(2) == 'S' || string2.charAt(2) == 'T' || string2.charAt(2) == 'L') break;
                    int n2 = string2.indexOf("?");
                    if (n2 >= 0) {
                        string = string2.substring(n2 + 1);
                        dArray = this.getMod(string2.substring(0, 2) + string + "#*;*");
                        if (dArray == null) break;
                        string2 = string2.substring(0, n2);
                        this.addModulation(hashtable, string2, dArray, n);
                        break;
                    }
                    double d = dArray[0];
                    double d2 = Math.PI * 2 * dArray[1];
                    dArray[0] = (float)(d * Math.cos(d2));
                    dArray[1] = (float)(d * Math.sin(-d2));
                    dArray[2] = 0.0;
                    Logger.info("msCIF setting " + string2 + " " + Escape.e(dArray));
                    break;
                }
                case 'W': {
                    if (this.modDim > 1) break;
                }
                case 'F': {
                    if (string2.indexOf("_coefs_") >= 0) {
                        this.cr.appendLoadNote("Wave vector " + string2 + "=" + Escape.eAD(dArray));
                        break;
                    }
                    double[] dArray2 = this.calculateQCoefs(dArray);
                    if (dArray2 == null) {
                        this.cr.appendLoadNote("Cannot match atom wave vector " + string2 + " " + Escape.eAD(dArray) + " to a cell wave vector or its harmonic");
                        break;
                    }
                    string = string2 + "_coefs_";
                    if (this.htModulation.containsKey(string + this.atModel)) break;
                    this.addModulation(hashtable, string, dArray2, n);
                    if (!string2.startsWith("F_")) break;
                    this.cr.appendLoadNote("atom wave vector " + string2 + " = " + Escape.e(dArray) + " fn = " + Escape.e(dArray2));
                }
            }
        }
        if (!hashtable.isEmpty()) {
            this.htModulation.putAll(hashtable);
        }
        if (this.htSubsystems == null) {
            this.haveAtomMods = false;
        } else {
            this.cr.strSupercell = null;
            this.haveAtomMods = true;
            this.htAtomMods = new Hashtable<String, Lst<Modulation>>();
        }
        for (Map.Entry<String, double[]> entry : this.htModulation.entrySet()) {
            string2 = this.checkKey(entry.getKey(), true);
            if (string2 == null) continue;
            double[] dArray3 = entry.getValue();
            string = string2.substring(string2.indexOf(";") + 1);
            int n3 = string.indexOf("#=");
            if (n3 >= 0) {
                dArray3 = this.getMod(string.substring(n3 + 2));
                string = string.substring(0, n3);
            }
            if (Logger.debuggingHigh) {
                Logger.debug("SetModulation: " + string2 + " " + Escape.e(dArray3));
            }
            char c = string2.charAt(0);
            n3 = string2.indexOf("#") + 1;
            String string3 = null;
            switch (c) {
                case 'U': {
                    string3 = string2.substring(n3, string2.indexOf(";"));
                }
                case 'D': 
                case 'M': 
                case 'O': {
                    if (this.modAverage) break;
                    char c2 = string2.charAt(n3);
                    c = this.getModType(string2);
                    if (this.htAtomMods == null) {
                        this.htAtomMods = new Hashtable<String, Lst<Modulation>>();
                    }
                    double[] dArray4 = new double[dArray3.length];
                    int n4 = dArray4.length;
                    while (--n4 >= 0) {
                        dArray4[n4] = dArray3[n4];
                    }
                    double[] dArray5 = this.getQCoefs(string2);
                    if (dArray5 == null) {
                        throw new Exception("Missing cell wave vector for atom wave vector for " + string2 + " " + Escape.e(dArray3));
                    }
                    this.addAtomModulation(string, c2, c, dArray4, string3, dArray5);
                    this.haveAtomMods = true;
                }
            }
        }
    }

    private void fixLegendre() {
        int n = this.legendres.size();
        while (--n >= 0) {
            String string = (String)this.legendres.get(n);
            double[] dArray = this.htModulation.get(string);
            if (dArray == null) continue;
            String string2 = "O_0#0" + string.substring(string.indexOf(";"));
            double[] dArray2 = this.htModulation.get(string2);
            if (dArray2 == null) {
                Logger.error("Crenel " + string2 + " not found for legendre modulation " + string);
                dArray[2] = Double.NaN;
                continue;
            }
            this.htModulation.put(string, new double[]{dArray2[0], dArray2[1], dArray[0], dArray[1]});
        }
    }

    private void fixDouble(double[] dArray) {
        if (this.cr.fixJavaFloat) {
            int n = dArray.length;
            while (--n >= 0) {
                dArray[n] = PT.fixDouble(dArray[n], 100000.0);
            }
        }
    }

    @Override
    public double[] getQCoefs(String string) {
        int n = Math.max(0, this.cr.parseIntAt(string, 2));
        if (n == 0) {
            if (this.qlist100 == null) {
                this.qlist100 = new double[this.modDim];
                this.qlist100[0] = 1.0;
            }
            return this.qlist100;
        }
        return this.getMod("F_" + n + "_coefs_");
    }

    @Override
    public char getModType(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(2);
        return (char)(c2 == 'S' ? 115 : (c2 == 'T' ? 116 : (c2 == 'L' ? (c == 'D' ? 108 : 76) : (c2 == '0' ? 99 : (c == 'D' ? 102 : (c == 'O' ? 111 : (c == 'M' ? 109 : (c == 'U' ? 117 : 63))))))));
    }

    private double[] calculateQCoefs(double[] dArray) {
        int n;
        int n2;
        int n3;
        if (this.qs == null) {
            this.qs = new P3[this.modDim];
            for (int i = 0; i < this.modDim; ++i) {
                this.qs[i] = this.toP3(this.getMod("W_" + (i + 1)));
            }
        }
        P3 p3 = this.toP3(dArray);
        for (int i = 0; i < this.modDim; ++i) {
            if (this.qs[i] == null || (n3 = this.approxInt(p3.dot(this.qs[i]) / this.qs[i].dot(this.qs[i]))) == 0) continue;
            dArray = new double[this.modDim];
            dArray[i] = n3;
            return dArray;
        }
        P3 p32 = this.toP3(dArray);
        n3 = this.modDim < 2 ? 0 : -3;
        int n4 = this.modDim < 2 ? 0 : 3;
        int n5 = this.modDim < 3 ? 0 : -3;
        int n6 = this.modDim < 3 ? 0 : 3;
        for (n2 = -3; n2 <= 3; ++n2) {
            for (n = n3; n <= n4; ++n) {
                for (int i = n5; i <= n6; ++i) {
                    p3.setT(this.qs[0]);
                    p3.scale(n2);
                    if (this.modDim > 1 && this.qs[1] != null) {
                        p3.scaleAdd2(n, this.qs[1], p3);
                    }
                    if (this.modDim > 2 && this.qs[2] != null) {
                        p3.scaleAdd2(i, this.qs[2], p3);
                    }
                    if (!(p3.distanceSquared(p32) < 1.0E-4f)) continue;
                    dArray = new double[this.modDim];
                    switch (this.modDim) {
                        default: {
                            dArray[2] = i;
                        }
                        case 2: {
                            dArray[1] = n;
                        }
                        case 1: 
                    }
                    dArray[0] = n2;
                    return dArray;
                }
            }
        }
        p3 = this.toP3(dArray);
        for (n2 = 0; n2 < this.modDim; ++n2) {
            if (this.qs[n2] == null) continue;
            p32 = this.qs[n2];
            n = 0;
            if (p3.x != 0.0f) {
                n = this.approxInt(p3.x / p32.x);
            }
            if (p3.y != 0.0f) {
                n = Math.max(this.approxInt(p3.y / p32.y), n);
            }
            if (n == 0 && p3.z != 0.0f) {
                n = Math.max(this.approxInt(p3.z / p32.z), n);
            }
            if (n == 0 || p32.x != 0.0f && this.approxInt(10.0f + p32.x * (float)n - p3.x) == 0 || p32.y != 0.0f && this.approxInt(10.0f + p32.y * (float)n - p3.y) == 0 || p32.z != 0.0f && this.approxInt(10.0f + p32.z * (float)n - p3.z) == 0) continue;
            dArray = new double[this.modDim];
            dArray[n2] = n;
            return dArray;
        }
        return null;
    }

    private int approxInt(float f) {
        int n = Math.round(f);
        return Math.abs(f - (float)n) < 0.001f ? n : 0;
    }

    private P3 toP3(double[] dArray) {
        return P3.new3((float)dArray[0], (float)dArray[1], (float)dArray[2]);
    }

    private void addAtomModulation(String string, char c, char c2, double[] dArray, String string2, double[] dArray2) {
        Lst<Modulation> lst = this.htAtomMods.get(string);
        if (lst == null) {
            ++this.ac;
            lst = new Lst();
            this.htAtomMods.put(string, lst);
        }
        lst.addLast(new Modulation(c, c2, dArray, string2, dArray2));
        ++this.modCount;
    }

    @Override
    public void addSubsystem(String string, Matrix matrix) {
        if (string == null) {
            return;
        }
        Subsystem subsystem = new Subsystem(this, string, matrix);
        this.cr.appendLoadNote("subsystem " + string + "\n" + matrix);
        this.setSubsystem(string, subsystem);
    }

    private void addUStr(Atom atom, String string, float f) {
        int n = U_LIST.indexOf(string) / 3;
        if (Logger.debuggingHigh) {
            Logger.debug("MOD RDR adding " + string + " " + n + " " + f + " to " + atom.anisoBorU[n]);
        }
        this.cr.asc.setU(atom, n, f + atom.anisoBorU[n]);
    }

    private void modulateAtom(Atom atom) {
        Object object;
        Serializable serializable;
        if (this.modCoord && this.htSubsystems != null) {
            serializable = P3.newP(atom);
            SymmetryInterface symmetryInterface = this.getSymmetry(atom);
            symmetryInterface.toCartesian((T3)serializable, true);
        }
        if ((serializable = this.htAtomMods.get(atom.atomName)) == null && atom.altLoc != '\u0000' && this.htSubsystems != null) {
            serializable = new Lst();
        }
        if (serializable == null || this.symmetry == null || atom.bsSymmetry == null) {
            return;
        }
        int n = Math.max(atom.bsSymmetry.nextSetBit(0), 0);
        if (this.modLast) {
            n = Math.max((atom.bsSymmetry.length() - 1) % this.nOps, n);
        }
        if (Logger.debuggingHigh) {
            Logger.debug("\nsetModulation: i=" + atom.index + " " + atom.atomName + " xyz=" + atom + " occ=" + atom.foccupancy);
        }
        if (n != this.iopLast) {
            this.iopLast = n;
            this.gammaE = new M3();
            this.getSymmetry(atom).getSpaceGroupOperation(n).getRotationScale(this.gammaE);
        }
        if (Logger.debugging) {
            Logger.debug("setModulation iop = " + n + " " + this.symmetry.getSpaceGroupXyz(n, false) + " " + atom.bsSymmetry);
        }
        ModulationSet modulationSet = new ModulationSet().setMod(atom.index + " " + atom.atomName, this.getAtomR0(this.cr.asc.atoms[atom.atomSite]), this.getAtomR0(atom), this.modDim, (Lst<Modulation>)serializable, this.gammaE, this.getMatrices(atom), n, this.getSymmetry(atom), atom.vib instanceof Vibration ? (Vibration)atom.vib : null);
        modulationSet.calculate(this.modTUV, false);
        if (!Float.isNaN(modulationSet.vOcc)) {
            double d;
            object = this.getMod("J_O#0;" + atom.atomName);
            float f = modulationSet.vOcc0;
            if (Float.isNaN(f)) {
                d = modulationSet.vOcc;
            } else if (object == null) {
                d = atom.foccupancy + modulationSet.vOcc;
            } else if (atom.vib != null) {
                double d2 = atom.vib.x;
                double d3 = (double)atom.foccupancy * d2 / (double)this.nOps / object[1];
                d = d3 * (object[1] + (double)modulationSet.vOcc);
            } else {
                d = (double)(object[0] * (object[1] + (double)modulationSet.vOcc));
            }
            float f2 = atom.foccupancy = d > 0.49 && d < 0.5 ? 0.489f : (float)Math.min(1.0, Math.max(0.0, d));
        }
        if (modulationSet.htUij != null) {
            Object object2 = object = atom.tensors == null ? null : (Tensor)atom.tensors.get(0);
            if (object != null && ((Tensor)object).parBorU != null) {
                atom.anisoBorU = new float[8];
                for (int i = 0; i < 8; ++i) {
                    atom.anisoBorU[i] = ((Tensor)object).parBorU[i];
                }
                ((Tensor)object).isUnmodulated = true;
            }
            if (atom.anisoBorU == null) {
                Logger.error("MOD RDR cannot modulate nonexistent atom anisoBorU for atom " + atom.atomName);
            } else {
                if (Logger.debuggingHigh) {
                    Logger.debug("setModulation Uij(initial)=" + Escape.eAF(atom.anisoBorU));
                    Logger.debug("setModulation tensor=" + Escape.e(((Tensor)atom.tensors.get(0)).getInfo("all")));
                }
                for (Map.Entry<String, Float> entry : modulationSet.htUij.entrySet()) {
                    this.addUStr(atom, entry.getKey(), entry.getValue().floatValue());
                }
                SymmetryInterface symmetryInterface = this.getAtomSymmetry(atom, this.symmetry);
                object = this.cr.asc.getXSymmetry().addRotatedTensor(atom, symmetryInterface.getTensor(this.cr.vwr, atom.anisoBorU), n, false, symmetryInterface);
                ((Tensor)object).isModulated = true;
                ((Tensor)object).id = Escape.e(atom.anisoBorU);
                atom.bfactor = atom.anisoBorU[7] * 100.0f;
                atom.anisoBorU = null;
                if (Logger.debuggingHigh) {
                    Logger.debug("setModulation Uij(final)=" + Escape.eAF(atom.anisoBorU) + "\n");
                    Logger.debug("setModulation tensor=" + Escape.e(((Tensor)atom.tensors.get(1)).getInfo("all")));
                }
            }
        }
        if (Float.isNaN(modulationSet.x)) {
            modulationSet.set(0.0f, 0.0f, 0.0f);
        }
        atom.vib = modulationSet;
    }

    private P3 getAtomR0(Atom atom) {
        P3 p3 = P3.newP(atom);
        if (this.supercellSymmetry != null) {
            this.supercellSymmetry.toCartesian(p3, true);
            this.symmetry.toFractional(p3, true);
        }
        return p3;
    }

    @Override
    public SymmetryInterface getAtomSymmetry(Atom atom, SymmetryInterface symmetryInterface) {
        Subsystem subsystem;
        return this.htSubsystems == null || (subsystem = this.getSubsystem(atom)) == null ? symmetryInterface : subsystem.getSymmetry();
    }

    private void setSubsystem(String string, Subsystem subsystem) {
        if (this.htSubsystems == null) {
            this.htSubsystems = new Hashtable<String, Subsystem>();
        }
        this.htSubsystems.put(string, subsystem);
        this.setSubsystemOptions();
    }

    private Matrix[] getMatrices(Atom atom) {
        Subsystem subsystem = this.getSubsystem(atom);
        return subsystem == null ? this.modMatrices : subsystem.getModMatrices();
    }

    private SymmetryInterface getSymmetry(Atom atom) {
        Subsystem subsystem = this.getSubsystem(atom);
        return subsystem == null ? this.symmetry : subsystem.getSymmetry();
    }

    private Subsystem getSubsystem(Atom atom) {
        return this.htSubsystems == null ? null : this.htSubsystems.get("" + atom.altLoc);
    }

    @Override
    public void setMinMax0(P3 p3, P3 p32) {
        if (this.htSubsystems == null) {
            return;
        }
        SymmetryInterface symmetryInterface = this.getDefaultUnitCell();
        this.minXYZ0 = P3.newP(p3);
        this.maxXYZ0 = P3.newP(p32);
        P3 p33 = P3.newP(p3);
        P3 p34 = P3.newP(p32);
        P3 p35 = new P3();
        symmetryInterface.toCartesian(p33, true);
        symmetryInterface.toCartesian(p34, true);
        P3[] p3Array = BoxInfo.unitCubePoints;
        if (this.sigma == null) {
            Logger.error("Why are we in MSRdr.setMinMax0 without modulation init?");
            return;
        }
        for (Map.Entry<String, Subsystem> entry : this.htSubsystems.entrySet()) {
            SymmetryInterface symmetryInterface2 = entry.getValue().getSymmetry();
            int n = 8;
            while (--n >= 0) {
                p35.x = p3Array[n].x == 0.0f ? p33.x : p34.x;
                p35.y = p3Array[n].y == 0.0f ? p33.y : p34.y;
                p35.z = p3Array[n].z == 0.0f ? p33.z : p34.z;
                this.expandMinMax(p35, symmetryInterface2, p3, p32);
            }
        }
    }

    private void expandMinMax(P3 p3, SymmetryInterface symmetryInterface, P3 p32, P3 p33) {
        P3 p34 = P3.newP(p3);
        float f = 1.0E-4f;
        symmetryInterface.toFractional(p34, false);
        if (p32.x > p34.x + f) {
            p32.x = (int)Math.floor(p34.x) - 1;
        }
        if (p32.y > p34.y + f) {
            p32.y = (int)Math.floor(p34.y) - 1;
        }
        if (p32.z > p34.z + f) {
            p32.z = (int)Math.floor(p34.z) - 1;
        }
        if (p33.x < p34.x - f) {
            p33.x = (int)Math.ceil(p34.x) + 1;
        }
        if (p33.y < p34.y - f) {
            p33.y = (int)Math.ceil(p34.y) + 1;
        }
        if (p33.z < p34.z - f) {
            p33.z = (int)Math.ceil(p34.z) + 1;
        }
    }

    private void trimAtomSet() {
        if (!this.cr.doApplySymmetry) {
            return;
        }
        AtomSetCollection atomSetCollection = this.cr.asc;
        BS bS = atomSetCollection.bsAtoms;
        SymmetryInterface symmetryInterface = this.getDefaultUnitCell();
        Atom[] atomArray = atomSetCollection.atoms;
        P3 p3 = new P3();
        if (bS == null) {
            bS = atomSetCollection.bsAtoms = BSUtil.newBitSet2(0, atomSetCollection.ac);
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            boolean bl;
            Atom atom = atomArray[n];
            boolean bl2 = bl = !this.isCommensurate || this.modAverage || atom.foccupancy >= 0.5f;
            if (bl) {
                p3.setT(atom);
                if (atom.vib != null) {
                    p3.add(atom.vib);
                }
                this.getSymmetry(atom).toCartesian(p3, false);
                symmetryInterface.toFractional(p3, false);
                if (this.cr.fixJavaFloat) {
                    PT.fixPtFloats(p3, 100000.0f);
                }
                bl = atomSetCollection.xtalSymmetry.isWithinCell(3, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, 0.001f);
            }
            if (bl) {
                if (this.cr.fixJavaFloat) {
                    PT.fixPtFloats(atom, 100000.0f);
                }
            } else {
                bS.clear(n);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private SymmetryInterface getDefaultUnitCell() {
        return this.modCell != null && this.htSubsystems.containsKey(this.modCell) ? this.htSubsystems.get(this.modCell).getSymmetry() : this.cr.asc.getSymmetry();
    }

    @Override
    public SymmetryInterface getSymmetryFromCode(String string) {
        return this.htSubsystems.get(string).getSymmetry();
    }

    @Override
    public boolean addLatticeVector(Lst<float[]> lst, String string) throws Exception {
        float[] fArray = null;
        char c = string.charAt(0);
        int n = this.modDim + 3;
        switch (c) {
            case 'P': 
            case 'X': {
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'I': {
                fArray = new float[]{0.5f, 0.5f, 0.5f};
                if (c == 'I') break;
                fArray[c - 65] = 0.0f;
                break;
            }
            case 'F': {
                this.addLatticeVector(lst, "A");
                this.addLatticeVector(lst, "B");
                this.addLatticeVector(lst, "C");
                break;
            }
            case 'M': {
                ++n;
            }
            case '0': {
                if (string.indexOf(".") < 0) break;
                fArray = AtomSetCollectionReader.getTokensFloat(string, null, n);
                break;
            }
            default: {
                return false;
            }
        }
        if (fArray != null) {
            lst.addLast(fArray);
        }
        return true;
    }
}

