/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.HallInfo;
import org.jmol.symmetry.HallTranslation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

class SpaceGroup {
    private static String[] canonicalSeitzList;
    int index = ++sgIndex;
    boolean isSSG;
    String name = "unknown!";
    String hallSymbol;
    String hmSymbol;
    String hmSymbolFull;
    String hmSymbolExt;
    String hmSymbolAbbr;
    String hmSymbolAlternative;
    String hmSymbolAbbrShort;
    char ambiguityType = '\u0000';
    char uniqueAxis = '\u0000';
    char axisChoice = '\u0000';
    String intlTableNumber;
    String intlTableNumberFull;
    String intlTableNumberExt;
    HallInfo hallInfo;
    int latticeParameter;
    SymmetryOperation[] operations;
    SymmetryOperation[] finalOperations;
    int operationCount;
    int latticeOp = -1;
    Map<String, Integer> xyzList;
    private int modDim;
    boolean doNormalize = true;
    boolean isBio;
    boolean isBilbao;
    private static final int NAME_HALL = 5;
    private static final int NAME_HM = 3;
    private static int sgIndex;
    private static String ambiguousNames;
    private static String lastInfo;
    private static SpaceGroup[] SG;
    private static String[] STR_SG;

    static SpaceGroup getNull(boolean bl) {
        SpaceGroup.getSpaceGroups();
        return new SpaceGroup(null, bl);
    }

    private SpaceGroup(String string, boolean bl) {
        this.init(bl && string == null);
        if (bl && string != null) {
            this.buildSpaceGroup(string);
        }
    }

    SpaceGroup set(boolean bl) {
        this.doNormalize = bl;
        return this;
    }

    private void init(boolean bl) {
        this.xyzList = new Hashtable<String, Integer>();
        this.operationCount = 0;
        if (bl) {
            this.addSymmetry("x,y,z", 0, false);
        }
    }

    static SpaceGroup createSpaceGroup(int n, String string, Object object) {
        SpaceGroup spaceGroup = null;
        if (n >= 0) {
            spaceGroup = SpaceGroup.getSpaceGroups()[n];
        } else {
            spaceGroup = object instanceof Lst ? SpaceGroup.createSGFromList(string, (Lst)object) : SpaceGroup.determineSpaceGroupNA(string, (float[])object);
            if (spaceGroup == null) {
                spaceGroup = SpaceGroup.createSpaceGroupN(string);
            }
        }
        if (spaceGroup != null) {
            spaceGroup.generateAllOperators(null);
        }
        return spaceGroup;
    }

    private static SpaceGroup createSGFromList(String string, Lst<?> lst) {
        SpaceGroup spaceGroup = new SpaceGroup("0;--;--;--", true);
        spaceGroup.doNormalize = false;
        spaceGroup.name = string;
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            Object e = lst.get(i);
            if (e instanceof SymmetryOperation) {
                SymmetryOperation symmetryOperation = (SymmetryOperation)e;
                int n2 = spaceGroup.addOp(symmetryOperation, symmetryOperation.xyz, false);
                spaceGroup.operations[n2].setTimeReversal(symmetryOperation.timeReversal);
                continue;
            }
            spaceGroup.addSymmetrySM("xyz matrix:" + e, (M4)e);
        }
        SpaceGroup spaceGroup2 = spaceGroup.getDerivedSpaceGroup();
        if (spaceGroup2 != null) {
            spaceGroup = spaceGroup2;
        }
        return spaceGroup;
    }

    int addSymmetry(String string, int n, boolean bl) {
        return (string = string.toLowerCase()).indexOf("[[") < 0 && string.indexOf("x4") < 0 && string.indexOf(";") < 0 && (string.indexOf("x") < 0 || string.indexOf("y") < 0 || string.indexOf("z") < 0) ? -1 : this.addOperation(string, n, bl);
    }

    void setFinalOperations(P3[] p3Array, int n, int n2, boolean bl) {
        Object object;
        if (this.hallInfo == null && this.latticeParameter != 0) {
            object = new HallInfo(HallTranslation.getHallLatticeEquivalent(this.latticeParameter));
            this.generateAllOperators((HallInfo)object);
        }
        this.finalOperations = null;
        boolean bl2 = this.isBio = this.name.indexOf("bio") >= 0;
        if (this.index >= SpaceGroup.getSpaceGroups().length && !this.isBio && this.name.indexOf("SSG:") < 0 && this.name.indexOf("[subsystem") < 0 && (object = this.getDerivedSpaceGroup()) != null) {
            this.name = ((SpaceGroup)object).getName();
        }
        this.finalOperations = new SymmetryOperation[this.operationCount];
        if (bl && n2 > 0 && p3Array != null) {
            this.finalOperations[0] = new SymmetryOperation(this.operations[0], p3Array, n, n2, true);
            object = p3Array[n];
            P3 p3 = P3.newP((T3)object);
            this.finalOperations[0].rotTrans(p3);
            if ((double)p3.distance((T3)object) > 1.0E-4) {
                for (int i = 0; i < n2; ++i) {
                    object = p3Array[n + i];
                    p3.setT((T3)object);
                    this.finalOperations[0].rotTrans(p3);
                    ((T3)object).setT(p3);
                }
            }
        }
        object = null;
        for (int i = 0; i < this.operationCount; ++i) {
            this.finalOperations[i] = new SymmetryOperation(this.operations[i], p3Array, n, n2, bl);
            object = this.finalOperations[i].setCentering((V3)object, true);
        }
    }

    int getOperationCount() {
        return this.finalOperations.length;
    }

    M4 getOperation(int n) {
        return this.finalOperations[n];
    }

    String getXyz(int n, boolean bl) {
        return this.finalOperations == null ? this.operations[n].getXyz(bl) : this.finalOperations[n].getXyz(bl);
    }

    void newPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4) {
        this.finalOperations[n].newPoint(p3, p32, n2, n3, n4);
    }

    static String getInfo(String string, SymmetryInterface symmetryInterface) {
        SpaceGroup spaceGroup;
        if (symmetryInterface != null) {
            if (string.indexOf("[") >= 0) {
                string = string.substring(0, string.indexOf("[")).trim();
            }
            if (string.equals("unspecified!")) {
                return "no space group identified in file";
            }
            spaceGroup = SpaceGroup.determineSpaceGroupNA(string, symmetryInterface.getNotionalUnitCell());
        } else {
            if (string.equalsIgnoreCase("ALL")) {
                return SpaceGroup.dumpAll();
            }
            if (string.equalsIgnoreCase("ALLSEITZ")) {
                return SpaceGroup.dumpAllSeitz();
            }
            spaceGroup = SpaceGroup.determineSpaceGroupN(string);
            if (spaceGroup == null) {
                spaceGroup = SpaceGroup.createSpaceGroupN(string);
            } else {
                SB sB = new SB();
                while (spaceGroup != null) {
                    sB.append(spaceGroup.dumpInfo(null));
                    spaceGroup = SpaceGroup.determineSpaceGroupNS(string, spaceGroup);
                }
                return sB.toString();
            }
        }
        return spaceGroup == null ? "?" : spaceGroup.dumpInfo(symmetryInterface);
    }

    String dumpInfo(SymmetryInterface symmetryInterface) {
        Object object = this.dumpCanonicalSeitzList();
        if (object instanceof SpaceGroup) {
            return ((SpaceGroup)object).dumpInfo(null);
        }
        SB sB = new SB().append("\nHermann-Mauguin symbol: ");
        sB.append(this.hmSymbol).append(this.hmSymbolExt.length() > 0 ? ":" + this.hmSymbolExt : "").append("\ninternational table number: ").append(this.intlTableNumber).append(this.intlTableNumberExt.length() > 0 ? ":" + this.intlTableNumberExt : "").append("\n\n").appendI(this.operationCount).append(" operators").append(!this.hallInfo.hallSymbol.equals("--") ? " from Hall symbol " + this.hallInfo.hallSymbol : "").append(": ");
        for (int i = 0; i < this.operationCount; ++i) {
            sB.append("\n").append(this.operations[i].xyz);
        }
        sB.append("\n\n").append(this.hallInfo == null ? "invalid Hall symbol" : this.hallInfo.dumpInfo());
        sB.append("\n\ncanonical Seitz: ").append((String)object).append("\n----------------------------------------------------\n");
        return sB.toString();
    }

    String getName() {
        return this.name;
    }

    String getLatticeDesignation() {
        return HallTranslation.getLatticeDesignation(this.latticeParameter);
    }

    void setLatticeParam(int n) {
        this.latticeParameter = n;
        if (n > 10) {
            this.latticeParameter = -HallTranslation.getLatticeIndex(HallTranslation.getLatticeCode(n));
        }
    }

    private Object dumpCanonicalSeitzList() {
        SpaceGroup spaceGroup;
        if (this.hallInfo == null) {
            this.hallInfo = new HallInfo(this.hallSymbol);
        }
        this.generateAllOperators(null);
        String string = this.getCanonicalSeitzList();
        if (this.index >= SG.length && (spaceGroup = SpaceGroup.findSpaceGroup(string)) != null) {
            return spaceGroup;
        }
        return (this.index >= 0 && this.index < SG.length ? this.hallSymbol + " = " : "") + string;
    }

    SpaceGroup getDerivedSpaceGroup() {
        String string;
        if (this.index >= 0 && this.index < SG.length || this.modDim > 0 || this.operations == null || this.operations.length == 0 || this.operations[0].timeReversal != 0) {
            return this;
        }
        if (this.finalOperations != null) {
            this.setFinalOperations(null, 0, 0, false);
        }
        return (string = this.getCanonicalSeitzList()) == null ? null : SpaceGroup.findSpaceGroup(string);
    }

    private String getCanonicalSeitzList() {
        Object[] objectArray = new String[this.operationCount];
        for (int i = 0; i < this.operationCount; ++i) {
            objectArray[i] = SymmetryOperation.dumpSeitz(this.operations[i], true);
        }
        Arrays.sort(objectArray, 0, this.operationCount);
        SB sB = new SB().append("\n[");
        for (int i = 0; i < this.operationCount; ++i) {
            sB.append(((String)objectArray[i]).replace('\t', ' ').replace('\n', ' ')).append("; ");
        }
        sB.append("]");
        return sB.toString();
    }

    private static synchronized SpaceGroup findSpaceGroup(String string) {
        SpaceGroup.getSpaceGroups();
        if (canonicalSeitzList == null) {
            canonicalSeitzList = new String[SG.length];
        }
        for (int i = 0; i < SG.length; ++i) {
            if (canonicalSeitzList[i] == null) {
                SpaceGroup.canonicalSeitzList[i] = (String)SG[i].dumpCanonicalSeitzList();
            }
            if (canonicalSeitzList[i].indexOf(string) < 0) continue;
            return SG[i];
        }
        return null;
    }

    private static final String dumpAll() {
        SB sB = new SB();
        SpaceGroup.getSpaceGroups();
        for (int i = 0; i < SG.length; ++i) {
            sB.append("\n----------------------\n" + SG[i].dumpInfo(null));
        }
        return sB.toString();
    }

    private static final String dumpAllSeitz() {
        SpaceGroup.getSpaceGroups();
        SB sB = new SB();
        for (int i = 0; i < SG.length; ++i) {
            sB.append("\n").appendO(SG[i].dumpCanonicalSeitzList());
        }
        return sB.toString();
    }

    private void setLattice(char c, boolean bl) {
        this.latticeParameter = HallTranslation.getLatticeIndex(c);
        if (!bl) {
            this.latticeParameter = -this.latticeParameter;
        }
    }

    private static final SpaceGroup createSpaceGroupN(String string) {
        SpaceGroup.getSpaceGroups();
        string = string.trim();
        SpaceGroup spaceGroup = SpaceGroup.determineSpaceGroupN(string);
        if (spaceGroup == null) {
            HallInfo hallInfo = new HallInfo(string);
            if (hallInfo.nRotations > 0) {
                spaceGroup = new SpaceGroup("0;--;--;" + string, true);
                spaceGroup.hallInfo = hallInfo;
            } else if (string.indexOf(",") >= 0) {
                spaceGroup = new SpaceGroup("0;--;--;--", true);
                spaceGroup.doNormalize = false;
                spaceGroup.generateOperatorsFromXyzInfo(string);
            }
        }
        if (spaceGroup != null) {
            spaceGroup.generateAllOperators(null);
        }
        return spaceGroup;
    }

    private int addOperation(String string, int n, boolean bl) {
        int n2;
        boolean bl2;
        if (string == null || string.length() < 3) {
            this.init(false);
            return -1;
        }
        boolean bl3 = bl2 = string.charAt(0) == '=';
        if (bl2) {
            string = string.substring(1);
        }
        if ((n2 = this.checkXYZlist(string)) >= 0) {
            return n2;
        }
        if (string.startsWith("x1,x2,x3,x4") && this.modDim == 0) {
            this.xyzList.clear();
            this.operationCount = 0;
            this.modDim = PT.parseInt(string.substring(string.lastIndexOf("x") + 1)) - 3;
        } else if (string.equals("x,y,z,m")) {
            this.xyzList.clear();
            this.operationCount = 0;
        }
        SymmetryOperation symmetryOperation = new SymmetryOperation(null, null, 0, n, this.doNormalize);
        if (!symmetryOperation.setMatrixFromXYZ(string, this.modDim, bl)) {
            Logger.error("couldn't interpret symmetry operation: " + string);
            return -1;
        }
        return this.addOp(symmetryOperation, string, bl2);
    }

    private int checkXYZlist(String string) {
        return this.xyzList.containsKey(string) && (this.latticeOp <= 0 || string.indexOf("/") >= 0) ? this.xyzList.get(string) : -1;
    }

    private int addOp(SymmetryOperation symmetryOperation, String string, boolean bl) {
        String string2 = symmetryOperation.xyz;
        if (!bl) {
            int n = this.checkXYZlist(string2);
            if (n >= 0) {
                return n;
            }
            if (this.latticeOp < 0) {
                String string3 = this.modDim > 0 ? SymmetryOperation.replaceXn(string2, this.modDim + 3) : string2;
                String string4 = PT.replaceAllCharacters(string3, "+123/", "");
                if (this.xyzList.containsKey(string4)) {
                    this.latticeOp = this.operationCount;
                } else {
                    this.xyzList.put(string4, this.operationCount);
                }
            }
            this.xyzList.put(string2, this.operationCount);
        }
        if (!string2.equals(string)) {
            this.xyzList.put(string, this.operationCount);
        }
        if (this.operations == null) {
            this.operations = new SymmetryOperation[4];
        }
        if (this.operationCount == this.operations.length) {
            this.operations = (SymmetryOperation[])AU.arrayCopyObject(this.operations, this.operationCount * 2);
        }
        this.operations[this.operationCount++] = symmetryOperation;
        symmetryOperation.index = this.operationCount;
        if (Logger.debugging) {
            Logger.debug("\naddOperation " + this.operationCount + symmetryOperation.dumpInfo());
        }
        return this.operationCount - 1;
    }

    private void generateOperatorsFromXyzInfo(String string) {
        this.init(true);
        String[] stringArray = PT.split(string.toLowerCase(), ";");
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSymmetry(stringArray[i], 0, false);
        }
    }

    private void generateAllOperators(HallInfo hallInfo) {
        int n;
        if (hallInfo == null) {
            hallInfo = this.hallInfo;
            if (this.operationCount > 0) {
                return;
            }
            this.operations = new SymmetryOperation[4];
            if (this.hallInfo == null || this.hallInfo.nRotations == 0) {
                hallInfo = this.hallInfo = new HallInfo(this.hallSymbol);
            }
            this.setLattice(this.hallInfo.latticeCode, this.hallInfo.isCentrosymmetric);
            this.init(true);
        }
        M4 m4 = new M4();
        M4 m42 = new M4();
        M4[] m4Array = new M4[7];
        for (n = 0; n < 7; ++n) {
            m4Array[n] = new M4();
        }
        for (n = 0; n < hallInfo.nRotations; ++n) {
            m4.setM4(hallInfo.rotationTerms[n].seitzMatrix12ths);
            int n2 = hallInfo.rotationTerms[n].order;
            m4Array[0].setIdentity();
            int n3 = this.operationCount;
            for (int i = 1; i <= n2; ++i) {
                m4Array[i].mul2(m4, m4Array[0]);
                m4Array[0].setM4(m4Array[i]);
                for (int j = 0; j < n3; ++j) {
                    m42.mul2(m4Array[i], this.operations[j]);
                    SymmetryOperation.normalizeTranslation(m42);
                    String string = SymmetryOperation.getXYZFromMatrix(m42, true, true, true);
                    this.addSymmetrySM(string, m42);
                }
            }
        }
    }

    int addSymmetrySM(String string, M4 m4) {
        int n = this.addOperation(string, 0, false);
        if (n >= 0) {
            SymmetryOperation symmetryOperation = this.operations[n];
            symmetryOperation.setM4(m4);
        }
        return n;
    }

    private static final SpaceGroup determineSpaceGroupN(String string) {
        return SpaceGroup.determineSpaceGroup(string, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1);
    }

    private static final SpaceGroup determineSpaceGroupNS(String string, SpaceGroup spaceGroup) {
        return SpaceGroup.determineSpaceGroup(string, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, spaceGroup.index);
    }

    private static final SpaceGroup determineSpaceGroupNA(String string, float[] fArray) {
        return fArray == null ? SpaceGroup.determineSpaceGroup(string, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1) : SpaceGroup.determineSpaceGroup(string, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], -1);
    }

    private static final SpaceGroup determineSpaceGroup(String string, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        int n2 = SpaceGroup.determineSpaceGroupIndex(string, f, f2, f3, f4, f5, f6, n);
        return n2 >= 0 ? SG[n2] : null;
    }

    private static final int determineSpaceGroupIndex(String string, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        SpaceGroup spaceGroup;
        int n2;
        int n3;
        SpaceGroup.getSpaceGroups();
        if (n < 0) {
            n = SG.length;
        }
        string = string.trim().toLowerCase();
        boolean bl = false;
        if (string.startsWith("bilbao:")) {
            bl = true;
            string = string.substring(7);
        }
        int n4 = string.startsWith("hall:") ? 5 : (n3 = string.startsWith("hm:") ? 3 : 0);
        if (n3 > 0) {
            string = string.substring(n3);
        } else if (string.contains("[")) {
            n3 = 5;
            string = string.substring(0, string.indexOf("[")).trim();
        }
        String string2 = string;
        boolean bl2 = false;
        string = string.replace('_', ' ');
        if (string.length() >= 2) {
            int n5 = n2 = string.indexOf("-") == 0 ? 2 : 1;
            if (n2 < string.length() && string.charAt(n2) != ' ') {
                string = string.substring(0, n2) + " " + string.substring(n2);
            }
            string = string.substring(0, 2).toUpperCase() + string.substring(2);
        }
        String string3 = "";
        n2 = string.indexOf(":");
        if (n2 > 0) {
            string3 = string.substring(n2 + 1);
            string = string.substring(0, n2).trim();
            bl2 = true;
        }
        if (n3 != 5 && !bl2 && PT.isOneOf(string, ambiguousNames)) {
            string3 = "?";
            bl2 = true;
        }
        String string4 = PT.replaceAllCharacters(string, " ()", "");
        if (n3 != 3 && !bl2) {
            n2 = n;
            while (--n2 >= 0) {
                if (!SpaceGroup.SG[n2].hallSymbol.equals(string)) continue;
                return n2;
            }
        }
        if (n3 != 5) {
            if (n3 != 3) {
                n2 = n;
                while (--n2 >= 0) {
                    if (!SpaceGroup.SG[n2].intlTableNumberFull.equals(string2)) continue;
                    return n2;
                }
            }
            n2 = n;
            while (--n2 >= 0) {
                if (!SpaceGroup.SG[n2].hmSymbolFull.equals(string2)) continue;
                return n2;
            }
            n2 = n;
            while (--n2 >= 0) {
                spaceGroup = SG[n2];
                if (spaceGroup.hmSymbolAlternative == null || !spaceGroup.hmSymbolAlternative.equals(string2)) continue;
                return n2;
            }
            if (bl2) {
                n2 = n;
                while (--n2 >= 0) {
                    spaceGroup = SG[n2];
                    if (!spaceGroup.hmSymbolAbbr.equals(string4) || !spaceGroup.intlTableNumberExt.equals(string3)) continue;
                    return n2;
                }
                n2 = n;
                while (--n2 >= 0) {
                    spaceGroup = SG[n2];
                    if (!spaceGroup.hmSymbolAbbrShort.equals(string4) || !spaceGroup.intlTableNumberExt.equals(string3)) continue;
                    return n2;
                }
            }
            char c = SpaceGroup.determineUniqueAxis(f, f2, f3, f4, f5, f6);
            if (!bl2 || string3.charAt(0) == '?') {
                block12: for (n2 = 0; n2 < n; ++n2) {
                    spaceGroup = SG[n2];
                    if (!spaceGroup.hmSymbolAbbr.equals(string4) && !spaceGroup.hmSymbolAbbrShort.equals(string4) || bl && !spaceGroup.isBilbao) continue;
                    switch (spaceGroup.ambiguityType) {
                        case '\u0000': {
                            return n2;
                        }
                        case 'a': {
                            if (spaceGroup.uniqueAxis != c && c != '\u0000') continue block12;
                            return n2;
                        }
                        case 'o': {
                            if (!(string3.length() == 0 ? spaceGroup.hmSymbolExt.equals("2") : spaceGroup.hmSymbolExt.equals(string3))) continue block12;
                            return n2;
                        }
                        case 't': {
                            if (!(string3.length() == 0 ? spaceGroup.axisChoice == 'h' : (spaceGroup.axisChoice + "").equals(string3))) continue block12;
                            return n2;
                        }
                    }
                }
            }
        }
        if (string3.length() == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                spaceGroup = SG[n2];
                if (!spaceGroup.intlTableNumber.equals(string2) || bl && !spaceGroup.isBilbao) continue;
                return n2;
            }
        }
        return -1;
    }

    private static final char determineUniqueAxis(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f == f2) {
            return f2 == f3 ? (char)'\u0000' : 'c';
        }
        if (f2 == f3) {
            return 'a';
        }
        if (f3 == f) {
            return 'b';
        }
        if (f4 == f5) {
            return f5 == f6 ? (char)'\u0000' : 'c';
        }
        if (f5 == f6) {
            return 'a';
        }
        if (f6 == f4) {
            return 'b';
        }
        return '\u0000';
    }

    private void buildSpaceGroup(String string) {
        String[] stringArray = PT.split(string.toLowerCase(), ";");
        this.intlTableNumberFull = stringArray[0].trim();
        this.isBilbao = stringArray.length < 5 && !this.intlTableNumberFull.equals("0");
        String[] stringArray2 = PT.split(this.intlTableNumberFull, ":");
        this.intlTableNumber = stringArray2[0];
        this.intlTableNumberExt = stringArray2.length == 1 ? "" : stringArray2[1];
        this.ambiguityType = '\u0000';
        if (this.intlTableNumberExt.length() > 0) {
            if (this.intlTableNumberExt.equals("h") || this.intlTableNumberExt.equals("r")) {
                this.ambiguityType = (char)116;
                this.axisChoice = this.intlTableNumberExt.charAt(0);
            } else if (this.intlTableNumberExt.startsWith("1") || this.intlTableNumberExt.startsWith("2")) {
                this.ambiguityType = (char)111;
            } else if (this.intlTableNumberExt.length() <= 2) {
                this.ambiguityType = (char)97;
                this.uniqueAxis = this.intlTableNumberExt.charAt(0);
            } else if (this.intlTableNumberExt.contains("-")) {
                this.ambiguityType = (char)45;
            }
        }
        this.hmSymbolFull = Character.toUpperCase(stringArray[2].charAt(0)) + stringArray[2].substring(1);
        stringArray2 = PT.split(this.hmSymbolFull, ":");
        this.hmSymbol = stringArray2[0];
        this.hmSymbolExt = stringArray2.length == 1 ? "" : stringArray2[1];
        int n = this.hmSymbol.indexOf(" -3");
        if (n >= 1 && "admn".indexOf(this.hmSymbol.charAt(n - 1)) >= 0) {
            this.hmSymbolAlternative = (this.hmSymbol.substring(0, n) + " 3" + this.hmSymbol.substring(n + 3)).toLowerCase();
        }
        this.hmSymbolAbbr = PT.rep(this.hmSymbol, " ", "");
        this.hmSymbolAbbrShort = PT.rep(this.hmSymbol, " 1", "");
        this.hmSymbolAbbrShort = PT.rep(this.hmSymbolAbbrShort, " ", "");
        this.hallSymbol = stringArray[3];
        if (this.hallSymbol.length() > 1) {
            this.hallSymbol = this.hallSymbol.substring(0, 2).toUpperCase() + this.hallSymbol.substring(2);
        }
        String string2 = this.intlTableNumber + this.hallSymbol;
        if (this.intlTableNumber.charAt(0) != '0' && lastInfo.equals(string2)) {
            ambiguousNames = ambiguousNames + this.hmSymbol + ";";
        }
        lastInfo = string2;
        this.name = this.hallSymbol + " [" + this.hmSymbolFull + "] #" + this.intlTableNumber;
    }

    private static synchronized SpaceGroup[] getSpaceGroups() {
        SpaceGroup[] spaceGroupArray;
        if (SG == null) {
            SG = SpaceGroup.createSpaceGroups();
            spaceGroupArray = SG;
        } else {
            spaceGroupArray = SG;
        }
        return spaceGroupArray;
    }

    private static SpaceGroup[] createSpaceGroups() {
        int n = STR_SG.length;
        SpaceGroup[] spaceGroupArray = new SpaceGroup[n];
        for (int i = 0; i < n; ++i) {
            spaceGroupArray[i] = new SpaceGroup(STR_SG[i], true);
        }
        STR_SG = null;
        return spaceGroupArray;
    }

    boolean addLatticeVectors(Lst<float[]> lst) {
        if (this.latticeOp >= 0 || lst.size() == 0) {
            return false;
        }
        int n = this.latticeOp = this.operationCount;
        boolean bl = ((float[])lst.get(0)).length == this.modDim + 4;
        int n2 = -2;
        for (int i = 0; i < lst.size(); ++i) {
            float[] fArray = (float[])lst.get(i);
            if (bl) {
                n2 = (int)fArray[this.modDim + 3];
                fArray = AU.arrayCopyF(fArray, this.modDim + 3);
            }
            if (fArray.length > this.modDim + 3) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                SymmetryOperation symmetryOperation = new SymmetryOperation(null, null, 0, 0, this.doNormalize);
                symmetryOperation.modDim = this.modDim;
                SymmetryOperation symmetryOperation2 = this.operations[j];
                symmetryOperation.linearRotTrans = AU.arrayCopyF(symmetryOperation2.linearRotTrans, -1);
                symmetryOperation.setFromMatrix(fArray, false);
                if (n2 != -2) {
                    symmetryOperation.setTimeReversal(symmetryOperation2.timeReversal * n2);
                }
                symmetryOperation.xyzOriginal = symmetryOperation.xyz;
                this.addOp(symmetryOperation, symmetryOperation.xyz, true);
            }
        }
        return true;
    }

    int getSiteMultiplicity(P3 p3, UnitCell unitCell) {
        int n = this.finalOperations.length;
        Lst<P3> lst = new Lst<P3>();
        int n2 = n;
        while (--n2 >= 0) {
            P3 p32 = P3.newP(p3);
            this.finalOperations[n2].rotTrans(p32);
            unitCell.unitize(p32);
            int n3 = lst.size();
            while (--n3 >= 0) {
                P3 p33 = (P3)lst.get(n3);
                if (!(p32.distanceSquared(p33) < 1.0E-6f)) continue;
                p32 = null;
                break;
            }
            if (p32 == null) continue;
            lst.addLast(p32);
        }
        return n / lst.size();
    }

    static {
        sgIndex = -1;
        ambiguousNames = "";
        lastInfo = "";
        STR_SG = new String[]{"1;c1^1;p 1;p 1", "2;ci^1;p -1;-p 1", "3:b;c2^1;p 1 2 1;p 2y", "3:b;c2^1;p 2;p 2y", "3:c;c2^1;p 1 1 2;p 2", "3:a;c2^1;p 2 1 1;p 2x", "4:b;c2^2;p 1 21 1;p 2yb", "4:b;c2^2;p 21;p 2yb", "4:b*;c2^2;p 1 21 1*;p 2y1", "4:c;c2^2;p 1 1 21;p 2c", "4:c*;c2^2;p 1 1 21*;p 21", "4:a;c2^2;p 21 1 1;p 2xa", "4:a*;c2^2;p 21 1 1*;p 2x1", "5:b1;c2^3;c 1 2 1;c 2y", "5:b1;c2^3;c 2;c 2y", "5:b2;c2^3;a 1 2 1;a 2y", "5:b3;c2^3;i 1 2 1;i 2y", "5:c1;c2^3;a 1 1 2;a 2", "5:c2;c2^3;b 1 1 2;b 2", "5:c3;c2^3;i 1 1 2;i 2", "5:a1;c2^3;b 2 1 1;b 2x", "5:a2;c2^3;c 2 1 1;c 2x", "5:a3;c2^3;i 2 1 1;i 2x", "6:b;cs^1;p 1 m 1;p -2y", "6:b;cs^1;p m;p -2y", "6:c;cs^1;p 1 1 m;p -2", "6:a;cs^1;p m 1 1;p -2x", "7:b1;cs^2;p 1 c 1;p -2yc", "7:b1;cs^2;p c;p -2yc", "7:b2;cs^2;p 1 n 1;p -2yac", "7:b2;cs^2;p n;p -2yac", "7:b3;cs^2;p 1 a 1;p -2ya", "7:b3;cs^2;p a;p -2ya", "7:c1;cs^2;p 1 1 a;p -2a", "7:c2;cs^2;p 1 1 n;p -2ab", "7:c3;cs^2;p 1 1 b;p -2b", "7:a1;cs^2;p b 1 1;p -2xb", "7:a2;cs^2;p n 1 1;p -2xbc", "7:a3;cs^2;p c 1 1;p -2xc", "8:b1;cs^3;c 1 m 1;c -2y", "8:b1;cs^3;c m;c -2y", "8:b2;cs^3;a 1 m 1;a -2y", "8:b3;cs^3;i 1 m 1;i -2y", "8:b3;cs^3;i m;i -2y", "8:c1;cs^3;a 1 1 m;a -2", "8:c2;cs^3;b 1 1 m;b -2", "8:c3;cs^3;i 1 1 m;i -2", "8:a1;cs^3;b m 1 1;b -2x", "8:a2;cs^3;c m 1 1;c -2x", "8:a3;cs^3;i m 1 1;i -2x", "9:b1;cs^4;c 1 c 1;c -2yc", "9:b1;cs^4;c c;c -2yc", "9:b2;cs^4;a 1 n 1;a -2yab", "9:b3;cs^4;i 1 a 1;i -2ya", "9:-b1;cs^4;a 1 a 1;a -2ya", "9:-b2;cs^4;c 1 n 1;c -2yac", "9:-b3;cs^4;i 1 c 1;i -2yc", "9:c1;cs^4;a 1 1 a;a -2a", "9:c2;cs^4;b 1 1 n;b -2ab", "9:c3;cs^4;i 1 1 b;i -2b", "9:-c1;cs^4;b 1 1 b;b -2b", "9:-c2;cs^4;a 1 1 n;a -2ab", "9:-c3;cs^4;i 1 1 a;i -2a", "9:a1;cs^4;b b 1 1;b -2xb", "9:a2;cs^4;c n 1 1;c -2xac", "9:a3;cs^4;i c 1 1;i -2xc", "9:-a1;cs^4;c c 1 1;c -2xc", "9:-a2;cs^4;b n 1 1;b -2xab", "9:-a3;cs^4;i b 1 1;i -2xb", "10:b;c2h^1;p 1 2/m 1;-p 2y", "10:b;c2h^1;p 2/m;-p 2y", "10:c;c2h^1;p 1 1 2/m;-p 2", "10:a;c2h^1;p 2/m 1 1;-p 2x", "11:b;c2h^2;p 1 21/m 1;-p 2yb", "11:b;c2h^2;p 21/m;-p 2yb", "11:b*;c2h^2;p 1 21/m 1*;-p 2y1", "11:c;c2h^2;p 1 1 21/m;-p 2c", "11:c*;c2h^2;p 1 1 21/m*;-p 21", "11:a;c2h^2;p 21/m 1 1;-p 2xa", "11:a*;c2h^2;p 21/m 1 1*;-p 2x1", "12:b1;c2h^3;c 1 2/m 1;-c 2y", "12:b1;c2h^3;c 2/m;-c 2y", "12:b2;c2h^3;a 1 2/m 1;-a 2y", "12:b3;c2h^3;i 1 2/m 1;-i 2y", "12:b3;c2h^3;i 2/m;-i 2y", "12:c1;c2h^3;a 1 1 2/m;-a 2", "12:c2;c2h^3;b 1 1 2/m;-b 2", "12:c3;c2h^3;i 1 1 2/m;-i 2", "12:a1;c2h^3;b 2/m 1 1;-b 2x", "12:a2;c2h^3;c 2/m 1 1;-c 2x", "12:a3;c2h^3;i 2/m 1 1;-i 2x", "13:b1;c2h^4;p 1 2/c 1;-p 2yc", "13:b1;c2h^4;p 2/c;-p 2yc", "13:b2;c2h^4;p 1 2/n 1;-p 2yac", "13:b2;c2h^4;p 2/n;-p 2yac", "13:b3;c2h^4;p 1 2/a 1;-p 2ya", "13:b3;c2h^4;p 2/a;-p 2ya", "13:c1;c2h^4;p 1 1 2/a;-p 2a", "13:c2;c2h^4;p 1 1 2/n;-p 2ab", "13:c3;c2h^4;p 1 1 2/b;-p 2b", "13:a1;c2h^4;p 2/b 1 1;-p 2xb", "13:a2;c2h^4;p 2/n 1 1;-p 2xbc", "13:a3;c2h^4;p 2/c 1 1;-p 2xc", "14:b1;c2h^5;p 1 21/c 1;-p 2ybc", "14:b1;c2h^5;p 21/c;-p 2ybc", "14:b2;c2h^5;p 1 21/n 1;-p 2yn", "14:b2;c2h^5;p 21/n;-p 2yn", "14:b3;c2h^5;p 1 21/a 1;-p 2yab", "14:b3;c2h^5;p 21/a;-p 2yab", "14:c1;c2h^5;p 1 1 21/a;-p 2ac", "14:c2;c2h^5;p 1 1 21/n;-p 2n", "14:c3;c2h^5;p 1 1 21/b;-p 2bc", "14:a1;c2h^5;p 21/b 1 1;-p 2xab", "14:a2;c2h^5;p 21/n 1 1;-p 2xn", "14:a3;c2h^5;p 21/c 1 1;-p 2xac", "15:b1;c2h^6;c 1 2/c 1;-c 2yc", "15:b1;c2h^6;c 2/c;-c 2yc", "15:b2;c2h^6;a 1 2/n 1;-a 2yab", "15:b3;c2h^6;i 1 2/a 1;-i 2ya", "15:b3;c2h^6;i 2/a;-i 2ya", "15:-b1;c2h^6;a 1 2/a 1;-a 2ya", "15:-b2;c2h^6;c 1 2/n 1;-c 2yac", "15:-b2;c2h^6;c 2/n;-c 2yac", "15:-b3;c2h^6;i 1 2/c 1;-i 2yc", "15:-b3;c2h^6;i 2/c;-i 2yc", "15:c1;c2h^6;a 1 1 2/a;-a 2a", "15:c2;c2h^6;b 1 1 2/n;-b 2ab", "15:c3;c2h^6;i 1 1 2/b;-i 2b", "15:-c1;c2h^6;b 1 1 2/b;-b 2b", "15:-c2;c2h^6;a 1 1 2/n;-a 2ab", "15:-c3;c2h^6;i 1 1 2/a;-i 2a", "15:a1;c2h^6;b 2/b 1 1;-b 2xb", "15:a2;c2h^6;c 2/n 1 1;-c 2xac", "15:a3;c2h^6;i 2/c 1 1;-i 2xc", "15:-a1;c2h^6;c 2/c 1 1;-c 2xc", "15:-a2;c2h^6;b 2/n 1 1;-b 2xab", "15:-a3;c2h^6;i 2/b 1 1;-i 2xb", "16;d2^1;p 2 2 2;p 2 2", "17;d2^2;p 2 2 21;p 2c 2", "17*;d2^2;p 2 2 21*;p 21 2", "17:cab;d2^2;p 21 2 2;p 2a 2a", "17:bca;d2^2;p 2 21 2;p 2 2b", "18;d2^3;p 21 21 2;p 2 2ab", "18:cab;d2^3;p 2 21 21;p 2bc 2", "18:bca;d2^3;p 21 2 21;p 2ac 2ac", "19;d2^4;p 21 21 21;p 2ac 2ab", "20;d2^5;c 2 2 21;c 2c 2", "20*;d2^5;c 2 2 21*;c 21 2", "20:cab;d2^5;a 21 2 2;a 2a 2a", "20:cab*;d2^5;a 21 2 2*;a 2a 21", "20:bca;d2^5;b 2 21 2;b 2 2b", "21;d2^6;c 2 2 2;c 2 2", "21:cab;d2^6;a 2 2 2;a 2 2", "21:bca;d2^6;b 2 2 2;b 2 2", "22;d2^7;f 2 2 2;f 2 2", "23;d2^8;i 2 2 2;i 2 2", "24;d2^9;i 21 21 21;i 2b 2c", "25;c2v^1;p m m 2;p 2 -2", "25:cab;c2v^1;p 2 m m;p -2 2", "25:bca;c2v^1;p m 2 m;p -2 -2", "26;c2v^2;p m c 21;p 2c -2", "26*;c2v^2;p m c 21*;p 21 -2", "26:ba-c;c2v^2;p c m 21;p 2c -2c", "26:ba-c*;c2v^2;p c m 21*;p 21 -2c", "26:cab;c2v^2;p 21 m a;p -2a 2a", "26:-cba;c2v^2;p 21 a m;p -2 2a", "26:bca;c2v^2;p b 21 m;p -2 -2b", "26:a-cb;c2v^2;p m 21 b;p -2b -2", "27;c2v^3;p c c 2;p 2 -2c", "27:cab;c2v^3;p 2 a a;p -2a 2", "27:bca;c2v^3;p b 2 b;p -2b -2b", "28;c2v^4;p m a 2;p 2 -2a", "28*;c2v^4;p m a 2*;p 2 -21", "28:ba-c;c2v^4;p b m 2;p 2 -2b", "28:cab;c2v^4;p 2 m b;p -2b 2", "28:-cba;c2v^4;p 2 c m;p -2c 2", "28:-cba*;c2v^4;p 2 c m*;p -21 2", "28:bca;c2v^4;p c 2 m;p -2c -2c", "28:a-cb;c2v^4;p m 2 a;p -2a -2a", "29;c2v^5;p c a 21;p 2c -2ac", "29:ba-c;c2v^5;p b c 21;p 2c -2b", "29:cab;c2v^5;p 21 a b;p -2b 2a", "29:-cba;c2v^5;p 21 c a;p -2ac 2a", "29:bca;c2v^5;p c 21 b;p -2bc -2c", "29:a-cb;c2v^5;p b 21 a;p -2a -2ab", "30;c2v^6;p n c 2;p 2 -2bc", "30:ba-c;c2v^6;p c n 2;p 2 -2ac", "30:cab;c2v^6;p 2 n a;p -2ac 2", "30:-cba;c2v^6;p 2 a n;p -2ab 2", "30:bca;c2v^6;p b 2 n;p -2ab -2ab", "30:a-cb;c2v^6;p n 2 b;p -2bc -2bc", "31;c2v^7;p m n 21;p 2ac -2", "31:ba-c;c2v^7;p n m 21;p 2bc -2bc", "31:cab;c2v^7;p 21 m n;p -2ab 2ab", "31:-cba;c2v^7;p 21 n m;p -2 2ac", "31:bca;c2v^7;p n 21 m;p -2 -2bc", "31:a-cb;c2v^7;p m 21 n;p -2ab -2", "32;c2v^8;p b a 2;p 2 -2ab", "32:cab;c2v^8;p 2 c b;p -2bc 2", "32:bca;c2v^8;p c 2 a;p -2ac -2ac", "33;c2v^9;p n a 21;p 2c -2n", "33*;c2v^9;p n a 21*;p 21 -2n", "33:ba-c;c2v^9;p b n 21;p 2c -2ab", "33:ba-c*;c2v^9;p b n 21*;p 21 -2ab", "33:cab;c2v^9;p 21 n b;p -2bc 2a", "33:cab*;c2v^9;p 21 n b*;p -2bc 21", "33:-cba;c2v^9;p 21 c n;p -2n 2a", "33:-cba*;c2v^9;p 21 c n*;p -2n 21", "33:bca;c2v^9;p c 21 n;p -2n -2ac", "33:a-cb;c2v^9;p n 21 a;p -2ac -2n", "34;c2v^10;p n n 2;p 2 -2n", "34:cab;c2v^10;p 2 n n;p -2n 2", "34:bca;c2v^10;p n 2 n;p -2n -2n", "35;c2v^11;c m m 2;c 2 -2", "35:cab;c2v^11;a 2 m m;a -2 2", "35:bca;c2v^11;b m 2 m;b -2 -2", "36;c2v^12;c m c 21;c 2c -2", "36*;c2v^12;c m c 21*;c 21 -2", "36:ba-c;c2v^12;c c m 21;c 2c -2c", "36:ba-c*;c2v^12;c c m 21*;c 21 -2c", "36:cab;c2v^12;a 21 m a;a -2a 2a", "36:cab*;c2v^12;a 21 m a*;a -2a 21", "36:-cba;c2v^12;a 21 a m;a -2 2a", "36:-cba*;c2v^12;a 21 a m*;a -2 21", "36:bca;c2v^12;b b 21 m;b -2 -2b", "36:a-cb;c2v^12;b m 21 b;b -2b -2", "37;c2v^13;c c c 2;c 2 -2c", "37:cab;c2v^13;a 2 a a;a -2a 2", "37:bca;c2v^13;b b 2 b;b -2b -2b", "38;c2v^14;a m m 2;a 2 -2", "38:ba-c;c2v^14;b m m 2;b 2 -2", "38:cab;c2v^14;b 2 m m;b -2 2", "38:-cba;c2v^14;c 2 m m;c -2 2", "38:bca;c2v^14;c m 2 m;c -2 -2", "38:a-cb;c2v^14;a m 2 m;a -2 -2", "39;c2v^15;a e m 2;a 2 -2b", "39;c2v^15;a b m 2;a 2 -2b", "39:ba-c;c2v^15;b m a 2;b 2 -2a", "39:cab;c2v^15;b 2 c m;b -2a 2", "39:-cba;c2v^15;c 2 m b;c -2a 2", "39:bca;c2v^15;c m 2 a;c -2a -2a", "39:a-cb;c2v^15;a c 2 m;a -2b -2b", "40;c2v^16;a m a 2;a 2 -2a", "40:ba-c;c2v^16;b b m 2;b 2 -2b", "40:cab;c2v^16;b 2 m b;b -2b 2", "40:-cba;c2v^16;c 2 c m;c -2c 2", "40:bca;c2v^16;c c 2 m;c -2c -2c", "40:a-cb;c2v^16;a m 2 a;a -2a -2a", "41;c2v^17;a e a 2;a 2 -2ab", "41;c2v^17;a b a 2;a 2 -2ab;-b", "41:ba-c;c2v^17;b b a 2;b 2 -2ab", "41:cab;c2v^17;b 2 c b;b -2ab 2", "41:-cba;c2v^17;c 2 c b;c -2ac 2", "41:bca;c2v^17;c c 2 a;c -2ac -2ac", "41:a-cb;c2v^17;a c 2 a;a -2ab -2ab", "42;c2v^18;f m m 2;f 2 -2", "42:cab;c2v^18;f 2 m m;f -2 2", "42:bca;c2v^18;f m 2 m;f -2 -2", "43;c2v^19;f d d 2;f 2 -2d", "43:cab;c2v^19;f 2 d d;f -2d 2", "43:bca;c2v^19;f d 2 d;f -2d -2d", "44;c2v^20;i m m 2;i 2 -2", "44:cab;c2v^20;i 2 m m;i -2 2", "44:bca;c2v^20;i m 2 m;i -2 -2", "45;c2v^21;i b a 2;i 2 -2c", "45:cab;c2v^21;i 2 c b;i -2a 2", "45:bca;c2v^21;i c 2 a;i -2b -2b", "46;c2v^22;i m a 2;i 2 -2a", "46:ba-c;c2v^22;i b m 2;i 2 -2b", "46:cab;c2v^22;i 2 m b;i -2b 2", "46:-cba;c2v^22;i 2 c m;i -2c 2", "46:bca;c2v^22;i c 2 m;i -2c -2c", "46:a-cb;c2v^22;i m 2 a;i -2a -2a", "47;d2h^1;p m m m;-p 2 2", "48:1;d2h^2;p n n n:1;p 2 2 -1n;-b", "48:2;d2h^2;p n n n:2;-p 2ab 2bc", "49;d2h^3;p c c m;-p 2 2c", "49:cab;d2h^3;p m a a;-p 2a 2", "49:bca;d2h^3;p b m b;-p 2b 2b", "50:1;d2h^4;p b a n:1;p 2 2 -1ab;-b", "50:2;d2h^4;p b a n:2;-p 2ab 2b", "50:1cab;d2h^4;p n c b:1;p 2 2 -1bc", "50:2cab;d2h^4;p n c b:2;-p 2b 2bc", "50:1bca;d2h^4;p c n a:1;p 2 2 -1ac", "50:2bca;d2h^4;p c n a:2;-p 2a 2c", "51;d2h^5;p m m a;-p 2a 2a", "51:ba-c;d2h^5;p m m b;-p 2b 2", "51:cab;d2h^5;p b m m;-p 2 2b", "51:-cba;d2h^5;p c m m;-p 2c 2c", "51:bca;d2h^5;p m c m;-p 2c 2", "51:a-cb;d2h^5;p m a m;-p 2 2a", "52;d2h^6;p n n a;-p 2a 2bc", "52:ba-c;d2h^6;p n n b;-p 2b 2n", "52:cab;d2h^6;p b n n;-p 2n 2b", "52:-cba;d2h^6;p c n n;-p 2ab 2c", "52:bca;d2h^6;p n c n;-p 2ab 2n", "52:a-cb;d2h^6;p n a n;-p 2n 2bc", "53;d2h^7;p m n a;-p 2ac 2", "53:ba-c;d2h^7;p n m b;-p 2bc 2bc", "53:cab;d2h^7;p b m n;-p 2ab 2ab", "53:-cba;d2h^7;p c n m;-p 2 2ac", "53:bca;d2h^7;p n c m;-p 2 2bc", "53:a-cb;d2h^7;p m a n;-p 2ab 2", "54;d2h^8;p c c a;-p 2a 2ac", "54:ba-c;d2h^8;p c c b;-p 2b 2c", "54:cab;d2h^8;p b a a;-p 2a 2b", "54:-cba;d2h^8;p c a a;-p 2ac 2c", "54:bca;d2h^8;p b c b;-p 2bc 2b", "54:a-cb;d2h^8;p b a b;-p 2b 2ab", "55;d2h^9;p b a m;-p 2 2ab", "55:cab;d2h^9;p m c b;-p 2bc 2", "55:bca;d2h^9;p c m a;-p 2ac 2ac", "56;d2h^10;p c c n;-p 2ab 2ac", "56:cab;d2h^10;p n a a;-p 2ac 2bc", "56:bca;d2h^10;p b n b;-p 2bc 2ab", "57;d2h^11;p b c m;-p 2c 2b", "57:ba-c;d2h^11;p c a m;-p 2c 2ac", "57:cab;d2h^11;p m c a;-p 2ac 2a", "57:-cba;d2h^11;p m a b;-p 2b 2a", "57:bca;d2h^11;p b m a;-p 2a 2ab", "57:a-cb;d2h^11;p c m b;-p 2bc 2c", "58;d2h^12;p n n m;-p 2 2n", "58:cab;d2h^12;p m n n;-p 2n 2", "58:bca;d2h^12;p n m n;-p 2n 2n", "59:1;d2h^13;p m m n:1;p 2 2ab -1ab;-b", "59:2;d2h^13;p m m n:2;-p 2ab 2a", "59:1cab;d2h^13;p n m m:1;p 2bc 2 -1bc", "59:2cab;d2h^13;p n m m:2;-p 2c 2bc", "59:1bca;d2h^13;p m n m:1;p 2ac 2ac -1ac", "59:2bca;d2h^13;p m n m:2;-p 2c 2a", "60;d2h^14;p b c n;-p 2n 2ab", "60:ba-c;d2h^14;p c a n;-p 2n 2c", "60:cab;d2h^14;p n c a;-p 2a 2n", "60:-cba;d2h^14;p n a b;-p 2bc 2n", "60:bca;d2h^14;p b n a;-p 2ac 2b", "60:a-cb;d2h^14;p c n b;-p 2b 2ac", "61;d2h^15;p b c a;-p 2ac 2ab", "61:ba-c;d2h^15;p c a b;-p 2bc 2ac", "62;d2h^16;p n m a;-p 2ac 2n", "62:ba-c;d2h^16;p m n b;-p 2bc 2a", "62:cab;d2h^16;p b n m;-p 2c 2ab", "62:-cba;d2h^16;p c m n;-p 2n 2ac", "62:bca;d2h^16;p m c n;-p 2n 2a", "62:a-cb;d2h^16;p n a m;-p 2c 2n", "63;d2h^17;c m c m;-c 2c 2", "63:ba-c;d2h^17;c c m m;-c 2c 2c", "63:cab;d2h^17;a m m a;-a 2a 2a", "63:-cba;d2h^17;a m a m;-a 2 2a", "63:bca;d2h^17;b b m m;-b 2 2b", "63:a-cb;d2h^17;b m m b;-b 2b 2", "64;d2h^18;c m c e;-c 2ac 2", "64;d2h^18;c m c a;-c 2ac 2", "64:ba-c;d2h^18;c c m b;-c 2ac 2ac", "64:cab;d2h^18;a b m a;-a 2ab 2ab", "64:-cba;d2h^18;a c a m;-a 2 2ab", "64:bca;d2h^18;b b c m;-b 2 2ab", "64:a-cb;d2h^18;b m a b;-b 2ab 2", "65;d2h^19;c m m m;-c 2 2", "65:cab;d2h^19;a m m m;-a 2 2", "65:bca;d2h^19;b m m m;-b 2 2", "66;d2h^20;c c c m;-c 2 2c", "66:cab;d2h^20;a m a a;-a 2a 2", "66:bca;d2h^20;b b m b;-b 2b 2b", "67;d2h^21;c m m e;-c 2a 2", "67;d2h^21;c m m a;-c 2a 2", "67:ba-c;d2h^21;c m m b;-c 2a 2a", "67:cab;d2h^21;a b m m;-a 2b 2b", "67:-cba;d2h^21;a c m m;-a 2 2b", "67:bca;d2h^21;b m c m;-b 2 2a", "67:a-cb;d2h^21;b m a m;-b 2a 2", "68:1;d2h^22;c c c e:1;c 2 2 -1ac;-b", "68:1;d2h^22;c c c a:1;c 2 2 -1ac;-b", "68:2;d2h^22;c c c e:2;-c 2a 2ac", "68:2;d2h^22;c c c a:2;-c 2a 2ac", "68:1ba-c;d2h^22;c c c b:1;c 2 2 -1ac", "68:2ba-c;d2h^22;c c c b:2;-c 2a 2c", "68:1cab;d2h^22;a b a a:1;a 2 2 -1ab", "68:2cab;d2h^22;a b a a:2;-a 2a 2b", "68:1-cba;d2h^22;a c a a:1;a 2 2 -1ab", "68:2-cba;d2h^22;a c a a:2;-a 2ab 2b", "68:1bca;d2h^22;b b c b:1;b 2 2 -1ab", "68:2bca;d2h^22;b b c b:2;-b 2ab 2b", "68:1a-cb;d2h^22;b b a b:1;b 2 2 -1ab", "68:2a-cb;d2h^22;b b a b:2;-b 2b 2ab", "69;d2h^23;f m m m;-f 2 2", "70:1;d2h^24;f d d d:1;f 2 2 -1d;-b", "70:2;d2h^24;f d d d:2;-f 2uv 2vw", "71;d2h^25;i m m m;-i 2 2", "72;d2h^26;i b a m;-i 2 2c", "72:cab;d2h^26;i m c b;-i 2a 2", "72:bca;d2h^26;i c m a;-i 2b 2b", "73;d2h^27;i b c a;-i 2b 2c", "73:ba-c;d2h^27;i c a b;-i 2a 2b", "74;d2h^28;i m m a;-i 2b 2", "74:ba-c;d2h^28;i m m b;-i 2a 2a", "74:cab;d2h^28;i b m m;-i 2c 2c", "74:-cba;d2h^28;i c m m;-i 2 2b", "74:bca;d2h^28;i m c m;-i 2 2a", "74:a-cb;d2h^28;i m a m;-i 2c 2", "75;c4^1;p 4;p 4", "76;c4^2;p 41;p 4w", "76*;c4^2;p 41*;p 41", "77;c4^3;p 42;p 4c", "77*;c4^3;p 42*;p 42", "78;c4^4;p 43;p 4cw", "78*;c4^4;p 43*;p 43", "79;c4^5;i 4;i 4", "80;c4^6;i 41;i 4bw", "81;s4^1;p -4;p -4", "82;s4^2;i -4;i -4", "83;c4h^1;p 4/m;-p 4", "84;c4h^2;p 42/m;-p 4c", "84*;c4h^2;p 42/m*;-p 42", "85:1;c4h^3;p 4/n:1;p 4ab -1ab;-b", "85:2;c4h^3;p 4/n:2;-p 4a", "86:1;c4h^4;p 42/n:1;p 4n -1n;-b", "86:2;c4h^4;p 42/n:2;-p 4bc", "87;c4h^5;i 4/m;-i 4", "88:1;c4h^6;i 41/a:1;i 4bw -1bw;-b", "88:2;c4h^6;i 41/a:2;-i 4ad", "89;d4^1;p 4 2 2;p 4 2", "90;d4^2;p 4 21 2;p 4ab 2ab", "91;d4^3;p 41 2 2;p 4w 2c", "91*;d4^3;p 41 2 2*;p 41 2c", "92;d4^4;p 41 21 2;p 4abw 2nw", "93;d4^5;p 42 2 2;p 4c 2", "93*;d4^5;p 42 2 2*;p 42 2", "94;d4^6;p 42 21 2;p 4n 2n", "95;d4^7;p 43 2 2;p 4cw 2c", "95*;d4^7;p 43 2 2*;p 43 2c", "96;d4^8;p 43 21 2;p 4nw 2abw", "97;d4^9;i 4 2 2;i 4 2", "98;d4^10;i 41 2 2;i 4bw 2bw", "99;c4v^1;p 4 m m;p 4 -2", "100;c4v^2;p 4 b m;p 4 -2ab", "101;c4v^3;p 42 c m;p 4c -2c", "101*;c4v^3;p 42 c m*;p 42 -2c", "102;c4v^4;p 42 n m;p 4n -2n", "103;c4v^5;p 4 c c;p 4 -2c", "104;c4v^6;p 4 n c;p 4 -2n", "105;c4v^7;p 42 m c;p 4c -2", "105*;c4v^7;p 42 m c*;p 42 -2", "106;c4v^8;p 42 b c;p 4c -2ab", "106*;c4v^8;p 42 b c*;p 42 -2ab", "107;c4v^9;i 4 m m;i 4 -2", "108;c4v^10;i 4 c m;i 4 -2c", "109;c4v^11;i 41 m d;i 4bw -2", "110;c4v^12;i 41 c d;i 4bw -2c", "111;d2d^1;p -4 2 m;p -4 2", "112;d2d^2;p -4 2 c;p -4 2c", "113;d2d^3;p -4 21 m;p -4 2ab", "114;d2d^4;p -4 21 c;p -4 2n", "115;d2d^5;p -4 m 2;p -4 -2", "116;d2d^6;p -4 c 2;p -4 -2c", "117;d2d^7;p -4 b 2;p -4 -2ab", "118;d2d^8;p -4 n 2;p -4 -2n", "119;d2d^9;i -4 m 2;i -4 -2", "120;d2d^10;i -4 c 2;i -4 -2c", "121;d2d^11;i -4 2 m;i -4 2", "122;d2d^12;i -4 2 d;i -4 2bw", "123;d4h^1;p 4/m m m;-p 4 2", "124;d4h^2;p 4/m c c;-p 4 2c", "125:1;d4h^3;p 4/n b m:1;p 4 2 -1ab;-b", "125:2;d4h^3;p 4/n b m:2;-p 4a 2b", "126:1;d4h^4;p 4/n n c:1;p 4 2 -1n;-b", "126:2;d4h^4;p 4/n n c:2;-p 4a 2bc", "127;d4h^5;p 4/m b m;-p 4 2ab", "128;d4h^6;p 4/m n c;-p 4 2n", "129:1;d4h^7;p 4/n m m:1;p 4ab 2ab -1ab;-b", "129:2;d4h^7;p 4/n m m:2;-p 4a 2a", "130:1;d4h^8;p 4/n c c:1;p 4ab 2n -1ab;-b", "130:2;d4h^8;p 4/n c c:2;-p 4a 2ac", "131;d4h^9;p 42/m m c;-p 4c 2", "132;d4h^10;p 42/m c m;-p 4c 2c", "133:1;d4h^11;p 42/n b c:1;p 4n 2c -1n;-b", "133:2;d4h^11;p 42/n b c:2;-p 4ac 2b", "134:1;d4h^12;p 42/n n m:1;p 4n 2 -1n;-b", "134:2;d4h^12;p 42/n n m:2;-p 4ac 2bc", "135;d4h^13;p 42/m b c;-p 4c 2ab", "135*;d4h^13;p 42/m b c*;-p 42 2ab", "136;d4h^14;p 42/m n m;-p 4n 2n", "137:1;d4h^15;p 42/n m c:1;p 4n 2n -1n;-b", "137:2;d4h^15;p 42/n m c:2;-p 4ac 2a", "138:1;d4h^16;p 42/n c m:1;p 4n 2ab -1n;-b", "138:2;d4h^16;p 42/n c m:2;-p 4ac 2ac", "139;d4h^17;i 4/m m m;-i 4 2", "140;d4h^18;i 4/m c m;-i 4 2c", "141:1;d4h^19;i 41/a m d:1;i 4bw 2bw -1bw;-b", "141:2;d4h^19;i 41/a m d:2;-i 4bd 2", "142:1;d4h^20;i 41/a c d:1;i 4bw 2aw -1bw;-b", "142:2;d4h^20;i 41/a c d:2;-i 4bd 2c", "143;c3^1;p 3;p 3", "144;c3^2;p 31;p 31", "145;c3^3;p 32;p 32", "146:h;c3^4;r 3:h;r 3", "146:r;c3^4;r 3:r;p 3*", "147;c3i^1;p -3;-p 3", "148:h;c3i^2;r -3:h;-r 3", "148:r;c3i^2;r -3:r;-p 3*", "149;d3^1;p 3 1 2;p 3 2", "150;d3^2;p 3 2 1;p 3 2\"", "151;d3^3;p 31 1 2;p 31 2 (0 0 4)", "152;d3^4;p 31 2 1;p 31 2\"", "153;d3^5;p 32 1 2;p 32 2 (0 0 2)", "154;d3^6;p 32 2 1;p 32 2\"", "155:h;d3^7;r 3 2:h;r 3 2\"", "155:r;d3^7;r 3 2:r;p 3* 2", "156;c3v^1;p 3 m 1;p 3 -2\"", "157;c3v^2;p 3 1 m;p 3 -2", "158;c3v^3;p 3 c 1;p 3 -2\"c", "159;c3v^4;p 3 1 c;p 3 -2c", "160:h;c3v^5;r 3 m:h;r 3 -2\"", "160:r;c3v^5;r 3 m:r;p 3* -2", "161:h;c3v^6;r 3 c:h;r 3 -2\"c", "161:r;c3v^6;r 3 c:r;p 3* -2n", "162;d3d^1;p -3 1 m;-p 3 2", "163;d3d^2;p -3 1 c;-p 3 2c", "164;d3d^3;p -3 m 1;-p 3 2\"", "165;d3d^4;p -3 c 1;-p 3 2\"c", "166:h;d3d^5;r -3 m:h;-r 3 2\"", "166:r;d3d^5;r -3 m:r;-p 3* 2", "167:h;d3d^6;r -3 c:h;-r 3 2\"c", "167:r;d3d^6;r -3 c:r;-p 3* 2n", "168;c6^1;p 6;p 6", "169;c6^2;p 61;p 61", "170;c6^3;p 65;p 65", "171;c6^4;p 62;p 62", "172;c6^5;p 64;p 64", "173;c6^6;p 63;p 6c", "173*;c6^6;p 63*;p 63 ", "174;c3h^1;p -6;p -6", "175;c6h^1;p 6/m;-p 6", "176;c6h^2;p 63/m;-p 6c", "176*;c6h^2;p 63/m*;-p 63", "177;d6^1;p 6 2 2;p 6 2", "178;d6^2;p 61 2 2;p 61 2 (0 0 5)", "179;d6^3;p 65 2 2;p 65 2 (0 0 1)", "180;d6^4;p 62 2 2;p 62 2 (0 0 4)", "181;d6^5;p 64 2 2;p 64 2 (0 0 2)", "182;d6^6;p 63 2 2;p 6c 2c", "182*;d6^6;p 63 2 2*;p 63 2c", "183;c6v^1;p 6 m m;p 6 -2", "184;c6v^2;p 6 c c;p 6 -2c", "185;c6v^3;p 63 c m;p 6c -2", "185*;c6v^3;p 63 c m*;p 63 -2", "186;c6v^4;p 63 m c;p 6c -2c", "186*;c6v^4;p 63 m c*;p 63 -2c", "187;d3h^1;p -6 m 2;p -6 2", "188;d3h^2;p -6 c 2;p -6c 2", "189;d3h^3;p -6 2 m;p -6 -2", "190;d3h^4;p -6 2 c;p -6c -2c", "191;d6h^1;p 6/m m m;-p 6 2", "192;d6h^2;p 6/m c c;-p 6 2c", "193;d6h^3;p 63/m c m;-p 6c 2", "193*;d6h^3;p 63/m c m*;-p 63 2", "194;d6h^4;p 63/m m c;-p 6c 2c", "194*;d6h^4;p 63/m m c*;-p 63 2c", "195;t^1;p 2 3;p 2 2 3", "196;t^2;f 2 3;f 2 2 3", "197;t^3;i 2 3;i 2 2 3", "198;t^4;p 21 3;p 2ac 2ab 3", "199;t^5;i 21 3;i 2b 2c 3", "200;th^1;p m -3;-p 2 2 3", "201:1;th^2;p n -3:1;p 2 2 3 -1n;-b", "201:2;th^2;p n -3:2;-p 2ab 2bc 3", "202;th^3;f m -3;-f 2 2 3", "203:1;th^4;f d -3:1;f 2 2 3 -1d;-b", "203:2;th^4;f d -3:2;-f 2uv 2vw 3", "204;th^5;i m -3;-i 2 2 3", "205;th^6;p a -3;-p 2ac 2ab 3", "206;th^7;i a -3;-i 2b 2c 3", "207;o^1;p 4 3 2;p 4 2 3", "208;o^2;p 42 3 2;p 4n 2 3", "209;o^3;f 4 3 2;f 4 2 3", "210;o^4;f 41 3 2;f 4d 2 3", "211;o^5;i 4 3 2;i 4 2 3", "212;o^6;p 43 3 2;p 4acd 2ab 3", "213;o^7;p 41 3 2;p 4bd 2ab 3", "214;o^8;i 41 3 2;i 4bd 2c 3", "215;td^1;p -4 3 m;p -4 2 3", "216;td^2;f -4 3 m;f -4 2 3", "217;td^3;i -4 3 m;i -4 2 3", "218;td^4;p -4 3 n;p -4n 2 3", "219;td^5;f -4 3 c;f -4a 2 3", "220;td^6;i -4 3 d;i -4bd 2c 3", "221;oh^1;p m -3 m;-p 4 2 3", "222:1;oh^2;p n -3 n:1;p 4 2 3 -1n;-b", "222:2;oh^2;p n -3 n:2;-p 4a 2bc 3", "223;oh^3;p m -3 n;-p 4n 2 3", "224:1;oh^4;p n -3 m:1;p 4n 2 3 -1n;-b", "224:2;oh^4;p n -3 m:2;-p 4bc 2bc 3", "225;oh^5;f m -3 m;-f 4 2 3", "226;oh^6;f m -3 c;-f 4a 2 3", "227:1;oh^7;f d -3 m:1;f 4d 2 3 -1d;-b", "227:2;oh^7;f d -3 m:2;-f 4vw 2vw 3", "228:1;oh^8;f d -3 c:1;f 4d 2 3 -1ad;-b", "228:2;oh^8;f d -3 c:2;-f 4ud 2vw 3", "229;oh^9;i m -3 m;-i 4 2 3", "230;oh^10;i a -3 d;-i 4bd 2c 3"};
    }
}

