/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.ShapeManager;

class JmolObject {
    int id;
    private BS bsAtoms;
    private Object info;
    private int size = -1;
    private Object[] colors;
    int modelIndex = Integer.MIN_VALUE;
    String jmolName;
    int argb;
    float translucency = 0.0f;
    boolean visible = true;
    RadiusData rd;
    public String cacheID;

    JmolObject(int n, String string, BS bS, Object object) {
        this.id = n;
        this.bsAtoms = bS;
        this.info = object;
        this.jmolName = string;
    }

    void offset(int n, int n2) {
        if (n > 0) {
            if (this.modelIndex != Integer.MIN_VALUE) {
                this.modelIndex += n;
            }
            switch (this.id) {
                case 12294: 
                case 1610625028: {
                    return;
                }
                case 4115: {
                    int n3 = (Integer)this.info;
                    if (n3 >= 0) {
                        this.info = n + n3;
                    }
                    return;
                }
                case 0x400000D0: {
                    Map map = (Map)this.info;
                    int[] nArray = (int[])map.get("frames");
                    int n4 = nArray.length;
                    while (--n4 >= 0) {
                        int n5 = n4;
                        nArray[n5] = nArray[n5] + n;
                    }
                    return;
                }
            }
        }
        if (n2 <= 0) {
            return;
        }
        if (this.id == 1060866) {
            Collection collection = ((Map)this.info).values();
            for (Object v : collection) {
                BSUtil.offset((BS)v, 0, n2);
            }
            return;
        }
        if (this.bsAtoms != null) {
            BSUtil.offset(this.bsAtoms, 0, n2);
        }
        if (this.colors != null) {
            short[] sArray = (short[])this.colors[0];
            short[] sArray2 = new short[sArray.length + n2];
            System.arraycopy(sArray, 0, sArray2, n2, sArray.length);
            this.colors[0] = sArray2;
        }
    }

    void finalizeObject(PyMOLScene pyMOLScene, ModelSet modelSet, String string, boolean bl) {
        Object object;
        ShapeManager shapeManager = modelSet.sm;
        String string2 = "color";
        SB sB = null;
        if (this.bsAtoms != null) {
            this.modelIndex = this.getModelIndex(modelSet);
        }
        switch (this.id) {
            case 3145770: {
                shapeManager.vwr.displayAtoms(this.bsAtoms, false, false, 1276118017, true);
                return;
            }
            case 12295: {
                BS bS = shapeManager.vwr.getModelUndeletedAtomsBitSet(this.argb);
                BSUtil.invertInPlace(bS, shapeManager.vwr.ms.ac);
                shapeManager.vwr.select(bS, false, 0, true);
                shapeManager.restrictSelected(false, true);
                return;
            }
            case 12294: 
            case 1610625028: {
                if (this.bsAtoms == null) {
                    if (this.info == null) {
                        shapeManager.vwr.displayAtoms(null, true, false, 0, true);
                    }
                    shapeManager.vwr.setObjectProp((String)this.info, this.id);
                } else {
                    shapeManager.vwr.displayAtoms(this.bsAtoms, this.id == 1610625028, false, 1276118017, true);
                }
                return;
            }
            case 1060866: {
                shapeManager.vwr.defineAtomSets((Map)this.info);
                return;
            }
            case 0x400000D0: {
                shapeManager.vwr.am.setMovie((Map)this.info);
                return;
            }
            case 4115: {
                int n = (Integer)this.info;
                if (n >= 0) {
                    shapeManager.vwr.setCurrentModelIndex(n);
                } else {
                    shapeManager.vwr.setAnimationRange(-1, -1);
                    shapeManager.vwr.setCurrentModelIndex(-1);
                }
                return;
            }
            case 1073742139: {
                shapeManager.vwr.stm.saveScene(this.jmolName, (Map)this.info);
                shapeManager.vwr.stm.saveOrientation(this.jmolName, (float[])((Map)this.info).get("pymolView"));
                return;
            }
            case 5: {
                shapeManager.loadShape(this.id);
                shapeManager.setShapePropertyBs(this.id, "textLabels", this.info, this.bsAtoms);
                return;
            }
            case 1678770178: {
                break;
            }
            case 1: 
            case 659488: {
                if (this.size != -1) {
                    shapeManager.setShapeSizeBs(1, this.size, null, this.bsAtoms);
                    object = ((BS[])shapeManager.getShapePropertyIndex(1, "sets", 0))[1];
                    pyMOLScene.setUniqueBonds((BS)object, this.id == 1);
                    this.size = -1;
                }
                this.id = 1;
                break;
            }
            case 0x44100001: {
                this.id = 0;
                break;
            }
            case 0: {
                break;
            }
            case 9: 
            case 10: {
                shapeManager.loadShape(this.id);
                object = modelSet.getAtoms(3145764, null);
                BSUtil.andNot(this.bsAtoms, (BS)object);
                break;
            }
            case 16: {
                shapeManager.loadShape(this.id);
                shapeManager.setShapePropertyBs(this.id, "ignore", BSUtil.copyInvert(this.bsAtoms, shapeManager.vwr.ms.ac), null);
                break;
            }
            default: {
                if (this.visible) break;
                return;
            }
        }
        switch (this.id) {
            case 23: {
                shapeManager.vwr.setCGO((Lst)this.info);
                break;
            }
            case 0: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 20: 
            case 24: {
                if (!(this.info instanceof Object[])) break;
                shapeManager.loadShape(this.id);
                shapeManager.setShapePropertyBs(this.id, "params", this.info, this.bsAtoms);
                break;
            }
            case 6: {
                if (this.modelIndex < 0) {
                    return;
                }
                shapeManager.loadShape(this.id);
                MeasurementData measurementData = (MeasurementData)this.info;
                measurementData.setModelSet(modelSet);
                Lst<Object> lst = measurementData.points;
                int n = lst.size();
                while (--n >= 0) {
                    ((Point3fi)lst.get((int)n)).mi = (short)this.modelIndex;
                }
                shapeManager.setShapePropertyBs(this.id, "measure", measurementData, this.bsAtoms);
                return;
            }
            case 135180: {
                String string3;
                String string4 = string3 = this.bsAtoms == null ? (String)this.info : this.jmolName;
                if (shapeManager.getShapeIdFromObjectName(string3) >= 0) {
                    shapeManager.vwr.setObjectProp(string3, 1610625028);
                    return;
                }
                sB = new SB();
                sB.append("isosurface ID ").append(PT.esc(string3));
                if (this.modelIndex < 0) {
                    this.modelIndex = shapeManager.vwr.am.cmi;
                }
                if (this.bsAtoms == null) {
                    sB.append(" model ").append(modelSet.getModelNumberDotted(this.modelIndex)).append(" color density sigma 1.0 ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(string3));
                    if (!bl) break;
                    sB.append(";isosurface cache");
                    break;
                }
                object = (String)((Object[])this.info)[0];
                String string5 = (String)((Object[])this.info)[1];
                string5 = " only";
                BS bS = (BS)((Object[])this.info)[2];
                float f = ((Float)((Object[])this.info)[3]).floatValue();
                String string6 = "";
                if (object == null) {
                    object = "mesh nofill";
                    string6 = " resolution 1.5";
                }
                boolean bl2 = PT.isOneOf(string3, string);
                String string7 = modelSet.getModelNumberDotted(this.modelIndex);
                String string8 = "";
                String string9 = this.size < 0 ? " sasurface " : " solvent ";
                sB.append(" model ").append(string7).append(string6).append(" select ").append(Escape.eBS(this.bsAtoms)).append(string5).append(string8).append(string9).appendF(Math.abs((float)this.size / 1000.0f));
                if (!bl2) {
                    if (this.argb == 0) {
                        sB.append(" map property color");
                    } else {
                        sB.append(";color isosurface ").append(Escape.escapeColor(this.argb));
                    }
                }
                sB.append(";isosurface frontOnly ").append((String)object);
                if (this.translucency > 0.0f) {
                    sB.append(";color isosurface translucent " + this.translucency);
                }
                if (bS != null && !bS.isEmpty()) {
                    sB.append(";isosurface slab within " + f + " {" + string7 + " and " + Escape.eBS(bS) + "}");
                }
                if (!bl || bl2) break;
                sB.append(";isosurface cache");
                break;
            }
            case 0x400000C0: {
                object = (Lst)this.info;
                String string10 = ((ArrayList)object).get(((ArrayList)object).size() - 2).toString();
                String string11 = ((ArrayList)object).get(((ArrayList)object).size() - 1).toString();
                float f = PyMOLScene.floatAt(PyMOLScene.listAt((Lst<Object>)object, 3), 0);
                float f2 = PyMOLScene.floatAt(PyMOLScene.listAt((Lst<Object>)object, 3), 2);
                sB = new SB();
                sB.append(";isosurface ID ").append(PT.esc(string10)).append(" map ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(string11)).append(";color isosurface range " + f + " " + f2 + ";isosurface colorscheme rwb;set isosurfacekey true");
                if (this.translucency > 0.0f) {
                    sB.append(";color isosurface translucent " + this.translucency);
                }
                if (!bl) break;
                sB.append(";isosurface cache");
                break;
            }
            case 1073742018: {
                this.modelIndex = shapeManager.vwr.am.cmi;
                Lst lst = (Lst)this.info;
                String string12 = lst.get(lst.size() - 2).toString();
                sB = new SB();
                sB.append("isosurface ID ").append(PT.esc(string12)).append(" model ").append(modelSet.getModelNumberDotted(this.modelIndex)).append(" color ").append(Escape.escapeColor(this.argb)).append("  ").append(PT.esc(this.cacheID)).append(" ").append(PT.esc(string12)).append(" mesh nofill frontonly");
                float f = PyMOLScene.floatAt(PyMOLScene.listAt(PyMOLScene.listAt(lst, 2), 0), 11);
                Lst<Object> lst2 = PyMOLScene.listAt(PyMOLScene.listAt(PyMOLScene.listAt(lst, 2), 0), 12);
                if (f > 0.0f) {
                    P3 p3 = new P3();
                    sB.append(";isosurface slab within ").appendF(f).append(" [ ");
                    for (int i = lst2.size() - 3; i >= 0; i -= 3) {
                        PyMOLScene.pointAt(lst2, i, p3);
                        sB.append(Escape.eP(p3));
                    }
                    sB.append(" ]");
                }
                if (bl && !PT.isOneOf(string12, string)) {
                    sB.append(";isosurface cache");
                }
                sB.append(";set meshScale ").appendI(this.size / 500);
                break;
            }
            case 135271429: {
                sB = (SB)this.info;
                break;
            }
            case 1113200654: {
                this.id = 10;
                shapeManager.loadShape(10);
                shapeManager.setShapePropertyBs(this.id, "putty", this.info, this.bsAtoms);
            }
        }
        if (sB != null) {
            shapeManager.vwr.runScript(sB.toString());
            return;
        }
        if (this.size != -1 || this.rd != null) {
            shapeManager.setShapeSizeBs(this.id, this.size, this.rd, this.bsAtoms);
        }
        if (this.argb != 0) {
            shapeManager.setShapePropertyBs(this.id, string2, this.argb, this.bsAtoms);
        }
        if (this.translucency > 0.0f) {
            shapeManager.setShapePropertyBs(this.id, "translucentLevel", Float.valueOf(this.translucency), this.bsAtoms);
            shapeManager.setShapePropertyBs(this.id, "translucency", "translucent", this.bsAtoms);
        } else if (this.colors != null) {
            shapeManager.setShapePropertyBs(this.id, "colors", this.colors, this.bsAtoms);
        }
    }

    private int getModelIndex(ModelSet modelSet) {
        if (this.bsAtoms == null) {
            return -1;
        }
        int n = this.bsAtoms.nextSetBit(0);
        if (n >= modelSet.at.length) {
            System.out.println("PyMOL LOADING ERROR IN MERGE");
        }
        return n < 0 ? -1 : (int)modelSet.at[n].mi;
    }

    void setColors(short[] sArray, float f) {
        this.colors = new Object[]{sArray, Float.valueOf(f)};
    }

    void setSize(float f) {
        this.size = (int)(f * 1000.0f);
    }
}

