/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class NBODialog
extends JDialog
implements ChangeListener {
    private transient Viewer vwr;
    protected JButton nboPathButton;
    protected JTextField Field;
    protected JTextField dataPathLabel;
    protected JTextField serverPathLabel;
    private JTextField saveField;
    private JTextField workingPathLabel;
    private JTextPane editArea1;
    private JScrollPane editPane1;
    private JTextPane editArea2;
    private JScrollPane editPane2;
    private JTabbedPane inputTabs;
    private Component modelPanel;
    private Component runPanel;
    private JTextField modelField;
    private String lastText;

    public NBODialog(JFrame jFrame, Viewer viewer) {
        super(jFrame, GT._("NBO-Server Interface Setup"), false);
        this.vwr = viewer;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(700, 500));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.buildLeftPanel();
        JPanel jPanel3 = this.buildRightPanel();
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        jSplitPane.setOneTouchExpandable(true);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jSplitPane, "Center");
        jPanel.add(jPanel4);
        JPanel jPanel5 = this.buildFilePanel();
        JPanel jPanel6 = this.buildButtonPanel();
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add(Box.createGlue(), "North");
        jPanel7.add((Component)jPanel5, "South");
        jPanel.add(jPanel7);
        jPanel.add(jPanel6);
        this.getContentPane().add(jPanel);
        this.getPathHistory();
        this.pack();
        this.centerDialog();
        this.setVisible(true);
        jSplitPane.setDividerLocation(0.5);
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.closePressed();
            }
        });
        box.add(jButton);
        jPanel.add(box);
        return jPanel;
    }

    private JPanel buildFilePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.setBorder(new TitledBorder("Working Directory"));
        this.workingPathLabel = new JTextField("");
        this.workingPathLabel.setEditable(false);
        this.workingPathLabel.setBorder(null);
        box.add(this.workingPathLabel);
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.showWorkingPathDialog();
            }
        });
        box.add(jButton);
        jPanel.add((Component)box, "North");
        Box box2 = Box.createHorizontalBox();
        box2.setBorder(new TitledBorder("Location of the NBO-Server Executable"));
        this.serverPathLabel = new JTextField("");
        this.serverPathLabel.setEditable(false);
        this.serverPathLabel.setBorder(null);
        box2.add(this.serverPathLabel);
        this.nboPathButton = new JButton("Browse...");
        this.nboPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.showNBOPathDialog();
            }
        });
        box2.add(this.nboPathButton);
        jPanel.add((Component)box2, "South");
        return jPanel;
    }

    private JPanel buildRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("NBO Working File (temp)");
        jPanel.setBorder(titledBorder);
        this.editArea1 = new JTextPane();
        this.editArea1.setContentType("text/plain");
        this.editArea1.setFont(new Font("Monospaced", 0, 10));
        this.editPane1 = new JScrollPane(this.editArea1);
        jPanel.add(this.editPane1);
        JButton jButton = new JButton("Execute");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.executeRaw();
            }
        });
        jPanel.add(jButton);
        this.editArea2 = new JTextPane();
        this.editArea2.setContentType("text/plain");
        this.editArea2.setFont(new Font("Monospaced", 0, 10));
        this.editPane2 = new JScrollPane(this.editArea2);
        jPanel.add(this.editPane2);
        jPanel.setPreferredSize(new Dimension(500, 100));
        return jPanel;
    }

    protected void executeRaw() {
        this.goPressed("raw");
    }

    private JPanel buildLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.inputTabs = new JTabbedPane();
        this.modelPanel = this.getModelPanel();
        this.inputTabs.addTab("Model", null, this.modelPanel);
        this.runPanel = this.getRunPanel();
        this.inputTabs.addTab("Run", null, this.runPanel);
        this.inputTabs.setSelectedComponent(this.modelPanel);
        this.inputTabs.addChangeListener(this);
        jPanel.add((Component)this.inputTabs, "Center");
        return jPanel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.inputTabs) {
            this.tabSwitched();
        }
    }

    private void tabSwitched() {
        Component component = this.inputTabs.getSelectedComponent();
        if (component == this.modelPanel) {
            this.modelPanel.setVisible(true);
            this.runPanel.setVisible(false);
        } else if (component == this.runPanel) {
            this.modelPanel.setVisible(false);
            this.runPanel.setVisible(true);
        }
        this.pack();
    }

    private Component getRunPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.setBorder(new TitledBorder("NBO Data Files and Directory"));
        Box box2 = Box.createHorizontalBox();
        box2.setBorder(new TitledBorder("File Root"));
        this.saveField = new JTextField("Jmol");
        box2.add(this.saveField);
        box.add(box2);
        box.add(Box.createGlue());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    private Component getModelPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(this.newLabel("Formula"));
        this.modelField = new JTextField("CH4");
        box2.add(this.modelField);
        box.add(box2);
        box.add(Box.createVerticalGlue());
        box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Load");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.loadModel();
            }
        });
        box2.add(jButton);
        box.add(box2);
        jPanel.add((Component)box, "North");
        return jPanel;
    }

    protected void loadModel() {
        this.goPressed("model");
        this.vwr.loadInline(this.editArea2.getText());
    }

    private Component newLabel(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEditable(false);
        jTextField.setBorder(null);
        return jTextField;
    }

    void goPressed(String string) {
        String string2 = "jmol_infile.txt";
        String string3 = this.workingPathLabel.getText();
        File file = new File(string3, string2);
        if (string.equals("model")) {
            this.editArea1.setText("    1    1    1\nsh " + this.modelField.getText());
        } else if (string.equals("raw")) {
            // empty if block
        }
        try {
            String string4 = this.editArea1.getText();
            if (!string4.equals(this.lastText)) {
                this.lastText = string4;
                this.vwr.writeTextFile(file.getAbsolutePath(), this.lastText);
            }
            String string5 = this.serverPathLabel.getText();
            File file2 = new File(string5);
            ProcessBuilder processBuilder = new ProcessBuilder(string5);
            processBuilder.directory(new File(file2.getParent()));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            process.waitFor();
            this.processResult();
        }
        catch (Exception exception) {
            Logger.errorEx("Caught IOException in NBO-Server exec", exception);
        }
    }

    void closePressed() {
        this.saveHistory();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    void showWorkingPathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this.workingPathLabel.getText();
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.isDirectory() ? file.toString() : file.getParent();
            this.workingPathLabel.setText(string2);
            this.loadArea1();
            this.pack();
        }
    }

    void showNBOPathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.serverPathLabel.getText();
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.serverPathLabel.setText(file.toString());
            this.pack();
        }
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    private void getPathHistory() {
        String string;
        Properties properties = JmolPanel.historyFile.getProperties();
        if (this.serverPathLabel != null && (string = properties.getProperty("nboServerPath", System.getProperty("user.home"))) != null) {
            this.serverPathLabel.setText(string);
        }
        if (this.workingPathLabel != null && (string = properties.getProperty("nboWorkingPath", System.getProperty("user.home"))) != null) {
            this.workingPathLabel.setText(string);
            this.loadArea1();
        }
    }

    private void saveHistory() {
        Properties properties = new Properties();
        properties.setProperty("nboServerPath", this.serverPathLabel.getText());
        properties.setProperty("nboWorkingPath", this.workingPathLabel.getText());
        JmolPanel.historyFile.addProperties(properties);
    }

    String doubleQuoteIfContainsSpace(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ' ') continue;
            return "\"" + string + "\"";
        }
        return string;
    }

    String simpleQuoteIfContainsSpace(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ' ') continue;
            return "'" + string + "'";
        }
        return string;
    }

    void loadArea1() {
        String string = this.vwr.getFileAsString3(this.workingPathLabel.getText().replace('\\', '/') + "/jmol_infile.txt", true, "nbodialog");
        this.editArea1.setText(string);
        this.lastText = string;
        this.editArea2.setText("");
    }

    void processResult() {
        this.loadArea1();
        this.loadArea2("jmol_molfile.txt");
    }

    private void loadArea2(String string) {
        String string2 = this.vwr.getFileAsString3(this.workingPathLabel.getText().replace('\\', '/') + "/" + string, true, "nbodialog");
        this.editArea2.setText(string2);
    }
}

