/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.util.Logger;

public class XmlQEReader
extends XmlReader {
    private float a;
    private float b;
    private float c;
    private String[] myAttributes = new String[]{"SPECIES", "TAU"};

    @Override
    protected String[] getDOMAttributes() {
        return this.myAttributes;
    }

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.doProcessLines = true;
        this.PX(xmlReader, object);
    }

    @Override
    public void processStartElement(String string) {
        if (Logger.debugging) {
            Logger.debug("xmlqe: start " + string);
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("NUMBER_OF_ATOMS".equalsIgnoreCase(string) || "CELL_DIMENSIONS".equalsIgnoreCase(string) || "AT".equalsIgnoreCase(string)) {
            this.keepChars = true;
            return;
        }
        if (string.startsWith("ATOM.")) {
            this.parent.setAtomCoordScaled(null, (String[])PT.getTokens((String)((String)this.atts.get((Object)"TAU"))), (int)0, (float)0.5291772f).elementSymbol = ((String)this.atts.get("SPECIES")).trim();
        }
        if ("structure".equals(string)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.asc.doFixPeriodic = true;
            this.asc.newAtomSet();
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if (Logger.debugging) {
            Logger.debug("xmlqe: end " + string);
        }
        if (this.parent.doProcessLines) {
            if ("CELL_DIMENSIONS".equalsIgnoreCase(string)) {
                this.parent.setFractionalCoordinates(true);
                float[] fArray = XmlQEReader.getTokensFloat(this.chars, null, 6);
                this.a = fArray[0];
                this.b = fArray[1] == 0.0f ? this.a : fArray[1];
                this.c = fArray[2] == 0.0f ? this.a : fArray[2];
            } else if ("AT".equalsIgnoreCase(string)) {
                float[] fArray = XmlQEReader.getTokensFloat(this.chars, null, 9);
                for (int i = 0; i < 9; i += 3) {
                    int n = i;
                    fArray[n] = fArray[n] * this.a;
                    int n2 = i + 1;
                    fArray[n2] = fArray[n2] * this.b;
                    int n3 = i + 2;
                    fArray[n3] = fArray[n3] * this.c;
                }
                this.parent.addPrimitiveLatticeVector(0, fArray, 0);
                this.parent.addPrimitiveLatticeVector(1, fArray, 3);
                this.parent.addPrimitiveLatticeVector(2, fArray, 6);
            } else if ("GEOMETRY_INFO".equalsIgnoreCase(string)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }
}

