/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.java.BS;
import org.jmol.modelset.ModelSet;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class AnimationManager {
    public JmolThread animationThread;
    public Viewer vwr;
    public boolean animationOn;
    public int animationFps;
    public int firstFrameDelayMs;
    public int lastFrameDelayMs;
    static final int FRAME_FIRST = -1;
    static final int FRAME_LAST = 1;
    static final int MODEL_CURRENT = 0;
    final BS bsVisibleModels = new BS();
    public int animationReplayMode = 1073742070;
    BS bsDisplay;
    int[] animationFrames;
    public boolean isMovie;
    boolean animationPaused;
    public int cmi;
    int caf;
    int morphCount;
    int animationDirection = 1;
    int currentDirection = 1;
    int firstFrameIndex;
    int lastFrameIndex;
    int frameStep;
    int backgroundModelIndex = -1;
    float currentMorphModel;
    float firstFrameDelay;
    float lastFrameDelay = 1.0f;
    private int lastFramePainted;
    private int lastModelPainted;
    private int intAnimThread;
    public int cai = -1;

    AnimationManager(Viewer viewer) {
        this.vwr = viewer;
    }

    public void setAnimationOn(boolean bl) {
        if (bl == this.animationOn) {
            return;
        }
        if (!bl || this.vwr.headless) {
            this.stopThread(false);
            return;
        }
        if (!this.vwr.tm.spinOn) {
            this.vwr.refresh(3, "Anim:setAnimationOn");
        }
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    public void stopThread(boolean bl) {
        boolean bl2 = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
            bl2 = true;
        }
        this.animationPaused = bl;
        if (bl2 && !this.vwr.tm.spinOn) {
            this.vwr.refresh(3, "Viewer:setAnimationOff");
        }
        this.animation(false);
        this.vwr.setStatusFrameChanged(false, true);
    }

    public boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    public boolean currentIsLast() {
        return this.isMovie ? this.lastFramePainted == this.caf : this.lastModelPainted == this.cmi;
    }

    public boolean currentFrameIs(int n) {
        int n2 = this.cmi;
        return this.morphCount == 0 ? n2 == n : Math.abs(this.currentMorphModel - (float)n) < 0.001f;
    }

    void clear() {
        this.setMovie(null);
        this.initializePointers(0);
        this.setAnimationOn(false);
        this.setModel(0, true);
        this.currentDirection = 1;
        this.cai = -1;
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(1073742070, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    String getModelSpecial(int n) {
        switch (n) {
            case -1: {
                n = this.firstFrameIndex;
                break;
            }
            case 0: {
                if (this.morphCount > 0) {
                    return "-" + (1.0f + this.currentMorphModel);
                }
                n = this.cmi;
                break;
            }
            case 1: {
                n = this.lastFrameIndex;
            }
        }
        return this.vwr.getModelNumberDotted(n);
    }

    void setDisplay(BS bS) {
        this.bsDisplay = bS == null || bS.cardinality() == 0 ? null : BSUtil.copy(bS);
    }

    public void setMorphCount(int n) {
        this.morphCount = this.isMovie ? 0 : n;
    }

    public void morph(float f) {
        int n = (int)f;
        if (Math.abs((float)n - f) < 0.001f) {
            f = n;
        } else if (Math.abs((float)n - f) > 0.999f) {
            f = ++n;
        }
        float f2 = f - (float)n;
        --n;
        if (f2 == 0.0f) {
            this.currentMorphModel = n;
            this.setModel(n, true);
            return;
        }
        this.setModel(n, true);
        int n2 = n + 1;
        this.currentMorphModel = (float)n + f2;
        if (n2 == n || n2 < 0 || n < 0) {
            return;
        }
        this.vwr.ms.morphTrajectories(n, n2, f2);
    }

    void setModel(int n, boolean bl) {
        int n2;
        if (n < 0) {
            this.stopThread(false);
        }
        int n3 = this.cmi;
        ModelSet modelSet = this.vwr.ms;
        int n4 = n2 = modelSet == null ? 0 : modelSet.mc;
        if (n2 == 1) {
            n = 0;
            this.cmi = 0;
        } else if (n < 0 || n >= n2) {
            n = -1;
        }
        String string = null;
        boolean bl2 = false;
        if (this.cmi != n) {
            if (n2 > 0) {
                ModelSet modelSet2 = this.vwr.ms;
                boolean bl3 = modelSet2.isJmolDataFrameForModel(n);
                boolean bl4 = modelSet2.isJmolDataFrameForModel(this.cmi);
                if (bl4) {
                    modelSet2.setJmolDataFrame(null, -1, this.cmi);
                }
                if (this.cmi != -1) {
                    this.vwr.saveModelOrientation();
                }
                if (bl4 || bl3) {
                    string = modelSet2.getJmolFrameType(n) + " " + n + " <-- " + " " + this.cmi + " " + modelSet2.getJmolFrameType(this.cmi);
                    bl2 = modelSet2.getJmolDataSourceFrame(n) == modelSet2.getJmolDataSourceFrame(this.cmi);
                }
            }
            this.cmi = n;
            if (string != null) {
                if (n >= 0) {
                    this.vwr.restoreModelOrientation(n);
                }
                if (bl2 && (string.indexOf("quaternion") >= 0 || string.indexOf("plot") < 0 && string.indexOf("ramachandran") < 0 && string.indexOf(" property ") < 0)) {
                    this.vwr.restoreModelRotation(n3);
                }
            }
        }
        this.setViewer(bl);
    }

    void setBackgroundModelIndex(int n) {
        ModelSet modelSet = this.vwr.ms;
        if (modelSet == null || n < 0 || n >= modelSet.mc) {
            n = -1;
        }
        this.backgroundModelIndex = n;
        if (n >= 0) {
            this.vwr.ms.setTrajectory(n);
        }
        this.vwr.setTainted(true);
        this.setFrameRangeVisible();
    }

    void initializePointers(int n) {
        this.firstFrameIndex = 0;
        this.lastFrameIndex = (n == 0 ? 0 : this.getFrameCount()) - 1;
        this.frameStep = n;
        this.vwr.setFrameVariables();
    }

    public void setAnimationDirection(int n) {
        this.animationDirection = n;
    }

    void setAnimationFps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 50) {
            n = 50;
        }
        this.animationFps = n;
        this.vwr.setFrameVariables();
    }

    public void setAnimationReplayMode(int n, float f, float f2) {
        this.firstFrameDelay = f > 0.0f ? f : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = f2 > 0.0f ? f2 : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        this.animationReplayMode = n;
        this.vwr.setFrameVariables();
    }

    void setAnimationRange(int n, int n2) {
        int n3 = this.getFrameCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = n3;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        this.firstFrameIndex = n;
        this.currentMorphModel = this.firstFrameIndex;
        this.lastFrameIndex = n2;
        this.frameStep = n2 < n ? -1 : 1;
        this.rewindAnimation();
    }

    void pauseAnimation() {
        this.stopThread(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void repaintDone() {
        this.lastModelPainted = this.cmi;
        this.lastFramePainted = this.caf;
    }

    void resumeAnimation() {
        if (this.cmi < 0) {
            this.setAnimationRange(this.firstFrameIndex, this.lastFrameIndex);
        }
        if (this.getFrameCount() <= 1) {
            this.animation(false);
            return;
        }
        this.animation(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            this.animationThread = (JmolThread)Interface.getOption("thread.AnimationThread", this.vwr, "script");
            this.animationThread.setManager(this, this.vwr, new int[]{this.firstFrameIndex, this.lastFrameIndex, ++this.intAnimThread});
            this.animationThread.start();
        }
    }

    void setAnimationLast() {
        this.setFrame(this.animationDirection > 0 ? this.lastFrameIndex : this.firstFrameIndex);
    }

    void rewindAnimation() {
        this.setFrame(this.animationDirection > 0 ? this.firstFrameIndex : this.lastFrameIndex);
        this.currentDirection = 1;
        this.vwr.setFrameVariables();
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    float getAnimRunTimeSeconds() {
        int n = this.getFrameCount();
        if (this.firstFrameIndex == this.lastFrameIndex || this.lastFrameIndex < 0 || this.firstFrameIndex < 0 || this.lastFrameIndex >= n || this.firstFrameIndex >= n) {
            return 0.0f;
        }
        int n2 = Math.min(this.firstFrameIndex, this.lastFrameIndex);
        int n3 = Math.max(this.firstFrameIndex, this.lastFrameIndex);
        float f = 1.0f * (float)(n3 - n2) / (float)this.animationFps + this.firstFrameDelay + this.lastFrameDelay;
        for (int i = n2; i <= n3; ++i) {
            f += (float)this.vwr.ms.getFrameDelayMs(this.modelIndexForFrame(i)) / 1000.0f;
        }
        return f;
    }

    public void setMovie(Map<String, Object> map) {
        boolean bl = this.isMovie = map != null && map.get("scripts") == null;
        if (this.isMovie) {
            this.animationFrames = (int[])map.get("frames");
            if (this.animationFrames == null || this.animationFrames.length == 0) {
                this.isMovie = false;
            } else {
                this.caf = (Integer)map.get("currentFrame");
                if (this.caf < 0 || this.caf >= this.animationFrames.length) {
                    this.caf = 0;
                }
            }
            this.setFrame(this.caf);
        }
        if (!this.isMovie) {
            this.animationFrames = null;
        }
        this.vwr.setBooleanProperty("_ismovie", this.isMovie);
        this.bsDisplay = null;
        this.morphCount = 0;
        this.currentMorphModel = 0;
    }

    int modelIndexForFrame(int n) {
        return this.isMovie ? this.animationFrames[n] - 1 : n;
    }

    public int getFrameCount() {
        return this.isMovie ? this.animationFrames.length : this.vwr.ms.mc;
    }

    public void setFrame(int n) {
        try {
            if (this.isMovie) {
                int n2 = this.modelIndexForFrame(n);
                this.caf = n;
                n = n2;
            } else {
                this.caf = n;
            }
            this.setModel(n, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setViewer(boolean bl) {
        this.vwr.ms.setTrajectory(this.cmi);
        this.vwr.tm.setFrameOffset(this.cmi);
        if (this.cmi == -1 && bl) {
            this.setBackgroundModelIndex(-1);
        }
        this.vwr.setTainted(true);
        this.setFrameRangeVisible();
        this.vwr.setStatusFrameChanged(false, true);
        if (this.vwr.ms != null && !this.vwr.g.selectAllModels) {
            this.vwr.slm.setSelectionSubset(this.vwr.getModelUndeletedAtomsBitSet(this.cmi));
        }
    }

    private void setFrameRangeVisible() {
        int n;
        this.bsVisibleModels.clearAll();
        if (this.backgroundModelIndex >= 0) {
            this.bsVisibleModels.set(this.backgroundModelIndex);
        }
        if (this.cmi >= 0) {
            this.bsVisibleModels.set(this.cmi);
            return;
        }
        if (this.frameStep == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = this.firstFrameIndex; n != this.lastFrameIndex; n += this.frameStep) {
            int n4 = this.modelIndexForFrame(n);
            if (this.vwr.ms.isJmolDataFrameForModel(n4)) continue;
            this.bsVisibleModels.set(n4);
            ++n2;
            n3 = n;
        }
        n = this.modelIndexForFrame(this.lastFrameIndex);
        if (this.firstFrameIndex == this.lastFrameIndex || !this.vwr.ms.isJmolDataFrameForModel(n) || n2 == 0) {
            this.bsVisibleModels.set(n);
            if (n2 == 0) {
                this.firstFrameIndex = this.lastFrameIndex;
            }
            n2 = 0;
        }
        if (n2 == 1 && this.cmi < 0) {
            this.setFrame(n3);
        }
    }

    private void animation(boolean bl) {
        this.animationOn = bl;
        this.vwr.setBooleanProperty("_animating", bl);
    }

    private boolean setAnimationRelative(int n) {
        boolean bl;
        int n2 = this.getFrameStep(n);
        int n3 = this.isMovie ? this.caf : this.cmi;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.morphCount > 0) {
            f = 1.0f / (float)(this.morphCount + 1);
            f2 = this.currentMorphModel + (float)n2 * f;
            bl = this.isNotInRange(f2);
        } else {
            bl = this.isNotInRange(n4);
        }
        if (bl) {
            switch (this.animationReplayMode) {
                case 1073742070: {
                    return false;
                }
                case 528410: {
                    n4 = this.animationDirection == this.currentDirection ? this.firstFrameIndex : this.lastFrameIndex;
                    f2 = n4;
                    break;
                }
                case 1073742082: {
                    this.currentDirection = -this.currentDirection;
                    n4 -= 2 * n2;
                    f2 -= (float)(2 * n2) * f;
                }
            }
        }
        if (this.morphCount < 1) {
            if (n4 < 0 || n4 >= this.getFrameCount()) {
                return false;
            }
            this.setFrame(n4);
            return true;
        }
        this.morph(f2 + 1.0f);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNotInRange(float f) {
        float f2;
        float f3 = f - 0.001f;
        if (f3 > (float)this.firstFrameIndex) {
            if (f3 > (float)this.lastFrameIndex) return true;
        }
        f3 = f + 0.001f;
        if (!(f2 < (float)this.firstFrameIndex)) return false;
        if (!(f3 < (float)this.lastFrameIndex)) return false;
        return true;
    }

    private int getFrameStep(int n) {
        return this.frameStep * n * this.currentDirection;
    }
}

