/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Logger;
import org.jmol.util.MeshSlicer;

public class MeshCapper {
    private MeshSlicer slicer;
    private boolean dumping;
    private boolean testing;
    private Map<Integer, CapVertex> capMap;
    private Lst<CapVertex> vertices;
    private Lst<CapVertex[]> lstRegions;
    private static final int DESCENDER = 0;
    private static final int ASCENDER = 1;
    private static final int LAST = 2;
    private int nTriangles;
    private int nRegions;

    MeshCapper set(MeshSlicer meshSlicer) {
        this.slicer = meshSlicer;
        this.dumping = Logger.debugging;
        return this;
    }

    void clear() {
        this.capMap = new Hashtable<Integer, CapVertex>();
        this.vertices = new Lst();
    }

    void addEdge(int n, int n2, int n3) {
        CapVertex capVertex = this.addPoint(n3, n);
        CapVertex capVertex2 = this.addPoint(n3, n2);
        capVertex.link(capVertex2);
    }

    private CapVertex addPoint(int n, int n2) {
        Integer n3 = n2;
        CapVertex capVertex = this.capMap.get(n3);
        if (capVertex == null) {
            T3 t3 = this.slicer.m.vs[n2];
            n2 = this.slicer.addIntersectionVertex(t3, 0.0f, -1, n, null, -1, -1);
            capVertex = new CapVertex(t3, n2);
            this.vertices.addLast(capVertex);
            this.capMap.put(n3, capVertex);
        }
        if (this.dumping) {
            Logger.info(n2 + "\t" + this.slicer.m.vs[n2]);
        }
        return capVertex;
    }

    private T3 getInputPoint(CapVertex capVertex) {
        return this.testing ? P3.newP(capVertex) : this.slicer.m.vs[capVertex.ipt];
    }

    private void outputTriangle(int n, int n2, int n3) {
        this.slicer.addTriangle(n, n2, n3);
    }

    private CapVertex[] test(CapVertex[] capVertexArray) {
        return capVertexArray;
    }

    void createCap(V3 v3) {
        this.capMap = null;
        CapVertex[] capVertexArray = new CapVertex[this.vertices.size()];
        if (capVertexArray.length < 3) {
            return;
        }
        V3 v32 = V3.newVsub((T3)this.vertices.get(0), (T3)this.vertices.get(1));
        V3 v33 = V3.newV(v3);
        v33.cross(v33, v32);
        Quat quat = Quat.getQuaternionFrameV(v32, v33, null, false);
        M3 m3 = quat.getMatrix();
        M4 m4 = M4.newMV(m3, (T3)this.vertices.get(0));
        M4 m42 = M4.newM4(m4).invert();
        this.vertices.toArray(capVertexArray);
        int n = capVertexArray.length;
        while (--n >= 0) {
            m42.rotTrans2(capVertexArray[n], capVertexArray[n]);
        }
        this.vertices = null;
        capVertexArray = this.test(capVertexArray);
        Logger.info("MeshCapper using " + capVertexArray.length + " vertices");
        CapVertex capVertex = capVertexArray[0].sort(capVertexArray);
        if (capVertex == null) {
            Logger.error("two identical points -- aborting");
            return;
        }
        this.lstRegions = new Lst();
        CapVertex capVertex2 = capVertex;
        while ((capVertex2 = this.process(capVertex2)) != capVertex) {
        }
        this.clear();
        Logger.info("MeshCapper created " + this.nTriangles + " triangles " + this.nRegions + " regions");
    }

    private CapVertex process(CapVertex capVertex) {
        boolean bl;
        CapVertex capVertex2 = capVertex.qnext;
        capVertex.qnext = null;
        if (this.dumping) {
            Logger.info(capVertex.toString());
        }
        if (capVertex.prev == capVertex.next) {
            return capVertex2;
        }
        boolean bl2 = capVertex.prev.region != null;
        boolean bl3 = bl = capVertex.next.region != null;
        if (this.dumping) {
            Logger.info("#" + (bl ? capVertex.next.id : "    ") + "    " + (bl2 ? capVertex.prev.id : "") + "\n#" + (bl ? "   \\" : "    ") + (bl2 ? "    /\n" : "\n") + "#    " + capVertex.id);
        }
        if (!bl2 && !bl) {
            CapVertex capVertex3 = this.getLastPoint(capVertex);
            if (capVertex3 == null) {
                this.newRegion(capVertex);
                return capVertex2;
            }
            CapVertex capVertex4 = this.processSplit(capVertex, capVertex3);
            capVertex4.qnext = capVertex2;
            capVertex2 = capVertex4;
            bl = true;
        }
        if (bl2) {
            this.processMonotonic(capVertex, true);
        }
        if (bl) {
            this.processMonotonic(capVertex, false);
        }
        if (bl2 && bl) {
            if (capVertex.prev.prev == capVertex.next) {
                this.lstRegions.removeObj(capVertex.region);
                this.addTriangle(capVertex.prev, capVertex, capVertex.next, "end");
                capVertex.prev.clear();
                capVertex.next.clear();
            } else {
                capVertex.region = null;
            }
        }
        return capVertex2;
    }

    private void processMonotonic(CapVertex capVertex, boolean bl) {
        CapVertex capVertex2 = bl ? capVertex.prev : capVertex.next;
        capVertex.region = capVertex2.region;
        CapVertex capVertex3 = capVertex.region[2];
        if (capVertex3 == capVertex) {
            this.lstRegions.removeObj(capVertex.region);
            return;
        }
        if (capVertex3 == capVertex2) {
            CapVertex capVertex4;
            CapVertex capVertex5 = capVertex3;
            CapVertex capVertex6 = capVertex4 = bl ? capVertex5.prev : capVertex5.next;
            while (capVertex4 != capVertex && capVertex4.qnext == null && bl == capVertex.x > capVertex.interpolateX(capVertex4, capVertex5)) {
                if (bl) {
                    this.addTriangle(capVertex4, capVertex5, capVertex, "same desc " + capVertex.ipt);
                    capVertex5 = capVertex4;
                    capVertex4 = capVertex4.prev;
                    continue;
                }
                this.addTriangle(capVertex, capVertex5, capVertex4, "same asc " + capVertex.ipt);
                capVertex5 = capVertex4;
                capVertex4 = capVertex4.next;
            }
        } else {
            CapVertex capVertex7 = capVertex2;
            do {
                CapVertex capVertex8 = capVertex7;
                if (bl) {
                    capVertex7 = capVertex8.prev;
                    this.addTriangle(capVertex7, capVertex8, capVertex, "opp desc " + capVertex.id);
                    continue;
                }
                capVertex7 = capVertex8.next;
                this.addTriangle(capVertex, capVertex8, capVertex7, "opp asc " + capVertex.id);
            } while (capVertex7 != capVertex3 && capVertex7 != capVertex && capVertex7.qnext == null);
            if (capVertex3.region == null) {
                this.lstRegions.removeObj(capVertex.region);
                CapVertex capVertex9 = bl ? capVertex3.prev : capVertex3.next;
                capVertex3.region = capVertex9.region;
                capVertex.region = capVertex9.region;
            }
        }
        CapVertex capVertex10 = capVertex;
        capVertex.region[bl ? 0 : 1] = capVertex10;
        capVertex.region[2] = capVertex10;
    }

    private CapVertex processSplit(CapVertex capVertex, CapVertex capVertexArray) {
        Object object;
        CapVertex capVertex2 = capVertexArray.cloneV();
        if (this.dumping) {
            capVertex2.id = capVertex2.id + "a";
        }
        CapVertex capVertex3 = capVertex.cloneV();
        if (this.dumping) {
            capVertex3.id = capVertex3.id + "a";
        }
        if (capVertexArray.region == null) {
            capVertexArray.region = capVertexArray.next.region;
            capVertex2.region = capVertexArray.prev.region;
        } else {
            this.newRegion((CapVertex)capVertexArray);
            object = capVertexArray;
            while (object.next.region != null) {
                object.next.region = object.region;
                object.region[0] = object = object.next;
            }
        }
        object = capVertex2.region;
        if (object[2] == capVertexArray) {
            object[2] = capVertex2;
        }
        object[0] = capVertex2;
        if (object[1] == capVertexArray) {
            object[1] = capVertex2;
        }
        capVertex.link((CapVertex)capVertexArray);
        capVertex2.prev.link(capVertex2);
        capVertex2.link(capVertex3);
        capVertex3.link(capVertex3.next);
        return capVertex3;
    }

    private void newRegion(CapVertex capVertex) {
        ++this.nRegions;
        capVertex.region = new CapVertex[]{capVertex, capVertex, capVertex};
        this.lstRegions.addLast(capVertex.region);
    }

    private CapVertex getLastPoint(CapVertex capVertex) {
        CapVertex capVertex2 = null;
        float f = Float.MAX_VALUE;
        int n = this.lstRegions.size();
        while (--n >= 0) {
            boolean bl;
            CapVertex[] capVertexArray = (CapVertex[])this.lstRegions.get(n);
            CapVertex capVertex3 = capVertexArray[0];
            if (capVertex3 == capVertexArray[1]) continue;
            boolean bl2 = capVertex3.region != null;
            boolean bl3 = bl = (bl2 ? capVertex.interpolateX(capVertex3, capVertex3.next) : capVertex3.x) < capVertex.x;
            if (bl2 && capVertex2 != null && capVertex2.x != capVertex3.x && bl == capVertex2.x < capVertex3.x) {
                capVertex2 = null;
                f = Float.MAX_VALUE;
            }
            if (!bl) continue;
            CapVertex capVertex4 = capVertexArray[1];
            bl2 = capVertex4.region != null;
            boolean bl4 = bl = (bl2 ? capVertex.interpolateX(capVertex4, capVertex4.prev) : capVertex4.x) >= capVertex.x;
            if (bl2 && capVertex2 != null && capVertex2.x != capVertex4.x && bl == capVertex2.x > capVertex4.x) {
                capVertex2 = null;
                f = Float.MAX_VALUE;
            }
            if (!bl || !(capVertexArray[2].y < f)) continue;
            f = capVertexArray[2].y;
            capVertex2 = capVertexArray[2];
        }
        return capVertex2;
    }

    private boolean checkWinding(CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3) {
        return (capVertex2.x - capVertex.x) * (capVertex3.y - capVertex.y) > (capVertex2.y - capVertex.y) * (capVertex3.x - capVertex.x);
    }

    private void addTriangle(CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3, String string) {
        ++this.nTriangles;
        if (this.checkWinding(capVertex, capVertex2, capVertex3)) {
            if (this.dumping) {
                this.drawTriangle(this.nTriangles, capVertex, capVertex2, capVertex3, "red");
            }
            this.outputTriangle(capVertex.ipt, capVertex2.ipt, capVertex3.ipt);
        } else if (this.dumping) {
            Logger.info("#!!!BAD WINDING " + string);
        }
        capVertex2.link(null);
    }

    private void drawTriangle(int n, CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3, String string) {
        T3 t3 = this.getInputPoint(capVertex);
        T3 t32 = this.getInputPoint(capVertex2);
        T3 t33 = this.getInputPoint(capVertex3);
        Logger.info("draw " + string + n + "/* " + capVertex.id + " " + capVertex2.id + " " + capVertex3.id + " */" + t3 + t32 + t33 + " color " + string);
    }

    private class CapVertex
    extends T3
    implements Cloneable,
    Comparator<CapVertex> {
        int ipt;
        String id = "";
        protected CapVertex qnext;
        CapVertex prev;
        CapVertex next;
        CapVertex[] region;
        protected int ok = 1;

        CapVertex(T3 t3, int n) {
            this.ipt = n;
            this.id = "" + n;
            this.setT(t3);
        }

        public CapVertex cloneV() {
            try {
                return (CapVertex)this.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public CapVertex sort(CapVertex[] capVertexArray) {
            Arrays.sort(capVertexArray, this);
            if (this.ok == 0) {
                return null;
            }
            int n = capVertexArray.length - 1;
            while (--n >= 0) {
                capVertexArray[n].qnext = capVertexArray[n + 1];
            }
            capVertexArray[capVertexArray.length - 1].qnext = capVertexArray[0];
            return capVertexArray[0];
        }

        @Override
        public int compare(CapVertex capVertex, CapVertex capVertex2) {
            return capVertex.y < capVertex2.y ? 1 : (capVertex.y > capVertex2.y || capVertex.x < capVertex2.x ? -1 : (capVertex.x > capVertex2.x ? 1 : (this.ok = 0)));
        }

        protected float interpolateX(CapVertex capVertex, CapVertex capVertex2) {
            float f = capVertex2.y - capVertex.y;
            float f2 = capVertex2.x - capVertex.x;
            return f != 0.0f ? capVertex.x + (this.y - capVertex.y) * f2 / f : (f2 > 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        }

        protected void link(CapVertex capVertex) {
            if (capVertex == null) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.clear();
            } else {
                this.next = capVertex;
                capVertex.prev = this;
            }
        }

        protected void clear() {
            this.prev = null;
            this.next = null;
            this.qnext = null;
            this.region = null;
        }

        private String dumpRegion() {
            String string = "\n#REGION d=" + this.region[0].id + " a=" + this.region[1].id + " last=" + this.region[2].id + "\n# ";
            CapVertex capVertex = this.region[1];
            while (true) {
                string = string + capVertex.id + " ";
                if (capVertex == this.region[0]) break;
                capVertex = capVertex.next;
            }
            return string + "\n";
        }

        @Override
        public String toString() {
            return "draw p" + this.id + " {" + this.x + " " + this.y + " " + this.z + "} # " + (this.prev == null ? null : this.prev.id + " " + this.next.id + (this.region == null ? null : this.dumpRegion()));
        }
    }
}

