/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.awt.Event;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Dimension;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.c.CBK;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public abstract class GenericApplet
implements JmolAppletInterface,
JmolStatusListener {
    protected static Map<String, Object> htRegistry;
    protected boolean isJS;
    private static final int SCRIPT_CHECK = 0;
    private static final int SCRIPT_WAIT = 1;
    private static final int SCRIPT_NOWAIT = 2;
    protected String codeBase;
    protected String documentBase;
    protected boolean isSigned;
    protected String language;
    protected boolean doTranslate = true;
    protected boolean haveDocumentAccess;
    protected boolean isStereoSlave;
    protected boolean mayScript;
    protected String htmlName;
    protected String fullName;
    protected String statusForm;
    protected String statusText;
    protected String statusTextarea;
    protected Object gRight;
    protected Viewer viewer;
    protected Map<CBK, String> callbacks;
    protected Map<String, Object> vwrOptions;
    protected boolean haveNotifiedError;
    protected Object appletObject;
    protected boolean isJNLP;
    private boolean loading;
    private String syncId;
    private SB outputBuffer;

    protected abstract void initOptions();

    protected abstract String getJmolParameter(String var1);

    protected abstract String doEval(String var1);

    protected abstract float[][] doFunctionXY(String var1, int var2, int var3);

    protected abstract float[][][] doFunctionXYZ(String var1, int var2, int var3, int var4);

    protected abstract String doSendCallback(String var1, Object[] var2, String var3);

    protected abstract void doSendJsTextareaStatus(String var1);

    protected abstract void doSendJsTextStatus(String var1);

    protected abstract void doShowDocument(URL var1);

    protected abstract void doShowStatus(String var1);

    protected void init(Object object) {
        this.callbacks = new Hashtable<CBK, String>();
        if (htRegistry == null) {
            htRegistry = new Hashtable<String, Object>();
        }
        this.appletObject = object;
        this.htmlName = PT.split("" + this.getJmolParameter("name"), "_object")[0];
        this.syncId = this.getJmolParameter("syncId");
        this.fullName = this.htmlName + "__" + this.syncId + "__";
        System.out.println("Jmol JavaScript applet " + this.fullName + " initializing");
        int n = this.getValue("logLevel", this.getBooleanValue("debug", false) ? "5" : "4").charAt(0) - 48;
        if (n != 4) {
            System.out.println("setting logLevel=" + n + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel(n);
        GT.ignoreApplicationBundle();
        this.initOptions();
        GenericApplet.checkIn(this.fullName, this.appletObject);
        this.initApplication();
    }

    private void initApplication() {
        this.vwrOptions.put("applet", Boolean.TRUE);
        if (this.getJmolParameter("statusListener") == null) {
            this.vwrOptions.put("statusListener", this);
        }
        this.viewer = new Viewer(this.vwrOptions);
        this.viewer.pushHoldRepaint();
        String string = this.getValueLowerCase("emulate", "jmol");
        this.setStringProperty("defaults", string.equals("chime") ? "RasMol" : "Jmol");
        this.setStringProperty("backgroundColor", this.getValue("bgcolor", this.getValue("boxbgcolor", "black")));
        this.viewer.setBooleanProperty("frank", true);
        this.loading = true;
        Object object = CBK.values();
        int n = ((CBK[])object).length;
        for (int i = 0; i < n; ++i) {
            CBK cBK = object[i];
            this.setValue(cBK.name() + "Callback", null);
        }
        this.loading = false;
        this.language = this.getJmolParameter("language");
        new GT(this.viewer, this.language);
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
        }
        this.doTranslate = !"none".equals(this.language) && this.getBooleanValue("doTranslate", true);
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        if (this.callbacks.get((Object)CBK.SCRIPT) == null && this.callbacks.get((Object)CBK.ERROR) == null && (this.callbacks.get((Object)CBK.MESSAGE) != null || this.statusForm != null || this.statusText != null)) {
            if (this.doTranslate && this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn("Note -- Presence of message callback disables disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn("Note -- Automatic language translation may affect parsing of message callbacks messages; use scriptCallback or errorCallback to process errors");
            }
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn("Note -- language translation disabled");
        }
        if (!this.getBooleanValue("popupMenu", true)) {
            this.viewer.getProperty("DATA_API", "disablePopupMenu", null);
        }
        if ((object = this.getJmolParameter("menuFile")) != null) {
            this.viewer.setMenu((String)object, true);
        }
        String string2 = this.getValue("script", "");
        String string3 = this.getValue("loadInline", null);
        if (string3 == null) {
            string3 = this.getValue("load", null);
            if (string3 != null) {
                string2 = "load \"" + string3 + "\";" + string2;
            }
            string3 = null;
        }
        this.viewer.popHoldRepaint("applet init");
        if (string3 != null && this.viewer.loadInline(string3) != null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            this.scriptProcessor(string2, null, 1);
        }
        this.viewer.notifyStatusReady(true);
    }

    @Override
    public void destroy() {
        this.gRight = null;
        this.viewer.notifyStatusReady(false);
        this.viewer = null;
        GenericApplet.checkOut(this.fullName);
    }

    protected boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getValue(string, bl ? "true" : "");
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes");
    }

    protected String getValue(String string, String string2) {
        String string3 = this.getJmolParameter(string);
        System.out.println("Jmol getValue " + string + " " + string3);
        return string3 == null ? string2 : string3;
    }

    private String getValueLowerCase(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    private void setValue(String string, String string2) {
        this.setStringProperty(string, this.getValue(string, string2));
    }

    private void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Logger.info(string + " = \"" + string2 + "\"");
        this.viewer.setStringProperty(string, string2);
    }

    private String scriptProcessor(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        switch (n) {
            case 0: {
                Object object = this.viewer.scriptCheck(string);
                return object instanceof String ? (String)object : "";
            }
            case 1: {
                if (string2 != null) {
                    return this.viewer.scriptWaitStatus(string, string2).toString();
                }
                return this.viewer.scriptWait(string);
            }
        }
        return this.viewer.script(string);
    }

    @Override
    public void register(String string, JmolSyncInterface jmolSyncInterface) {
        GenericApplet.checkIn(string, jmolSyncInterface);
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String string) {
        return null;
    }

    @Override
    public synchronized void syncScript(String string) {
        this.viewer.syncScript(string, "~", 0);
    }

    @Override
    public boolean handleEvent(Event event) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.processMouseEvent(event.id, event.x, event.y, event.modifiers, event.when);
    }

    @Override
    public String getAppletInfo() {
        return GT.o(GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information"), new Object[]{JC.version, JC.date}) + "\nhtmlName = " + PT.esc(this.htmlName) + "\nsyncId = " + PT.esc(this.syncId) + "\ndocumentBase = " + PT.esc(this.documentBase) + "\ncodeBase = " + PT.esc(this.codeBase);
    }

    @Override
    public void script(String string) {
        this.scriptNoWait(string);
    }

    @Override
    public String scriptCheck(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 0);
    }

    @Override
    public String scriptNoWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 2);
    }

    @Override
    public String scriptWait(String string) {
        return this.scriptWait(string, null);
    }

    @Override
    public String scriptWait(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = null;
        return this.scriptProcessor(string, string2, 1);
    }

    @Override
    public String scriptWaitOutput(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = new SB();
        this.viewer.scriptWaitStatus(string, "");
        String string2 = this.outputBuffer == null ? "" : this.outputBuffer.toString();
        this.outputBuffer = null;
        return string2;
    }

    @Override
    public int getModelIndexFromId(String string) {
        return this.viewer.getModelIndexFromId(string);
    }

    @Override
    public Object getProperty(String string) {
        return this.viewer.getProperty(null, string, "");
    }

    @Override
    public Object getProperty(String string, String string2) {
        return this.viewer.getProperty(null, string, string2);
    }

    @Override
    public String getPropertyAsString(String string) {
        return this.viewer.getProperty("readable", string, "").toString();
    }

    @Override
    public String getPropertyAsString(String string, String string2) {
        return this.viewer.getProperty("readable", string, string2).toString();
    }

    @Override
    public String getPropertyAsJSON(String string) {
        return this.viewer.getProperty("JSON", string, "").toString();
    }

    @Override
    public String getPropertyAsJSON(String string, String string2) {
        return this.viewer.getProperty("JSON", string, string2).toString();
    }

    @Override
    public String loadInlineString(String string, String string2, boolean bl) {
        String string3 = this.viewer.loadInlineAppend(string, bl);
        if (string3 == null) {
            this.script(string2);
        }
        return string3;
    }

    @Override
    public String loadInlineArray(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = this.viewer.loadInline(stringArray, bl);
        if (string2 == null) {
            this.script(string);
        }
        return string2;
    }

    @Override
    public String loadDOMNode(Object object) {
        return this.viewer.openDOM(object);
    }

    @Override
    @Deprecated
    public String loadInline(String string) {
        return this.loadInlineString(string, "", false);
    }

    @Override
    @Deprecated
    public String loadInline(String string, String string2) {
        return this.loadInlineString(string, string2, false);
    }

    @Override
    @Deprecated
    public String loadInline(String[] stringArray) {
        return this.loadInlineArray(stringArray, "", false);
    }

    @Override
    @Deprecated
    public String loadInline(String[] stringArray, String string) {
        return this.loadInlineArray(stringArray, string, false);
    }

    public void output(String string) {
        if (this.outputBuffer != null && string != null) {
            this.outputBuffer.append(string).appendC('\n');
        }
    }

    @Override
    public void setCallbackFunction(String string, String string2) {
        if (string.equalsIgnoreCase("modelkit")) {
            return;
        }
        if (string.equalsIgnoreCase("language")) {
            this.consoleMessage("");
            this.consoleMessage(null);
            return;
        }
        CBK cBK = CBK.getCallback(string);
        if (cBK != null && (this.loading || cBK != CBK.EVAL)) {
            if (string2 == null) {
                this.callbacks.remove((Object)cBK);
            } else {
                this.callbacks.put(cBK, string2);
            }
            return;
        }
        this.consoleMessage("Available callbacks include: " + CBK.getNameList().replace(';', ' ').trim());
    }

    private void consoleMessage(String string) {
        this.notifyCallback(CBK.ECHO, new Object[]{"", string});
    }

    @Override
    public boolean notifyEnabled(CBK cBK) {
        switch (cBK) {
            case ECHO: 
            case MESSAGE: 
            case MEASURE: 
            case PICK: 
            case SYNC: {
                return true;
            }
            case ANIMFRAME: 
            case DRAGDROP: 
            case ERROR: 
            case EVAL: 
            case LOADSTRUCT: 
            case SCRIPT: {
                return !this.isJNLP;
            }
        }
        return this.callbacks.get((Object)cBK) != null;
    }

    @Override
    public void notifyCallback(CBK cBK, Object[] objectArray) {
        Object object;
        String string = this.callbacks.get((Object)cBK);
        boolean bl = string != null && (objectArray == null || objectArray[0] == null);
        boolean bl2 = false;
        if (objectArray != null) {
            objectArray[0] = this.htmlName;
        }
        String string2 = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (cBK) {
            case APPLETREADY: {
                objectArray[3] = this.appletObject;
                break;
            }
            case DRAGDROP: 
            case ERROR: 
            case EVAL: 
            case HOVER: 
            case MINIMIZATION: 
            case RESIZE: {
                break;
            }
            case CLICK: {
                if (!"alert".equals(string)) break;
                string2 = "x=" + objectArray[1] + " y=" + objectArray[2] + " action=" + objectArray[3] + " clickCount=" + objectArray[4];
                break;
            }
            case ANIMFRAME: {
                int n;
                object = (int[])objectArray[1];
                int n2 = object[0];
                int n3 = object[1];
                Object object2 = object[2];
                Object object3 = object[3];
                Object object4 = object[4];
                boolean bl3 = n2 <= -2;
                int n4 = object3 < 0 ? -1 : 1;
                int n5 = n = object4 < 0 ? -1 : 1;
                if (!bl) break;
                objectArray = new Object[]{this.htmlName, Math.max(n2, -2 - n2), n3, (int)object2, Math.abs((int)object3), Math.abs((int)object4), bl3 ? 1 : 0, n4, n, objectArray[2], objectArray[3]};
                break;
            }
            case ATOMMOVED: {
                break;
            }
            case ECHO: {
                boolean bl4;
                boolean bl5 = objectArray.length == 2;
                boolean bl6 = bl4 = bl5 || (Integer)objectArray[2] == 1;
                if (!bl) {
                    if (bl4) {
                        bl2 = true;
                    }
                    boolean bl7 = bl = !bl5 && (string = this.callbacks.get((Object)(cBK = CBK.MESSAGE))) != null;
                }
                if (bl2) break;
                this.output(string2);
                break;
            }
            case LOADSTRUCT: {
                String string3 = (String)objectArray[4];
                if (string3 == null) break;
                string3 = (string3.indexOf("NOTE:") >= 0 ? "" : GT._("File Error:")) + string3;
                this.doShowStatus(string3);
                this.notifyCallback(CBK.MESSAGE, new Object[]{"", string3});
                return;
            }
            case MEASURE: {
                String string4;
                if (!bl) {
                    cBK = CBK.MESSAGE;
                    string = this.callbacks.get((Object)cBK);
                    boolean bl8 = bl = string != null;
                }
                if ((string4 = (String)objectArray[3]).indexOf("Picked") >= 0 || string4.indexOf("Sequence") >= 0) {
                    this.doShowStatus(string2);
                    bl2 = true;
                    break;
                }
                if (string4.indexOf("Completed") < 0) break;
                string2 = string4 + ": " + string2;
                bl2 = true;
                break;
            }
            case MESSAGE: {
                bl2 = !bl;
                bl &= string2 != null;
                if (bl2) break;
                this.output(string2);
                break;
            }
            case PICK: {
                this.doShowStatus(string2);
                bl2 = true;
                break;
            }
            case SCRIPT: {
                int n = (Integer)objectArray[3];
                if (n <= 0 && !bl) {
                    cBK = CBK.MESSAGE;
                    string = this.callbacks.get((Object)cBK);
                    bl = string != null;
                }
                this.output(string2);
                this.doShowStatus(string2);
                break;
            }
            case STRUCTUREMODIFIED: {
                break;
            }
            case SYNC: {
                this.sendScript(string2, (String)objectArray[2], true, bl);
                return;
            }
        }
        if (bl2 && (object = (Object)((JmolCallbackListener)this.viewer.getProperty("DATA_API", "getAppConsole", null))) != null) {
            object.notifyCallback(cBK, objectArray);
            this.output(string2);
            this.doSendJsTextareaStatus(string2);
        }
        if (!bl || !this.mayScript) {
            return;
        }
        try {
            this.doSendCallback(string, objectArray, string2);
        }
        catch (Exception exception) {
            if (!this.haveNotifiedError && Logger.debugging) {
                Logger.debug(cBK.name() + "Callback call error to " + string + ": " + exception);
            }
            this.haveNotifiedError = true;
        }
    }

    private String sendScript(String string, String string2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2 && ((string = this.notifySync(string, string2)) == null || string.length() == 0 || string.equals("0"))) {
            return "";
        }
        Lst<String> lst = new Lst<String>();
        GenericApplet.findApplets(string2, this.syncId, this.fullName, lst);
        int n = lst.size();
        if (n == 0) {
            if (!bl2 && !string2.equals("*")) {
                Logger.error(this.fullName + " couldn't find applet " + string2);
            }
            return "";
        }
        SB sB = bl ? null : new SB();
        boolean bl4 = bl && string.equals("GET_GRAPHICS");
        boolean bl5 = bl3 = bl && string.equals("SET_GRAPHICS_OFF");
        if (bl4) {
            this.gRight = null;
            this.viewer.setStereo(false, null);
        }
        for (int i = 0; i < n; ++i) {
            String string3 = (String)lst.get(i);
            JmolSyncInterface jmolSyncInterface = (JmolSyncInterface)htRegistry.get(string3);
            boolean bl6 = true;
            if (Logger.debugging) {
                Logger.debug(this.fullName + " sending to " + string3 + ": " + string);
            }
            try {
                if (bl6 && (bl4 || bl3)) {
                    this.isStereoSlave = bl4;
                    this.gRight = ((JmolAppletInterface)jmolSyncInterface).setStereoGraphics(bl4);
                    this.viewer.setStereo(this.isStereoSlave, this.gRight);
                    return "";
                }
                if (bl) {
                    jmolSyncInterface.syncScript(string);
                    continue;
                }
                if (!bl6) continue;
                sB.append(((JmolAppletInterface)jmolSyncInterface).scriptWait(string, "output")).append("\n");
                continue;
            }
            catch (Exception exception) {
                String string4 = this.htmlName + " couldn't send to " + string3 + ": " + string + ": " + exception;
                Logger.error(string4);
                if (bl) continue;
                sB.append(string4);
            }
        }
        return bl ? "" : sB.toString();
    }

    private String notifySync(String string, String string2) {
        String string3 = this.callbacks.get((Object)CBK.SYNC);
        if (!this.mayScript || string3 == null) {
            return string;
        }
        try {
            return this.doSendCallback(string3, new Object[]{this.fullName, string, string2}, null);
        }
        catch (Exception exception) {
            if (!this.haveNotifiedError && Logger.debugging) {
                Logger.debug("syncCallback call error to " + string3 + ": " + exception);
            }
            this.haveNotifiedError = true;
            return string;
        }
    }

    @Override
    public String eval(String string) {
        int n = string.indexOf("\u0001");
        if (n >= 0) {
            return this.sendScript(string.substring(n + 1), string.substring(0, n), false, false);
        }
        if (!this.haveDocumentAccess) {
            return "NO EVAL ALLOWED";
        }
        if (this.callbacks.get((Object)CBK.EVAL) != null) {
            this.notifyCallback(CBK.EVAL, new Object[]{null, string});
            return "";
        }
        return this.doEval(string);
    }

    @Override
    public float[][] functionXY(String string, int n, int n2) {
        return this.doFunctionXY(string, n, n2);
    }

    @Override
    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        return this.doFunctionXYZ(string, n, n2, n3);
    }

    @Override
    public String createImage(String string, String string2, Object object, int n) {
        return null;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        GenericApplet.checkIn(null, null);
        return htRegistry;
    }

    @Override
    public void showUrl(String string) {
        if (Logger.debugging) {
            Logger.debug("showUrl(" + string + ")");
        }
        if (string != null && string.length() > 0) {
            try {
                this.doShowDocument(new URL((URL)null, string, null));
            }
            catch (MalformedURLException malformedURLException) {
                this.consoleMessage("Malformed URL:" + string);
            }
        }
    }

    @Override
    public Dimension resizeInnerPanel(String string) {
        return new Dimension(0, 0);
    }

    static synchronized void checkIn(String string, Object object) {
        if (string != null) {
            Logger.info("AppletRegistry.checkIn(" + string + ")");
            htRegistry.put(string, object);
        }
        if (Logger.debugging) {
            for (Map.Entry<String, Object> entry : htRegistry.entrySet()) {
                String string2 = entry.getKey();
                Logger.debug(string2 + " " + entry.getValue());
            }
        }
    }

    static synchronized void checkOut(String string) {
        htRegistry.remove(string);
    }

    static synchronized void findApplets(String string, String string2, String string3, Lst<String> lst) {
        if (string != null && string.indexOf(",") >= 0) {
            String[] stringArray = PT.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                GenericApplet.findApplets(stringArray[i], string2, string3, lst);
            }
            return;
        }
        String string4 = "__" + string2 + "__";
        if (string == null || string.equals("*") || string.equals(">")) {
            for (String string5 : htRegistry.keySet()) {
                if (string5.equals(string3) || string5.indexOf(string4) <= 0) continue;
                lst.addLast(string5);
            }
            return;
        }
        if (string3.indexOf("_object") >= 0 && string.indexOf("_object") < 0) {
            string = string + "_object";
        }
        if (string.indexOf("__") < 0) {
            string = string + string4;
        }
        if (!htRegistry.containsKey(string)) {
            string = "jmolApplet" + string;
        }
        if (!string.equals(string3) && htRegistry.containsKey(string)) {
            lst.addLast(string);
        }
    }
}

