/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.VTemp;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesSearch
extends JmolMolecule {
    private static final int INITIAL_ATOMS = 16;
    SmilesAtom[] patternAtoms = new SmilesAtom[16];
    String pattern;
    Node[] jmolAtoms;
    Node[] smartsAtoms;
    BNode[] bioAtoms;
    int jmolAtomCount;
    private BS bsSelected;
    BS bsRequired;
    boolean firstMatchOnly;
    boolean matchAllAtoms;
    boolean isSmarts;
    boolean isSmilesFind;
    SmilesSearch[] subSearches;
    boolean haveSelected;
    boolean haveBondStereochemistry;
    boolean haveAtomStereochemistry;
    boolean needRingData;
    boolean needAromatic = true;
    boolean needRingMemberships;
    int ringDataMax = Integer.MIN_VALUE;
    Lst<SmilesMeasure> measures = new Lst();
    int flags;
    SB ringSets;
    BS bsAromatic = new BS();
    BS bsAromatic5 = new BS();
    BS bsAromatic6 = new BS();
    SmilesAtom lastChainAtom;
    boolean asVector;
    boolean getMaps;
    SmilesSearch top = this;
    private boolean isSilent;
    private boolean isRingCheck;
    private int selectedAtomCount;
    private BS[] ringData;
    private int[] ringCounts;
    private int[] ringConnections;
    BS bsFound = new BS();
    private Map<String, Object> htNested;
    private int nNested;
    private SmilesBond nestedBond;
    private Lst<Object> vReturn;
    BS bsReturn = new BS();
    private boolean ignoreStereochemistry;
    private boolean noAromatic;
    private boolean aromaticDouble;
    private BS bsCheck;
    VTemp v = new VTemp();

    public String toString() {
        SB sB = new SB().append(this.pattern);
        sB.append("\nmolecular formula: " + this.getMolecularFormula(true, null, false));
        return sB.toString();
    }

    void setSelected(BS bS) {
        if (bS == null) {
            bS = BS.newN(this.jmolAtomCount);
            bS.setBits(0, this.jmolAtomCount);
        }
        this.bsSelected = bS;
    }

    void setAtomArray() {
        if (this.patternAtoms.length > this.ac) {
            this.patternAtoms = (SmilesAtom[])AU.arrayCopyObject(this.patternAtoms, this.ac);
        }
        this.nodes = this.patternAtoms;
    }

    SmilesAtom addAtom() {
        SmilesAtom smilesAtom;
        if (this.ac >= this.patternAtoms.length) {
            this.patternAtoms = (SmilesAtom[])AU.doubleLength(this.patternAtoms);
        }
        this.patternAtoms[this.ac] = smilesAtom = new SmilesAtom().setIndex(this.ac);
        ++this.ac;
        return smilesAtom;
    }

    int addNested(String string) {
        if (this.top.htNested == null) {
            this.top.htNested = new Hashtable<String, Object>();
        }
        this.setNested(++this.top.nNested, string);
        return this.top.nNested;
    }

    void clear() {
        this.bsReturn.clearAll();
        this.nNested = 0;
        this.htNested = null;
        this.nestedBond = null;
        this.clearBsFound(-1);
    }

    void setNested(int n, Object object) {
        this.top.htNested.put("_" + n, object);
    }

    Object getNested(int n) {
        return this.top.htNested.get("_" + n);
    }

    int getMissingHydrogenCount() {
        int n = 0;
        for (int i = 0; i < this.ac; ++i) {
            int n2 = this.patternAtoms[i].missingHydrogenCount;
            if (n2 < 0) continue;
            n += n2;
        }
        return n;
    }

    void setRingData(BS bS) throws InvalidSmilesException {
        if (this.needAromatic) {
            this.needRingData = true;
        }
        boolean bl = (this.flags & 1) != 0;
        this.needAromatic &= bS == null & !bl;
        if (!this.needAromatic) {
            this.bsAromatic.clearAll();
            if (bS != null) {
                this.bsAromatic.or(bS);
            }
            if (!this.needRingMemberships && !this.needRingData) {
                return;
            }
        }
        this.getRingData(this.needRingData, this.flags, null);
    }

    void getRingData(boolean bl, int n, Lst<BS>[] lstArray) throws InvalidSmilesException {
        Object object;
        Object object2;
        int n2;
        boolean bl2;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl2 = (n & 8) != 0;
        if (bl3 && lstArray == null) {
            lstArray = AU.createArrayOfArrayList(4);
        }
        if (bl2 && this.needAromatic) {
            this.bsAromatic = SmilesAromatic.checkAromaticDefined(this.jmolAtoms, this.bsSelected);
            bl3 = false;
        }
        if (this.ringDataMax < 0) {
            this.ringDataMax = 8;
        }
        if (bl3 && this.ringDataMax < 6) {
            this.ringDataMax = 6;
        }
        if (bl) {
            this.ringCounts = new int[this.jmolAtomCount];
            this.ringConnections = new int[this.jmolAtomCount];
            this.ringData = new BS[this.ringDataMax + 1];
        }
        this.ringSets = new SB();
        String string = "****";
        while (string.length() < this.ringDataMax) {
            string = string + string;
        }
        Lst lst = null;
        for (n2 = 3; n2 <= this.ringDataMax; ++n2) {
            if (n2 > this.jmolAtomCount) continue;
            object2 = "*1" + string.substring(0, n2 - 2) + "*1";
            object = SmilesParser.getMolecule((String)object2, true);
            Lst lst2 = (Lst)this.subsearch((SmilesSearch)object, false, true);
            if (lstArray != null && n2 <= 5) {
                Lst<BS> lst3 = new Lst<BS>();
                int n3 = lst2.size();
                while (--n3 >= 0) {
                    lst3.addLast((BS)lst2.get(n3));
                }
                lstArray[n2 - 3] = lst3;
            }
            if (this.needAromatic) {
                if (!(bl2 || bl3 && n2 != 5 && n2 != 6)) {
                    int n4 = lst2.size();
                    while (--n4 >= 0) {
                        BS bS = (BS)lst2.get(n4);
                        if (!bl2 && !SmilesAromatic.isFlatSp2Ring(this.jmolAtoms, this.bsSelected, bS, bl3 ? 0.1f : 0.01f)) continue;
                        this.bsAromatic.or(bS);
                    }
                }
                if (bl3) {
                    switch (n2) {
                        case 5: {
                            lst = lst2;
                            break;
                        }
                        case 6: {
                            if (bl2) {
                                this.bsAromatic = SmilesAromatic.checkAromaticDefined(this.jmolAtoms, this.bsAromatic);
                            } else {
                                SmilesAromatic.checkAromaticStrict(this.jmolAtoms, this.bsAromatic, lst, lst2);
                            }
                            lstArray[3] = new Lst();
                            this.setAromatic56(lst, this.bsAromatic5, 5, lstArray[3]);
                            this.setAromatic56(lst2, this.bsAromatic6, 6, lstArray[3]);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.ringData[n2] = new BS();
            for (int i = 0; i < lst2.size(); ++i) {
                BS bS = (BS)lst2.get(i);
                this.ringData[n2].or(bS);
                int n5 = bS.nextSetBit(0);
                while (n5 >= 0) {
                    int n6 = n5;
                    this.ringCounts[n6] = this.ringCounts[n6] + 1;
                    n5 = bS.nextSetBit(n5 + 1);
                }
            }
        }
        if (bl) {
            n2 = this.bsSelected.nextSetBit(0);
            while (n2 >= 0) {
                object2 = this.jmolAtoms[n2];
                object = object2.getEdges();
                if (object != null) {
                    int n7 = ((Edge[])object).length;
                    while (--n7 >= 0) {
                        if (this.ringCounts[object2.getBondedAtomIndex(n7)] <= 0) continue;
                        int n8 = n2;
                        this.ringConnections[n8] = this.ringConnections[n8] + 1;
                    }
                }
                n2 = this.bsSelected.nextSetBit(n2 + 1);
            }
        }
    }

    private void setAromatic56(Lst<Object> lst, BS bS, int n, Lst<BS> lst2) {
        for (int i = 0; i < lst.size(); ++i) {
            BS bS2 = (BS)lst.get(i);
            this.v.bsTemp.clearAll();
            this.v.bsTemp.or(bS2);
            this.v.bsTemp.and(this.bsAromatic);
            if (this.v.bsTemp.cardinality() != n) continue;
            bS.or(bS2);
            if (lst2 == null) continue;
            lst2.addLast(bS2);
        }
    }

    Object subsearch(SmilesSearch smilesSearch, boolean bl, boolean bl2) throws InvalidSmilesException {
        smilesSearch.ringSets = this.ringSets;
        smilesSearch.jmolAtoms = this.jmolAtoms;
        smilesSearch.jmolAtomCount = this.jmolAtomCount;
        smilesSearch.bsSelected = this.bsSelected;
        smilesSearch.htNested = this.htNested;
        smilesSearch.isSmilesFind = this.isSmilesFind;
        smilesSearch.bsCheck = this.bsCheck;
        smilesSearch.isSmarts = true;
        smilesSearch.bsAromatic = this.bsAromatic;
        smilesSearch.bsAromatic5 = this.bsAromatic5;
        smilesSearch.bsAromatic6 = this.bsAromatic6;
        smilesSearch.ringData = this.ringData;
        smilesSearch.ringCounts = this.ringCounts;
        smilesSearch.ringConnections = this.ringConnections;
        if (bl) {
            smilesSearch.bsRequired = null;
            smilesSearch.firstMatchOnly = false;
            smilesSearch.matchAllAtoms = false;
        } else if (bl2) {
            smilesSearch.bsRequired = null;
            smilesSearch.isSilent = true;
            smilesSearch.isRingCheck = true;
            smilesSearch.asVector = true;
            smilesSearch.matchAllAtoms = false;
        } else {
            smilesSearch.haveSelected = this.haveSelected;
            smilesSearch.bsRequired = this.bsRequired;
            smilesSearch.firstMatchOnly = this.firstMatchOnly;
            smilesSearch.matchAllAtoms = this.matchAllAtoms;
            smilesSearch.getMaps = this.getMaps;
            smilesSearch.asVector = this.asVector;
            smilesSearch.vReturn = this.vReturn;
            smilesSearch.bsReturn = this.bsReturn;
        }
        return smilesSearch.search(bl);
    }

    Object search(boolean bl) throws InvalidSmilesException {
        this.ignoreStereochemistry = (this.flags & 2) != 0;
        this.noAromatic = (this.flags & 1) != 0;
        boolean bl2 = this.aromaticDouble = (this.flags & 0x10) != 0;
        if (Logger.debugging && !this.isSilent) {
            Logger.debug("SmilesSearch processing " + this.pattern);
        }
        if (this.vReturn == null && (this.asVector || this.getMaps)) {
            this.vReturn = new Lst();
        }
        if (this.bsSelected == null) {
            this.bsSelected = BS.newN(this.jmolAtomCount);
            this.bsSelected.setBits(0, this.jmolAtomCount);
        }
        this.selectedAtomCount = this.bsSelected.cardinality();
        if (this.subSearches != null) {
            for (int i = 0; i < this.subSearches.length; ++i) {
                if (this.subSearches[i] == null) continue;
                this.subsearch(this.subSearches[i], false, false);
                if (!this.firstMatchOnly || !(this.vReturn == null ? this.bsReturn.nextSetBit(0) >= 0 : this.vReturn.size() > 0)) {
                    continue;
                }
                break;
            }
        } else if (this.ac > 0) {
            this.checkMatch(null, -1, -1, bl);
        }
        return this.asVector || this.getMaps ? this.vReturn : this.bsReturn;
    }

    private final boolean checkMatch(SmilesAtom smilesAtom, int n, int n2, boolean bl) throws InvalidSmilesException {
        if (smilesAtom == null) {
            if (this.nestedBond == null) {
                this.clearBsFound(-1);
            } else {
                this.bsReturn.clearAll();
            }
        } else {
            int n3;
            if (this.bsFound.get(n2) || !this.bsSelected.get(n2)) {
                return true;
            }
            Node node = this.jmolAtoms[n2];
            if (!this.isRingCheck) {
                if (smilesAtom.atomsOr != null) {
                    for (int i = 0; i < smilesAtom.nAtomsOr; ++i) {
                        if (this.checkMatch(smilesAtom.atomsOr[i], n, n2, bl)) continue;
                        return false;
                    }
                    return true;
                }
                if (smilesAtom.primitives == null) {
                    if (!this.checkPrimitiveAtom(smilesAtom, n2)) {
                        return true;
                    }
                } else {
                    for (n3 = 0; n3 < smilesAtom.nPrimitives; ++n3) {
                        if (this.checkPrimitiveAtom(smilesAtom.primitives[n3], n2)) continue;
                        return true;
                    }
                }
            }
            Edge[] edgeArray = node.getEdges();
            n3 = smilesAtom.getBondCount();
            block5: while (--n3 >= 0) {
                int n4;
                SmilesBond smilesBond = smilesAtom.getBond(n3);
                if (smilesBond.getAtomIndex2() != smilesAtom.index) continue;
                SmilesAtom smilesAtom2 = smilesBond.atom1;
                int n5 = smilesAtom2.getMatchingAtom();
                switch (smilesBond.order) {
                    case 96: 
                    case 112: {
                        if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, null)) continue block5;
                        return true;
                    }
                }
                for (n4 = 0; n4 < edgeArray.length && (edgeArray[n4].getAtomIndex1() != n5 && edgeArray[n4].getAtomIndex2() != n5 || !edgeArray[n4].isCovalent()); ++n4) {
                }
                if (n4 == edgeArray.length) {
                    return true;
                }
                if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, edgeArray[n4])) continue;
                return true;
            }
            this.patternAtoms[smilesAtom.index].setMatchingAtom(n2);
            if (Logger.debugging && !this.isSilent) {
                Logger.debug("pattern atom " + n + " " + smilesAtom);
            }
            this.bsFound.set(n2);
        }
        if (!this.continueMatch(n, n2, bl)) {
            return false;
        }
        if (n2 >= 0) {
            this.clearBsFound(n2);
        }
        return true;
    }

    private boolean continueMatch(int n, int n2, boolean bl) throws InvalidSmilesException {
        int n3;
        int n4;
        if (++n < this.ac) {
            SmilesBond smilesBond;
            SmilesAtom smilesAtom = this.patternAtoms[n];
            SmilesBond smilesBond2 = n2 >= 0 ? smilesAtom.getBondTo(null) : (smilesBond = n == 0 ? this.nestedBond : null);
            if (smilesBond == null) {
                int n5;
                BS bS = BSUtil.copy(this.bsFound);
                if (smilesAtom.notBondedIndex >= 0) {
                    SmilesAtom smilesAtom2 = this.patternAtoms[smilesAtom.notBondedIndex];
                    Node node = this.jmolAtoms[smilesAtom2.getMatchingAtom()];
                    if (smilesAtom2.isBioAtom) {
                        n5 = ((BNode)node).getOffsetResidueAtom("0", 1);
                        if (n5 >= 0) {
                            bS.set(n5);
                        }
                        if ((n5 = ((BNode)node).getOffsetResidueAtom("0", -1)) >= 0) {
                            bS.set(n5);
                        }
                    } else {
                        Edge[] edgeArray = node.getEdges();
                        for (n5 = 0; n5 < edgeArray.length; ++n5) {
                            bS.set(edgeArray[n5].getOtherAtomNode(node).getIndex());
                        }
                    }
                }
                boolean bl2 = n2 >= 0 && smilesAtom.isBioAtom && (smilesAtom.atomName == null || smilesAtom.residueChar != null);
                int n6 = this.bsSelected.nextSetBit(0);
                while (n6 >= 0) {
                    if (!bS.get(n6) && !this.checkMatch(smilesAtom, n, n6, bl)) {
                        return false;
                    }
                    if (bl2 && (n5 = ((BNode)this.jmolAtoms[n6]).getOffsetResidueAtom(smilesAtom.atomName, 1)) >= 0) {
                        n6 = n5 - 1;
                    }
                    n6 = this.bsSelected.nextSetBit(n6 + 1);
                }
                this.bsFound = bS;
                return true;
            }
            Node node = this.jmolAtoms[smilesBond.atom1.getMatchingAtom()];
            switch (smilesBond.order) {
                case 96: {
                    int n7 = ((BNode)node).getOffsetResidueAtom(smilesAtom.atomName, 1);
                    if (n7 >= 0) {
                        BS bS = BSUtil.copy(this.bsFound);
                        ((BNode)node).getGroupBits(this.bsFound);
                        if (!this.checkMatch(smilesAtom, n, n7, bl)) {
                            return false;
                        }
                        this.bsFound = bS;
                    }
                    return true;
                }
                case 112: {
                    Lst<Integer> lst = new Lst<Integer>();
                    ((BNode)node).getCrossLinkLeadAtomIndexes(lst);
                    BS bS = BSUtil.copy(this.bsFound);
                    ((BNode)node).getGroupBits(this.bsFound);
                    for (int i = 0; i < lst.size(); ++i) {
                        if (this.checkMatch(smilesAtom, n, (Integer)lst.get(i), bl)) continue;
                        return false;
                    }
                    this.bsFound = bS;
                    return true;
                }
            }
            Edge[] edgeArray = node.getEdges();
            if (edgeArray != null) {
                for (int i = 0; i < edgeArray.length; ++i) {
                    if (this.checkMatch(smilesAtom, n, node.getBondedAtomIndex(i), bl)) continue;
                    return false;
                }
            }
            this.clearBsFound(n2);
            return true;
        }
        if (!this.ignoreStereochemistry && !this.checkStereochemistry()) {
            return true;
        }
        BS bS = new BS();
        int n8 = 0;
        for (n4 = 0; n4 < this.ac; ++n4) {
            n3 = this.patternAtoms[n4].getMatchingAtom();
            if (!bl && this.top.haveSelected && !this.patternAtoms[n4].selected) continue;
            ++n8;
            bS.set(n3);
            if (this.patternAtoms[n4].isBioAtom && this.patternAtoms[n4].atomName == null) {
                ((BNode)this.jmolAtoms[n3]).getGroupBits(bS);
            }
            if (bl) break;
            if (this.isSmarts || this.patternAtoms[n4].missingHydrogenCount <= 0) continue;
            this.getHydrogens(this.jmolAtoms[n3], bS);
        }
        if (this.bsRequired != null && !this.bsRequired.intersects(bS)) {
            return true;
        }
        if (this.matchAllAtoms && bS.cardinality() != this.selectedAtomCount) {
            return true;
        }
        if (this.bsCheck != null) {
            if (bl) {
                this.bsCheck.clearAll();
                for (n4 = 0; n4 < this.ac; ++n4) {
                    this.bsCheck.set(this.patternAtoms[n4].getMatchingAtom());
                }
                if (this.bsCheck.cardinality() != this.ac) {
                    return true;
                }
            } else if (bS.cardinality() != this.ac) {
                return true;
            }
        }
        this.bsReturn.or(bS);
        if (this.getMaps) {
            int[] nArray = new int[n8];
            int n9 = 0;
            for (n3 = 0; n3 < this.ac; ++n3) {
                if (!bl && this.top.haveSelected && !this.patternAtoms[n3].selected) continue;
                nArray[n9++] = this.patternAtoms[n3].getMatchingAtom();
            }
            this.vReturn.addLast(nArray);
            return !this.firstMatchOnly;
        }
        if (this.asVector) {
            n4 = 1;
            n3 = this.vReturn.size();
            while (--n3 >= 0 && n4 != 0) {
                n4 = !((BS)this.vReturn.get(n3)).equals(bS) ? 1 : 0;
            }
            if (n4 == 0) {
                return true;
            }
            this.vReturn.addLast(bS);
        }
        if (this.isRingCheck) {
            this.ringSets.append(" ");
            n4 = n * 3 + 2;
            while (--n4 > n) {
                this.ringSets.append("-").appendI(this.patternAtoms[(n4 <= n * 2 ? n * 2 - n4 + 1 : n4 - 1) % n].getMatchingAtom());
            }
            this.ringSets.append("- ");
            return true;
        }
        if (this.firstMatchOnly) {
            return false;
        }
        return bS.cardinality() != this.selectedAtomCount;
    }

    private void clearBsFound(int n) {
        if (n < 0) {
            if (this.bsCheck == null) {
                this.bsFound.clearAll();
            }
        } else {
            this.bsFound.clear(n);
        }
    }

    private Node getHydrogens(Node node, BS bS) {
        Edge[] edgeArray = node.getEdges();
        int n = -1;
        for (int i = 0; i < edgeArray.length; ++i) {
            if (this.jmolAtoms[node.getBondedAtomIndex(i)].getElementNumber() != 1) continue;
            n = node.getBondedAtomIndex(i);
            if (bS == null) break;
            bS.set(n);
        }
        return n >= 0 ? this.jmolAtoms[n] : null;
    }

    private boolean checkPrimitiveAtom(SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        boolean bl;
        block14: {
            block17: {
                int n2;
                block20: {
                    block21: {
                        Node node;
                        block19: {
                            int n3;
                            block18: {
                                block15: {
                                    block16: {
                                        block13: {
                                            node = this.jmolAtoms[n];
                                            bl = smilesAtom.not;
                                            if (smilesAtom.iNested <= 0) break block13;
                                            Object object = this.getNested(smilesAtom.iNested);
                                            if (object instanceof SmilesSearch) {
                                                SmilesSearch smilesSearch = (SmilesSearch)object;
                                                if (smilesAtom.isBioAtom) {
                                                    smilesSearch.nestedBond = smilesAtom.getBondTo(null);
                                                }
                                                if ((object = this.subsearch(smilesSearch, true, false)) == null) {
                                                    object = new BS();
                                                }
                                                if (!smilesAtom.isBioAtom) {
                                                    this.setNested(smilesAtom.iNested, object);
                                                }
                                            }
                                            bl = smilesAtom.not != ((BS)object).get(n);
                                            break block14;
                                        }
                                        if (!smilesAtom.isBioAtom) break block15;
                                        BNode bNode = (BNode)node;
                                        if (smilesAtom.atomName != null && (!smilesAtom.isLeadAtom() ? !smilesAtom.atomName.equals(bNode.getAtomName().toUpperCase()) : !bNode.isLeadAtom())) break block14;
                                        if (smilesAtom.notCrossLinked && bNode.getCrossLinkLeadAtomIndexes(null) || smilesAtom.residueName != null && !smilesAtom.residueName.equals(bNode.getGroup3(false).toUpperCase())) break block14;
                                        if (smilesAtom.residueChar == null) break block16;
                                        if (smilesAtom.isDna() && !bNode.isDna() || smilesAtom.isRna() && !bNode.isRna() || smilesAtom.isProtein() && !bNode.isProtein() || smilesAtom.isNucleic() && !bNode.isNucleic()) break block14;
                                        String string = bNode.getGroup1('\u0000').toUpperCase();
                                        boolean bl2 = smilesAtom.residueChar.equals(string);
                                        switch (smilesAtom.residueChar.charAt(0)) {
                                            case 'N': {
                                                bl2 = smilesAtom.isNucleic() ? bNode.isNucleic() : bl2;
                                                break;
                                            }
                                            case 'R': {
                                                bl2 = smilesAtom.isNucleic() ? bNode.isPurine() : bl2;
                                                break;
                                            }
                                            case 'Y': {
                                                boolean bl3 = bl2 = smilesAtom.isNucleic() ? bNode.isPyrimidine() : bl2;
                                            }
                                        }
                                        if (!bl2) break block14;
                                    }
                                    if (smilesAtom.elementNumber < 0 || smilesAtom.elementNumber == node.getElementNumber()) break block17;
                                    break block14;
                                }
                                if (smilesAtom.atomName != null && !smilesAtom.atomName.equals(node.getAtomName().toUpperCase()) || smilesAtom.jmolIndex >= 0 && node.getIndex() != smilesAtom.jmolIndex || smilesAtom.atomType != null && !smilesAtom.atomType.equals(node.getAtomType()) || smilesAtom.elementNumber >= 0 && smilesAtom.elementNumber != node.getElementNumber()) break block14;
                                boolean bl4 = smilesAtom.isAromatic();
                                if (!this.noAromatic && !smilesAtom.aromaticAmbiguous && bl4 != this.bsAromatic.get(n)) break block14;
                                n2 = smilesAtom.getAtomicMass();
                                if (n2 == Integer.MIN_VALUE) break block18;
                                n3 = node.getIsotopeNumber();
                                if (n2 >= 0 && n2 != n3 || n2 < 0 && n3 != 0 && -n2 != n3) break block14;
                            }
                            if ((n2 = smilesAtom.getCharge()) != Integer.MIN_VALUE && n2 != node.getFormalCharge() || (n2 = smilesAtom.getCovalentHydrogenCount() + smilesAtom.missingHydrogenCount) >= 0 && n2 != node.getCovalentHydrogenCount()) break block14;
                            n2 = smilesAtom.implicitHydrogenCount;
                            if (n2 == Integer.MIN_VALUE) break block19;
                            n3 = node.getImplicitHydrogenCount();
                            if (n2 != -1 ? n2 != n3 : n3 == 0) break block14;
                        }
                        if (smilesAtom.degree > 0 && smilesAtom.degree != node.getCovalentBondCount() || smilesAtom.nonhydrogenDegree > 0 && smilesAtom.nonhydrogenDegree != node.getCovalentBondCount() - node.getCovalentHydrogenCount() || smilesAtom.valence > 0 && smilesAtom.valence != node.getValence() || smilesAtom.connectivity > 0 && smilesAtom.connectivity != node.getCovalentBondCount() + node.getImplicitHydrogenCount()) break block14;
                        if (this.ringData == null || smilesAtom.ringSize < -1) break block20;
                        if (smilesAtom.ringSize > 0) break block21;
                        if (this.ringCounts[n] == 0 == (smilesAtom.ringSize == 0)) break block20;
                        break block14;
                    }
                    BS bS = this.ringData[smilesAtom.ringSize == 500 ? 5 : (smilesAtom.ringSize == 600 ? 6 : smilesAtom.ringSize)];
                    if (bS == null || !bS.get(n) || !this.noAromatic && (smilesAtom.ringSize != 500 ? smilesAtom.ringSize == 600 && !this.bsAromatic6.get(n) : !this.bsAromatic5.get(n))) break block14;
                }
                if (this.ringData != null && smilesAtom.ringMembership >= -1 && (smilesAtom.ringMembership != -1 ? this.ringCounts[n] != smilesAtom.ringMembership : this.ringCounts[n] == 0)) break block14;
                if (smilesAtom.ringConnectivity < 0) break block17;
                n2 = this.ringConnections[n];
                if (smilesAtom.ringConnectivity == -1 && n2 == 0 || smilesAtom.ringConnectivity != -1 && n2 != smilesAtom.ringConnectivity) break block14;
            }
            bl = !bl;
        }
        return bl;
    }

    private boolean checkMatchBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond smilesBond, int n, int n2, Edge edge) {
        if (smilesBond.bondsOr != null) {
            for (int i = 0; i < smilesBond.nBondsOr; ++i) {
                if (!this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond.bondsOr[i], n, n2, edge)) continue;
                return true;
            }
            return false;
        }
        if (smilesBond.primitives == null) {
            if (!this.checkPrimitiveBond(smilesBond, n, n2, edge)) {
                return false;
            }
        } else {
            for (int i = 0; i < smilesBond.nPrimitives; ++i) {
                if (this.checkPrimitiveBond(smilesBond.primitives[i], n, n2, edge)) continue;
                return false;
            }
        }
        smilesBond.matchingBond = edge;
        return true;
    }

    private boolean checkPrimitiveBond(SmilesBond smilesBond, int n, int n2, Edge edge) {
        boolean bl = false;
        switch (smilesBond.order) {
            case 96: {
                return smilesBond.isNot != (this.bioAtoms[n2].getOffsetResidueAtom("0", 1) == this.bioAtoms[n].getOffsetResidueAtom("0", 0));
            }
            case 112: {
                return smilesBond.isNot != this.bioAtoms[n].isCrossLinked(this.bioAtoms[n2]);
            }
        }
        boolean bl2 = !this.noAromatic && this.bsAromatic.get(n);
        boolean bl3 = !this.noAromatic && this.bsAromatic.get(n2);
        int n3 = edge.getCovalentOrder();
        if (bl2 && bl3) {
            switch (smilesBond.order) {
                case 17: 
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case 1: {
                    bl = !this.isSmarts || !SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case 2: {
                    bl = !this.isSmarts || this.aromaticDouble && (n3 == 2 || n3 == 514);
                    break;
                }
                case -1: 
                case 81: 
                case 769: 
                case 1025: {
                    bl = true;
                }
            }
        } else {
            switch (smilesBond.order) {
                case -1: 
                case 81: {
                    bl = true;
                    break;
                }
                case 1: 
                case 257: 
                case 513: {
                    bl = n3 == 1 || n3 == 1041 || n3 == 1025;
                    break;
                }
                case 769: {
                    bl = n3 == (this.isSmilesFind ? 33 : 1);
                    break;
                }
                case 1025: {
                    bl = n3 == (this.isSmilesFind ? 97 : 1);
                    break;
                }
                case 2: {
                    bl = n3 == 2;
                    break;
                }
                case 3: {
                    bl = n3 == 3;
                    break;
                }
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                }
            }
        }
        return bl != smilesBond.isNot;
    }

    static boolean isRingBond(SB sB, int n, int n2) {
        return sB != null && sB.indexOf("-" + n + "-" + n2 + "-") >= 0;
    }

    private boolean checkStereochemistry() {
        Object object;
        int n;
        Node node;
        Node node2;
        Node node3;
        Node node4;
        int n2;
        for (n2 = 0; n2 < this.measures.size(); ++n2) {
            if (((SmilesMeasure)this.measures.get(n2)).check()) continue;
            return false;
        }
        if (this.haveAtomStereochemistry) {
            if (Logger.debugging) {
                Logger.debug("checking stereochemistry...");
            }
            Node node5 = null;
            node4 = null;
            node3 = null;
            node2 = null;
            node = null;
            Node node6 = null;
            SmilesAtom smilesAtom = null;
            SmilesAtom smilesAtom2 = null;
            block16: for (n = 0; n < this.ac; ++n) {
                int n3;
                SmilesAtom smilesAtom3 = this.patternAtoms[n];
                Node node7 = this.jmolAtoms[smilesAtom3.getMatchingAtom()];
                int n4 = smilesAtom3.missingHydrogenCount;
                if (n4 < 0) {
                    n4 = 0;
                }
                if ((n3 = smilesAtom3.getChiralClass()) == Integer.MIN_VALUE) continue;
                int n5 = smilesAtom3.getChiralOrder();
                if (this.isSmilesFind && node7.getAtomSite() >> 8 != n3) {
                    return false;
                }
                node2 = null;
                if (Logger.debugging) {
                    Logger.debug("...type " + n3 + " for pattern atom " + smilesAtom3 + " " + node7);
                }
                switch (n3) {
                    case 2: {
                        int n6;
                        boolean bl = true;
                        if (bl) {
                            smilesAtom = smilesAtom3.getBond(0).getOtherAtom(smilesAtom3);
                            smilesAtom2 = smilesAtom3.getBond(1).getOtherAtom(smilesAtom3);
                            if (smilesAtom == null || smilesAtom2 == null) continue block16;
                            SmilesAtom smilesAtom4 = smilesAtom3;
                            SmilesAtom smilesAtom5 = smilesAtom3;
                            while (smilesAtom.getBondCount() == 2 && smilesAtom2.getBondCount() == 2 && smilesAtom.getValence() == 4 && smilesAtom2.getValence() == 4) {
                                SmilesBond smilesBond = smilesAtom.getBondNotTo(smilesAtom4, true);
                                smilesAtom4 = smilesAtom;
                                smilesAtom = smilesBond.getOtherAtom(smilesAtom);
                                smilesBond = smilesAtom2.getBondNotTo(smilesAtom5, true);
                                smilesAtom5 = smilesAtom2;
                                smilesAtom2 = smilesBond.getOtherAtom(smilesAtom2);
                            }
                            smilesAtom3 = smilesAtom;
                        }
                        object = new Node[6];
                        object[4] = new SmilesAtom().setIndex(604);
                        int n7 = smilesAtom3.getBondCount();
                        for (n6 = 0; n6 < n7; ++n6) {
                            smilesAtom = smilesAtom3.bonds[n6].getOtherAtom(smilesAtom3);
                            if (smilesAtom3.bonds[n6].matchingBond.getCovalentOrder() == 2) {
                                if (smilesAtom2 != null) continue;
                                smilesAtom2 = smilesAtom;
                                continue;
                            }
                            if (object[0] == null) {
                                object[0] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                                continue;
                            }
                            object[1] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                        }
                        if (smilesAtom2 == null || (n7 = smilesAtom2.getBondCount()) < 2 || n7 > 3) continue block16;
                        for (n6 = 0; n6 < n7; ++n6) {
                            smilesAtom = smilesAtom2.bonds[n6].getOtherAtom(smilesAtom2);
                            if (smilesAtom2.bonds[n6].matchingBond.getCovalentOrder() == 2) continue;
                            if (object[2] == null) {
                                object[2] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                                continue;
                            }
                            object[3] = this.getJmolAtom(smilesAtom.getMatchingAtom());
                        }
                        if (this.isSmilesFind) {
                            if (object[1] == null) {
                                this.getX(smilesAtom3, (Node[])object, 1, false, bl);
                            }
                            if (object[3] == null) {
                                this.getX(smilesAtom2, (Node[])object, 3, false, false);
                            }
                            if (!this.setSmilesCoordinates(node7, smilesAtom3, smilesAtom2, (Node[])object)) {
                                return false;
                            }
                        }
                        if (object[1] == null) {
                            this.getX(smilesAtom3, (Node[])object, 1, true, false);
                        }
                        if (object[3] == null) {
                            this.getX(smilesAtom2, (Node[])object, 3, true, false);
                        }
                        if (SmilesSearch.checkStereochemistryAll(smilesAtom3.not, node7, n3, n5, object[0], object[1], object[2], object[3], null, null, this.v)) continue block16;
                        return false;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        node5 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(0));
                        switch (n4) {
                            case 0: {
                                node4 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(1));
                                break;
                            }
                            case 1: {
                                node4 = this.getHydrogens(this.getJmolAtom(smilesAtom3.getMatchingAtom()), null);
                                if (!smilesAtom3.isFirst) break;
                                Node node8 = node4;
                                node4 = node5;
                                node5 = node8;
                                break;
                            }
                            default: {
                                continue block16;
                            }
                        }
                        node3 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(2 - n4));
                        node2 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(3 - n4));
                        node = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(4 - n4));
                        node6 = this.getJmolAtom(smilesAtom3.getMatchingBondedAtom(5 - n4));
                        if (this.isSmilesFind && !this.setSmilesCoordinates(node7, smilesAtom3, smilesAtom2, new Node[]{node5, node4, node3, node2, node, node6})) {
                            return false;
                        }
                        if (SmilesSearch.checkStereochemistryAll(smilesAtom3.not, node7, n3, n5, node5, node4, node3, node2, node, node6, this.v)) continue block16;
                        return false;
                    }
                }
            }
        }
        if (this.haveBondStereochemistry) {
            for (n2 = 0; n2 < this.ac; ++n2) {
                int n8;
                node4 = this.patternAtoms[n2];
                node3 = null;
                node2 = null;
                node = null;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                n = node4.getBondCount();
                boolean bl = false;
                block21: for (n8 = 0; n8 < n; ++n8) {
                    object = node4.getBond(n8);
                    boolean bl2 = object.atom2 == node4;
                    int n12 = object.order;
                    switch (n12) {
                        case 2: 
                        case 769: 
                        case 1025: {
                            if (bl2) continue block21;
                            node3 = object.atom2;
                            n11 = n12;
                            boolean bl3 = bl = n12 != 2;
                            if (!bl) continue block21;
                            n9 = object.isNot ? -1 : 1;
                            continue block21;
                        }
                        case 257: 
                        case 513: {
                            node2 = bl2 ? object.atom1 : object.atom2;
                            n9 = bl2 != (n12 == 257) ? 1 : -1;
                        }
                    }
                }
                if (bl) {
                    object = node4.getBondNotTo((SmilesAtom)node3, false);
                    if (object == null) {
                        return false;
                    }
                    node2 = object.getOtherAtom((SmilesAtom)node4);
                    object = node3.getBondNotTo((SmilesAtom)node4, false);
                    if (object == null) {
                        return false;
                    }
                    node = object.getOtherAtom((SmilesAtom)node3);
                } else {
                    if (node3 == null || n9 == 0) continue;
                    n = node3.getBondCount();
                    for (n8 = 0; n8 < n && n10 == 0; ++n8) {
                        object = node3.getBond(n8);
                        boolean bl4 = object.atom2 == node3;
                        int n13 = object.order;
                        switch (n13) {
                            case 257: 
                            case 513: {
                                node = bl4 ? object.atom1 : object.atom2;
                                n10 = bl4 != (n13 == 257) ? 1 : -1;
                            }
                        }
                    }
                    if (n10 == 0) continue;
                }
                if (this.isSmilesFind) {
                    this.setSmilesBondCoordinates((SmilesAtom)node4, (SmilesAtom)node3, n11);
                }
                Node node9 = this.getJmolAtom(node4.getMatchingAtom());
                Node node10 = this.getJmolAtom(node3.getMatchingAtom());
                Node node11 = this.getJmolAtom(node2.getMatchingAtom());
                Node node12 = this.getJmolAtom(node.getMatchingAtom());
                if (node11 == null || node12 == null) {
                    return false;
                }
                SmilesMeasure.setTorsionData((P3)((Object)node11), (P3)((Object)node9), (P3)((Object)node10), (P3)((Object)node12), this.v, bl);
                if (bl) {
                    n10 = n11 == 769 ? 1 : -1;
                    float f = this.v.vTemp1.dot(this.v.vTemp2);
                    if (!(f < 0.05f) && !(f > 0.95f) && !(this.v.vNorm1.dot(this.v.vNorm2) * (float)n9 * (float)n10 > 0.0f)) continue;
                    return false;
                }
                if (!(this.v.vTemp1.dot(this.v.vTemp2) * (float)n9 * (float)n10 < 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    private void getX(SmilesAtom smilesAtom, Node[] nodeArray, int n, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        Node node = this.getJmolAtom(smilesAtom.getMatchingAtom());
        boolean bl4 = bl3 = smilesAtom.isFirst || n == 3;
        if (bl) {
            int n2;
            if (this.isSmarts) {
                object = node.getEdges();
                for (n2 = 0; n2 < ((Edge[])object).length; ++n2) {
                    Node node2;
                    if (object[n2].getCovalentOrder() == 2 || (node2 = this.jmolAtoms[node.getBondedAtomIndex(n2)]) == nodeArray[n - 1]) continue;
                    nodeArray[n] = node2;
                    break;
                }
            }
            if (nodeArray[n] == null) {
                object = new V3();
                n2 = 0;
                for (int i = 0; i < 4; ++i) {
                    if (nodeArray[i] == null) continue;
                    ++n2;
                    ((T3)object).sub((P3)((Object)nodeArray[i]));
                }
                if (((T3)object).length() == 0.0f) {
                    ((T3)object).setT((P3)((Object)nodeArray[4]));
                    bl3 = false;
                } else {
                    ((T3)object).scaleAdd2(n2 + 1, (P3)((Object)this.getJmolAtom(smilesAtom.getMatchingAtom())), (T3)object);
                    bl3 = this.isSmilesFind || bl3;
                }
                nodeArray[n] = new SmilesAtom().setIndex(-1);
                ((P3)((Object)nodeArray[n])).setT((T3)object);
            }
        }
        if (nodeArray[n] == null) {
            nodeArray[n] = this.getHydrogens(node, null);
            if (bl2) {
                bl3 = true;
            }
        }
        if (nodeArray[n] != null && bl3) {
            object = nodeArray[n];
            nodeArray[n] = nodeArray[n - 1];
            nodeArray[n - 1] = object;
        }
    }

    static boolean checkStereochemistryAll(boolean bl, Node node, int n, int n2, Node node2, Node node3, Node node4, Node node5, Node node6, Node node7, VTemp vTemp) {
        switch (n) {
            default: {
                return bl == (SmilesSearch.getHandedness(node3, node4, node5, node2, vTemp) != n2);
            }
            case 5: {
                return bl == (!SmilesSearch.isDiaxial(node, node, node6, node2, vTemp, -0.95f) || SmilesSearch.getHandedness(node3, node4, node5, node2, vTemp) != n2);
            }
            case 6: {
                if (bl != !SmilesSearch.isDiaxial(node, node, node7, node2, vTemp, -0.95f)) {
                    return false;
                }
                SmilesSearch.getPlaneNormals(node3, node4, node5, node6, vTemp);
                if (bl != (vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f || vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f)) {
                    return false;
                }
                vTemp.vNorm2.sub2((P3)((Object)node), (P3)((Object)node2));
                return bl == ((vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f ? 2 : 1) == n2);
            }
            case 8: 
        }
        SmilesSearch.getPlaneNormals(node2, node3, node4, node5, vTemp);
        return vTemp.vNorm1.dot(vTemp.vNorm2) < 0.0f ? bl == (n2 != 3) : (vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f ? bl == (n2 != 2) : bl == (n2 != 1));
    }

    private Node getJmolAtom(int n) {
        return n < 0 || n >= this.jmolAtoms.length ? null : this.jmolAtoms[n];
    }

    private void setSmilesBondCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n) {
        Node node = this.jmolAtoms[smilesAtom.getMatchingAtom()];
        Node node2 = this.jmolAtoms[smilesAtom2.getMatchingAtom()];
        node.set(-1.0f, 0.0f, 0.0f);
        node2.set(1.0f, 0.0f, 0.0f);
        if (n == 2) {
            Node[] nodeArray;
            int n2 = 0;
            int n3 = 0;
            Edge[] edgeArray = node.getEdges();
            int n4 = edgeArray.length;
            while (--n4 >= 0) {
                nodeArray = edgeArray[n4];
                Node node3 = nodeArray.getOtherAtomNode(node);
                if (node3 == node2) continue;
                node3.set(-1.0f, n2++ == 0 ? -1.0f : 1.0f, 0.0f);
                int n5 = nodeArray.getAtomIndex2() == node.getIndex() ? n2 : -n2;
                switch (nodeArray.order) {
                    case 1025: {
                        n3 = n5;
                        break;
                    }
                    case 1041: {
                        n3 = -n5;
                    }
                }
            }
            n4 = 0;
            n2 = 0;
            nodeArray = new Node[2];
            edgeArray = node2.getEdges();
            int n6 = edgeArray.length;
            while (--n6 >= 0) {
                Edge edge = edgeArray[n6];
                Node node4 = edge.getOtherAtomNode(node2);
                if (node4 == node) continue;
                nodeArray[n2] = node4;
                node4.set(1.0f, n2++ == 0 ? 1.0f : -1.0f, 0.0f);
                int n7 = edge.getAtomIndex2() == node2.getIndex() ? n2 : -n2;
                switch (edge.order) {
                    case 1025: {
                        n4 = n7;
                        break;
                    }
                    case 1041: {
                        n4 = -n7;
                    }
                }
            }
            if (n3 * n4 > 0 == (Math.abs(n3) % 2 == Math.abs(n4) % 2)) {
                float f = ((P3)((Object)nodeArray[0])).y;
                ((P3)((Object)nodeArray[0])).y = ((P3)((Object)nodeArray[1])).y;
                ((P3)((Object)nodeArray[1])).y = f;
            }
        } else {
            Node node5;
            Edge edge;
            Edge[] edgeArray = node.getEdges();
            int n8 = 0;
            int n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                if (edge.getOtherAtomNode(node) != node2) continue;
                n8 = edge.order == 33 ? 1 : -1;
                break;
            }
            n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                node5 = edge.getOtherAtomNode(node);
                if (node5 == node2) continue;
                node5.set(-1.0f, 1.0f, 0.0f);
            }
            edgeArray = node2.getEdges();
            n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                node5 = edge.getOtherAtomNode(node2);
                if (node5 == node) continue;
                node5.set(1.0f, 1.0f, (float)(-n8) / 2.0f);
            }
        }
    }

    private boolean setSmilesCoordinates(Node node, SmilesAtom smilesAtom, SmilesAtom smilesAtom2, Node[] nodeArray) {
        Node node2;
        int n = node.getAtomSite();
        if (n == Integer.MIN_VALUE) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        node2 = n2 == 2 || n2 == 3 ? (node2 = this.jmolAtoms[smilesAtom2.getMatchingAtom()]) : null;
        node.set(0.0f, 0.0f, 0.0f);
        node = this.jmolAtoms[smilesAtom.getMatchingAtom()];
        node.set(0.0f, 0.0f, 0.0f);
        int[] nArray = this.getMappedAtoms(node, node2, nodeArray);
        switch (n2) {
            case 2: 
            case 4: {
                if (n3 == 2) {
                    int n4 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n4;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, -1.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, -1.0f);
                nodeArray[nArray[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 8: {
                switch (n3) {
                    case 1: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(-1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        nodeArray[nArray[0]].set(1.0f, 0.0f, 0.0f);
                        nodeArray[nArray[1]].set(0.0f, 1.0f, 0.0f);
                        nodeArray[nArray[2]].set(0.0f, -1.0f, 0.0f);
                        nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 5: 
            case 6: {
                int n5 = nArray.length;
                if (n3 == 2) {
                    int n6 = nArray[0];
                    nArray[0] = nArray[n5 - 1];
                    nArray[n5 - 1] = n6;
                }
                nodeArray[nArray[0]].set(0.0f, 0.0f, 1.0f);
                nodeArray[nArray[n5 - 1]].set(0.0f, 0.0f, -1.0f);
                nodeArray[nArray[1]].set(1.0f, 0.0f, 0.0f);
                nodeArray[nArray[2]].set(0.0f, 1.0f, 0.0f);
                nodeArray[nArray[3]].set(-1.0f, 0.0f, 0.0f);
                if (n5 != 6) break;
                nodeArray[nArray[4]].set(0.0f, -1.0f, 0.0f);
            }
        }
        return true;
    }

    int[] getMappedAtoms(Node node, Node node2, Node[] nodeArray) {
        int n;
        int n2;
        int[] nArray = new int[nodeArray[4] == null ? 4 : (nodeArray[5] == null ? 5 : 6)];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = nodeArray[n2] == null ? 104 + n2 * 100 : nodeArray[n2].getIndex();
        }
        Edge[] edgeArray = node.getEdges();
        Edge[] edgeArray2 = node2 == null ? null : node2.getEdges();
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 0; n2 < edgeArray.length && edgeArray[n2].getOtherAtomNode(node) != nodeArray[n]; ++n2) {
            }
            if (n2 < edgeArray.length) {
                nArray[n] = n2 * 10 + 100 + n;
                continue;
            }
            if (node2 == null) continue;
            for (n2 = 0; n2 < edgeArray2.length && edgeArray2[n2].getOtherAtomNode(node2) != nodeArray[n]; ++n2) {
            }
            if (n2 >= edgeArray2.length) continue;
            nArray[n] = n2 * 10 + 300 + n;
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = nArray[n] % 10;
        }
        return nArray;
    }

    static boolean isDiaxial(Node node, Node node2, Node node3, Node node4, VTemp vTemp, float f) {
        vTemp.vA.sub2((P3)((Object)node), (P3)((Object)node3));
        vTemp.vB.sub2((P3)((Object)node2), (P3)((Object)node4));
        vTemp.vA.normalize();
        vTemp.vB.normalize();
        return vTemp.vA.dot(vTemp.vB) < f;
    }

    private static int getHandedness(Node node, Node node2, Node node3, Node node4, VTemp vTemp) {
        float f = SmilesAromatic.getNormalThroughPoints(node, node2, node3, vTemp.vTemp, vTemp.vA, vTemp.vB);
        return SmilesSearch.distanceToPlane(vTemp.vTemp, f, (P3)((Object)node4)) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(Node node, Node node2, Node node3, Node node4, VTemp vTemp) {
        SmilesAromatic.getNormalThroughPoints(node, node2, node3, vTemp.vNorm1, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(node2, node3, node4, vTemp.vNorm2, vTemp.vTemp1, vTemp.vTemp2);
        SmilesAromatic.getNormalThroughPoints(node3, node4, node, vTemp.vNorm3, vTemp.vTemp1, vTemp.vTemp2);
    }

    static float distanceToPlane(V3 v3, float f, P3 p3) {
        return v3 == null ? Float.NaN : (v3.x * p3.x + v3.y * p3.y + v3.z * p3.z + f) / (float)Math.sqrt(v3.x * v3.x + v3.y * v3.y + v3.z * v3.z);
    }

    void createTopoMap(BS bS) {
        Object object;
        int n;
        Edge[] edgeArray;
        int n2;
        if (bS == null) {
            bS = new BS();
        }
        int n3 = this.getMissingHydrogenCount();
        SmilesAtom[] smilesAtomArray = new SmilesAtom[this.ac + n3];
        this.jmolAtoms = smilesAtomArray;
        int n4 = 0;
        BS bS2 = new BS();
        for (n2 = 0; n2 < this.ac; ++n2) {
            edgeArray = this.patternAtoms[n2];
            n = edgeArray.getChiralClass();
            int n5 = edgeArray.missingHydrogenCount;
            if (n5 < 0) {
                n5 = 0;
            }
            SmilesAtom smilesAtom = smilesAtomArray[n4] = new SmilesAtom().setAll(0, n4, n == Integer.MIN_VALUE ? n : (n << 8) + edgeArray.getChiralOrder(), edgeArray.elementNumber, edgeArray.getCharge());
            smilesAtom.atomName = edgeArray.atomName;
            smilesAtom.residueName = edgeArray.residueName;
            smilesAtom.residueChar = edgeArray.residueChar;
            smilesAtom.isBioAtom = edgeArray.isBioAtom;
            smilesAtom.isLeadAtom = edgeArray.isLeadAtom;
            smilesAtom.setAtomicMass(edgeArray.getAtomicMass());
            if (edgeArray.isAromatic()) {
                bS.set(n4);
            }
            if (!edgeArray.isFirst && n5 == 1 && n > 0) {
                bS2.set(n4);
            }
            edgeArray.setMatchingAtom(n4++);
            SmilesBond[] smilesBondArray = new SmilesBond[edgeArray.getBondCount() + n5];
            smilesAtom.setBonds(smilesBondArray);
            while (--n5 >= 0) {
                smilesAtomArray[n4] = new SmilesAtom().setAll(0, n4, 0, 1, 0);
                object = smilesAtomArray[n4];
                ++n4;
                ((SmilesAtom)object).setBonds(new SmilesBond[1]);
                SmilesBond smilesBond = new SmilesBond(smilesAtom, (SmilesAtom)object, 1, false);
                Logger.info("" + smilesBond);
            }
        }
        for (n2 = 0; n2 < this.ac; ++n2) {
            edgeArray = this.patternAtoms[n2];
            n = edgeArray.getMatchingAtom();
            SmilesAtom smilesAtom = smilesAtomArray[n];
            int n6 = edgeArray.getBondCount();
            for (int i = 0; i < n6; ++i) {
                Object object2;
                boolean bl;
                object = edgeArray.getBond(i);
                boolean bl2 = bl = ((SmilesBond)object).atom1 == edgeArray;
                if (bl) {
                    int n7 = 1;
                    switch (((SmilesBond)object).order) {
                        case 769: {
                            n7 = 33;
                            break;
                        }
                        case 1025: {
                            n7 = 97;
                            break;
                        }
                        case 257: {
                            n7 = 1025;
                            break;
                        }
                        case 513: {
                            n7 = 1041;
                            break;
                        }
                        case 96: 
                        case 112: {
                            n7 = ((SmilesBond)object).order;
                            break;
                        }
                        case 1: {
                            n7 = 1;
                            break;
                        }
                        case 17: {
                            n7 = 514;
                            break;
                        }
                        case 2: {
                            n7 = 2;
                            break;
                        }
                        case 3: {
                            n7 = 3;
                        }
                    }
                    object2 = smilesAtomArray[((SmilesBond)object).atom2.getMatchingAtom()];
                    SmilesBond smilesBond = new SmilesBond(smilesAtom, (SmilesAtom)object2, n7, false);
                    --((SmilesAtom)object2).bondCount;
                    Logger.info("" + smilesBond);
                    continue;
                }
                SmilesAtom smilesAtom2 = smilesAtomArray[((SmilesBond)object).atom1.getMatchingAtom()];
                object2 = smilesAtom2.getBondTo(smilesAtom);
                smilesAtom.addBond((SmilesBond)object2);
            }
        }
        n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            edgeArray = smilesAtomArray[n2].getEdges();
            Edge edge = edgeArray[0];
            edgeArray[0] = edgeArray[1];
            edgeArray[1] = edge;
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }

    public void setTop(SmilesSearch smilesSearch) {
        this.top = smilesSearch == null ? this : smilesSearch.getTop();
    }

    SmilesSearch getTop() {
        return this.top == this ? this : this.top.getTop();
    }

    void getSelections() {
        Map<String, Object> map = this.top.htNested;
        if (map == null || this.jmolAtoms.length == 0) {
            return;
        }
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            BS bS;
            String string = entry.getValue().toString();
            if (!string.startsWith("select")) continue;
            BS bS2 = bS = hashtable.containsKey(string) ? (BS)hashtable.get(string) : this.smartsAtoms[0].findAtomsLike(string.substring(6));
            if (bS == null) {
                bS = new BS();
            }
            hashtable.put(string, bS);
            entry.setValue(bS);
        }
    }
}

