/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.P4;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;

public class MarchingSquares {
    public static final int CONTOUR_POINT = -1;
    public static final int VERTEX_POINT = -2;
    public static final int EDGE_POINT = -3;
    VertexDataServer surfaceReader;
    VolumeData volumeData;
    private static final int nContourMax = 100;
    public static final int defaultContourCount = 9;
    private int nContourSegments;
    public int contourType;
    int thisContour = 0;
    private float valueMin;
    private float valueMax;
    final P3 pointA = new P3();
    final P3 pointB = new P3();
    private boolean contourFromZero = true;
    private float[] contoursDiscrete;
    public int contourVertexCount;
    ContourVertex[] contourVertexes = new ContourVertex[1000];
    float contourPlaneMinimumValue;
    float contourPlaneMaximumValue;
    public float[] contourValuesUsed;
    final P3 ptTemp = new P3();
    private int triangleCount = 0;
    private Triangle[] triangles = new Triangle[1000];
    Map<String, Integer> htPts = new Hashtable<String, Integer>();

    public MarchingSquares(VertexDataServer vertexDataServer, VolumeData volumeData, P4 p4, float[] fArray, int n, int n2, boolean bl) {
        this.surfaceReader = vertexDataServer;
        this.volumeData = volumeData;
        this.thisContour = n2;
        this.contoursDiscrete = fArray;
        this.contourFromZero = bl;
        if (fArray == null) {
            int n3 = 0;
            this.nContourSegments = (n == 0 ? 9 : n) + n3;
            if (this.nContourSegments > 100) {
                this.nContourSegments = 100;
            }
        } else {
            this.nContourSegments = n = fArray.length;
            this.contourFromZero = false;
        }
    }

    public void setMinMax(float f, float f2) {
        this.valueMin = f;
        this.valueMax = f2;
    }

    public int addContourVertex(P3 p3, float f) {
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])AU.doubleLength(this.contourVertexes);
        }
        int n = this.surfaceReader.addVertexCopy(p3, f, -2, true);
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(p3);
        return n;
    }

    public void setContourData(int n, float f) {
        this.contourVertexes[n].setValue(f);
    }

    float calcContourPoint(float f, float f2, float f3, P3 p3) {
        return this.volumeData.calculateFractionalPoint(f, this.pointA, this.pointB, f2, f3, p3);
    }

    public int addTriangle(int n, int n2, int n3, int n4, int n5) {
        if (this.triangleCount == this.triangles.length) {
            this.triangles = (Triangle[])AU.doubleLength(this.triangles);
        }
        this.triangles[this.triangleCount++] = new Triangle(n, n2, n3, n4, n5);
        return 0;
    }

    public int generateContourData(boolean bl, float f) {
        Logger.info("generateContours: " + this.nContourSegments + " segments");
        this.getVertexValues(bl);
        this.createContours(this.valueMin, this.valueMax, f);
        this.addAllTriangles();
        return this.contourVertexCount;
    }

    private void getVertexValues(boolean bl) {
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        for (int i = 0; i < this.contourVertexCount; ++i) {
            float f;
            ContourVertex contourVertex = this.contourVertexes[i];
            if (bl) {
                f = contourVertex.value;
            } else {
                f = this.volumeData.lookupInterpolatedVoxelValue(contourVertex, false);
                contourVertex.setValue(f);
            }
            if (f < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = f;
            }
            if (!(f > this.contourPlaneMaximumValue)) continue;
            this.contourPlaneMaximumValue = f;
        }
    }

    private boolean createContours(float f, float f2, float f3) {
        float f4;
        float f5 = f2 - f;
        this.contourValuesUsed = new float[this.nContourSegments];
        int n = this.triangleCount;
        while (--n >= 0) {
            this.triangles[n].check = 0;
        }
        float f6 = f4 = -3.4028235E38f;
        for (int i = 0; i < this.nContourSegments; ++i) {
            float f7 = this.contoursDiscrete != null ? this.contoursDiscrete[i] : (this.contourFromZero ? f + (float)i * 1.0f / (float)this.nContourSegments * f5 : (i == 0 ? -3.4028235E38f : (f6 = i == this.nContourSegments - 1 ? Float.MAX_VALUE : f + (float)(i - 1) * 1.0f / (float)(this.nContourSegments - 1) * f5)));
            if (this.contoursDiscrete == null && Math.abs(f6) < f3) {
                f6 = f6 < 0.0f ? -f3 : f3;
            }
            this.contourValuesUsed[i] = f6;
            Logger.info("#contour " + (i + 1) + " " + f6);
            this.htPts.clear();
            int n2 = this.triangleCount;
            while (--n2 >= 0) {
                if (!this.triangles[n2].isValid) continue;
                this.checkContour(this.triangles[n2], i, f6);
            }
            if (this.thisContour <= 0 || i + 1 != this.thisContour) continue;
            f4 = f6;
        }
        if (this.contoursDiscrete != null) {
            f4 = this.contoursDiscrete[0];
        }
        this.valueMin = this.contourValuesUsed[0];
        this.valueMax = this.contourValuesUsed.length == 0 ? this.valueMin : this.contourValuesUsed[this.contourValuesUsed.length - 1];
        return true;
    }

    private int intercept(Triangle triangle, int n, float f) {
        float f2;
        String string;
        int n2 = triangle.pts[n];
        int n3 = triangle.pts[(n + 1) % 3];
        if (n2 == Integer.MAX_VALUE || n3 == Integer.MAX_VALUE) {
            return -1;
        }
        String string2 = string = n2 < n3 ? n2 + "_" + n3 : n3 + "_" + n2;
        if (this.htPts.containsKey(string)) {
            return this.htPts.get(string);
        }
        float f3 = this.contourVertexes[n2].value;
        float f4 = this.contourVertexes[n3].value;
        int n4 = -1;
        if (f3 != f4 && (f2 = (f - f3) / (f4 - f3)) >= 0.0f && f2 <= 1.0f) {
            this.pointA.setT(this.contourVertexes[n2]);
            this.pointB.setT(this.contourVertexes[n3]);
            f = this.calcContourPoint(f, f3, f4, this.ptTemp);
            if (!Float.isNaN(f)) {
                n4 = this.addContourVertex(this.ptTemp, f);
                if (n4 < 0) {
                    return -1;
                }
                this.contourVertexes[n4].setValue(f);
            }
        }
        this.htPts.put(string, n4);
        return n4;
    }

    private void checkContour(Triangle triangle, int n, float f) {
        if (this.thisContour > 0 && n + 1 != this.thisContour) {
            return;
        }
        int n2 = this.intercept(triangle, 0, f);
        int n3 = this.intercept(triangle, 1, f);
        int n4 = this.intercept(triangle, 2, f);
        int[] nArray = triangle.pts;
        int n5 = 0;
        if (n2 >= 0) {
            ++n5;
        }
        if (n3 >= 0) {
            n5 += 2;
        }
        if (n4 >= 0) {
            n5 += 4;
        }
        switch (n5) {
            case 3: {
                this.addTriangle(nArray[0], n2, n3, 2 | triangle.check & 1, n);
                this.addTriangle(n2, nArray[1], n3, 4 | triangle.check & 3, n);
                this.addTriangle(nArray[0], n3, nArray[2], triangle.check & 6, n);
                break;
            }
            case 5: {
                this.addTriangle(nArray[0], n2, n4, 2 | triangle.check & 5, n);
                this.addTriangle(n2, nArray[1], n4, 4 | triangle.check & 1, n);
                this.addTriangle(n4, nArray[1], nArray[2], triangle.check & 6, n);
                break;
            }
            case 6: {
                this.addTriangle(nArray[0], nArray[1], n4, triangle.check & 5, n);
                this.addTriangle(n4, nArray[1], n3, 4 | triangle.check & 2, n);
                this.addTriangle(n4, n3, nArray[2], 1 | triangle.check & 6, n);
                break;
            }
            default: {
                return;
            }
        }
        triangle.isValid = false;
    }

    public float[] getMinMax() {
        return new float[]{this.valueMin, this.valueMax};
    }

    private void addAllTriangles() {
        for (int i = 0; i < this.triangleCount; ++i) {
            if (!this.triangles[i].isValid) continue;
            Triangle triangle = this.triangles[i];
            this.surfaceReader.addTriangleCheck(triangle.pts[0], triangle.pts[1], triangle.pts[2], triangle.check, triangle.contourIndex, false, -1);
        }
    }

    private class Triangle {
        protected int[] pts;
        protected int check;
        protected boolean isValid = true;
        protected int contourIndex;

        Triangle(int n, int n2, int n3, int n4, int n5) {
            this.pts = new int[]{n, n2, n3};
            this.check = n4;
            this.contourIndex = n5;
        }
    }

    private class ContourVertex
    extends P3 {
        float value;

        ContourVertex(P3 p3) {
            this.setT(p3);
        }

        void setValue(float f) {
            this.value = f;
        }
    }
}

