/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.JSONEncodable;
import javajs.util.PT;
import javajs.util.SB;

public class BS
implements Cloneable,
JSONEncodable {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int WORD_MASK = -1;
    private int[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final int[] emptyBitmap = new int[0];

    private static int wordIndex(int n) {
        return n >> 5;
    }

    private void recalculateWordsInUse() {
        int n;
        for (n = this.wordsInUse - 1; n >= 0 && this.words[n] == 0; --n) {
        }
        this.wordsInUse = n + 1;
    }

    public BS() {
        this.initWords(32);
        this.sizeIsSticky = false;
    }

    public static BS newN(int n) {
        BS bS = new BS();
        bS.init(n);
        return bS;
    }

    private void init(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.initWords(n);
        this.sizeIsSticky = true;
    }

    private void initWords(int n) {
        this.words = new int[BS.wordIndex(n - 1) + 1];
    }

    private void ensureCapacity(int n) {
        if (this.words.length < n) {
            int n2 = Math.max(2 * this.words.length, n);
            this.setLength(n2);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n) {
        int n2 = n + 1;
        if (this.wordsInUse < n2) {
            this.ensureCapacity(n2);
            this.wordsInUse = n2;
        }
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] | 1 << n;
    }

    public void setBitTo(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void setBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BS.wordIndex(n);
        int n4 = BS.wordIndex(n2 - 1);
        this.expandTo(n4);
        int n5 = -1 << n;
        int n6 = -1 >>> -n2;
        if (n3 == n4) {
            int n7 = n3;
            this.words[n7] = this.words[n7] | n5 & n6;
        } else {
            int n8 = n3;
            this.words[n8] = this.words[n8] | n5;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = -1;
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] | n6;
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return;
        }
        int n3 = n2;
        this.words[n3] = this.words[n3] & ~(1 << n);
        this.recalculateWordsInUse();
    }

    public void clearBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BS.wordIndex(n);
        if (n3 >= this.wordsInUse) {
            return;
        }
        int n4 = BS.wordIndex(n2 - 1);
        if (n4 >= this.wordsInUse) {
            n2 = this.length();
            n4 = this.wordsInUse - 1;
        }
        int n5 = -1 << n;
        int n6 = -1 >>> -n2;
        if (n3 == n4) {
            int n7 = n3;
            this.words[n7] = this.words[n7] & ~(n5 & n6);
        } else {
            int n8 = n3;
            this.words[n8] = this.words[n8] & ~n5;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = 0;
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] & ~n6;
        }
        this.recalculateWordsInUse();
    }

    public void clearAll() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        return n2 < this.wordsInUse && (this.words[n2] & 1 << n) != 0;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return -1;
        }
        int n3 = this.words[n2] & -1 << n;
        while (n3 == 0) {
            if (++n2 == this.wordsInUse) {
                return -1;
            }
            n3 = this.words[n2];
        }
        return n2 * 32 + Integer.numberOfTrailingZeros(n3);
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return n;
        }
        int n3 = ~this.words[n2] & -1 << n;
        while (n3 == 0) {
            if (++n2 == this.wordsInUse) {
                return this.wordsInUse * 32;
            }
            n3 = ~this.words[n2];
        }
        return n2 * 32 + Integer.numberOfTrailingZeros(n3);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 32 * (this.wordsInUse - 1) + (32 - Integer.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BS bS) {
        for (int i = Math.min(this.wordsInUse, bS.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & bS.words[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            n += Integer.bitCount(this.words[i]);
        }
        return n;
    }

    public void and(BS bS) {
        if (this == bS) {
            return;
        }
        while (this.wordsInUse > bS.wordsInUse) {
            this.words[--this.wordsInUse] = 0;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & bS.words[i];
        }
        this.recalculateWordsInUse();
    }

    public void or(BS bS) {
        if (this == bS) {
            return;
        }
        int n = Math.min(this.wordsInUse, bS.wordsInUse);
        if (this.wordsInUse < bS.wordsInUse) {
            this.ensureCapacity(bS.wordsInUse);
            this.wordsInUse = bS.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] | bS.words[i];
        }
        if (n < bS.wordsInUse) {
            System.arraycopy(bS.words, n, this.words, n, this.wordsInUse - n);
        }
    }

    public void xor(BS bS) {
        int n = Math.min(this.wordsInUse, bS.wordsInUse);
        if (this.wordsInUse < bS.wordsInUse) {
            this.ensureCapacity(bS.wordsInUse);
            this.wordsInUse = bS.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] ^ bS.words[i];
        }
        if (n < bS.wordsInUse) {
            System.arraycopy(bS.words, n, this.words, n, bS.wordsInUse - n);
        }
        this.recalculateWordsInUse();
    }

    public void andNot(BS bS) {
        for (int i = Math.min(this.wordsInUse, bS.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & ~bS.words[i];
        }
        this.recalculateWordsInUse();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.wordsInUse;
        while (--n >= 0) {
            l ^= (long)(this.words[n] * (n + 1));
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 32;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BS)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BS bS = (BS)object;
        if (this.wordsInUse != bS.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == bS.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky && this.wordsInUse != this.words.length) {
            this.setLength(this.wordsInUse);
        }
        return BS.copy(this);
    }

    private void setLength(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.words, 0, nArray, 0, Math.min(this.wordsInUse, n));
        this.words = nArray;
    }

    public String toString() {
        return BS.escape(this, '{', '}');
    }

    public static BS copy(BS bS) {
        BS bS2 = new BS();
        int n = bS.wordsInUse;
        if (n == 0) {
            bS2.words = emptyBitmap;
        } else {
            bS2.wordsInUse = n;
            bS2.words = new int[bS2.wordsInUse];
            System.arraycopy(bS.words, 0, bS2.words, 0, n);
        }
        return bS2;
    }

    public int cardinalityN(int n) {
        int n2 = this.cardinality();
        int n3 = this.length();
        while (--n3 >= n) {
            if (!this.get(n3)) continue;
            --n2;
        }
        return n2;
    }

    @Override
    public String toJSON() {
        int n = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 32;
        SB sB = SB.newN(6 * n + 2);
        sB.appendC('[');
        int n2 = this.nextSetBit(0);
        if (n2 != -1) {
            sB.appendI(n2);
            n2 = this.nextSetBit(n2 + 1);
            while (n2 >= 0) {
                int n3 = this.nextClearBit(n2);
                do {
                    sB.append(", ").appendI(n2);
                } while (++n2 < n3);
                n2 = this.nextSetBit(n2 + 1);
            }
        }
        sB.appendC(']');
        return sB.toString();
    }

    public static String escape(BS bS, char c, char c2) {
        if (bS == null) {
            return c + "{}" + c2;
        }
        SB sB = new SB();
        sB.append(c + "{");
        int n = bS.length();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl = bS.get(n4);
            if (n4 == n || n2 >= 0 && !bl) {
                if (n2 >= 0 && n3 != n2) {
                    sB.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bS.get(n4)) continue;
            if (n2 < 0) {
                sB.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        sB.append("}").appendC(c2);
        return sB.toString();
    }

    public static BS unescape(String string) {
        char c;
        int n;
        if (string == null || (n = (string = string.trim()).length()) < 4 || string.equalsIgnoreCase("({null})") || (c = string.charAt(0)) != '(' && c != '[' || string.charAt(n - 1) != (c == '(' ? (char)')' : ']') || string.charAt(1) != '{' || string.indexOf(125) != n - 2) {
            return null;
        }
        int n2 = n -= 2;
        while (--n2 >= 2) {
            c = string.charAt(n2);
            if (PT.isDigit(c) || c == ' ' || c == '\t' || c == ':') continue;
            return null;
        }
        n2 = n;
        while (PT.isDigit(string.charAt(--n2))) {
        }
        if (++n2 == n) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        BS bS = BS.newN(n2);
        n2 = -1;
        int n3 = -1;
        int n4 = -2;
        block8: for (int i = 2; i <= n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '}': {
                    if (n4 < 0) continue block8;
                    if (n4 < n2) {
                        return null;
                    }
                    n2 = n4;
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    bS.setBits(n3, n4 + 1);
                    n3 = -1;
                    n4 = -2;
                    continue block8;
                }
                case ':': {
                    n3 = n2 = n4;
                    n4 = -2;
                    continue block8;
                }
                default: {
                    if (!PT.isDigit(c)) continue block8;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n4 = n4 * 10 + (c - 48);
                }
            }
        }
        return n3 >= 0 ? null : bS;
    }
}

