/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.quantum.QS;
import org.jmol.shape.Shape;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.Escape;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency;
    private Float moTranslucentLevel;
    private P4 moPlane;
    private Float moCutoff;
    private Float moResolution;
    private Float moScale;
    private Integer moColorPos;
    private Integer moColorNeg;
    private Integer moMonteCarloCount;
    private boolean moIsPositiveOnly;
    private Boolean moSquareData;
    private Boolean moSquareLinear;
    private Integer moRandomSeed;
    private int moFill = 1073742046;
    private int moMesh = 1073742018;
    private int moDots = 1073742042;
    private int moFrontOnly = 0x40000088;
    private String moTitleFormat;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private float[] moLinearCombination;
    private Map<String, Map<String, Object>> htModels;
    private Map<String, Object> thisModel;
    private Lst<Object> moSlab;
    private Integer moSlabValue;
    private String nboType;

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "mo";
        this.setPropI("thisID", this.myType, null);
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.myColorPt = 0;
            this.moDebug = false;
            int n = (Integer)object;
            this.strID = this.getId(n);
            this.setPropI("init", null, null);
            this.setPropI("modelIndex", n, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable<String, Map<String, Object>>();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
            this.moSquareLinear = null;
            this.moSquareData = null;
            return;
        }
        if ("slab" == string) {
            if (object instanceof Integer) {
                this.thisModel.put("slabValue", object);
            } else {
                Object[] objectArray = (Object[])object;
                int n = (Integer)objectArray[0];
                this.moSlab = (Lst)this.thisModel.get("slab");
                if (this.moSlab == null) {
                    this.moSlab = new Lst();
                    this.thisModel.put("slab", this.moSlab);
                }
                if (n == 0x10000B) {
                    this.moSlab = null;
                    this.thisModel.remove("slab");
                    return;
                }
                this.moSlab.addLast(object);
            }
            return;
        }
        if ("cutoff" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == string) {
            this.thisModel.put("moScale", object);
            return;
        }
        if ("squareData" == string) {
            this.thisModel.put("moSquareData", Boolean.TRUE);
            this.moSquareData = Boolean.TRUE;
            return;
        }
        if ("squareLinear" == string) {
            this.thisModel.put("moSquareLinear", Boolean.TRUE);
            this.moSquareLinear = Boolean.TRUE;
            return;
        }
        if ("cutoffPositive" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == string) {
            this.thisModel.put("moResolution", object);
            return;
        }
        if ("titleFormat" == string) {
            this.moTitleFormat = (String)object;
            return;
        }
        if ("color" == string) {
            if (!(object instanceof Integer)) {
                return;
            }
            this.thisModel.remove("moTranslucency");
            this.setPropI("color", object, bS);
            string = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == string) {
            this.moColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == string) {
            if (object == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", object);
            }
            return;
        }
        if ("monteCarloCount" == string) {
            this.thisModel.put("monteCarloCount", object);
            return;
        }
        if ("randomSeed" == string) {
            if (object == null) {
                this.thisModel.remove("randomSeed");
            } else {
                this.thisModel.put("randomSeed", object);
            }
            return;
        }
        if ("molecularOrbital" == string) {
            if (object instanceof Integer) {
                this.moNumber = (Integer)object;
                this.thisModel.put("moNumber", object);
                this.thisModel.remove("moLinearCombination");
                this.moLinearCombination = null;
            } else {
                this.moNumber = 0;
                this.moLinearCombination = (float[])object;
                this.thisModel.put("moNumber", 0);
                this.thisModel.put("moLinearCombination", this.moLinearCombination);
            }
            if (this.moSquareData == Boolean.TRUE) {
                this.thisModel.put("moSquareData", Boolean.TRUE);
            } else {
                this.thisModel.remove("moSquareData");
            }
            if (this.moSquareLinear == Boolean.TRUE) {
                this.thisModel.put("moSquareLinear", Boolean.TRUE);
            } else {
                this.thisModel.remove("moSquareLinear");
            }
            this.setOrbital(this.moNumber, this.moLinearCombination);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                if (this.meshes[n2] == null) continue;
                if (this.meshes[n2].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n2] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])AU.deleteElements((Object)this.meshes, (int)n2, (int)1);
                    continue;
                }
                Map<String, Object> map = this.htModels.get(this.meshes[n2].thisID);
                if (this.meshes[n2].modelIndex > n) {
                    --this.meshes[n2].modelIndex;
                    this.meshes[n2].thisID = this.getId(this.meshes[n2].modelIndex);
                }
                hashtable.put(this.meshes[n2].thisID, map);
            }
            this.htModels = hashtable;
            return;
        }
        if ("moData" == string) {
            Map map = (Map)object;
            this.nboType = (String)map.get("nboType");
            if (this.nboType == null) {
                this.thisModel.remove("nboType");
            } else {
                this.thisModel.put("nboType", this.nboType);
            }
        } else if ("translucentLevel" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", object);
        } else if ("delete" == string) {
            this.htModels.remove(this.strID);
            this.moNumber = 0;
            this.moLinearCombination = null;
        } else if ("token" == string) {
            int n = (Integer)object;
            switch (n) {
                case 1073742042: 
                case 1113198595: {
                    this.moDots = n;
                    break;
                }
                case 1073741938: 
                case 1073742046: {
                    this.moFill = n;
                    break;
                }
                case 1073742018: 
                case 0x400000E4: {
                    this.moMesh = n;
                    break;
                }
                case 0x40000088: 
                case 1073742058: {
                    this.moFrontOnly = n;
                }
            }
        } else if ("translucency" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", object);
        }
        this.setPropI(string, object, bS);
    }

    private String getId(int n) {
        return "mo_model" + this.vwr.getModelNumberDotted(n);
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string.startsWith("list")) {
            String string2 = "";
            if (string.equals("list")) {
                string2 = (String)this.getPropI("list");
                if (string2.length() > 1) {
                    string2 = string2 + "cutoff = " + this.jvxlData.cutoff + "\n";
                }
                string2 = "\n" + string2;
            }
            return this.getMoInfo(-1) + string2;
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (string == "showMO") {
            int n2;
            boolean bl;
            boolean bl2;
            SB sB = new SB();
            Lst lst = (Lst)this.sg.params.moData.get("mos");
            int n3 = lst == null ? 0 : lst.size();
            int n4 = n;
            int n5 = this.moNumber;
            boolean bl3 = bl2 = n4 == Integer.MIN_VALUE;
            if (n4 == Integer.MAX_VALUE) {
                n4 = n5;
            }
            if (n3 == 0 || bl2 && n5 == 0) {
                return "";
            }
            boolean bl4 = bl = n4 != 0;
            if (n5 == 0) {
                n4 = 0;
            }
            boolean bl5 = false;
            int n6 = n4 > 0 ? 1 : n3;
            for (int i = n2 = n6 == 1 && n5 > 0 ? n5 : 1; i <= n3; ++i) {
                if (n4 != 0 && n4 != i && (bl || i != n5)) continue;
                if (!bl) {
                    this.setPropI("init", this.sg.params, null);
                    this.setOrbital(i, null);
                }
                this.jvxlData.moleculeXml = this.vwr.getModelCml(this.vwr.getModelUndeletedAtomsBitSet(this.thisMesh.modelIndex), 100, true);
                if (!bl5) {
                    sB.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "HEADERONLY", true, n6, null, null));
                    bl5 = true;
                }
                sB.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, this.jvxlData.title, null, false, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand));
                if (!bl) {
                    this.setPropI("delete", "mo_show", null);
                }
                if (n6 == 1) break;
            }
            sB.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "TRAILERONLY", true, 0, null, null));
            return sB.toString();
        }
        return this.getPropI(string);
    }

    public String getMoInfo(int n) {
        SB sB = new SB();
        int n2 = this.vwr.ms.mc;
        for (int i = 0; i < n2; ++i) {
            int n3;
            Map map;
            if (n >= 0 && i != n || (map = (Map)this.vwr.ms.getInfo(i, "moData")) == null) continue;
            Lst lst = (Lst)map.get("mos");
            int n4 = n3 = lst == null ? 0 : lst.size();
            if (n3 == 0) continue;
            String string = (String)map.get("nboType");
            if (string == null) {
                string = "mo";
            }
            int n5 = n3;
            while (--n5 >= 0) {
                String string2;
                String string3;
                Float f;
                String string4;
                Map map2 = (Map)lst.get(n5);
                String string5 = (String)map2.get("type");
                if (string5 == null) {
                    string5 = "";
                }
                if ((string4 = (String)map2.get("energyUnits")) == null) {
                    string4 = "";
                }
                if ((f = (Float)map2.get("occupancy")) != null) {
                    string5 = "occupancy " + f.floatValue() + " " + string5;
                }
                if ((string3 = (String)map2.get("symmetry")) != null) {
                    string5 = string5 + string3;
                }
                if (Float.isNaN(PT.parseFloat((String)(string2 = "" + map2.get("energy"))))) {
                    sB.append(PT.sprintf((String)"model %-2s; %s %-2i # %s\n", (String)"ssis", (Object[])new Object[]{this.vwr.ms.getModelNumberDotted(i), string, n5 + 1, string5}));
                    continue;
                }
                sB.append(PT.sprintf((String)"model %-2s;  %s %-2i # energy %-8.3f %s %s\n", (String)"ssifss", (Object[])new Object[]{this.vwr.ms.getModelNumberDotted(i), string, n5 + 1, map2.get("energy"), string4, string5}));
            }
        }
        return sB.toString();
    }

    @Override
    protected void clearSg() {
    }

    private boolean getSettings(String string) {
        this.thisModel = this.htModels.get(string);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (P4)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.params.moData.get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = Float.valueOf(0.05f);
        }
        this.thisModel.put("moCutoff", Float.valueOf(this.moCutoff.floatValue()));
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.nboType = (String)this.thisModel.get("moType");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moSquareData = (Boolean)this.thisModel.get("moSquareData");
        this.moSquareLinear = (Boolean)this.thisModel.get("moSquareLinear");
        this.moMonteCarloCount = (Integer)this.thisModel.get("monteCarloCount");
        this.moRandomSeed = (Integer)this.thisModel.get("randomSeed");
        this.moSlabValue = (Integer)this.thisModel.get("slabValue");
        this.moSlab = (Lst)this.thisModel.get("slab");
        if (this.moRandomSeed == null) {
            this.moRandomSeed = (int)(-System.currentTimeMillis()) % 10000;
            this.thisModel.put("randomSeed", this.moRandomSeed);
        }
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
        Object object = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = object != null && (Boolean)object != false;
        return true;
    }

    private void setOrbital(int n, float[] fArray) {
        this.setPropI("reset", this.strID, null);
        if (this.moDebug) {
            this.setPropI("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            this.setPropI("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            this.setPropI("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            this.setPropI("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                this.setPropI("red", Float.valueOf(-this.moCutoff.floatValue()), null);
                this.setPropI("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                this.setPropI(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                this.setPropI("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                this.setPropI("colorRGB", this.moColorPos, null);
            }
            if (this.moMonteCarloCount != null) {
                this.setPropI("randomSeed", this.moRandomSeed, null);
                this.setPropI("monteCarloCount", this.moMonteCarloCount, null);
            }
        }
        this.setPropI("squareData", this.moSquareData, null);
        this.setPropI("squareLinear", this.moSquareLinear, null);
        this.setPropI("title", this.moTitleFormat, null);
        this.setPropI("fileName", this.vwr.fm.getFileName(), null);
        this.setPropI("molecularOrbital", fArray == null ? (Object)n : fArray, null);
        if (this.moPlane != null && this.moColorNeg != null) {
            this.setPropI("colorRGB", this.moColorNeg, null);
        }
        if (this.moPlane != null && this.moColorPos != null) {
            this.setPropI("colorRGB", this.moColorPos, null);
        }
        this.currentMesh.isColorSolid = false;
        if (this.moSlabValue != null) {
            this.setPropI("slab", this.moSlabValue, null);
        }
        if (this.moSlab != null) {
            for (int i = 0; i < this.moSlab.size(); ++i) {
                this.setPropI("slab", this.moSlab.get(i), null);
            }
        }
        if (this.moTranslucentLevel != null) {
            this.setPropI("translucentLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            this.setPropI("translucency", this.moTranslucency, null);
        }
        this.setPropI("token", this.moFill, null);
        this.setPropI("token", this.moMesh, null);
        this.setPropI("token", this.moDots, null);
        this.setPropI("token", this.moFrontOnly, null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    @Override
    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        SB sB = new SB();
        int n = this.vwr.ms.mc;
        for (int i = 0; i < n; ++i) {
            if (!this.getSettings(this.getId(i))) continue;
            if (n > 1) {
                MolecularOrbital.appendCmd((SB)sB, (String)("frame " + this.vwr.getModelNumberDotted(i)));
            }
            if (this.nboType != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)("nbo type " + this.nboType));
            }
            if (this.moCutoff != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " cutoff " + (this.sg.params.isPositiveOnly ? "+" : "") + this.moCutoff));
            }
            if (this.moScale != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " scale " + this.moScale));
            }
            if (this.moMonteCarloCount != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " points " + this.moMonteCarloCount + " " + this.moRandomSeed));
            }
            if (this.moResolution != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " resolution " + this.moResolution));
            }
            if (this.moPlane != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}"));
            }
            if (this.moTitleFormat != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " titleFormat " + PT.esc((String)this.moTitleFormat)));
            }
            if (this.moColorNeg != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " color " + Escape.escapeColor((int)this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor((int)this.moColorPos))));
            }
            if (this.moSlab != null) {
                if (this.thisMesh.slabOptions != null) {
                    MolecularOrbital.appendCmd((SB)sB, (String)this.thisMesh.slabOptions.toString());
                }
                if (this.thisMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
                    MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " slab " + this.thisMesh.jvxlData.slabValue));
                }
            }
            if (this.moLinearCombination == null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " " + (this.moSquareData == Boolean.TRUE ? "squared " : "") + this.moNumber));
            } else {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " " + QS.getMOString((float[])this.moLinearCombination) + (this.moSquareLinear == Boolean.TRUE ? " squared" : "")));
            }
            if (this.moTranslucency != null) {
                MolecularOrbital.appendCmd((SB)sB, (String)(this.myType + " translucent " + this.moTranslucentLevel));
            }
            MolecularOrbital.appendCmd((SB)sB, (String)((IsosurfaceMesh)((Object)this.thisModel.get("mesh"))).getState(this.myType));
        }
        return sB.toString();
    }

    @Override
    public void merge(Shape shape) {
        Map<String, Map<String, Object>> map;
        MolecularOrbital molecularOrbital = (MolecularOrbital)shape;
        this.moColorNeg = molecularOrbital.moColorNeg;
        this.moColorPos = molecularOrbital.moColorPos;
        this.moCutoff = molecularOrbital.moCutoff;
        this.moPlane = molecularOrbital.moPlane;
        this.moResolution = molecularOrbital.moResolution;
        this.moScale = molecularOrbital.moScale;
        this.moSlab = molecularOrbital.moSlab;
        this.moSlabValue = molecularOrbital.moSlabValue;
        this.moTitleFormat = molecularOrbital.moTitleFormat;
        this.moTranslucency = molecularOrbital.moTranslucency;
        if (this.htModels == null) {
            this.htModels = new Hashtable<String, Map<String, Object>>();
        }
        if ((map = molecularOrbital.htModels) != null) {
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                this.htModels.put(string, entry.getValue());
            }
        }
        super.merge(shape);
    }
}

