/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class VaspPoscarReader
extends AtomSetCollectionReader {
    private Lst<String> atomLabels = new Lst();
    private int ac;

    protected void initializeReader() throws Exception {
        this.readJobTitle();
        this.readUnitCellVectors();
        this.readMolecularFormula();
        this.readCoordinates();
        this.continuing = false;
    }

    private void readJobTitle() throws Exception {
        this.asc.setAtomSetName(this.rd().trim());
    }

    private void readUnitCellVectors() throws Exception {
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        float f = this.parseFloatStr(this.rd().trim());
        float[] fArray = new float[9];
        this.fillFloatArray(null, 0, fArray);
        if (f != 1.0f) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
        this.addPrimitiveLatticeVector(0, fArray, 0);
        this.addPrimitiveLatticeVector(1, fArray, 3);
        this.addPrimitiveLatticeVector(2, fArray, 6);
    }

    private void readMolecularFormula() throws Exception {
        String[] stringArray = PT.getTokens((String)this.discardLinesUntilNonBlank());
        String[] stringArray2 = PT.getTokens((String)this.rd());
        SB sB = new SB();
        for (int i = 0; i < stringArray2.length; ++i) {
            int n = Integer.parseInt(stringArray2[i]);
            this.ac += n;
            String string = stringArray[i];
            sB.append(" ").append(string).appendI(n);
            int n2 = n;
            while (--n2 >= 0) {
                this.atomLabels.addLast((Object)string);
            }
        }
        String string = sB.toString();
        Logger.info((String)("VaspPoscar reader: " + this.ac + " atoms identified for" + string));
        this.appendLoadNote(string);
        this.asc.newAtomSet();
        this.asc.setAtomSetName(string);
    }

    private void readCoordinates() throws Exception {
        if (this.discardLinesUntilNonBlank().toLowerCase().contains("selective")) {
            this.rd();
        }
        if (this.line.toLowerCase().contains("cartesian")) {
            this.setFractionalCoordinates(false);
        }
        for (int i = 0; i < this.ac; ++i) {
            this.addAtomXYZSymName(PT.getTokens((String)this.rd()), 0, null, (String)this.atomLabels.get(i));
        }
    }
}

