/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    public float vOcc = Float.NaN;
    public Map<String, Float> htUij;
    public float vOcc0;
    String id;
    private Lst<Modulation> mods;
    private int iop;
    private P3 r0;
    public Vibration vib;
    public V3 mxyz;
    private SymmetryInterface symmetry;
    private M3 gammaE;
    private Matrix gammaIinv;
    private Matrix sigma;
    private Matrix tau;
    private boolean enabled;
    private float scale = 1.0f;
    private P3 qtOffset = new P3();
    private boolean isQ;
    private Matrix rI;
    private ModulationSet modTemp;
    private String strop;
    private boolean isSubsystem;
    private Matrix tFactorInv;
    private Matrix rsvs;
    private float spinOp;
    P3 ptTemp = new P3();
    private V3 v0;
    private float[] axesLengths;

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ModulationSet setMod(String string, P3 p3, P3 p32, int n, Lst<Modulation> lst, M3 m3, Matrix[] matrixArray, int n2, SymmetryInterface symmetryInterface, Vibration vibration) {
        this.id = string + "_" + symmetryInterface.getSpaceGroupName();
        this.strop = symmetryInterface.getSpaceGroupXyz(n2, false);
        this.r0 = p32;
        this.modDim = n;
        this.rI = new Matrix(null, n, 1);
        this.mods = lst;
        this.iop = n2;
        this.symmetry = symmetryInterface;
        this.gammaE = m3;
        this.sigma = matrixArray[0];
        if (matrixArray[1] != null) {
            this.isSubsystem = true;
            this.tFactorInv = matrixArray[1].inverse();
        }
        if (vibration != null) {
            this.vib = vibration;
            this.vib.modScale = 1.0f;
            this.mxyz = new V3();
        }
        Matrix matrix = Matrix.newT(p3, true);
        Matrix matrix2 = Matrix.newT(p32, true);
        this.rsvs = symmetryInterface.getOperationRsVs(n2);
        this.gammaIinv = this.rsvs.getSubmatrix(3, 3, n, n).inverse();
        Matrix matrix3 = this.rsvs.getSubmatrix(3, 0, n, 3);
        Matrix matrix4 = this.rsvs.getSubmatrix(3, 3 + n, n, 1);
        this.spinOp = symmetryInterface.getSpinOp(n2);
        System.out.println("spinOp " + n2 + " " + this.strop + " " + this.spinOp);
        this.tau = this.gammaIinv.mul(this.sigma.mul(matrix2).sub(matrix3.mul(matrix)).sub(matrix4));
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create " + string + " r0=" + Escape.eP(p32) + " tau=" + this.tau);
        }
        return this;
    }

    @Override
    public SymmetryInterface getSubSystemUnitCell() {
        return this.isSubsystem ? this.symmetry : null;
    }

    public synchronized ModulationSet calculate(T3 t3, boolean bl) {
        double[][] dArray;
        Object object;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        if (this.mxyz != null) {
            this.mxyz.set(0.0f, 0.0f, 0.0f);
        }
        if (bl && this.qtOffset != null) {
            object = new Matrix(null, 3, 1);
            dArray = ((Matrix)object).getArray();
            dArray[0][0] = this.qtOffset.x;
            dArray[1][0] = this.qtOffset.y;
            dArray[2][0] = this.qtOffset.z;
            this.rI = this.sigma.mul((Matrix)object);
            dArray = this.rI.getArray();
        } else {
            dArray = this.rI.getArray();
            for (int i = 0; i < this.modDim; ++i) {
                dArray[i][0] = 0.0;
            }
        }
        if (t3 != null) {
            switch (this.modDim) {
                default: {
                    double[] dArray2 = dArray[2];
                    dArray2[0] = dArray2[0] + (double)t3.z;
                }
                case 2: {
                    double[] dArray3 = dArray[1];
                    dArray3[0] = dArray3[0] + (double)t3.y;
                }
                case 1: 
            }
            double[] dArray4 = dArray[0];
            dArray4[0] = dArray4[0] + (double)t3.x;
        }
        if (this.isSubsystem) {
            this.rI = this.tFactorInv.mul(this.rI);
        }
        this.rI = this.tau.add(this.gammaIinv.mul(this.rI));
        object = this.rI.getArray();
        int n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, (double[][])object);
        }
        this.gammaE.rotate(this);
        if (this.mxyz != null) {
            this.gammaE.rotate(this.mxyz);
            if (this.spinOp < 0.0f) {
                this.mxyz.scale(this.spinOp);
            }
        }
        return this;
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    @Override
    public synchronized void setModTQ(T3 t3, boolean bl, T3 t32, boolean bl2, float f) {
        if (this.enabled) {
            this.addTo(t3, Float.NaN);
        }
        this.enabled = false;
        this.scale = f;
        if (t32 != null) {
            this.qtOffset.setT(t32);
            this.isQ = bl2;
            if (bl2) {
                t32 = null;
            }
            this.calculate(t32, bl2);
        }
        if (bl) {
            this.addTo(t3, 1.0f);
            this.enabled = true;
        }
    }

    @Override
    public void addTo(T3 t3, float f) {
        boolean bl = Float.isNaN(f);
        if (bl) {
            f = -1.0f;
        }
        this.ptTemp.setT(this);
        this.ptTemp.scale(this.scale * f);
        if (t3 != null) {
            this.symmetry.toCartesian(this.ptTemp, true);
            t3.add(this.ptTemp);
        }
        if (this.mxyz != null) {
            this.setVib(bl);
        }
    }

    private void setVib(boolean bl) {
        this.vib.setT(this.v0);
        if (bl) {
            return;
        }
        this.ptTemp.setT(this.mxyz);
        this.ptTemp.scale(this.scale * this.scale);
        this.symmetry.toCartesian(this.ptTemp, true);
        PT.fixPtFloats(this.ptTemp, 10000.0f);
        this.ptTemp.scale(this.vib.modScale);
        this.vib.add(this.ptTemp);
    }

    @Override
    public String getState() {
        String string = "";
        if (this.qtOffset != null && this.qtOffset.length() > 0.0f) {
            string = string + "; modulation " + Escape.eP(this.qtOffset) + " " + this.isQ + ";\n";
        }
        string = string + "modulation {selected} " + (this.enabled ? "ON" : "OFF");
        return string;
    }

    @Override
    public T3 getModPoint(boolean bl) {
        return bl ? this : this.r0;
    }

    @Override
    public Object getModulation(char c, T3 t3) {
        this.getModTemp();
        switch (c) {
            case 'D': {
                return P3.newP(t3 == null ? this.r0 : this.modTemp.calculate(t3, false));
            }
            case 'M': {
                return P3.newP(t3 == null ? this.v0 : this.modTemp.calculate((T3)t3, (boolean)false).mxyz);
            }
            case 'T': {
                this.modTemp.calculate(t3, false);
                double[][] dArray = this.modTemp.rI.getArray();
                return P3.new3((float)dArray[0][0], this.modDim > 1 ? (float)dArray[1][0] : 0.0f, this.modDim > 2 ? (float)dArray[2][0] : 0.0f);
            }
            case 'O': {
                return Float.valueOf((t3 == null ? this.vOcc : this.modTemp.calculate((T3)t3, (boolean)false).vOcc) * 100.0f);
            }
        }
        return null;
    }

    @Override
    public void setTempPoint(T3 t3, T3 t32, float f, float f2) {
        if (!this.enabled) {
            return;
        }
        this.getModTemp();
        this.addTo(t3, Float.NaN);
        this.modTemp.calculate(t32, false).addTo(t3, f2);
    }

    private void getModTemp() {
        if (this.modTemp == null) {
            this.modTemp = new ModulationSet();
            this.modTemp.id = this.id;
            this.modTemp.tau = this.tau;
            this.modTemp.spinOp = this.spinOp;
            this.modTemp.mods = this.mods;
            this.modTemp.gammaE = this.gammaE;
            this.modTemp.modDim = this.modDim;
            this.modTemp.gammaIinv = this.gammaIinv;
            this.modTemp.sigma = this.sigma;
            this.modTemp.r0 = this.r0;
            this.modTemp.v0 = this.v0;
            this.modTemp.vib = this.vib;
            this.modTemp.symmetry = this.symmetry;
            this.modTemp.rI = this.rI;
            if (this.mxyz != null) {
                this.modTemp.mxyz = new V3();
            }
        }
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.id);
        hashtable.put("r0", this.r0);
        hashtable.put("tau", this.tau.getArray());
        hashtable.put("modDim", this.modDim);
        hashtable.put("rsvs", this.rsvs);
        hashtable.put("sigma", this.sigma.getArray());
        hashtable.put("symop", this.iop + 1);
        hashtable.put("strop", this.strop);
        hashtable.put("unitcell", this.symmetry.getUnitCellInfo());
        Lst<Hashtable<String, Object>> lst = new Lst<Hashtable<String, Object>>();
        for (int i = 0; i < this.mods.size(); ++i) {
            lst.addLast(((Modulation)this.mods.get(i)).getInfo());
        }
        hashtable.put("mods", lst);
        map.put("modulation", hashtable);
    }

    @Override
    public void setXYZ(T3 t3) {
        if (this.vib == null) {
            return;
        }
        if (this.vib.modDim == -2 && t3.x == Float.MIN_VALUE && t3.y == Float.MIN_VALUE) {
            this.vib.modScale = t3.z;
            return;
        }
        this.vib.setT(t3);
    }

    @Override
    public Vibration getVibration(boolean bl) {
        if (this.vib == null && bl) {
            this.vib = new Vibration();
        }
        return this.vib;
    }

    @Override
    public V3 getV3() {
        return this.mxyz == null ? this : this.mxyz;
    }

    @Override
    public void scaleVibration(float f) {
        if (this.vib != null) {
            this.vib.scale(f);
        }
        this.vib.modScale *= f;
    }

    @Override
    public void setMoment() {
        if (this.mxyz == null) {
            return;
        }
        this.symmetry.toCartesian(this.vib, true);
        this.v0 = V3.newV(this.vib);
    }

    @Override
    public boolean isNonzero() {
        return this.x != 0.0f || this.y != 0.0f || this.z != 0.0f || this.mxyz != null && (this.mxyz.x != 0.0f || this.mxyz.y != 0.0f || this.mxyz.z != 0.0f);
    }

    float[] getAxesLengths() {
        return this.axesLengths == null ? (this.axesLengths = this.symmetry.getNotionalUnitCell()) : this.axesLengths;
    }
}

