/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.GData;
import org.jmol.util.Rgb16;

public class TriangleRenderer
implements G3DRenderer {
    private Graphics3D g3d;
    private static final int DEFAULT = 64;
    private int[] ax = new int[3];
    private int[] ay = new int[3];
    private int[] az = new int[3];
    private int[] axW = new int[64];
    private int[] azW = new int[64];
    private int[] axE = new int[64];
    private int[] azE = new int[64];
    private Rgb16[] rgb16sW;
    private Rgb16[] rgb16sE;
    private Rgb16[] rgb16sGouraud;
    final Rgb16 rgb16t1 = new Rgb16();
    final Rgb16 rgb16t2 = new Rgb16();

    @Override
    public G3DRenderer set(JmolRendererInterface jmolRendererInterface, GData gData) {
        try {
            this.rgb16sW = new Rgb16[64];
            this.rgb16sE = new Rgb16[64];
            int n = 64;
            while (--n >= 0) {
                this.rgb16sW[n] = new Rgb16();
                this.rgb16sE[n] = new Rgb16();
            }
            this.g3d = (Graphics3D)jmolRendererInterface;
            this.rgb16sGouraud = new Rgb16[3];
            n = 3;
            while (--n >= 0) {
                this.rgb16sGouraud[n] = new Rgb16();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    Rgb16[] reallocRgb16s(Rgb16[] rgb16Array, int n) {
        Rgb16[] rgb16Array2 = new Rgb16[n];
        System.arraycopy(rgb16Array, 0, rgb16Array2, 0, rgb16Array.length);
        for (int i = rgb16Array.length; i < n; ++i) {
            rgb16Array2[i] = new Rgb16();
        }
        return rgb16Array2;
    }

    void setGouraud(int n, int n2, int n3) {
        this.rgb16sGouraud[0].setInt(n);
        this.rgb16sGouraud[1].setInt(n2);
        this.rgb16sGouraud[2].setInt(n3);
    }

    void fillTriangleXYZ(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.ax[0] = n;
        this.ax[1] = n4;
        this.ax[2] = n7;
        this.ay[0] = n2;
        this.ay[1] = n5;
        this.ay[2] = n8;
        this.az[0] = n3;
        this.az[1] = n6;
        this.az[2] = n9;
        this.fillTriangleB(bl);
    }

    void fillTriangleP3i(P3i p3i, P3i p3i2, P3i p3i3, boolean bl) {
        this.ax[0] = p3i.x;
        this.ax[1] = p3i2.x;
        this.ax[2] = p3i3.x;
        this.ay[0] = p3i.y;
        this.ay[1] = p3i2.y;
        this.ay[2] = p3i3.y;
        this.az[0] = p3i.z;
        this.az[1] = p3i2.z;
        this.az[2] = p3i3.z;
        this.fillTriangleB(bl);
    }

    void fillTriangleP3f(P3 p3, P3 p32, P3 p33, boolean bl) {
        this.ax[0] = Math.round(p3.x);
        this.ax[1] = Math.round(p32.x);
        this.ax[2] = Math.round(p33.x);
        this.ay[0] = Math.round(p3.y);
        this.ay[1] = Math.round(p32.y);
        this.ay[2] = Math.round(p33.y);
        this.az[0] = Math.round(p3.z);
        this.az[1] = Math.round(p32.z);
        this.az[2] = Math.round(p33.z);
        this.fillTriangleB(bl);
    }

    private void fillTriangleB(boolean bl) {
        int n;
        int n2;
        int n3;
        Rgb16[] rgb16Array;
        Rgb16[] rgb16Array2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        if (this.az[0] <= 1 || this.az[1] <= 1 || this.az[2] <= 1) {
            return;
        }
        int n9 = this.g3d.clipCode3(this.ax[0], this.ay[0], this.az[0]);
        boolean bl3 = bl2 = (n9 | (n8 = this.g3d.clipCode3(this.ax[1], this.ay[1], this.az[1])) | (n7 = this.g3d.clipCode3(this.ax[2], this.ay[2], this.az[2]))) != 0;
        if (bl2 && (n9 & n8 & n7) != 0) {
            return;
        }
        int n10 = 0;
        if (this.ay[1] < this.ay[n10]) {
            n10 = 1;
        }
        if (this.ay[2] < this.ay[n10]) {
            n10 = 2;
        }
        if (this.ay[n6 = (n10 + 1) % 3] > this.ay[n5 = (n10 + 2) % 3]) {
            n4 = n6;
            n6 = n5;
            n5 = n4;
        }
        n4 = this.ay[n10];
        int n11 = this.ay[n6];
        int n12 = this.ay[n5];
        int n13 = n12 - n4 + 1;
        if (n13 > this.g3d.height * 3) {
            return;
        }
        if (n13 > this.axW.length) {
            int n14 = n13 + 31 & 0xFFFFFFE0;
            this.axW = new int[n14];
            this.azW = new int[n14];
            this.axE = new int[n14];
            this.azE = new int[n14];
            this.rgb16sW = this.reallocRgb16s(this.rgb16sW, n14);
            this.rgb16sE = this.reallocRgb16s(this.rgb16sE, n14);
        }
        if (bl) {
            rgb16Array2 = this.rgb16sW;
            rgb16Array = this.rgb16sE;
        } else {
            rgb16Array = null;
            rgb16Array2 = null;
        }
        int n15 = n11 - n4;
        if (n15 == 0) {
            if (this.ax[n6] < this.ax[n10]) {
                n3 = n6;
                n6 = n10;
                n10 = n3;
            }
            this.generateRaster(n13, n10, n5, this.axW, this.azW, 0, rgb16Array2);
            this.generateRaster(n13, n6, n5, this.axE, this.azE, 0, rgb16Array);
        } else if (n11 == n12) {
            if (this.ax[n5] < this.ax[n6]) {
                n3 = n6;
                n6 = n5;
                n5 = n3;
            }
            this.generateRaster(n13, n10, n6, this.axW, this.azW, 0, rgb16Array2);
            this.generateRaster(n13, n10, n5, this.axE, this.azE, 0, rgb16Array);
        } else {
            n3 = this.ax[n5] - this.ax[n10];
            n2 = GData.roundInt(n13 / 2);
            if (n3 < 0) {
                n2 = -n2;
            }
            if ((n = this.ax[n10] + (n3 * n15 + n2) / n13) < this.ax[n6]) {
                this.generateRaster(n13, n10, n5, this.axW, this.azW, 0, rgb16Array2);
                this.generateRaster(n15 + 1, n10, n6, this.axE, this.azE, 0, rgb16Array);
                this.generateRaster(n13 - n15, n6, n5, this.axE, this.azE, n15, rgb16Array);
            } else {
                this.generateRaster(n15 + 1, n10, n6, this.axW, this.azW, 0, rgb16Array2);
                this.generateRaster(n13 - n15, n6, n5, this.axW, this.azW, n15, rgb16Array2);
                this.generateRaster(n13, n10, n5, this.axE, this.azE, 0, rgb16Array);
            }
        }
        this.g3d.setZMargin(5);
        n3 = this.g3d.pass2Flag01;
        n2 = 1 - n3;
        int n16 = 0;
        if (n4 < 0) {
            n13 += n4;
            n16 -= n4;
            n4 = 0;
        }
        if (n4 + n13 > this.g3d.height) {
            n13 = this.g3d.height - n4;
        }
        if (bl) {
            if (bl2) {
                while (--n13 >= n3) {
                    n = this.axW[n16];
                    int n17 = this.axE[n16] - n + n2;
                    if (n17 > 0) {
                        this.g3d.plotPixelsClippedRaster(n17, n, n4, this.azW[n16], this.azE[n16], this.rgb16sW[n16], this.rgb16sE[n16]);
                    }
                    ++n4;
                    ++n16;
                }
            } else {
                while (--n13 >= n3) {
                    n = this.axW[n16];
                    int n18 = this.axE[n16] - n + n2;
                    if (n3 == 1 && n18 < 0) {
                        n18 = 1;
                        --n;
                    }
                    if (n18 > 0) {
                        this.g3d.plotPixelsUnclippedRaster(n18, n, n4, this.azW[n16], this.azE[n16], this.rgb16sW[n16], this.rgb16sE[n16]);
                    }
                    ++n4;
                    ++n16;
                }
            }
        } else if (bl2) {
            while (--n13 >= n3) {
                n = this.axW[n16];
                int n19 = this.axE[n16] - n + n2;
                if (n19 > 0) {
                    this.g3d.plotPixelsClippedRaster(n19, n, n4, this.azW[n16], this.azE[n16], null, null);
                }
                ++n4;
                ++n16;
            }
        } else {
            while (--n13 >= n3) {
                n = this.axW[n16];
                int n20 = this.axE[n16] - n + n2;
                if (n3 == 1 && n20 < 0) {
                    n20 = 1;
                    --n;
                }
                if (n20 > 0) {
                    this.g3d.plotPixelsUnclippedRaster(n20, n, n4, this.azW[n16], this.azE[n16], null, null);
                }
                ++n4;
                ++n16;
            }
        }
        this.g3d.setZMargin(0);
    }

    private void generateRaster(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Rgb16[] rgb16Array) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.ax[n2];
        int n11 = this.az[n2];
        int n12 = this.ax[n3];
        int n13 = this.az[n3];
        int n14 = n12 - n10;
        int n15 = n13 - n11;
        int n16 = n10;
        if (n14 >= 0) {
            n9 = 1;
            n8 = n14;
            n7 = 0;
        } else {
            n9 = -1;
            n8 = -n14;
            n7 = 1 - n;
        }
        int n17 = (n11 << 10) + 512;
        int n18 = GData.roundInt(n / 2);
        if (n15 < 0) {
            n18 = -n18;
        }
        int n19 = ((n15 << 10) + n18) / n;
        if (n8 <= n) {
            n6 = 0;
            n5 = n8;
        } else {
            n6 = GData.roundInt(n14 / n);
            n5 = n8 % n;
        }
        int n20 = n4;
        for (int i = 0; i < n; ++i) {
            nArray[n20] = n16;
            nArray2[n20] = n17 >> 10;
            n16 += n6;
            if ((n7 += n5) > 0) {
                n16 += n9;
                n7 -= n;
            }
            n17 += n19;
            ++n20;
        }
        if (rgb16Array != null) {
            Rgb16 rgb16 = this.rgb16t1;
            rgb16.setRgb(this.rgb16sGouraud[n2]);
            Rgb16 rgb162 = this.rgb16t2;
            rgb162.diffDiv(this.rgb16sGouraud[n3], rgb16, n);
            int n21 = n4 + n;
            for (int i = n4; i < n21; ++i) {
                rgb16Array[i].setAndIncrement(rgb16, rgb162);
            }
        }
    }
}

