/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.JmolConsole;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.i18n.GT;

public class AppletConsole
extends JmolConsole
implements JmolAppConsoleInterface {
    protected final JTextArea input = new ControlEnterTextArea();
    private JButton clearOutButton;
    private JButton clearInButton;
    private JButton loadButton;
    private final JTextPane output = new JTextPane();
    private final Document outputDocument = this.output.getDocument();
    private final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();

    private AppletConsole(JmolViewer jmolViewer, Container container) {
        this.viewer = jmolViewer;
        Component component = (Component)jmolViewer.getDisplay();
        JFrame jFrame = this.viewerFrame = component instanceof JFrame ? (JFrame)component : null;
        if (container == null) {
            JFrame jFrame2 = new JFrame();
            jFrame2.setSize(600, 400);
            this.externalContainer = jFrame2;
        } else {
            this.externalContainer = container;
            jmolViewer.setConsole((JmolAppConsoleInterface)this);
        }
        this.addWindowListener();
        this.layoutWindow();
        this.output(this.defaultMessage);
    }

    public AppletConsole() {
    }

    public JmolAppConsoleInterface getAppConsole(JmolViewer jmolViewer) {
        return new AppletConsole(jmolViewer, null);
    }

    public void sendConsoleEcho(String string) {
        if (string == null) {
            this.updateLabels();
            this.output(null);
            string = this.defaultMessage;
        }
        this.output(string);
    }

    public void sendConsoleMessage(String string) {
        if (string != null && this.output.getText().startsWith(this.defaultMessage)) {
            this.output(null);
        }
        this.output(string);
    }

    public void zap() {
    }

    private void layoutWindow() {
        this.setLabels();
        this.setupInput();
        this.setupOutput();
        JScrollPane jScrollPane = new JScrollPane(this.input);
        jScrollPane.setMinimumSize(new Dimension(2, 100));
        JScrollPane jScrollPane2 = new JScrollPane(this.output);
        jScrollPane2.setMinimumSize(new Dimension(2, 100));
        Container container = this.getPane();
        container.setLayout(new BoxLayout(container, 1));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setAlignmentX(0.5f);
        container.add(jSplitPane);
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 0));
        container2.add(Box.createGlue());
        container2.add(this.editButton);
        container2.add(this.runButton);
        container2.add(this.loadButton);
        container2.add(this.clearInButton);
        container2.add(this.clearOutButton);
        container2.add(this.historyButton);
        container2.add(this.stateButton);
        container2.add(Box.createGlue());
        container.add(container2);
        this.label1.setAlignmentX(0.5f);
        container.add(this.label1);
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setJMenuBar(this.createMenubar());
        }
    }

    private void setLabels() {
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate((boolean)true);
        this.editButton = this.setButton("Editor");
        this.stateButton = this.setButton("State");
        this.runButton = this.setButton("Run");
        this.clearOutButton = this.setButton("Clear Output");
        this.clearInButton = this.setButton("Clear Input");
        this.historyButton = this.setButton("History");
        this.loadButton = this.setButton("Load");
        this.label1 = new JLabel(this.getLabel("label1"), 0);
        this.defaultMessage = this.getLabel("default");
        this.setTitle();
        GT.setDoTranslate((boolean)bl);
    }

    protected void setupLabels() {
        this.labels.put("help", GT._((String)"&Help"));
        this.labels.put("search", GT._((String)"&Search..."));
        this.labels.put("commands", GT._((String)"&Commands"));
        this.labels.put("functions", GT._((String)"Math &Functions"));
        this.labels.put("parameters", GT._((String)"Set &Parameters"));
        this.labels.put("more", GT._((String)"&More"));
        this.labels.put("Editor", GT._((String)"Editor"));
        this.labels.put("State", GT._((String)"State"));
        this.labels.put("Run", GT._((String)"Run"));
        this.labels.put("Clear Output", GT._((String)"Clear Output"));
        this.labels.put("Clear Input", GT._((String)"Clear Input"));
        this.labels.put("History", GT._((String)"History"));
        this.labels.put("Load", GT._((String)"Load"));
        this.labels.put("label1", GT._((String)"press CTRL-ENTER for new line or paste model data and press Load"));
        this.labels.put("default", GT._((String)"Messages will appear here. Enter commands in the box below. Click the console Help menu item for on-line help, which will appear in a new browser window."));
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        KeyJMenu keyJMenu = new KeyJMenu("help", this.getLabel("help"), this.menuMap);
        JMenuItem jMenuItem = this.createMenuItem("search");
        jMenuItem.addActionListener(this);
        jMenuItem.setName("help ?search=?");
        keyJMenu.add(jMenuItem);
        this.addHelpItems(keyJMenu, "commands", "command");
        this.addHelpItems(keyJMenu, "functions", "mathfunc");
        this.addHelpItems(keyJMenu, "parameters", "setparam");
        this.addHelpItems(keyJMenu, "more", "misc");
        jMenuBar.add(keyJMenu);
    }

    private void addHelpItems(JMenu jMenu, String string, String string2) {
        KeyJMenu keyJMenu = new KeyJMenu(string, this.getLabel(string), this.menuMap);
        String[] stringArray = (String[])this.viewer.getProperty(null, "tokenList", (Object)string2);
        jMenu.add(keyJMenu);
        JMenu jMenu2 = null;
        String string3 = null;
        int n = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!Character.isLetter(string4.charAt(0))) continue;
            JMenuItem jMenuItem = new JMenuItem(string4);
            jMenuItem.addActionListener(this);
            jMenuItem.setName("help " + string4);
            if (jMenu2 == null) {
                jMenu2 = new JMenu();
                string3 = string4;
                jMenu2.add(jMenuItem);
                jMenu2.setText(string3);
                continue;
            }
            if (i % n + 1 == n) {
                jMenu2.add(jMenuItem);
                jMenu2.setText(string3 + " - " + string4);
                keyJMenu.add(jMenu2);
                jMenu2 = null;
                continue;
            }
            jMenu2.add(jMenuItem);
            if (i + 1 != stringArray.length || jMenu2 == null) continue;
            jMenu2.setText(string3 + " - " + string4);
            keyJMenu.add(jMenu2);
        }
    }

    protected JMenuItem createMenuItem(String string) {
        return new KeyJMenuItem(string, this.getLabel(string), this.menuMap);
    }

    private void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        this.input.setDragEnabled(true);
        Keymap keymap = this.input.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 1);
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    private void setupOutput() {
        this.output.setEditable(false);
        this.output.setDragEnabled(true);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.input.requestFocus();
    }

    private void output(String string) {
        this.output(string, null);
    }

    public String getText() {
        return this.output.getText();
    }

    private void output(String string, AttributeSet attributeSet) {
        if (string == null || string.length() == 0) {
            this.output.setText("");
            return;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    protected void clearContent(String string) {
        this.output.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearInButton) {
            this.input.setText("");
            return;
        }
        if (object == this.clearOutButton) {
            this.output.setText("");
            return;
        }
        if (object == this.loadButton) {
            this.viewer.loadInline(this.input.getText(), false);
            return;
        }
        if (object instanceof JMenuItem) {
            this.execute(((JMenuItem)object).getName());
            return;
        }
        super.actionPerformed(actionEvent);
    }

    protected void execute(String string) {
        String string2;
        String string3;
        String string4 = string3 = string == null ? this.input.getText() : string;
        if (string == null) {
            this.input.setText(null);
        }
        if ((string2 = this.viewer.script(string3 + "\u0001## EDITOR_IGNORE ##")) != null && !string2.equals("pending")) {
            this.output(string2);
        }
        if (string == null) {
            this.input.requestFocus();
        }
    }

    protected String completeCommand(String string) {
        return super.completeCommand(string);
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (keyEvent.getID()) {
                case 401: {
                    switch (n) {
                        case 9: {
                            keyEvent.consume();
                            if (AppletConsole.this.input.getCaretPosition() != AppletConsole.this.input.getText().length()) break;
                            String string = AppletConsole.this.completeCommand(this.getText());
                            if (string != null) {
                                this.setText(string.replace('\t', ' '));
                            }
                            ++AppletConsole.this.nTab;
                            return;
                        }
                        case 27: {
                            keyEvent.consume();
                            this.setText("");
                        }
                    }
                    AppletConsole.this.nTab = 0;
                    if (n == 10 && !keyEvent.isControlDown()) {
                        AppletConsole.this.execute(null);
                        return;
                    }
                    if (n != 38 && n != 40) break;
                    this.recallCommand(n == 38);
                    return;
                }
                case 402: {
                    if (n != 10 || keyEvent.isControlDown()) break;
                    return;
                }
            }
            if (n == 10) {
                keyEvent.setModifiers(0);
            }
            super.processComponentKeyEvent(keyEvent);
        }

        private void recallCommand(boolean bl) {
            String string = AppletConsole.this.viewer.getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            this.setText(string);
        }
    }
}

