/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.script.Token;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceFieldUFF
extends ForceField {
    private static List<String[]> atomTypes;
    private static Map<Object, FFParam> ffParams;
    private BitSet bsAromatic;
    private static final int TOKEN_ELEMENT_ONLY = 0;
    private static final int TOKEN_ELEMENT_CHARGED = 1;
    private static final int TOKEN_ELEMENT_CONNECTED = 2;
    private static final int TOKEN_AROMATIC = 3;
    private static final int TOKEN_ELEMENT_SP = 4;
    private static final int TOKEN_ELEMENT_ALLYLIC = 6;
    private static final int PT_ELEMENT = 2;
    private static final int PT_CHARGE = 5;
    private static final int PT_CONNECT = 6;
    private static final Token[][] tokenTypes;

    public ForceFieldUFF(Minimizer minimizer) {
        this.minimizer = minimizer;
        this.name = "UFF";
    }

    @Override
    public void clear() {
        this.bsAromatic = null;
    }

    @Override
    public boolean setModel(BitSet bitSet, int n) {
        this.setModelFields();
        Logger.info((String)"minimize: setting atom types...");
        if (atomTypes == null && (atomTypes = this.getAtomTypes()) == null) {
            return false;
        }
        if (ffParams == null && (ffParams = this.getFFParameters()) == null) {
            return false;
        }
        this.setAtomTypes(bitSet, n);
        this.calc = new CalculationsUFF(this, ffParams, this.minAtoms, this.minBonds, this.minAngles, this.minTorsions, this.minimizer.constraints);
        return this.calc.setupCalculations();
    }

    private void setAtomTypes(BitSet bitSet, int n) {
        int n2 = atomTypes.size();
        bitSet.clear(0);
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = atomTypes.get(i);
            String string = stringArray[0];
            if (string == null) continue;
            BitSet bitSet2 = this.getSearch(string, n, bitSet);
            if (bitSet.get(0)) {
                bitSet.clear(0);
                continue;
            }
            if (bitSet2 == null) break;
            int n3 = this.minimizer.bsAtoms.nextSetBit(0);
            int n4 = 0;
            while (n3 < this.minimizer.atoms.length && n3 >= 0) {
                if (bitSet2.get(n3)) {
                    this.minAtoms[n4].sType = stringArray[1].intern();
                }
                n3 = this.minimizer.bsAtoms.nextSetBit(n3 + 1);
                ++n4;
            }
        }
    }

    private BitSet getSearch(String string, int n, BitSet bitSet) {
        Object object;
        Token[] tokenArray = null;
        int n2 = string.length();
        tokenArray = tokenTypes[0];
        int n3 = string.charAt(n2 - 2) - 48;
        int n4 = 0;
        if (n3 >= 10) {
            n3 = 0;
        }
        boolean bl = false;
        if (string.charAt(1) == '#') {
            n4 = Parser.parseInt((String)string.substring(2, n2 - 1));
        } else {
            object = string.substring(1, n3 > 0 ? n2 - 3 : n2 - 1);
            if (((String)object).equals(((String)object).toLowerCase())) {
                object = ((String)object).toUpperCase();
                bl = true;
            }
            n4 = Elements.elementNumberFromSymbol((String)object, (boolean)false);
        }
        if (n4 > n) {
            return null;
        }
        if (!bitSet.get(n4)) {
            bitSet.set(0);
            return null;
        }
        switch (string.charAt(n2 - 3)) {
            case 'D': {
                tokenArray = tokenTypes[2];
                tokenArray[6].intValue = n3;
                break;
            }
            case '^': {
                tokenArray = tokenTypes[4 + (n3 - 1)];
                break;
            }
            case '+': {
                tokenArray = tokenTypes[1];
                tokenArray[5].intValue = n3;
                break;
            }
            case '-': {
                tokenArray = tokenTypes[1];
                tokenArray[5].intValue = -n3;
                break;
            }
            case 'A': {
                tokenArray = tokenTypes[6];
            }
        }
        tokenArray[2].intValue = n4;
        object = this.minimizer.viewer.evaluateExpression((Object)tokenArray);
        if (!(object instanceof BitSet)) {
            return null;
        }
        BitSet bitSet2 = (BitSet)object;
        if (bl && bitSet2.cardinality() > 0) {
            if (this.bsAromatic == null) {
                this.bsAromatic = (BitSet)this.minimizer.viewer.evaluateExpression((Object)tokenTypes[3]);
            }
            bitSet2.and(this.bsAromatic);
        }
        if (Logger.debugging && bitSet2.cardinality() > 0) {
            Logger.debug((String)(string + " minimize atoms=" + bitSet2));
        }
        return bitSet2;
    }

    private Map<Object, FFParam> getFFParameters() {
        Hashtable<Object, FFParam> hashtable = new Hashtable<Object, FFParam>();
        URL uRL = null;
        String string = "uff/UFF.txt";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            uRL = this.getClass().getResource(string);
            if (uRL == null) {
                System.err.println("Couldn't find file: " + string);
                throw new NullPointerException();
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = Parser.getTokens((String)string2);
                if (stringArray.length < 13) continue;
                if (Logger.debugging) {
                    Logger.info((String)string2);
                }
                if (!string2.substring(0, 5).equals("param")) continue;
                FFParam fFParam = new FFParam();
                hashtable.put(stringArray[1], fFParam);
                fFParam.dVal = new double[11];
                fFParam.sVal = new String[1];
                fFParam.sVal[0] = stringArray[1];
                fFParam.dVal[0] = Parser.parseFloat((String)stringArray[2]);
                fFParam.dVal[1] = (double)Parser.parseFloat((String)stringArray[3]) * (Math.PI / 180);
                fFParam.dVal[2] = Parser.parseFloat((String)stringArray[4]);
                fFParam.dVal[3] = Parser.parseFloat((String)stringArray[5]);
                fFParam.dVal[4] = Parser.parseFloat((String)stringArray[6]);
                fFParam.dVal[5] = Parser.parseFloat((String)stringArray[7]);
                fFParam.dVal[6] = Parser.parseFloat((String)stringArray[8]);
                fFParam.dVal[7] = Parser.parseFloat((String)stringArray[9]);
                fFParam.dVal[8] = Parser.parseFloat((String)stringArray[10]);
                fFParam.dVal[9] = Parser.parseFloat((String)stringArray[11]);
                fFParam.dVal[10] = Parser.parseFloat((String)stringArray[12]);
                fFParam.iVal = new int[1];
                int n = stringArray[1].length() > 2 ? (int)stringArray[1].charAt(2) : 49;
                switch (n) {
                    case 82: {
                        n = 50;
                        break;
                    }
                    default: {
                        n = 49;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                }
                fFParam.iVal[0] = n - 48;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        Logger.info((String)(hashtable.size() + " atom types read from " + string));
        return hashtable;
    }

    private List<String[]> getAtomTypes() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        URL uRL = null;
        String string = "uff/UFF.txt";
        try {
            String string2;
            uRL = this.getClass().getResource(string);
            if (uRL == null) {
                System.err.println("Couldn't find file: " + string);
                throw new NullPointerException();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 4 || !string2.substring(0, 4).equals("atom")) continue;
                String[] stringArray = Parser.getTokens((String)string2);
                String[] stringArray2 = new String[]{stringArray[1], stringArray[2]};
                arrayList.add(stringArray2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
        }
        Logger.info((String)(arrayList.size() + " UFF parameters read"));
        return arrayList.size() > 0 ? arrayList : null;
    }

    static {
        tokenTypes = new Token[][]{{Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenAnd, new Token(269484436, 1632634889), Token.intToken((int)0), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenAnd, Token.tokenConnected, Token.tokenLeftParen, Token.intToken((int)0), Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(0x40000000, (Object)"flatring"), Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenAnd, Token.tokenLeftParen, Token.tokenConnected, Token.tokenLeftParen, Token.intToken((int)1), Token.tokenComma, new Token(4, (Object)"triple"), Token.tokenRightParen, Token.tokenOr, Token.tokenConnected, Token.tokenLeftParen, Token.intToken((int)2), Token.tokenComma, new Token(4, (Object)"double"), Token.tokenRightParen, Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenAnd, new Token(135266310, (Object)"connected"), Token.tokenLeftParen, Token.intToken((int)1), Token.tokenComma, new Token(4, (Object)"double"), Token.tokenRightParen, Token.tokenExpressionEnd}, {Token.tokenExpressionBegin, new Token(269484436, 1095763976), Token.intToken((int)0), Token.tokenAnd, Token.tokenConnected, Token.tokenLeftParen, Token.intToken((int)3), Token.tokenRightParen, Token.tokenAnd, Token.tokenConnected, Token.tokenLeftParen, Token.tokenConnected, Token.tokenLeftParen, new Token(4, (Object)"double"), Token.tokenRightParen, Token.tokenRightParen, Token.tokenExpressionEnd}};
    }
}

