/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.util.Rectangle;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

class RepaintManager {
    private Viewer viewer;
    private ShapeManager shapeManager;
    private ShapeRenderer[] renderers;
    private int holdRepaint = 0;
    boolean repaintPending;
    private boolean logTime;
    private BitSet bsAtoms;
    private Point3f ptOffset = new Point3f();

    RepaintManager(Viewer viewer, ShapeManager shapeManager) {
        this.viewer = viewer;
        this.shapeManager = shapeManager;
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint(boolean bl) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (bl) {
                this.repaintPending = true;
                this.viewer.repaint();
            }
        }
    }

    boolean refresh() {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.repaint();
        }
        return true;
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    synchronized void requestRepaintAndWait() {
        this.viewer.repaint();
        try {
            this.wait(this.viewer.getRepaintWait());
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            for (int i = 0; i < 35; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int n, Graphics3D graphics3D) {
        if (this.renderers[n] != null) {
            return this.renderers[n];
        }
        String string = JmolConstants.getShapeClassName(n) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            this.renderers[n] = shapeRenderer;
            return this.renderers[n];
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate renderer:" + string, exception);
            return null;
        }
    }

    void render(Graphics3D graphics3D, ModelSet modelSet, boolean bl) {
        if (modelSet == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        this.logTime = false;
        if (this.logTime) {
            Logger.startTimer();
        }
        this.viewer.finalizeTransformParameters();
        try {
            graphics3D.renderBackground();
            if (bl) {
                int[] nArray = this.shapeManager.transformAtoms(this.bsAtoms, this.ptOffset);
                this.bsAtoms = null;
                if (nArray != null) {
                    this.renderCrossHairs(graphics3D, nArray);
                }
                this.renderSelectionRubberBand(graphics3D);
            }
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[35];
            }
            for (int i = 0; i < 35 && graphics3D.currentlyRendering(); ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                this.getRenderer(i, graphics3D).render(graphics3D, modelSet, shape);
                if (!this.logTime) continue;
                Logger.checkTimer("render time " + JmolConstants.getShapeClassName(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("rendering error? ");
        }
    }

    String renderExport(String string, Graphics3D graphics3D, ModelSet modelSet, String string2) {
        boolean bl;
        JmolRendererInterface jmolRendererInterface = null;
        CharSequence charSequence = null;
        this.viewer.finalizeTransformParameters();
        try {
            this.shapeManager.transformAtoms(null, null);
            charSequence = string2 == null ? new StringBuffer() : string2;
            Class<?> clazz = Class.forName("org.jmol.export.Export3D");
            jmolRendererInterface = (JmolRendererInterface)clazz.newInstance();
            bl = this.viewer.initializeExporter(jmolRendererInterface, string, charSequence);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Logger.error("Cannot export " + string);
            return null;
        }
        jmolRendererInterface.renderBackground();
        for (int i = 0; i < 35; ++i) {
            Shape shape = this.shapeManager.getShape(i);
            if (shape == null) continue;
            this.getRenderer(i, graphics3D).render(jmolRendererInterface, modelSet, shape);
        }
        return jmolRendererInterface.finalizeOutput();
    }

    void setSelectedTranslation(BitSet bitSet, char c, int n) {
        this.bsAtoms = bitSet;
        switch (c) {
            case 'X': 
            case 'x': {
                this.ptOffset.x += (float)n;
                break;
            }
            case 'Y': 
            case 'y': {
                this.ptOffset.y += (float)n;
                break;
            }
            case 'Z': 
            case 'z': {
                this.ptOffset.z += (float)n;
            }
        }
    }

    private void renderCrossHairs(Graphics3D graphics3D, int[] nArray) {
        Point3f point3f = new Point3f(this.viewer.getNavigationOffset());
        boolean bl = graphics3D.isAntialiased();
        float f = this.viewer.getNavigationDepthPercent();
        graphics3D.setColix((short)(f < 0.0f ? 10 : (f > 100.0f ? 11 : 23)));
        int n = Math.max(Math.min(this.viewer.getScreenWidth(), (int)point3f.x), 0);
        int n2 = Math.max(Math.min(this.viewer.getScreenHeight(), (int)point3f.y), 0);
        int n3 = (int)point3f.z + 1;
        int n4 = bl ? 8 : 4;
        int n5 = bl ? 20 : 10;
        int n6 = bl ? 2 : 1;
        graphics3D.drawRect(n - n4, n2, n3, 0, n5, n6);
        graphics3D.drawRect(n, n2 - n4, n3, 0, n6, n5);
        graphics3D.drawRect(n - n4, n2 - n4, n3, 0, n5, n5);
        n4 = n5;
        graphics3D.setColix((float)nArray[1] < point3f.x ? (short)21 : 11);
        graphics3D.drawRect(n - n4, n2, n3, 0, n5 >>= 1, n6);
        graphics3D.setColix((float)nArray[0] > point3f.x ? (short)21 : 11);
        graphics3D.drawRect(n + n5, n2, n3, 0, n5, n6);
        graphics3D.setColix((float)nArray[3] < point3f.y ? (short)21 : 11);
        graphics3D.drawRect(n, n2 - n4, n3, 0, n6, n5);
        graphics3D.setColix((float)nArray[2] > point3f.y ? (short)21 : 11);
        graphics3D.drawRect(n, n2 + n5, n3, 0, n6, n5);
    }

    private void renderSelectionRubberBand(Graphics3D graphics3D) {
        Rectangle rectangle = this.viewer.getRubberBandSelection();
        if (rectangle != null && graphics3D.setColix(this.viewer.getColixRubberband())) {
            graphics3D.drawRect(rectangle.x, rectangle.y, 0, 0, rectangle.width, rectangle.height);
        }
    }
}

