/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quadric;

public class Eigen {
    private int n;
    private double[] d;
    private double[] e;
    private double[][] V;

    public Eigen(int n) {
        this.n = n;
        this.V = new double[n][n];
        this.d = new double[n];
        this.e = new double[n];
    }

    public Eigen(double[][] dArray) {
        this(dArray.length);
        this.calc(dArray);
    }

    public Eigen(double[][] dArray, Vector3f[] vector3fArray, float[] fArray) {
        this(dArray);
        this.set(vector3fArray, fArray);
        Eigen.sort(vector3fArray, fArray);
    }

    private void set(Vector3f[] vector3fArray, float[] fArray) {
        float[][] fArray2 = this.getEigenvectorsFloatTransposed();
        double[] dArray = this.getRealEigenvalues();
        for (int i = 0; i < this.n; ++i) {
            if (vector3fArray[i] == null) {
                vector3fArray[i] = new Vector3f();
            }
            vector3fArray[i].set(fArray2[i]);
            fArray[i] = (float)Math.sqrt(Math.abs(dArray[i]));
        }
    }

    public void calc(double[][] dArray) {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.V[i][j] = dArray[i][j];
            }
        }
        this.tred2();
        this.tql2();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public double[] getEigenvalues() {
        return this.d;
    }

    public float[][] getEigenvectorsFloatTransposed() {
        float[][] fArray = new float[this.n][this.n];
        int n = this.n;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                fArray[n2][n] = (float)this.V[n][n2];
            }
        }
        return fArray;
    }

    public Vector3f[] getEigenVectors3() {
        Vector3f[] vector3fArray = new Vector3f[3];
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i] = new Vector3f((float)this.V[0][i], (float)this.V[1][i], (float)this.V[2][i]);
        }
        return vector3fArray;
    }

    private void tred2() {
        double d;
        int n;
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
        }
        for (n = this.n - 1; n > 0; --n) {
            int n2;
            d = 0.0;
            double d2 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += Math.abs(this.d[n2]);
            }
            if (d == 0.0) {
                this.e[n] = this.d[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.d[n2] = this.V[n - 1][n2];
                    this.V[n][n2] = 0.0;
                    this.V[n2][n] = 0.0;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.d[n5] = this.d[n5] / d;
                    d2 += this.d[n2] * this.d[n2];
                }
                double d3 = this.d[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.e[n] = d * d4;
                d2 -= d3 * d4;
                this.d[n - 1] = d3 - d4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.e[n4] = 0.0;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.V[n4][n] = d3 = this.d[n4];
                    d4 = this.e[n4] + this.V[n4][n4] * d3;
                    for (int i = n4 + 1; i <= n - 1; ++i) {
                        d4 += this.V[i][n4] * this.d[i];
                        int n6 = i;
                        this.e[n6] = this.e[n6] + this.V[i][n4] * d3;
                    }
                    this.e[n4] = d4;
                }
                d3 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.e[n7] = this.e[n7] / d2;
                    d3 += this.e[n4] * this.d[n4];
                }
                double d5 = d3 / (d2 + d2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.e[n8] = this.e[n8] - d5 * this.d[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = this.d[n3];
                    d4 = this.e[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        double[] dArray = this.V[i];
                        int n9 = n3;
                        dArray[n9] = dArray[n9] - (d3 * this.e[i] + d4 * this.d[i]);
                    }
                    this.d[n3] = this.V[n - 1][n3];
                    this.V[n][n3] = 0.0;
                }
            }
            this.d[n] = d2;
        }
        for (n = 0; n < this.n - 1; ++n) {
            int n10;
            this.V[this.n - 1][n] = this.V[n][n];
            this.V[n][n] = 1.0;
            d = this.d[n + 1];
            if (d != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.d[n10] = this.V[n10][n + 1] / d;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    double d6 = 0.0;
                    for (n11 = 0; n11 <= n; ++n11) {
                        d6 += this.V[n11][n + 1] * this.V[n11][n10];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        double[] dArray = this.V[n11];
                        int n12 = n10;
                        dArray[n12] = dArray[n12] - d6 * this.d[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.V[n10][n + 1] = 0.0;
            }
        }
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
            this.V[this.n - 1][n] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        int n;
        int n2;
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.pow(2.0, -52.0);
        for (n2 = 0; n2 < this.n; ++n2) {
            d2 = Math.max(d2, Math.abs(this.d[n2]) + Math.abs(this.e[n2]));
            for (n = n2; n < this.n && !(Math.abs(this.e[n]) <= d3 * d2); ++n) {
            }
            if (n > n2) {
                int n3 = 0;
                do {
                    double d4;
                    ++n3;
                    double d5 = this.d[n2];
                    double d6 = (this.d[n2 + 1] - d5) / (2.0 * this.e[n2]);
                    double d7 = Eigen.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    this.d[n2] = this.e[n2] / (d6 + d7);
                    this.d[n2 + 1] = this.e[n2] * (d6 + d7);
                    double d8 = this.d[n2 + 1];
                    double d9 = d5 - this.d[n2];
                    int n4 = n2 + 2;
                    while (n4 < this.n) {
                        int n5 = n4++;
                        this.d[n5] = this.d[n5] - d9;
                    }
                    d += d9;
                    d6 = this.d[n];
                    double d10 = d4 = 1.0;
                    double d11 = d4;
                    double d12 = this.e[n2 + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (int i = n - 1; i >= n2; --i) {
                        d11 = d10;
                        d10 = d4;
                        d14 = d13;
                        d5 = d4 * this.e[i];
                        d9 = d4 * d6;
                        d7 = Eigen.hypot(d6, this.e[i]);
                        this.e[i + 1] = d13 * d7;
                        d13 = this.e[i] / d7;
                        d4 = d6 / d7;
                        d6 = d4 * this.d[i] - d13 * d5;
                        this.d[i + 1] = d9 + d13 * (d4 * d5 + d13 * this.d[i]);
                        for (int j = 0; j < this.n; ++j) {
                            d9 = this.V[j][i + 1];
                            this.V[j][i + 1] = d13 * this.V[j][i] + d4 * d9;
                            this.V[j][i] = d4 * this.V[j][i] - d13 * d9;
                        }
                    }
                    d6 = -d13 * d14 * d11 * d12 * this.e[n2] / d8;
                    this.e[n2] = d13 * d6;
                    this.d[n2] = d4 * d6;
                } while (Math.abs(this.e[n2]) > d3 * d2);
            }
            this.d[n2] = this.d[n2] + d;
            this.e[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.n - 1; ++n2) {
            int n6;
            n = n2;
            double d15 = this.d[n2];
            for (n6 = n2 + 1; n6 < this.n; ++n6) {
                if (!(this.d[n6] < d15)) continue;
                n = n6;
                d15 = this.d[n6];
            }
            if (n == n2) continue;
            this.d[n] = this.d[n2];
            this.d[n2] = d15;
            for (n6 = 0; n6 < this.n; ++n6) {
                d15 = this.V[n6][n2];
                this.V[n6][n2] = this.V[n6][n];
                this.V[n6][n] = d15;
            }
        }
    }

    private static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static Quadric getEllipsoid(double[][] dArray) {
        Eigen eigen = new Eigen(3);
        eigen.calc(dArray);
        Matrix3f matrix3f = new Matrix3f();
        float[] fArray = new float[9];
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                fArray[n++] = (float)dArray[i][j];
            }
        }
        matrix3f.set(fArray);
        Vector3f[] vector3fArray = eigen.getEigenVectors3();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < 3; ++i) {
            vector3f.set(vector3fArray[i]);
            matrix3f.transform(vector3f);
            vector3f2.cross(vector3f, vector3fArray[i]);
            Logger.info("v[i], n, n x v[i]" + vector3fArray[i] + " " + vector3f + " " + vector3f2);
            vector3f.set(vector3fArray[i]);
            vector3f.normalize();
            vector3f2.cross(vector3fArray[i], vector3fArray[(i + 1) % 3]);
            Logger.info("draw id eigv" + i + " " + Escape.escape(vector3fArray[i]) + " color " + (i == 0 ? "red" : (i == 1 ? "green" : "blue")) + " # " + vector3f + " " + vector3f2);
        }
        Logger.info("eigVl (" + eigen.d[0] + " + " + eigen.e[0] + "I) (" + eigen.d[1] + " + " + eigen.e[1] + "I) (" + eigen.d[2] + " + " + eigen.e[2] + "I)");
        Vector3f[] vector3fArray2 = new Vector3f[3];
        float[] fArray2 = new float[3];
        eigen.set(vector3fArray2, fArray2);
        Eigen.sort(vector3fArray2, fArray2);
        return new Quadric(vector3fArray2, fArray2, false);
    }

    public static Quadric getEllipsoid(Vector3f[] vector3fArray, float[] fArray, boolean bl) {
        Vector3f[] vector3fArray2 = (Vector3f[])vector3fArray.clone();
        Eigen.sort(vector3fArray2, fArray);
        return new Quadric(vector3fArray2, fArray, bl);
    }

    private static void sort(Vector3f[] vector3fArray, float[] fArray) {
        Object[][] objectArrayArray = new Object[][]{{vector3fArray[0], Float.valueOf(Math.abs(fArray[0]))}, {vector3fArray[1], Float.valueOf(Math.abs(fArray[1]))}, {vector3fArray[2], Float.valueOf(Math.abs(fArray[2]))}};
        Arrays.sort(objectArrayArray, new EigenSort());
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i] = new Vector3f((Vector3f)objectArrayArray[i][0]);
            vector3fArray[i].normalize();
            fArray[i] = ((Float)objectArrayArray[i][1]).floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EigenSort
    implements Comparator<Object[]> {
        protected EigenSort() {
        }

        @Override
        public int compare(Object[] objectArray, Object[] objectArray2) {
            float f;
            float f2 = ((Float)objectArray[1]).floatValue();
            return f2 < (f = ((Float)objectArray2[1]).floatValue()) ? -1 : (f2 > f ? 1 : 0);
        }
    }
}

