/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import netscape.javascript.JSObject;
import org.jmol.api.JmolSyncInterface;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JmolAppletRegistry {
    static Map<String, Object> htRegistry = new Hashtable<String, Object>();

    JmolAppletRegistry() {
    }

    static synchronized void checkIn(String string, JmolSyncInterface jmolSyncInterface) {
        JmolAppletRegistry.cleanRegistry();
        if (string != null) {
            Logger.info("AppletRegistry.checkIn(" + string + ")");
            htRegistry.put(string, jmolSyncInterface);
        }
        if (Logger.debugging) {
            for (Map.Entry<String, Object> entry : htRegistry.entrySet()) {
                String string2 = entry.getKey();
                Logger.debug(string2 + " " + entry.getValue());
            }
        }
    }

    static synchronized void checkOut(String string) {
        htRegistry.remove(string);
    }

    static synchronized void findApplets(String string, String string2, String string3, List<String> list) {
        if (string != null && string.indexOf(",") >= 0) {
            String[] stringArray = TextFormat.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                JmolAppletRegistry.findApplets(stringArray[i], string2, string3, list);
            }
            return;
        }
        String string4 = "__" + string2 + "__";
        if (string == null || string.equals("*") || string.equals(">")) {
            for (String string5 : htRegistry.keySet()) {
                if (string5.equals(string3) || string5.indexOf(string4) <= 0) continue;
                list.add(string5);
            }
            return;
        }
        if (string.indexOf("__") < 0) {
            string = string + string4;
        }
        if (!htRegistry.containsKey(string)) {
            string = "jmolApplet" + string;
        }
        if (!string.equals(string3) && htRegistry.containsKey(string)) {
            list.add(string);
        }
    }

    private static synchronized void cleanRegistry() {
        Applet applet = null;
        boolean bl = true;
        for (Map.Entry<String, Object> entry : htRegistry.entrySet()) {
            String string = entry.getKey();
            try {
                applet = (Applet)entry.getValue();
                JSObject jSObject = JSObject.getWindow((Applet)applet);
                bl = (Boolean)jSObject.getMember("closed");
                if (bl || jSObject.hashCode() == 0) {
                    // empty if block
                }
                if (Logger.debugging) {
                    Logger.debug("Preserving registered applet " + string + " window: " + jSObject.hashCode());
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) continue;
            if (Logger.debugging) {
                Logger.debug("Dereferencing closed window applet " + string);
            }
            htRegistry.remove(string);
            applet.destroy();
        }
    }
}

