/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import jspecview.common.Coordinate;
import jspecview.util.TextFormat;

public class ScaleData {
    private static final double[] UNITS = new double[]{1.5, 2.0, 2.5, 4.0, 5.0, 8.0, 10.0};
    private static final DecimalFormat SCI_FORMATTER = TextFormat.getDecimalFormat("0.###E0");
    public double minX;
    public double maxX;
    public int[] hashNums = new int[2];
    public double xStep;
    public double firstX = Double.NaN;
    public double minXOnScale;
    public double maxXOnScale;
    public double minY;
    public double maxY;
    public double yStep;
    public double minYOnScale;
    public double maxYOnScale;
    public int startDataPointIndex;
    public int endDataPointIndex;
    public int numOfPoints;

    public ScaleData(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public ScaleData(Coordinate[] coords, int start, int end, int initNumXDivisions, int initNumYDivisions, boolean isContinuous) {
        this(Coordinate.getMinX(coords, start, end), Coordinate.getMaxX(coords, start, end), Coordinate.getMinY(coords, start, end), Coordinate.getMaxY(coords, start, end));
        this.setScale(initNumXDivisions, initNumYDivisions, isContinuous);
    }

    public ScaleData(ScaleData data) {
        this.minX = data.minX;
        this.maxX = data.maxX;
        this.hashNums[0] = data.hashNums[0];
        this.hashNums[1] = data.hashNums[1];
        this.xStep = data.xStep;
        this.firstX = data.firstX;
        this.minXOnScale = data.minXOnScale;
        this.maxXOnScale = data.maxXOnScale;
        this.minY = data.minY;
        this.maxY = data.maxY;
        this.yStep = data.yStep;
        this.minYOnScale = data.minYOnScale;
        this.maxYOnScale = data.maxYOnScale;
        this.startDataPointIndex = data.startDataPointIndex;
        this.endDataPointIndex = data.endDataPointIndex;
        this.numOfPoints = data.numOfPoints;
    }

    protected ScaleData setScale(int initNumXDivisions, int initNumYDivisions, boolean isContinuous) {
        this.setXScale(initNumXDivisions);
        if (!isContinuous) {
            this.maxXOnScale += this.xStep / 2.0;
        }
        if (this.minY == 0.0 && this.maxY == 0.0) {
            this.maxY = 1.0;
        }
        this.yStep = ScaleData.getStep(this.minY, this.maxY, initNumYDivisions, this.hashNums, 1);
        this.minYOnScale = this.yStep * Math.floor(this.minY / this.yStep);
        this.maxYOnScale = this.yStep * Math.ceil(this.maxY / this.yStep);
        return this;
    }

    protected void setXScale(int initNumXDivisions) {
        this.xStep = ScaleData.getStep(this.minX, this.maxX, initNumXDivisions, this.hashNums, 0);
        this.minXOnScale = this.xStep * Math.floor(this.minX / this.xStep);
        this.maxXOnScale = this.xStep * Math.ceil(this.maxX / this.xStep);
        this.firstX = Math.floor(this.minX / this.xStep) * this.xStep;
        if (Math.abs((this.minX - this.firstX) / this.xStep) > 1.0E-4) {
            this.firstX += this.xStep;
        }
        this.minXOnScale = this.minX;
        this.maxXOnScale = this.maxX;
    }

    private static double getStep(double min, double max, int nDiv, int[] hashNums, int i) {
        double spanX = (max - min) / (double)nDiv;
        String strSpanX = SCI_FORMATTER.format(spanX);
        strSpanX = strSpanX.toUpperCase();
        int indexOfE = strSpanX.indexOf(69);
        hashNums[i] = Integer.parseInt(strSpanX.substring(indexOfE + 1));
        return ScaleData.getStepFromExponent(Double.parseDouble(strSpanX.substring(0, indexOfE)), hashNums[i]);
    }

    private static double getStepFromExponent(double leftOfE, int rightOfE) {
        int i = 0;
        while (leftOfE > UNITS[i] && i <= 6) {
            ++i;
        }
        return Math.pow(10.0, rightOfE) * UNITS[i];
    }

    public static boolean isWithinRange(double x, ScaleData scaleData) {
        return x >= scaleData.minX && x <= scaleData.maxX;
    }
}

