/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Coordinate;

class PlotWidget
extends Coordinate {
    int xPixel0;
    int yPixel0;
    int xPixel1;
    int yPixel1;
    boolean isPin;
    boolean isPinOrCursor;
    boolean isXtype;
    boolean is2D;
    boolean is2Donly;
    boolean isEnabled = true;
    private String name;

    public String toString() {
        return String.valueOf(this.name) + (!this.isPinOrCursor ? this.xPixel0 + " " + this.yPixel0 + " / " + this.xPixel1 + " " + this.yPixel1 : " x=" + this.getXVal() + "/" + this.xPixel0 + " y=" + this.getYVal() + "/" + this.yPixel0);
    }

    PlotWidget(String name) {
        this.name = name;
        this.isPin = name.charAt(0) == 'p';
        this.isPinOrCursor = name.charAt(0) != 'z';
        this.isXtype = name.indexOf("x") >= 0;
        this.is2D = name.indexOf("2D") >= 0;
        this.is2Donly = this.is2D && name.charAt(0) == 'p';
    }

    boolean selected(int xPixel, int yPixel) {
        return Math.abs(xPixel - this.xPixel0) < 5 && Math.abs(yPixel - this.yPixel0) < 5;
    }

    void setX(double x, int xPixel) {
        this.setXVal(x);
        this.xPixel0 = this.xPixel1 = xPixel;
    }

    void setY(double y, int yPixel) {
        this.setYVal(y);
        this.yPixel0 = this.yPixel1 = yPixel;
    }

    double getValue() {
        return this.isXtype ? this.getXVal() : this.getYVal();
    }

    void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

