/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.JSVPanel;
import jspecview.common.ScriptToken;
import jspecview.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    protected String name;
    protected String titleFont;
    protected String displayFont;
    protected Map<ScriptToken, Object> elementColors = new Hashtable<ScriptToken, Object>();
    protected boolean isDefault = false;
    protected Object plotColors;
    public double integralMinY = 0.1;
    public double integralFactor = 50.0;
    public double integralOffset = 30.0;
    private Map<ScriptToken, Boolean> htBooleans = new Hashtable<ScriptToken, Boolean>();

    public Map<ScriptToken, Object> getColors() {
        return this.elementColors;
    }

    public Parameters(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(String fontName) {
        this.titleFont = fontName;
    }

    public String getDisplayFont() {
        return this.displayFont;
    }

    public void setDisplayFont(String fontName) {
        this.displayFont = fontName;
    }

    public void setDefault(boolean val) {
        this.isDefault = val;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Object getColor(ScriptToken st) {
        return this.elementColors.get((Object)st);
    }

    public Object setColor(ScriptToken st, Object color) {
        if (color != null) {
            this.elementColors.put(st, color);
        }
        return color;
    }

    public Parameters copy(String newName) {
        Parameters ds = new Parameters(newName);
        ds.setDisplayFont(this.getDisplayFont());
        for (Map.Entry<ScriptToken, Object> entry : this.elementColors.entrySet()) {
            ds.setColor(entry.getKey(), entry.getValue());
        }
        return ds;
    }

    public Parameters copy() {
        return this.copy(this.getName());
    }

    protected void setDefaultColors(Object[] colors) {
        this.setColor(ScriptToken.TITLECOLOR, colors[0]);
        this.setColor(ScriptToken.UNITSCOLOR, colors[1]);
        this.setColor(ScriptToken.SCALECOLOR, colors[2]);
        this.setColor(ScriptToken.COORDINATESCOLOR, colors[3]);
        this.setColor(ScriptToken.GRIDCOLOR, colors[4]);
        this.setColor(ScriptToken.PLOTCOLOR, colors[5]);
        this.setColor(ScriptToken.PLOTAREACOLOR, colors[6]);
        this.setColor(ScriptToken.BACKGROUNDCOLOR, colors[7]);
        this.setColor(ScriptToken.INTEGRALPLOTCOLOR, colors[8]);
    }

    protected void setParamDefaults() {
        this.setBoolean(ScriptToken.TITLEON, !this.name.equals("application"));
        this.setBoolean(ScriptToken.ENABLEZOOM, true);
        this.setBoolean(ScriptToken.DISPLAY2D, true);
        this.setBoolean(ScriptToken.COORDINATESON, true);
        this.setBoolean(ScriptToken.GRIDON, true);
        this.setBoolean(ScriptToken.XSCALEON, true);
        this.setBoolean(ScriptToken.YSCALEON, true);
        this.setBoolean(ScriptToken.XUNITSON, true);
        this.setBoolean(ScriptToken.YUNITSON, true);
    }

    public static boolean isTrue(String value) {
        return value.length() == 0 || Boolean.parseBoolean(value);
    }

    public Map<ScriptToken, Boolean> getBooleans() {
        return this.htBooleans;
    }

    public boolean setBoolean(ScriptToken st, String value) {
        return this.setBoolean(st, Parameters.isTrue(value));
    }

    public boolean setBoolean(ScriptToken st, boolean val) {
        this.htBooleans.put(st, val);
        return val;
    }

    public boolean getBoolean(ScriptToken t) {
        return Boolean.TRUE == this.htBooleans.get((Object)t);
    }

    public void setFor(JSVPanel jsvp, Parameters ds, boolean includeMeasures) {
        if (ds == null) {
            ds = this;
        }
        if (includeMeasures) {
            jsvp.getPanelData().setBoolean(this, null);
        }
        if (jsvp.getPlotColor(1) != null) {
            jsvp.setPlotColors(this.plotColors);
        }
        jsvp.setColorOrFont(ds, null);
    }

    public void set(JSVPanel jsvp, ScriptToken st, String value) {
        Object param = null;
        block0 : switch (st) {
            default: {
                return;
            }
            case PLOTCOLORS: {
                if (jsvp == null) {
                    this.getPlotColors(value);
                } else {
                    jsvp.setPlotColors(this.getPlotColors(value));
                }
                return;
            }
            case ZOOM: {
                if (jsvp == null) break;
                List<String> tokens = ScriptToken.getTokens(value);
                switch (tokens.size()) {
                    case 1: {
                        if (!tokens.get(0).equalsIgnoreCase("out")) break block0;
                        jsvp.getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        jsvp.getPanelData().setZoom(Double.parseDouble(tokens.get(0)), 0.0, Double.parseDouble(tokens.get(1)), 0.0);
                        break;
                    }
                    case 4: {
                        jsvp.getPanelData().setZoom(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2)), Double.parseDouble(tokens.get(3)));
                    }
                }
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(value.toLowerCase().equals("high") ? 6 : (Parameters.isTrue(value) ? 5 : 4));
                return;
            }
            case COORDINATESON: 
            case DISPLAY1D: 
            case DISPLAY2D: 
            case ENABLEZOOM: 
            case GRIDON: 
            case REVERSEPLOT: 
            case TITLEON: 
            case TITLEBOLDON: 
            case XSCALEON: 
            case XUNITSON: 
            case YSCALEON: 
            case YUNITSON: {
                if (value.equalsIgnoreCase("TOGGLE")) {
                    if (jsvp == null) {
                        return;
                    }
                    boolean b = !jsvp.getPanelData().getBoolean(st);
                    value = b ? "TRUE" : "FALSE";
                    switch (st) {
                        case XSCALEON: {
                            this.setBoolean(ScriptToken.XUNITSON, b);
                            jsvp.getPanelData().setBoolean(ScriptToken.XUNITSON, b);
                            break;
                        }
                        case YSCALEON: {
                            this.setBoolean(ScriptToken.YUNITSON, b);
                            jsvp.getPanelData().setBoolean(ScriptToken.YUNITSON, b);
                        }
                    }
                }
                this.setBoolean(st, value);
                break;
            }
            case BACKGROUNDCOLOR: 
            case COORDINATESCOLOR: 
            case GRIDCOLOR: 
            case INTEGRALPLOTCOLOR: 
            case PLOTAREACOLOR: 
            case PLOTCOLOR: 
            case SCALECOLOR: 
            case TITLECOLOR: 
            case UNITSCOLOR: {
                param = this.setColorFromString(st, value);
                break;
            }
            case DISPLAYFONTNAME: 
            case TITLEFONTNAME: {
                param = this.getFontName(st, value);
            }
        }
        if (jsvp == null) {
            return;
        }
        if (param != null) {
            jsvp.setColorOrFont(this, st);
        } else {
            jsvp.getPanelData().setBoolean(this, st);
        }
    }

    protected Object getPlotColors(String value) {
        return null;
    }

    protected Object setColorFromString(ScriptToken st, String value) {
        return null;
    }

    protected Object getFontName(ScriptToken st, String value) {
        return null;
    }
}

