/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Coordinate;
import jspecview.common.ScaleData;

public class ImageScaleData {
    public int xPixel0;
    public int yPixel0;
    public int xPixel1;
    public int yPixel1;
    public int imageWidth;
    public int imageHeight;
    public int xPixels;
    public int yPixels;
    public int xPixelZoom1;
    public int yPixelZoom1;
    public int xPixelZoom2;
    public int yPixelZoom2;
    public int xView1;
    public int yView1;
    public int xView2;
    public int yView2;
    public double minX = Double.NaN;
    public double maxX;
    public double minZ;
    public double maxZ;

    public void setScale(ScaleData scaleData) {
        if (Double.isNaN(this.minX)) {
            this.minX = scaleData.minX;
            this.maxX = scaleData.maxX;
        }
        this.minZ = scaleData.minY;
        this.maxZ = scaleData.maxY;
    }

    public void setZoom(int xPixel1, int yPixel1, int xPixel2, int yPixel2) {
        this.xPixelZoom1 = Math.min(xPixel1, xPixel2);
        this.yPixelZoom1 = Math.min(yPixel1, yPixel2);
        this.xPixelZoom2 = Math.max(xPixel1, xPixel2);
        this.yPixelZoom2 = Math.max(yPixel1, yPixel2);
        this.setView();
    }

    public void setImageSize(int width, int height, boolean resetView) {
        this.imageWidth = width;
        this.imageHeight = height;
        if (resetView) {
            this.resetView();
        }
    }

    public void setXY0(int xPixel, int yPixel) {
        this.xPixel0 = xPixel;
        this.yPixel0 = yPixel;
        this.xPixel1 = this.xPixel0 + this.xPixels - 1;
        this.yPixel1 = this.yPixel0 + this.yPixels - 1;
    }

    public void setPixelWidthHeight(int xPixels, int yPixels) {
        this.xPixels = xPixels;
        this.yPixels = yPixels;
    }

    public void resetView() {
        this.xView1 = 0;
        this.yView1 = 0;
        this.xView2 = this.imageWidth - 1;
        this.yView2 = this.imageHeight - 1;
    }

    public void setView() {
        if (this.xPixelZoom1 == 0) {
            this.resetZoom();
        }
        int x1 = this.toImageX(this.xPixelZoom1);
        int y1 = this.toImageY(this.yPixelZoom1);
        int x2 = this.toImageX(this.xPixelZoom2);
        int y2 = this.toImageY(this.yPixelZoom2);
        this.xView1 = Math.min(x1, x2);
        this.yView1 = Math.min(y1, y2);
        this.xView2 = Math.max(x1, x2);
        this.yView2 = Math.max(y1, y2);
        this.resetZoom();
    }

    public void resetZoom() {
        this.xPixelZoom1 = this.xPixel0;
        this.yPixelZoom1 = this.yPixel0;
        this.xPixelZoom2 = this.xPixel1;
        this.yPixelZoom2 = this.yPixel1;
    }

    public int fixX(int xPixel) {
        return xPixel < this.xPixel0 ? this.xPixel0 : (xPixel > this.xPixel1 ? this.xPixel1 : xPixel);
    }

    public int toImageX(int xPixel) {
        return this.xView1 + (int)Math.floor((double)(xPixel - this.xPixel0) / ((double)this.xPixels - 1.0) * (double)(this.xView2 - this.xView1));
    }

    public int toImageY(int yPixel) {
        return this.yView1 + (int)Math.floor((double)(yPixel - this.yPixel0) / ((double)this.yPixels - 1.0) * (double)(this.yView2 - this.yView1));
    }

    public int toImageX0(int xPixel) {
        return Coordinate.intoRange((int)((1.0 * (double)xPixel - (double)this.xPixel0) / (double)(this.xPixels - 1) * (double)(this.imageWidth - 1)), 0, this.imageWidth - 1);
    }

    public int toImageY0(int yPixel) {
        return Coordinate.intoRange((int)((1.0 * (double)yPixel - (double)this.yPixel0) / (double)(this.yPixels - 1) * (double)(this.imageHeight - 1)), 0, this.imageHeight - 1);
    }

    public boolean isXWithinRange(int xPixel) {
        return xPixel >= this.xPixel0 - 5 && xPixel < this.xPixel0 + this.xPixels + 5;
    }

    public double toX(int xPixel) {
        return this.maxX + (this.minX - this.maxX) * (double)this.toImageX(this.fixX(xPixel)) / (double)(this.imageWidth - 1);
    }

    public double toX0(int xPixel) {
        return this.maxX + (this.minX - this.maxX) * (double)(this.fixX(xPixel) - this.xPixel0) / (double)(this.xPixels - 1);
    }

    public int toPixelX(double x) {
        double x0 = this.toX(this.xPixel0);
        double x1 = this.toX(this.xPixel1);
        return this.xPixel0 + (int)((x - x0) / (x1 - x0) * (double)(this.xPixels - 1));
    }

    public int toPixelX0(double x) {
        return this.xPixel1 - (int)((x - this.minX) / (this.maxX - this.minX) * (double)(this.xPixels - 1));
    }

    public int toSubspectrumIndex(int yPixel) {
        return Coordinate.intoRange(this.imageHeight - 1 - this.toImageY(yPixel), 0, this.imageHeight - 1);
    }

    public int toPixelY0(double ysub) {
        return this.yPixel1 - (int)(ysub / (double)(this.imageHeight - 1) * (double)(this.yPixels - 1));
    }

    public int toPixelX(int imageX) {
        return this.xPixel0 + (int)((double)(this.xPixels - 1) * (1.0 - 1.0 * (double)imageX / (double)(this.imageWidth - 1)));
    }

    public int toPixelY(int subIndex) {
        double f = 1.0 * (double)(this.imageHeight - 1 - subIndex - this.yView1) / (double)(this.yView2 - this.yView1);
        int y = this.yPixel0 + (int)(f * (double)(this.yPixels - 1));
        return y;
    }

    public int fixSubIndex(int subIndex) {
        return Coordinate.intoRange(subIndex, this.imageHeight - 1 - this.yView2, this.imageHeight - 1 - this.yView1);
    }

    public void setView0(int xp1, int yp1, int xp2, int yp2) {
        int x1 = this.toImageX0(xp1);
        int y1 = this.toImageY0(yp1);
        int x2 = this.toImageX0(xp2);
        int y2 = this.toImageY0(yp2);
        this.xView1 = Math.min(x1, x2);
        this.yView1 = Math.min(y1, y2);
        this.xView2 = Math.max(x1, x2);
        this.yView2 = Math.max(y1, y2);
        this.resetZoom();
    }
}

