/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.swing.JOptionPane;
import jspecview.common.Annotation;
import jspecview.common.AwtPanel;
import jspecview.common.AwtParameters;
import jspecview.common.ColoredAnnotation;
import jspecview.common.GraphSet;
import jspecview.common.ImageScaleData;
import jspecview.common.JDXSpectrum;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AwtGraphSet
extends GraphSet {
    private AwtPanel jsvp;
    private BufferedImage image2D;
    private Color[] plotColors;

    @Override
    protected void disposeImage() {
        this.image2D = null;
        this.jsvp = null;
        this.pd = null;
        this.highlights = null;
        this.plotColors = null;
    }

    AwtGraphSet(AwtPanel jsvp) {
        this.jsvp = jsvp;
        this.pd = jsvp.pd;
    }

    @Override
    protected AwtGraphSet getGraphSet(Object jsvp) {
        return new AwtGraphSet((AwtPanel)jsvp);
    }

    @Override
    protected void initGraphSet(int startIndex, int endIndex) {
        this.setPlotColors(AwtParameters.defaultPlotColors);
        super.initGraphSet(startIndex, endIndex);
    }

    @Override
    void setPlotColors(Object oColors) {
        Color[] colors = (Color[])oColors;
        if (colors.length > this.nSpectra) {
            Color[] tmpPlotColors = new Color[this.nSpectra];
            System.arraycopy(colors, 0, tmpPlotColors, 0, this.nSpectra);
            colors = tmpPlotColors;
        } else if (this.nSpectra > colors.length) {
            Color[] tmpPlotColors = new Color[this.nSpectra];
            int numAdditionColors = this.nSpectra - colors.length;
            System.arraycopy(colors, 0, tmpPlotColors, 0, colors.length);
            int i = 0;
            int j = colors.length;
            while (i < numAdditionColors) {
                tmpPlotColors[j] = AwtGraphSet.generateRandomColor();
                ++i;
                ++j;
            }
            colors = tmpPlotColors;
        }
        this.plotColors = colors;
    }

    private static Color generateRandomColor() {
        int blue;
        int green;
        int red;
        Color randomColor;
        while ((randomColor = new Color(red = (int)(Math.random() * 255.0), green = (int)(Math.random() * 255.0), blue = (int)(Math.random() * 255.0))).equals(Color.blue)) {
        }
        return randomColor;
    }

    @Override
    void setPlotColor0(Object oColor) {
        this.plotColors[0] = (Color)oColor;
    }

    Color getPlotColor(int index) {
        if (index >= this.plotColors.length) {
            return null;
        }
        return this.plotColors[index];
    }

    @Override
    protected void setColor(Object g, ScriptToken whatColor) {
        if (whatColor != null) {
            ((Graphics)g).setColor(whatColor == ScriptToken.PLOTCOLOR ? this.plotColors[0] : this.jsvp.getColor(whatColor));
        }
    }

    @Override
    protected void draw2DImage(Object g) {
        if (this.isd != null) {
            ((Graphics)g).drawImage(this.image2D, this.isd.xPixel0, this.isd.yPixel0, this.isd.xPixel0 + this.isd.xPixels - 1, this.isd.yPixel0 + this.isd.yPixels - 1, this.isd.xView1, this.isd.yView1, this.isd.xView2, this.isd.yView2, null);
        }
    }

    @Override
    protected boolean get2DImage() {
        this.isd = new ImageScaleData();
        this.isd.setScale((ScaleData)this.zoomInfoList.get(0));
        if (!this.update2dImage(false)) {
            return false;
        }
        this.isd.resetZoom();
        this.sticky2Dcursor = true;
        return true;
    }

    @Override
    protected boolean update2dImage(boolean forceNew) {
        this.isd.setScale(this.multiScaleData);
        JDXSpectrum spec0 = this.getSpectrumAt(0);
        int[] buffer = spec0.get2dBuffer(this.jsvp.pd.thisWidth, this.jsvp.pd.thisPlotHeight, this.isd, forceNew);
        if (buffer == null) {
            this.image2D = null;
            this.isd = null;
            return false;
        }
        this.isd.setImageSize(spec0.getXYCoords().length, spec0.getSubSpectra().size(), !forceNew);
        this.image2D = new BufferedImage(this.isd.imageWidth, this.isd.imageHeight, 10);
        WritableRaster raster = this.image2D.getRaster();
        raster.setSamples(0, 0, this.isd.imageWidth, this.isd.imageHeight, 0, buffer);
        this.setImageWindow();
        return true;
    }

    @Override
    Annotation getAnnotation(double x, double y, String text, boolean isPixels, boolean is2d, int offsetX, int offsetY) {
        return new ColoredAnnotation(x, y, text, Color.BLACK, isPixels, is2d, offsetX, offsetY);
    }

    @Override
    Annotation getAnnotation(List<String> args, Annotation lastAnnotation) {
        return ColoredAnnotation.getAnnotation(args, (ColoredAnnotation)lastAnnotation);
    }

    @Override
    protected String getInput(String message, String title, String sval) {
        return (String)JOptionPane.showInputDialog(null, message, title, -1, null, null, sval);
    }

    @Override
    protected void fillBox(Object g, int x0, int y0, int x1, int y1, ScriptToken whatColor) {
        this.setColor(g, whatColor);
        ((Graphics)g).fillRect(Math.min(x0, x1), Math.min(y0, y1), Math.abs(x0 - x1), Math.abs(y0 - y1));
    }

    @Override
    protected void drawTitle(Object g, int height, int width, String title) {
        this.jsvp.drawTitle(g, height, width, title);
    }

    @Override
    protected void drawHandle(Object g, int x, int y, boolean outlineOnly) {
        if (outlineOnly) {
            ((Graphics)g).drawRect(x - 2, y - 2, 4, 4);
        } else {
            ((Graphics)g).fillRect(x - 2, y - 2, 5, 5);
        }
    }

    @Override
    protected void drawLine(Object g, int x0, int y0, int x1, int y1) {
        ((Graphics)g).drawLine(x0, y0, x1, y1);
    }

    @Override
    protected void setPlotColor(Object g, int i) {
        ((Graphics)g).setColor(i < 0 ? this.jsvp.getColor(ScriptToken.INTEGRALPLOTCOLOR) : this.plotColors[i]);
    }

    @Override
    protected void drawRect(Object g, int x0, int y0, int x1, int y1) {
        ((Graphics)g).drawRect(x0, y0, x1, y1);
    }

    @Override
    protected void setCurrentBoxColor(Object g) {
        ((Graphics)g).setColor(Color.MAGENTA);
    }

    @Override
    protected void drawString(Object g, String s, int x, int y) {
        ((Graphics)g).drawString(s, x, y);
    }

    @Override
    protected int getFontHeight(Object g) {
        return ((Graphics)g).getFontMetrics().getHeight();
    }

    @Override
    protected int getStringWidth(Object g, String s) {
        return ((Graphics)g).getFontMetrics().stringWidth(s);
    }

    @Override
    protected void setAnnotationColor(Object g, Annotation note, ScriptToken whatColor) {
        if (whatColor != null) {
            this.setColor(g, whatColor);
            return;
        }
        Color color = null;
        if (note instanceof ColoredAnnotation) {
            color = ((ColoredAnnotation)note).getColor();
        }
        if (color == null) {
            color = Color.BLACK;
        }
        ((Graphics)g).setColor(color);
    }

    @Override
    protected void setColor(Object g, int red, int green, int blue) {
        ((Graphics)g).setColor(new Color(red, green, blue));
    }
}

